struct HotDesertData {
	uint coverage;
	uint growthTimer;
	uint targetCoverage;
	uint currentYearMinimumCoverage;
};

HotDesertData unpackHotDesertData(inout uint value) {
	return HotDesertData(value >> 24, (value & 0x00ff0000) >> 16, (value & 0x0000ff00) >> 8, (value & 0x000000ff));
}

uint packHotDesertData(inout HotDesertData value) {
	return (value.coverage << 24) | (value.growthTimer << 16) | (value.targetCoverage << 8) | (value.currentYearMinimumCoverage);
}

vec4 updateHotDesert(inout EnvironmentInfo info, inout float targetCoverage) {
	HotDesertData data = unpackHotDesertData(info.additionalData[1][3]);
	if (dayProgressed) {
		float groundwaterFactor = range(50, 250, info.groundwaterMM, 300, 420);
		float rainfallFactor = range(25, 100, info.yearlyRainfallMM, 300, 420);
		float innundationFactor = range(0, 0, info.inundationData.daysInnundatedLastYear, 15, 20);
		float temperatureFactor = range(0, 5, info.temperature.meanCelsius, 99, 99);
		float currentCoverage = groundwaterFactor * rainfallFactor * innundationFactor * temperatureFactor * info.normalFactor;
		bool remove = false;
		if (info.standardExclusions) {
			currentCoverage = 0.f;
			remove = true;
		}
		uint coverageNow = clamp(uint(currentCoverage * 255u), 0u, 255u);

		#include mixin "operations/plants/biomes/tree_growth_mixin.glsl"
	}
	info.additionalData[1][3] = packHotDesertData(data);
	targetCoverage = data.targetCoverage / 255.f;
	float amount = data.coverage / 255.f;
	float colour = 0.f;
	if (info.snowCoverage > 0.5f) {
		colour = 15.5f / 16.f;
	}
	return vec4(7.f / 255.f, amount, colour, 0.6f);
}