InundationData unpackInundationData(inout uint value) {
	return InundationData(value >> 24, (value & 0x00ff0000) >> 16, (value & 0x0000ff00) >> 8, (value & 0x000000ff));
}

uint packInundationData(inout InundationData value) {
	return (value.daysInnundatedLastYear << 24) | (value.daysInnundatedThisYear << 16) | (value.unused1 << 8) | (value.unused2);
}

InundationData updateInundation(inout EnvironmentInfo info) {
	InundationData data = unpackInundationData(info.additionalData[2][0]);
	if (yearProgressed) {
		data.daysInnundatedLastYear = data.daysInnundatedThisYear;
		data.daysInnundatedThisYear = 0u;
	}
	if (dayProgressed) {
		if (info.waterData.waterHeight > RIVER_THRESHOLD && data.daysInnundatedThisYear < 255u) {
			data.daysInnundatedThisYear += 1u;
		}
		if (data.daysInnundatedThisYear > data.daysInnundatedLastYear) {
			data.daysInnundatedLastYear = data.daysInnundatedThisYear;
		}
	}
	info.additionalData[2][0] = packInundationData(data);
	return data;
}