struct MangroveSwampData {
	uint coverage;
	uint growthTimer;
	uint targetCoverage;
	uint currentYearMinimumCoverage;
};

MangroveSwampData unpackMangroveSwampData(inout uint value) {
	return MangroveSwampData(value >> 24, (value & 0x00ff0000) >> 16, (value & 0x0000ff00) >> 8, (value & 0x000000ff));
}

uint packMangroveSwampData(inout MangroveSwampData value) {
	return (value.coverage << 24) | (value.growthTimer << 16) | (value.targetCoverage << 8) | (value.currentYearMinimumCoverage);
}

vec4 updateMangroveSwamp(inout EnvironmentInfo info, inout float targetCoverage) {
	MangroveSwampData data = unpackMangroveSwampData(info.additionalData[1][1]);
	if (dayProgressed) {
		float groundwaterFactor = range(500.f, 750.f, info.groundwaterMM, 9999.f, 9999.f);
		float minimumRainfallFactor = range(250, 500.f, info.rainfallMM, 9999.f, 9999.f);
		float averageTemperatureFactor = range(3.f, 10.f, info.temperature.meanCelsius, 99.f, 99.f);
		float minimumTemperatureFactor = range(0.f, 5.f, info.temperature.minCelsius, 99.f, 99.f);
		float currentCoverage = groundwaterFactor * minimumRainfallFactor * averageTemperatureFactor * minimumTemperatureFactor;
		bool remove = false;
		if (info.iceDepth > 0.f || info.inLava || info.temperature.currentCelsius < 0.f || info.dirtDepth < 1.f || info.waterData.waterHeight > 0.2f || 
			info.waterData.landHeight < -0.2f || info.waterData.landHeight > 2.f) {
			currentCoverage = 0.f;
			remove = true;
		}
		uint coverageNow = clamp(uint(currentCoverage * 255u), 0u, 255u);
		#include mixin "operations/plants/biomes/tree_growth_mixin.glsl"
	}
	info.additionalData[1][1] = packMangroveSwampData(data);
	float amount = data.coverage / 255.f;
	targetCoverage = data.targetCoverage / 255.f;
	float colour = 0.f;
	if (info.snowCoverage > 0.5f) {
		colour = 15.5f / 16.f;
	}
	return vec4(6.f / 255.f, amount, colour, 0.6f);
}