struct MarshData {
	uint unused;
	uint growth;
	uint savedGrowth;
	uint savedGrowthCounter;
};

MarshData unpackMarshData(inout uint value) {
	return MarshData(value >> 24, (value & 0x00ff0000) >> 16, (value & 0x0000ff00) >> 8, (value & 0x000000ff));
}

uint packMarshData(inout MarshData value) {
	return (value.unused << 24) | (value.growth << 16) | (value.savedGrowth << 8) | (value.savedGrowthCounter);
}

vec4 updateMarsh(inout EnvironmentInfo info, inout float targetCoverage) {
	MarshData data = unpackMarshData(info.additionalData[2][1]);
	if (dayProgressed) {
		float inundationFactor = range(75, 90, info.inundationData.daysInnundatedLastYear, 190, 210);
		float groundWaterFactor = clamp((info.groundwaterMM - 250) / 250.f, 0.f, 1.f);
		targetCoverage = inundationFactor * groundWaterFactor * info.normalFactor;
		bool remove = false;
		if (info.dirtDepth < 1.f || info.waterData.landHeight < 2.f || info.iceDepth > 0.f || info.inLava ) {
			targetCoverage = 0.f;
			remove = true;
		}

		uint coverageNow = clamp(uint(targetCoverage * 255u), 0u, 255u);
		if (coverageNow >= data.savedGrowth || data.savedGrowthCounter == 0u) {
			data.savedGrowth = coverageNow;
			data.savedGrowthCounter = 12u;
		}
		if (data.savedGrowthCounter > 0u) {
			coverageNow = max(coverageNow, data.savedGrowth);
		}
		if (coverageNow < data.growth) {
			data.growth = data.growth - 1u;
		} else {
			data.growth = coverageNow;
		}
	}

	if (monthProgressed && data.savedGrowthCounter > 0u) {
		data.savedGrowthCounter -= 1;
	}
	info.additionalData[2][1] = packMarshData(data);
	float amount = data.growth / 255.f;
	if (info.snowCoverage > 0.f) {
		amount = 0.f;
	}
	return vec4(9.f / 255.f, amount, 0.f, 0.6f);
}