struct OasisData {
	uint coverage;
	uint growthTimer;
	uint targetCoverage;
	uint currentYearMinimumCoverage;
};

OasisData unpackOasisData(inout uint value) {
	return OasisData(value >> 24, (value & 0x00ff0000) >> 16, (value & 0x0000ff00) >> 8, (value & 0x000000ff));
}

uint packOasisData(inout OasisData value) {
	return (value.coverage << 24) | (value.growthTimer << 16) | (value.targetCoverage << 8) | (value.currentYearMinimumCoverage);
}

vec4 updateOasis(inout EnvironmentInfo info, inout float targetCoverage, float forestCoverage) {
	OasisData data = unpackOasisData(info.additionalData[0][2]);
	if (dayProgressed) {
		float groundwaterFactor = range(550.f, 750.f, info.groundwaterMM, 9999.f, 9999.f);
		groundwaterFactor = max(0.f, groundwaterFactor - forestCoverage);
		float temperatureFactor = range(2.f, 7.f, info.temperature.minCelsius, 99.f, 99.f);
		float innundationFactor = range(0, 0, info.inundationData.daysInnundatedLastYear, 15, 20);
		float currentCoverage = groundwaterFactor * temperatureFactor * innundationFactor;
		bool remove = false;
		if (info.standardExclusions) {
			currentCoverage = 0.f;
			remove = true;
		}
		uint coverageNow = clamp(uint(currentCoverage * 255u), 0u, 255u);

		#include mixin "operations/plants/biomes/tree_growth_mixin.glsl"
	}
	info.additionalData[0][2] = packOasisData(data);
	targetCoverage = data.targetCoverage / 255.f;
	float amount = data.coverage / 255.f;
	float colour = 0.f;
	if (info.snowCoverage > 0.5f) {
		colour = 15.5f / 16.f;
	}
	return vec4(3.f / 255.f, amount, colour, 0.6f);
}