struct SavannahData {
	uint coverage;
	uint growthTimer;
	uint targetCoverage;
	uint currentYearMinimumCoverage;
};

SavannahData unpackSavannahData(inout uint value) {
	return SavannahData(value >> 24, (value & 0x00ff0000) >> 16, (value & 0x0000ff00) >> 8, (value & 0x000000ff));
}

uint packSavannahData(inout SavannahData value) {
	return (value.coverage << 24) | (value.growthTimer << 16) | (value.targetCoverage << 8) | (value.currentYearMinimumCoverage);
}

vec4 updateSavannah(inout EnvironmentInfo info, inout float targetCoverage, inout float forestCoverage) {
	SavannahData data = unpackSavannahData(info.additionalData[0][3]);
	if (dayProgressed) {
		float rainfallFactor = range(500.f, 750.f, info.yearlyRainfallMM, 9999.f, 9999.f);
		rainfallFactor = max(0.f, rainfallFactor - (forestCoverage * 2.f));
		float innundationFactor = range(0, 0, info.inundationData.daysInnundatedLastYear, 15, 20);
		float temperatureFactor = range(2.f, 5.f, info.temperature.minCelsius, 99.f, 99.f);
		float currentCoverage = rainfallFactor * info.normalFactor * innundationFactor * temperatureFactor;
		bool remove = false;
		if (info.standardExclusions) {
			currentCoverage = 0.f;
			remove = true;
		}
		uint coverageNow = clamp(uint(currentCoverage * 255u), 0u, 255u);

		#include mixin "operations/plants/biomes/tree_growth_mixin.glsl"
	}
	info.additionalData[0][3] = packSavannahData(data);
	targetCoverage = data.targetCoverage / 255.f;
	float amount = data.coverage / 255.f;
	float colour = 0.f;
	if (info.snowCoverage > 0.5f) {
		colour = 15.5f / 16.f;
	}
	return vec4(5.f / 255.f, amount, colour, 0.6f);
}