vec4 updateSwamp(inout EnvironmentInfo info, inout float targetCoverage) {
	GrowthData data = unpackGrowthData(info.additionalData[2][2]);
	if (dayProgressed) {
		float rainfallFactor = range(500.f, 750.f, info.groundwaterMM, 9999.f, 9999.f);
		float temperatureFactor = range(2.f, 7.f, info.temperature.meanCelsius, 40.f, 64.f);
		float inundationFactor = range(15, 20, info.inundationData.daysInnundatedLastYear, 75, 90);
		float currentCoverage = info.normalFactor * rainfallFactor * inundationFactor * temperatureFactor;
		bool remove = false;
		if (info.iceDepth > 0.f || info.inLava || info.dirtDepth < 1.f || info.waterData.landHeight < 2.f) {
			currentCoverage = 0.f;
			remove = true;
		}
		uint coverageNow = clamp(uint(currentCoverage * 255u), 0u, 255u);
		#include mixin "operations/plants/biomes/tree_growth_mixin.glsl"
	}
	info.additionalData[2][2] = packGrowthData(data);
	targetCoverage = data.targetCoverage / 255.f;
	float amount = data.coverage / 255.f;
	float colour = 0.f;
	if (info.snowCoverage > 0.5f) {
		colour = 15.5f / 16.f;
	}
	return vec4(8.f / 255.f, amount, colour, 0.6f);
}