struct TemperateForestData {
	uint coverage;
	uint growthTimer;
	uint targetCoverage;
	uint currentYearMinimumCoverage;
};

TemperateForestData unpackTemperateForestData(inout uint value) {
	return TemperateForestData(value >> 24, (value & 0x00ff0000) >> 16, (value & 0x0000ff00) >> 8, (value & 0x000000ff));
}

uint packTemperateForestData(inout TemperateForestData value) {
	return (value.coverage << 24) | (value.growthTimer << 16) | (value.targetCoverage << 8) | (value.currentYearMinimumCoverage);
}

vec4 updateTemperateForest(inout EnvironmentInfo info, inout float targetCoverage, float rainforestCoverage) {
	TemperateForestData data = unpackTemperateForestData(info.additionalData[0][1]);
	if (dayProgressed) {
		float groundwaterFactor = range(500.f, 750.f, info.groundwaterMM, 9999.f, 9999.f);
		float minimumRainfallFactor = range(250, 500.f, info.rainfallMM, 9999.f, 9999.f);
		float averageTemperatureFactor = range(3.f, 7.f, info.temperature.meanCelsius, 50.f, 64.f);
		float innundationFactor = range(0, 0, info.inundationData.daysInnundatedLastYear, 15, 20);
		float rainforestFactor = (1.f - rainforestCoverage);
		float currentCoverage = minimumRainfallFactor * groundwaterFactor * averageTemperatureFactor * info.normalFactor * innundationFactor * rainforestFactor;
		bool remove = false;
		if (info.standardExclusions) {
			currentCoverage = 0.f;
			remove = true;
		}
		uint coverageNow = clamp(uint(currentCoverage * 255u), 0u, 255u);

		#include mixin "operations/plants/biomes/tree_growth_mixin.glsl"
	}
	info.additionalData[0][1] = packTemperateForestData(data);
	float amount = data.coverage / 255.f;
	float leafColour = 2.5f / 16.f;
	if (info.springProgress < 1.f) {
		leafColour = (0.f + 2.5f * min(info.springProgress * 2.f, 1.f)) / 16.f;
	}
	if (info.autumnProgress > 0.f) {
		leafColour = 0.21875 + (info.autumnProgress * (4.f / 16.f));
	}
	if (info.winterProgress > 0.f) {
		leafColour = 15.5f / 16.f;
	} else {
		if (info.snowCoverage > 0.5f) {
			leafColour = 14.5f / 16.f;
		}
	}
	targetCoverage = data.targetCoverage / 255.f;
	return vec4(0.f / 255.f, amount, leafColour, 0.6f);
}