struct TropicalRainforestData {
	uint coverage;
	uint growthTimer;
	uint targetCoverage;
	uint currentYearMinimumCoverage;
};

TropicalRainforestData unpackTropicalRainforestData(inout uint value) {
	return TropicalRainforestData(value >> 24, (value & 0x00ff0000) >> 16, (value & 0x0000ff00) >> 8, (value & 0x000000ff));
}

uint packTropicalRainforestData(inout TropicalRainforestData value) {
	return (value.coverage << 24) | (value.growthTimer << 16) | (value.targetCoverage << 8) | (value.currentYearMinimumCoverage);
}

vec4 updateTropicalRainforest(inout EnvironmentInfo info, inout float targetCoverage) {
	TropicalRainforestData data = unpackTropicalRainforestData(info.additionalData[1][0]);
	if (dayProgressed) {
		float groundwaterFactor = range(1200.f, 1700.f, info.groundwaterMM, 9999.f, 9999.f);
		float minimumRainfallFactor = range(800, 1200.f, info.rainfallMM, 9999.f, 9999.f);
		float averageTemperatureFactor = range(16.f, 19.f, info.temperature.meanCelsius, 99.f, 99.f);
		float minimumTemperatureFactor = range(5.f, 7.f, info.temperature.minCelsius, 99.f, 99.f);
		float currentCoverage = groundwaterFactor * minimumRainfallFactor * min(averageTemperatureFactor, minimumTemperatureFactor);
		bool remove = false;
		if (info.standardExclusions) {
			currentCoverage = 0.f;
			remove = true;
		}
		uint coverageNow = clamp(uint(currentCoverage * 255u), 0u, 255u);
		#include mixin "operations/plants/biomes/tree_growth_mixin.glsl"
	}
	targetCoverage = data.targetCoverage / 255.f;
	info.additionalData[1][0] = packTropicalRainforestData(data);
	float amount = data.coverage / 255.f;
	float colour = 0.f;
	if (info.snowCoverage > 0.5f) {
		colour = 15.5f / 16.f;
	}
	return vec4(2.f / 255.f, amount, colour, 0.6f);
}