// Fragment shader for the GPU simulation that generates biodiversity counts
#version 150

uniform usampler2DRect data1; // animals row 0
uniform sampler2D data2; // coverages row 0
uniform float DEER_PER_HECTARE;
uniform float CRABS_PER_HECTARE;
uniform float CROCS_PER_HECTARE;
uniform float BEARS_PER_HECTARE;
uniform float IBEX_PER_HECTARE;
uniform float RABBITS_PER_HECTARE;

in vec2 texCoord;

out vec4 output1; // biodiversity row 0
out vec4 output2; // biodiversity row 1
out vec4 output3; // biodiversity row 2
out vec4 output4; // biodiversity row 3

void main() {
	uvec4 animals = texture(data1, texCoord);
	float hectaresPerUnit = (16.f * 16.f / 10000.f);
	float deerCoverage = ((animals[0] & 0xffu) / 256.f) * DEER_PER_HECTARE * hectaresPerUnit;
	float crabCoverage = (((animals[0] >> 8) & 0xffu) / 256.f) * CRABS_PER_HECTARE * hectaresPerUnit;
	float ibexCoverage = (((animals[0] >> 16) & 0xffu) / 256.f) * IBEX_PER_HECTARE * hectaresPerUnit;
	float crocCoverage = (((animals[0] >> 24) & 0xffu) / 256.f) * CROCS_PER_HECTARE * hectaresPerUnit;
	float rabbitCoverage = ((animals[1] & 0xffu) / 256.f) * RABBITS_PER_HECTARE * hectaresPerUnit;
	float bearCoverage = (((animals[1] >> 8) & 0xffu) / 256.f) * BEARS_PER_HECTARE * hectaresPerUnit;
	vec4 coverages = texelFetch(data2, ivec2(texCoord - vec2(0.5, 0.5)), 0);

	output1 = vec4(deerCoverage, crabCoverage, ibexCoverage, crocCoverage);
	output2 = vec4(rabbitCoverage, bearCoverage, 0.0, 0.0);
	output3 = vec4(0.0, 0.0, 0.0, 0.0);
	output4 = vec4(0.0, 0.0, 0.0, 0.0);
}