// Fragment shader for the GPU simulation that calculates coastline length
#version 150

uniform sampler2DRect data1; // coastline row 0
uniform sampler2DRect data2; // water row 0
uniform int data1_resolution;
uniform ivec2 data2_size; // dimensions of the water layer

in vec2 texCoord;

out vec4 output1; // coastline row 0

void main() {

	vec2 offsets[2];
	offsets[0] = vec2(0, 1);
	offsets[1] = vec2(1, 0);

	float longest = -1;
	vec4 waterHere = texture(data2, texCoord);
	float coastlineCount = 0;

	for (int i=0; i<2; i++) {
		vec4 neighbourWater = texture(data2, texCoord + offsets[i]);
		if ((waterHere[0] < 0 && neighbourWater[0] > 0) || (waterHere[0] > 0 && neighbourWater[0] < 0)) {
			coastlineCount += 1;
		}
	}

	output1 = vec4(coastlineCount, 1.f, 0.f, 0.f);
}