// Fragment shader for the GPU water flow simulation pass that calculates occlusion for land
#version 150

uniform sampler2DRect data1; // river length row 0
uniform sampler2DRect data2; // water row 0
uniform sampler2DRect data3; // water row 1
uniform sampler2DRect data4; // water row 2
uniform int data1_resolution;
uniform ivec2 data2_size; // dimensions of the water layer

in vec2 texCoord;

out vec4 output1; // river length row 0

int oppositeDirection(int direction) {
	if (direction == 0 || direction == 2) { 
		return 2 - direction; 
	} else { 
		return 4 - direction; 
	};
}

void main() {

	vec2 offsets[4];
	offsets[0] = vec2(0, -1);
	offsets[1] = vec2(1, 0);
	offsets[2] = vec2(0, 1);
	offsets[3] = vec2(-1, 0);

	float longest = -1;
	vec4 waterHere = texture(data2, texCoord);
	if (waterHere.x < 0) {
		output1 = vec4(0);
	} else {
		for (int i=0; i<4; i++) {
			vec4 flows = texture(data3, texCoord + offsets[i]);
			vec4 info = texture(data4, texCoord + offsets[i]);
			int direction = oppositeDirection(i);
			if (flows[direction] > 0 && int(info[0]) == direction) {
				float length = texture(data1, texCoord + offsets[i])[0];
				if (length > longest) {
					longest = length;
				}
			}
		}

		output1 = vec4(longest + 1, 1.f, 1.f, 1.f);
	}
}