// Compute shader that copies the current rainfall from the rainfall layers into the water later
#version 430

layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

layout (binding = 0) uniform sampler2DRect water2Read;
layout (binding = 1) uniform sampler2DRect rainfall0Read;
layout (binding = 2) uniform sampler2DRect rainfall1Read;
layout (binding = 3) uniform sampler2DRect rainfall2Read;

layout (binding = 0, rgba32f) uniform restrict image2DRect water2Write;
layout (binding = 1, rg16) uniform restrict image2DRect rainfall2Write;

uniform int currentAttribute;
uniform float RAINFALL_NORMALISED_TO_SIM_CONVERSION;

void main() {
	ivec2 dataPos = ivec2(gl_GlobalInvocationID.xy);

	vec4 waterData = texelFetch(water2Read, dataPos);
	vec4 rainfallData;
	float currentRainfallNormalised = 0.f;
	if (currentAttribute < 4) {
		rainfallData = texelFetch(rainfall0Read, dataPos);
		currentRainfallNormalised = rainfallData[currentAttribute];
		waterData[3] = currentRainfallNormalised * RAINFALL_NORMALISED_TO_SIM_CONVERSION;
	} else {
		rainfallData = texelFetch(rainfall1Read, dataPos);
		currentRainfallNormalised = rainfallData[currentAttribute - 4];
		waterData[3] = currentRainfallNormalised * RAINFALL_NORMALISED_TO_SIM_CONVERSION;
	}
	vec4 rainfall2Data = texelFetch(rainfall2Read, dataPos);
	rainfall2Data[1] = currentRainfallNormalised;

	imageStore(water2Write, dataPos, waterData);
	imageStore(rainfall2Write, dataPos, rainfall2Data);
}