#version 430

layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

layout (binding = 0) uniform sampler2DRect rainfall0Read;
layout (binding = 1) uniform sampler2DRect rainfall1Read;
layout (binding = 2) uniform sampler2DRect rainfall2Read;

layout (binding = 0, rgba16) uniform restrict image2DRect rainfall0Write;
layout (binding = 1, rgba16) uniform restrict image2DRect rainfall1Write;
layout (binding = 2, rg16) uniform restrict image2DRect rainfall2Write;

uniform int currentAttribute;
uniform int resolution;
uniform vec3 mousePosition;
uniform float editMagnitude;
uniform float affectedAreaRadius;
uniform int attributeMappings[8];
uniform int stepCount;
uniform ivec2 rainfall_size;

#include "common/constants.glsl"
#include "common/noise.glsl"

float interpolate(float value, vec2 coordValue, int type) {
	float _value = 1.0 - value;
	return sin((M_PI / 2.0) * _value);
}

float getEditAmount(float currentAmount, float randomAdd, float _sign) {
	if (_sign < 0) {
		return -(2 / 255.f) * (currentAmount + 0.03f);
	} else {
		if (currentAmount > 0.5f) {
			return (2 / 255.f) * ((1.f - currentAmount) + 0.03f);
		} else {
			return (2 / 255.f) * (currentAmount + 0.03f);
		}
		
	}
}

void main() {
	ivec2 dataPos = ivec2(gl_GlobalInvocationID.xy);

	vec4 rainfallData0 = texelFetch(rainfall0Read, dataPos);
	vec4 rainfallData1 = texelFetch(rainfall1Read, dataPos);
	vec4 rainfallData2 = texelFetch(rainfall2Read, dataPos);

	float neighbourAverage =0.f;
	const int neighbours = 12;
	const ivec2 neighbourOffsets[neighbours] = ivec2[neighbours](
		ivec2(-1, 0), ivec2(0, 1), ivec2(1, 0), ivec2(0, -1),
		ivec2(-4, 0), ivec2(0, 4), ivec2(4, 0), ivec2(0, -4),
		ivec2(-8, 0), ivec2(0, 8), ivec2(8, 0), ivec2(0, -8)
	);
	for (int i=0; i<neighbours; i++) {
		ivec2 neighbourDataPos = clamp(dataPos + neighbourOffsets[i], ivec2(0, 0), rainfall_size - ivec2(1, 1));
		if (currentAttribute < 4) {
			neighbourAverage += texelFetch(rainfall0Read, neighbourDataPos)[currentAttribute];
		} else {
			neighbourAverage += texelFetch(rainfall1Read, neighbourDataPos)[currentAttribute - 4];
		}
	}
	neighbourAverage /= float(neighbours);

	vec2 ourPosition = dataPos * resolution; 
	float dist = distance(mousePosition.xz, ourPosition) / affectedAreaRadius;
	vec2 coordDist = vec2(abs(mousePosition.x - ourPosition.x) / affectedAreaRadius, abs(mousePosition.z - ourPosition.y) / affectedAreaRadius);

	float averageAmount = 0.5f;

	float currentAmount = 0.f;
	if (currentAttribute < 4) {
		currentAmount = rainfallData0[currentAttribute];
	} else {
		currentAmount = rainfallData1[currentAttribute - 4];
	}

	if (dist <= 1.25f) {
		currentAmount = (currentAmount * (1.f - averageAmount)) + (averageAmount * neighbourAverage);
	} else {
		if (abs(neighbourAverage - currentAmount) > 0.002f) {
			currentAmount = (currentAmount * (1.f - averageAmount)) + (averageAmount * neighbourAverage);
		}
	}

	if (dist <= 1) {
		currentAmount += getEditAmount(currentAmount, 0, sign(editMagnitude));
	}

	if (currentAttribute < 4) {
		rainfallData0[currentAttribute] = currentAmount;
	} else {
		rainfallData1[currentAttribute - 4] = currentAmount;
	}

	float total = 0.f;
	for (int i=0; i<8; i++) {
		int mapping = attributeMappings[i];
		if (mapping < 4) {
			total += rainfallData0[mapping];
		} else {
			total += rainfallData1[mapping - 4];
		}
	}

	imageStore(rainfall0Write, dataPos, rainfallData0);
	imageStore(rainfall1Write, dataPos, rainfallData1);
	imageStore(rainfall2Write, dataPos, vec4(total / 8.f, 0.f, 0.f, 0.f));
}