// Fragment shader for the GPU pass to calculate the max water
#version 150

uniform sampler2DRect data1; // waterMax row 0
uniform sampler2DRect data2; // water row 0
uniform sampler2DRect data3; // water row 2

in vec2 texCoord;

out vec4 output1; // waterMax row 0

void main() {
	vec4 existing = texture(data1, texCoord);
	vec4 water = texture(data2, texCoord);
	vec4 waterMisc = texture(data3, texCoord);
	float waterHeight = water[1];
	float groundWater = waterMisc[1];
	output1 = vec4(max(existing[0], waterHeight), max(existing[1], waterHeight), max(existing[2], groundWater), max(existing[3], groundWater));
}