#version 330

uniform sampler2D mainTexture;
uniform sampler2D previousTexture;

in vec2 texCoord;

out vec4 _output;

void main() {
	vec2 points[9] = vec2[](
		vec2(0.25f, 0.25f),
		vec2(0.25f, 0.50f),
		vec2(0.25f, 0.75f),
		vec2(0.50f, 0.25f),
		vec2(0.50f, 0.50f),
		vec2(0.50f, 0.75f),		
		vec2(0.75f, 0.25f),
		vec2(0.75f, 0.50f),
		vec2(0.75f, 0.75f)
	);
	vec3 value = vec3(0);
	for (int i=0; i<9; i++) {
		vec4 texValue = texture(mainTexture, points[i]);
		vec3 newValue = texValue.rgb * 1.3f;
		vec3 previousValue = texture(previousTexture, points[i]).rgb;

		value += (mix(previousValue, newValue, 0.01f * texValue.a) * (1.f / 9.f));
	}
	_output = vec4(value, 1.f);
}