#version 330

uniform sampler2D mainTexture;
uniform float solidColourMix;
uniform vec4 solidColour;

in vec2 texCoord;

out vec4 _output;

vec3 fixLuminance(vec4 color, float targetLuminance) {
	float currentLuminance = dot(color.rgb, vec3(0.299, 0.587, 0.114));
	
	if (currentLuminance < 0.0001) {
		return vec3(targetLuminance);
	}
	
	float scale = targetLuminance / currentLuminance;
	return color.rgb * scale;
}

void main() {
	const float luminance = 0.7f;
	float vigMultiplier = clamp(1.f - (distance(texCoord, vec2(0.5, 0.5)) / 0.707f), 0.f, 1.f);
	vec4 colourValue = vec4(mix(fixLuminance(texture(mainTexture, texCoord), luminance), vec3(luminance, luminance, luminance), 0.5), 1.0);
	vec4 screenBlend = vec4(1) - ((vec4(1) - colourValue) * (vec4(1) - colourValue));
	_output = colourValue;
	_output = mix(colourValue, screenBlend, vigMultiplier * 0.5);
	_output = mix(_output, _output * _output, 0.6 * (1.f - vigMultiplier));
	_output = mix(_output, solidColour, solidColourMix);
}