#version 150

uniform sampler2DRect previousOutput;
uniform float spacingMultipler;
uniform float thresholds[12];
uniform vec4 displayColours[12];

in highp vec2 texCoord;

out vec4 _output;

int getIndex(float rainfall) {
	int index = 0;
	for (int i=0; i<12; i++) {
		if (rainfall > thresholds[i]) {
			index = i;
		}
	}
	return index;
}

struct PreviousPassPixel {
	float rainfall;
	float terrainIllumination;
	float mouseIllumination;
	float alpha;
};

void main() {
	vec4 _previous = texture(previousOutput, texCoord);
	PreviousPassPixel previousPassPixel = PreviousPassPixel(_previous[0], _previous[1], _previous[2], _previous[3]);

	if (previousPassPixel.alpha == 0.f) {
		discard;
	}

	// map sides set these special values
	if (previousPassPixel.mouseIllumination == 0.f && previousPassPixel.alpha == 1.f) {
		_output = vec4(0.5f, 0.5f, 0.5f, 1.f);
		return;
	}

	int index = getIndex(previousPassPixel.rainfall);
	float illumination = previousPassPixel.terrainIllumination * previousPassPixel.mouseIllumination;

	_output = vec4(displayColours[index].rgb * illumination, 1.f);

	float heights[4];
	heights[0] = texture(previousOutput, texCoord + vec2(0, -1))[0];
	heights[1] = texture(previousOutput, texCoord + vec2(1, 0))[0];
	heights[2] = texture(previousOutput, texCoord + vec2(0, 1))[0];
	heights[3] = texture(previousOutput, texCoord + vec2(-1, 0))[0];

	bool line = false;
	for (int i=0; i<4; i++) {
		int otherIndex = getIndex(heights[i]);
		if (otherIndex != index) {
			line = true;
		}
	}

	if (line) {
		_output = mix(_output, vec4(0, 0, 0, 1), 0.75f);
	}
}