#version 330

uniform sampler2D inputHeightmap;
uniform sampler2D evelationTint;
uniform float waterLevel;
uniform float lowerLimitPercent;
uniform float upperLimitPercent;

in vec2 texCoord;

out vec4 _output;

void main() {
	float value = texture(inputHeightmap, texCoord).r;
	if (value < waterLevel) {
		_output = vec4(150 / 255.f, 190 / 255.f, 255 / 255.f, 1.f);
	} else {
		value = (value - waterLevel) / (1.f - waterLevel);
		value = value * upperLimitPercent;
		_output = texture(evelationTint, vec2(value, 0.5f));
	}
}

