#version 150

uniform sampler2DRect previousOutput;
uniform float spacingMultipler;

in highp vec2 texCoord;

out vec4 _output;

void main() {
	float heights[4];
	vec4 here = texture(previousOutput, texCoord);

	if (here[3] == 0.f) {
		discard;
	}

	float illumination = here[1];
	float mouse = here[2];
	float smallLineSpacing = 20.f * spacingMultipler, largeLineSpacing = 100.f * spacingMultipler;
	int smallMods[4], largeMods[4];

	heights[0] = texture(previousOutput, texCoord + vec2(0, -1))[0];
	heights[1] = texture(previousOutput, texCoord + vec2(1, 0))[0];
	heights[2] = texture(previousOutput, texCoord + vec2(0, 1))[0];
	heights[3] = texture(previousOutput, texCoord + vec2(-1, 0))[0];

	smallMods[0] = int(floor(heights[0] / smallLineSpacing));
	smallMods[1] = int(floor(heights[1] / smallLineSpacing));
	smallMods[2] = int(floor(heights[2] / smallLineSpacing));
	smallMods[3] = int(floor(heights[3] / smallLineSpacing));

	largeMods[0] = int(floor(heights[0] / largeLineSpacing));
	largeMods[1] = int(floor(heights[1] / largeLineSpacing));
	largeMods[2] = int(floor(heights[2] / largeLineSpacing));
	largeMods[3] = int(floor(heights[3] / largeLineSpacing));

	const vec3 smallLandLineColour = vec3(175 / 255.f, 31 / 255.f, 32 / 255.f);
	const vec3 smallWaterLineColour = vec3(63 / 255.f, 134 / 255.f, 163 / 255.f);
	const vec3 largeLineColour = vec3(50 / 255.f, 50 / 255.f, 50 / 255.f);
	const vec3 waterColour = vec3(123 / 255.f, 197 / 255.f, 206 / 255.f);
	const vec3 landColour = vec3(244 / 255.f, 236 / 255.f, 211 / 255.f);
	const vec3 mouseColour = vec3(0, 0, 0);

	bool largeLine = false, smallLine = false, underwater = false;
	if (smallMods[0] != smallMods[2] || smallMods[1] != smallMods[3]) {
		smallLine = true;
	}
	if (largeMods[0] != largeMods[2] || largeMods[1] != largeMods[3]) {
		largeLine = true;
	}

	vec3 colour = landColour;
	if (here[0] < 0.f) {
		underwater = true;
		colour = waterColour;
	}
	if (smallLine) {
		if (underwater) {
			colour = mix(colour, smallWaterLineColour, 0.5f);
		} else {
			colour = mix(colour, smallLandLineColour, 0.35f);
		}
	}
	if (largeLine) {
		colour = mix(colour, largeLineColour, 1.f);
	}
	colour = mix(colour, mouseColour, mouse);

	colour *= illumination;

	_output = vec4(colour.x, colour.y, colour.z, 1);
}