#version 440

uniform sampler2D mainPassColour;
uniform sampler2D mainPassDepth;
uniform sampler2D waterColour;
uniform sampler2D waterDepth;
uniform ivec2 screenSize;

out vec4 _output;

void main() {
	vec2 screenTexCoords = gl_FragCoord.xy / vec2(screenSize);
	vec4 mainPixel = texture(mainPassColour, screenTexCoords);
	vec4 waterPixel = texture(waterColour, screenTexCoords);
	float mainDepth = texture(mainPassDepth, screenTexCoords)[0];
	float waterDepth = texture(waterDepth, screenTexCoords)[0];
	if (waterDepth < mainDepth) {
		_output = waterPixel;
	} else {
		_output = mainPixel;
	}
}