#version 150

layout(points) in;
layout(triangle_strip, max_vertices=4) out;

in vec4 vColour[];

out vec4 fColour;

void main() {	
	vec4 position = gl_in[0].gl_Position;
	vec4 colour = vColour[0];

	float size = 0.5;

	gl_Position = position + vec4(-size, -size, 0, 0);
	fColour = colour;
	EmitVertex();

	gl_Position = position + vec4(-size, size, 0, 0);
	fColour = colour;
	EmitVertex();

	gl_Position = position + vec4(size, -size, 0, 0);
	fColour = colour;
	EmitVertex();

	gl_Position = position + vec4(size, size, 0, 0);
	fColour = colour;
	EmitVertex();

	EndPrimitive();
}
