#version 150

uniform mat4 ciModelViewProjection;

in vec4 ciPosition;

out vec4 vColour;

highp float rand(vec2 co) {

	int x = int(co.x);
	int y = int(co.y);
	highp float result = 0.f;

	for (int i = 0; i < 4; i++) {
		x += (x << 29);
		x ^= (x << 11);
		x ^= (y << 17);
		x ^= (x >> 19);
		x ^= (y >> 6);
		x ^= (x << 4);
	}

	result = x;
	
	return (x & 8191) / 8192.0;
}

void main() {
	gl_Position = ciModelViewProjection * ciPosition;
	vColour = vec4(rand(vec2(1, 1)), rand(vec2(2, 2)), rand(vec2(3, 3)), 1);
}

