#version 150

in vec4 ciPosition;
in vec4 ciColor;
in vec4 ciColor2;
in vec3 ciNormal;
in vec2 ciTexCoord0;

#define M_PI 3.14159265358979323846

highp float rand(vec2 co) {

	int x = int(co.x);
	int y = int(co.y);
	highp float result = 0.f;

	for (int i = 0; i < 4; i++) {
		x += (x << 29);
		x ^= (x << 11);
		x ^= (y << 17);
		x ^= (x >> 19);
		x ^= (y >> 6);
		x ^= (x << 4);
	}

	result = x;
	
	return (x & 8191) / 8192.0;
}

vec3 hsv2rgb(vec3 c) {
	vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);
	vec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);
	return c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);
}

int scale(int fromResolution, int toResolution) {
	int numerator = 1, denominator = 1;
	if (fromResolution > 0) {
		numerator *= fromResolution;
	} else {
		denominator *= -fromResolution;
	}
	if (toResolution > 0) {
		denominator *= toResolution;
	} else {
		numerator *= -toResolution;
	}
	return numerator / denominator;
	// return numerator / float(denominator);
}