//-----------------------------------------------------------------------------
//  Galv's Character Frames
//-----------------------------------------------------------------------------
//  For: RPGMAKER MV
//  GALV_CharacterFrames.js
//-----------------------------------------------------------------------------
//  2017-10-26 - Version 1.3 - made aliased functions publicly available
//  2015-01-17 - Version 1.2 - fixed drawing character in menus bug
//  2015-12-15 - Version 1.1 - added equation to control frame speed
//  2015-12-12 - Version 1.0 - release
//-----------------------------------------------------------------------------
//  Terms can be found at:
//  galvs-scripts.com
//-----------------------------------------------------------------------------

var Imported = Imported || {};
Imported.Galv_CharacterFrames = true;

var Galv = Galv || {};        // Galv's main object
Galv.CF = Galv.CF || {};      // Galv's stuff

//-----------------------------------------------------------------------------
/*:
 * @plugindesc 角色行走图多帧功能插件
 * 
 * @author galvs-scripts.com  汉化:硕明云书
 *
 * @param Frame Speed Modifier
 * @text 帧速度修改
 * @desc 等式从帧速（当不是3帧时）导出。有关此的详细信息，请参阅帮助。
 * @default f * 0.8
 *
 * @help
 * ----------------------------------------------------------------------------
 *  汉化：硕明云书
 * ----------------------------------------------------------------------------
 *  这个插件允许你制作每帧超过3帧的行走图
 *
 *  请在文件名重命名：
 *  MainHero%(8).png   其中（8）说明此文件每个动画带有8帧
 *  可修改里面的数值进行调节你的动画帧数
 *  插件来源网站：galvs-scripts.com
 *  脚本可免费用于商业用途
 *  署名信息<galvs-scripts.com>
 * ----------------------------------------------------------------------------
 */


//-----------------------------------------------------------------------------
//  CODE STUFFS
//-----------------------------------------------------------------------------



(function() {
	
Galv.CF.y = PluginManager.parameters('Galv_CharacterFrames')["Frame Speed Modifier"];

	
Game_CharacterBase.prototype._cframes = 3;
Game_CharacterBase.prototype._spattern = 1;
var f = Game_CharacterBase.prototype._cframes;
Game_CharacterBase.prototype._patSpd = 0;


// Draw Char in menus
Galv.CF.Galv_Window_Base_drawCharacter = Window_Base.prototype.drawCharacter;
Window_Base.prototype.drawCharacter = function(characterName, characterIndex, x, y) {
	var setFrame = characterName.match(/\%\((.*)\)/i);
	
	if (setFrame) {
		this._cframes = Number(setFrame[1]);
		var f = this._cframes;

		var bitmap = ImageManager.loadCharacter(characterName);
		var big = ImageManager.isBigCharacter(characterName);
		var pw = bitmap.width / (big ? f : f * 4);
		var ph = bitmap.height / (big ? 4 : 8);
		var n = characterIndex;
		var sx = (n % 4 * 3 + 1) * pw;
		var sy = (Math.floor(n / 4) * 4) * ph;
		this.contents.blt(bitmap, sx, sy, pw, ph, x - pw / 2, y - ph);
	} else {
		Galv.CF.Galv_Window_Base_drawCharacter.call(this,characterName,characterIndex,x,y);
	};
};

Galv.CF.Galv_Sprite_Character_setCharacterBitmap = Sprite_Character.prototype.setCharacterBitmap;
Sprite_Character.prototype.setCharacterBitmap = function() {
	var setFrame = this._characterName.match(/\%\((.*)\)/i);
	if (setFrame) {
		this._cframes = Number(setFrame[1]);
		this._character._spattern = 0;
		var f = this._cframes;
		this._character._patSpd = eval(Galv.CF.y);
		
	} else {
		this._cframes = 3;
		this._character._spattern = 1;
		this._character._patSpd = 0;
	};
	this._character._cframes = this._cframes;
	Galv.CF.Galv_Sprite_Character_setCharacterBitmap.call(this);
};

// OVERWRITE
Game_CharacterBase.prototype.pattern = function() {
    return this._pattern < this._cframes ? this._pattern : this._spattern;
};

// OVERWRITE
Game_CharacterBase.prototype.updatePattern = function() {
    if (!this.hasStepAnime() && this._stopCount > 0) {
        this.resetPattern();
    } else {
		this._pattern = (this._pattern + 1) % (this._cframes + this._spattern);
    }
};

Galv.CF.Galv_Game_CharacterBase_animationWait = Game_CharacterBase.prototype.animationWait;
Game_CharacterBase.prototype.animationWait = function() {
    return Galv.CF.Galv_Game_CharacterBase_animationWait.call(this) - this._patSpd;
};

// OVERWRITE
Sprite_Character.prototype.characterBlockX = function() {
    if (this._isBigCharacter) {
        return 0;
    } else {
        var index = this._character.characterIndex();
        return index % 4 * this._cframes;
    }
};

// OVERWRITE
Sprite_Character.prototype.patternWidth = function() {
    if (this._tileId > 0) {
        return $gameMap.tileWidth();
    } else if (this._isBigCharacter) {
        return this.bitmap.width / this._cframes;
    } else {
        return this.bitmap.width / (this._cframes * 4);
    }
};
})();