//=============================================================================
// VIPArcher_CharacterPoses.js
//=============================================================================
/*:
 * @plugindesc 行走图多姿势动画扩展，多帧|八方向|奔跑|待机
 * @author VIPArcher
 *
 * @param MoveDir8
 * @desc 是否启用 8 方向移动
 * Default: true (启用: true / 不启用: false)
 * @default true
 * @type boolean
 *
 * @param AnimationSpeed
 * @desc 加快帧动画速度程度
 * 1 到 10 之间的数字
 * @default 0
 * @type number
 *
 * @param GapTime
 * @desc 两次待机之间等待的帧数
 * @default 120
 * @type number
 *
 * @param MinTime
 * @desc 进入待机前最短要等待的帧数
 * @default 120
 * @type number
 *
 * @param RandTime
 * @desc 在最短时间上额外随机等待的帧数范围
 * @default 120
 * @type number
 *
 * @param IdleTimes
 * @desc 一次待机动画循环的次数
 * @default 1
 * @type number
 *
 * @param NoteIdle
 * @desc 事件使用待机动画的注释
 * @default <idleAnime>
 * @type string
 *
 * @help 使用该脚本的行走图素材文件名前面添加一个标志 ＠(英文半角)
 * 文件名的命名规范如下：
 * ＠VIPArcher.png 或者 $＠VIPArcher.png
 *   ◆ 然后必须提供配套的不同姿势素材，各姿势素材命名如下：
 * · (普通姿势斜方向)：FILE_NAME + _8D.png
 * · (奔跑姿势四方向)：FILE_NAME + _DASH.png
 * · (奔跑姿势斜方向)：FILE_NAME + _DASH_8D.png
 * · (待机姿势四方向)：FILE_NAME + _IDLE.png
 * · (待机姿势斜方向)：FILE_NAME + _IDLE_8D.png
 *   ◆ 使用多帧则名为(默认设置): ＠文件名[f帧数h静止帧].png
 *   例如 ＠VIPArcher[f8h1].png
 */
var VIPArcher = VIPArcher || {};
VIPArcher.CharAnime = {};
VIPArcher.CharAnime.version = '1.5.0';
void function() {
    var _CharAnime = VIPArcher.CharAnime;
    _CharAnime.Parameters = PluginManager.parameters('VIPArcher_CharacterPoses');
    _CharAnime.MoveDir8   = Boolean(_CharAnime.Parameters['MoveDir8'] === 'true' || false);
    _CharAnime.AnimationSpeed = Number(_CharAnime.Parameters['AnimationSpeed'] || 0);
    _CharAnime.GapTime   = Number(_CharAnime.Parameters['GapTime']   || 120);
    _CharAnime.MinTime   = Number(_CharAnime.Parameters['MinTime']   || 120);
    _CharAnime.RandTime  = Number(_CharAnime.Parameters['RandTime']  || 120);
    _CharAnime.IdleTimes = Number(_CharAnime.Parameters['IdleTimes'] || 1);
    _CharAnime.NoteIdle  = String(_CharAnime.Parameters['NoteIdle']  || '<idleAnime>');
    ImageManager.isDir8Character = function(filename) {
        var sign = filename.match(/^[\!\$\@]+/);
        return sign && sign[0].contains('@');
    };
    ImageManager.isMultiFrames = function(filename) {
        return /\[f\d+h?\d*\]/i.test(filename);
    };
    ImageManager.getMaxFrame = function(filename) {
        var match = /\[f(\d+)h?\d*\]/i.exec(filename);
        return match ? parseInt(match[1]) : 3;
    };
    ImageManager.getHaltFrame = function(filename) {
        var match = /\[f\d+h(\d+)\]/i.exec(filename);
        return match ? parseInt(match[1]) : 1;
    };
    var _Game_CharacterBaseinitMembers = Game_CharacterBase.prototype.initMembers;
    Game_CharacterBase.prototype.initMembers = function() {
        _Game_CharacterBaseinitMembers.call(this);
        this._idleCount = 0;
        this._isIdle = false;
    };
    var _Game_CharacterBasesetImage = Game_CharacterBase.prototype.setImage;
    Game_CharacterBase.prototype.setImage = function(characterName, characterIndex) {
        _Game_CharacterBasesetImage.call(this, characterName, characterIndex);
        this._pattern = this._originalPattern = ImageManager.getHaltFrame(characterName);
        if (!this._characterName) {this._characterName = ''};
        if (!this._characterIndex) {this._characterIndex = 0};
        this._originalName = this._characterName;
        if (this.isDir8Character()) {this.setCachePoses()};
    };
    Game_CharacterBase.prototype.setCachePoses = function() {
        this._posesName = {};
        this._posesName["dash"] = ImageManager.loadCharacter(this._originalName + "_DASH");
        this._posesName["idle"] = ImageManager.loadCharacter(this._originalName + "_IDLE");
        if (!_CharAnime.MoveDir8) { return; };
        this._posesName["dir8"] = ImageManager.loadCharacter(this._originalName + "_8D");
        this._posesName["dash_dir8"] = ImageManager.loadCharacter(this._originalName + "_DASH_8D");
        this._posesName["idle_dir8"] = ImageManager.loadCharacter(this._originalName + "_IDLE_8D");
    };
    Game_CharacterBase.prototype.isMultiFrames = function() {
        return ImageManager.isMultiFrames(this._characterName);
    };
    Game_CharacterBase.prototype.maxFrame = function() {
        return ImageManager.getMaxFrame(this._characterName);
    };
    Game_CharacterBase.prototype.isDir8Character = function() {
        return ImageManager.isDir8Character(this._characterName);
    };
    var _Game_CharacterBaseupdate = Game_CharacterBase.prototype.update;
    Game_CharacterBase.prototype.update = function() {
        _Game_CharacterBaseupdate.call(this);
        if (this.needUpdatePoses()) {this.updatePoses()};
        if (this.isDir8Character()) this.updateIdlePoses();
    };
    Game_CharacterBase.prototype.updatePoses = function() {
        this._characterName = this._originalName + this.poses();
    };
    Game_CharacterBase.prototype.needUpdatePoses = function() {
        if (!this.isDir8Character()) {return false};
        if (this._poses == this.poses()) {return false};
        this._poses = this.poses();
        return true;
    };
    Game_CharacterBase.prototype.poses = function() {
        return (this.isIdle() ? '_IDLE' : this.isDash() ? '_DASH' : '') +
            (this.isDir8() && _CharAnime.MoveDir8 ? '_8D' : '');
    };
    var _Game_CharacterBaseupdateStop = Game_CharacterBase.prototype.updateStop;
    Game_CharacterBase.prototype.updateStop = function() {
        _Game_CharacterBaseupdateStop.call(this);
        this._idleCount++;
    };
    var _Game_CharacterBaseresetStopCount = Game_CharacterBase.prototype.resetStopCount;
    Game_CharacterBase.prototype.resetStopCount = function() {
        _Game_CharacterBaseresetStopCount.call(this);
        this._idleCount = 0;
    };
    Game_CharacterBase.prototype.updateIdlePoses = function() {
        if (this._idleCount == this.startIdleTime()) {
            this.setIdleAnime(true);
        } else if (this._idleCount == this.startIdleTime() + this.idleAnimeTime() - 1) {
            this._idleCount = this.startIdleTime() - this.idleIntervalTime();
            this.setIdleAnime(false);
        } else if (this._idleCount < this.startIdleTime()){
            if (this._isIdle) this.setIdleAnime(false);
        }
    };
    // 进入待机前需要的时间
    Game_CharacterBase.prototype.startIdleTime = function() {
        if (!this._startIdleTime) {
            this._startIdleTime = parseInt(Math.random() * (_CharAnime.RandTime + 1));
            this._startIdleTime += _CharAnime.MinTime;
        }
        return this._startIdleTime;
    };
    // 一次待机需要的时间
    Game_CharacterBase.prototype.idleAnimeTime = function() {
        return this.animationWait() * this.maxPattern() * _CharAnime.IdleTimes;
    };
    // 两次待机之间的时间间隔
    Game_CharacterBase.prototype.idleIntervalTime = function() {
        return _CharAnime.GapTime;
    };
    // 设置待机动画
    Game_CharacterBase.prototype.setIdleAnime = function(idleAnime) {
        this._isIdle = idleAnime;
        this.setStepAnime(idleAnime);
    };
    Game_CharacterBase.prototype.animationWait = function() {
        return (9 - this.realMoveSpeed()) * 3;
    };
    var _Game_CharacterBaseanimationWait = Game_CharacterBase.prototype.animationWait;
    Game_CharacterBase.prototype.animationWait = function() {
        var wait = _Game_CharacterBaseanimationWait.call(this);
        return Math.max(wait * this.animationWaitSpeed() / 10, 2);
    };
    Game_CharacterBase.prototype.animationWaitSpeed = function() {
        return Math.max(10 - _CharAnime.AnimationSpeed, 0);
    };
    var _Game_CharacterBasemoveDiagonally = Game_CharacterBase.prototype.moveDiagonally;
    Game_CharacterBase.prototype.moveDiagonally = function(horz, vert) {
        _Game_CharacterBasemoveDiagonally.call(this, horz, vert);
        if (horz > 5) {
            vert > 5 ? this.setDirection(9) : this.setDirection(7);
        } else {
            vert > 5 ? this.setDirection(3) : this.setDirection(1);
        };
    };
    Game_CharacterBase.prototype.pattern = function() {
        return this._pattern < this.maxFrame() ? this._pattern : this.isMultiFrames() ? 0 : 1;
    };
    Game_CharacterBase.prototype.maxPattern = function() {
        return this.maxFrame() === 3 ? 4 : this.maxFrame();
    };
    var _Game_CharacterBasestraighten = Game_CharacterBase.prototype.straighten;
    Game_CharacterBase.prototype.straighten = function() {
        if (this.isMultiFrames()) {
            if (this.hasWalkAnime() || this.hasStepAnime()) this._pattern = this._originalPattern;
            this._animationCount = 0;
        } else {
            _Game_CharacterBasestraighten.call(this);
        }
    };
    Game_CharacterBase.prototype.isOriginalPattern = function() {
        return this.pattern() === this._originalPattern;
    };
    var _Game_CharacterBaseresetPattern = Game_CharacterBase.prototype.resetPattern;
    Game_CharacterBase.prototype.resetPattern = function() {
        if (this.isMultiFrames()) {
            this.setPattern(this._originalPattern);
        } else {
            _Game_CharacterBaseresetPattern.call(this);
        }
    };
    Game_CharacterBase.prototype.isDash = function() {
        return this._idleCount == 0 && (this.isDashing() || this._moveSpeed > 4);
    };
    Game_CharacterBase.prototype.isIdle = function() {
        return this._isIdle;
    };
    Game_CharacterBase.prototype.isDir8 = function() {
        return this.direction() % 2 != 0;
    };
    var _Game_PlayermoveByInput = Game_Player.prototype.moveByInput;
    Game_Player.prototype.moveByInput = function() {
        if (_CharAnime.MoveDir8) {
            if (!this.isMoving() && this.canMove()) {
                var direction = Input.dir8;
                if (direction > 0) {
                    $gameTemp.clearDestination();
                } else if ($gameTemp.isDestinationValid()){
                    var x = $gameTemp.destinationX();
                    var y = $gameTemp.destinationY();
                    direction = this.findDirectionTo(x, y);
                };
                if (direction > 0) {
                    if (direction % 2 == 0){
                        this.executeMove(direction);
                        return;
                    }
                    if (direction < 5){
                        this.moveDiagonally(direction + 3 , 2);
                    } else {
                        this.moveDiagonally(direction - 3 , 8);
                    }
                }
            }
        } else {
            _Game_PlayermoveByInput.call(this);
        }
    };
    var _Game_PlayermoveDiagonally = Game_Player.prototype.moveDiagonally;
    Game_Player.prototype.moveDiagonally = function(horz, vert) {
        if (!this.canPass(this._x, this._y, horz) && !this.canPass(this._x, this._y, vert)){
            this.setMovementSuccess(false);
            return;
        }
        if (this.canPass(this._x, this._y, horz) && !this.canPass(this._x, this._y, vert)){
            this.moveStraight(horz);
            return;
        }
        if (this.canPass(this._x, this._y, vert) && !this.canPass(this._x, this._y, horz)){
            this.moveStraight(vert);
            return;
        }
        if (!this.canPassDiagonally(this._x, this._y, horz, vert)) {
            if (Math.random() > 0.5){
                this.setDirection(vert); this.moveStraight(vert);
            } else {
                this.setDirection(horz); this.moveStraight(horz);
            }
            return;
        }
        _Game_PlayermoveDiagonally.call(this, horz, vert);
    };
    var _Game_Followerupdate = Game_Follower.prototype.update
    Game_Follower.prototype.update = function() {
        _Game_Followerupdate.call(this);
        this._stepAnime = this.isIdle();
    };
    Game_Event.prototype.updateIdlePoses = function() {
        if (this.noteIsIdle()) Game_CharacterBase.prototype.updateIdlePoses.call(this);
    };
    Game_Event.prototype.noteIsIdle = function() {
        var _list = this.list();
        for(var event of _list){
            if (event.code == 108 || event.code == 408) {
                if ((new RegExp(_CharAnime.IdleAnime)).test(event.parameters[0])) {return true}
            }
        }
        return false;
    };
    Sprite_Character.prototype.characterPatternY = function() {
        if (this._character.direction() % 2 == 0){
            return (this._character.direction() - 2) / 2;
        } else {
            var _dir = this._character.direction();
            if (this._character.isDir8Character()){
                _dir = (_dir == 3 || _dir == 7) ? 10 - _dir : _dir;
            };
            return parseInt((_dir + 1) / 3);
        }
    };
    Sprite_Character.prototype.patternWidth = function() {
        if (this._tileId > 0) {
            return $gameMap.tileWidth();
        } else if (this._isBigCharacter) {
            return this.bitmap.width / this._character.maxFrame();
        } else {
            return this.bitmap.width / (this._character.maxFrame() * 4);
        }
    };
    Sprite_Character.prototype.characterBlockX = function() {
        if (this._isBigCharacter) {
            return 0;
        } else {
            var index = this._character.characterIndex();
            return (index % 4) * this._character.maxFrame();
        }
    };
}();
void function(){
    var _Window_BasedrawCharacter = Window_Base.prototype.drawCharacter;
    Window_Base.prototype.drawCharacter = function(characterName, characterIndex, x, y) {
        if (ImageManager.isMultiFrames(characterName)) {
            var frames = ImageManager.getMaxFrame(characterName);
            var bitmap = ImageManager.loadCharacter(characterName);
            var big = ImageManager.isBigCharacter(characterName);
            var pw = bitmap.width / (big ? frames : frames * 4);
            var ph = bitmap.height / (big ? 4 : 8);
            var n = characterIndex;
            var sx = (n % 4 * 3 + 1) * pw;
            var sy = (Math.floor(n / 4) * 4) * ph;
            this.contents.blt(bitmap, sx, sy, pw, ph, x - pw / 2, y - ph);
        } else {
            _Window_BasedrawCharacter.call(this, characterName, characterIndex, x, y)
        }
    };
}();