/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign;

import com.fs.graphics.particle.BaseParticle;
import com.fs.graphics.particle.DynamicParticleGroup;
import com.fs.graphics.particle.SmoothParticle;
import com.fs.starfarer.campaign.WarpingSpriteRenderer;
import com.fs.starfarer.combat.OOOo;
import com.fs.starfarer.settings.StarfarerSettings;
import com.fs.starfarer.util.ColorShifter;
import com.fs.starfarer.util.ReplaceableSprite;
import com.fs.util.DoNotObfuscate;
import java.awt.Color;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;

public class BackgroundAndStars
implements DoNotObfuscate,
ReplaceableSprite.SpriteUpdateDelegate {
    private transient OOOo starfield;
    private transient OOOo starfield2;
    private transient OOOo starfield3;
    private Vector2f bgOffset = new Vector2f();
    private ReplaceableSprite sprite;
    private boolean hyperspaceMode = false;
    private WarpingSpriteRenderer warpngRenderer = null;
    private ColorShifter colorShifter = new ColorShifter(new Color(255, 255, 255, 255));
    private ColorShifter particleColorShifter = new ColorShifter(new Color(191, 191, 191, 200));
    private boolean wasShifted = false;

    public BackgroundAndStars(boolean bl) {
        this.hyperspaceMode = bl;
        if (bl) {
            this.warpngRenderer = new WarpingSpriteRenderer(16, 16);
            this.sprite = new ReplaceableSprite(StarfarerSettings.new("backgrounds", "defaultHyperBackground"), this);
        } else {
            this.sprite = new ReplaceableSprite(StarfarerSettings.new("backgrounds", "defaultSpaceBackground"), this);
        }
        this.readResolve();
    }

    Object readResolve() {
        float f2 = StarfarerSettings.O\u00d30000();
        float f3 = StarfarerSettings.null.new();
        this.starfield = new OOOo(0.0f, 0.0f, f2, f3, 0.25f);
        this.starfield2 = new OOOo(0.0f, 0.0f, f2, f3, 0.25f);
        this.starfield3 = new OOOo(0.0f, 0.0f, 1.0f, 1.0f, 0.25f);
        if (this.hyperspaceMode && this.warpngRenderer == null) {
            this.warpngRenderer = new WarpingSpriteRenderer(16, 16);
        }
        if (this.colorShifter == null) {
            this.colorShifter = new ColorShifter(new Color(255, 255, 255, 255));
        }
        if (this.particleColorShifter == null) {
            this.particleColorShifter = new ColorShifter(new Color(191, 191, 191, 200));
        }
        this.spriteUpdated();
        return this;
    }

    public void advance(float f2) {
        if (this.warpngRenderer != null) {
            this.warpngRenderer.advance(f2);
        }
        if (this.colorShifter != null) {
            this.colorShifter.advance(f2);
        }
        if (this.particleColorShifter != null) {
            this.particleColorShifter.advance(f2);
        }
    }

    public void updateStarfield(float f2, float f3, float f4, float f5) {
        this.starfield.o00000(f2, f3, f4, f5);
        this.starfield2.o00000(f2 / 2.0f, f3 / 2.0f, f4, f5);
        this.starfield3.o00000(f2 / 4.0f, f3 / 4.0f, f4, f5);
    }

    public void renderBG(float f2, float f3) {
        this.renderBG(f2, f3, 1.0f);
    }

    public void renderBG(float f2, float f3, float f4) {
        boolean bl;
        this.sprite.update();
        this.sprite.getSprite().setColor(this.colorShifter.getCurr());
        boolean bl2 = bl = f4 < 1.0f;
        if (bl) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
        }
        this.sprite.getSprite().setAlphaMult(f4);
        if (this.warpngRenderer != null) {
            this.warpngRenderer.renderNoBlendOrRotate(this.sprite.getSprite(), f2 - this.bgOffset.x, f3 - this.bgOffset.y, !bl);
        } else {
            this.sprite.getSprite().renderNoBlendOrRotate(f2 - this.bgOffset.x, f3 - this.bgOffset.y, !bl);
        }
    }

    public void applyColorShift(DynamicParticleGroup dynamicParticleGroup) {
        Color color = this.particleColorShifter.getCurr();
        for (BaseParticle baseParticle : dynamicParticleGroup.getParticles()) {
            if (!(baseParticle instanceof SmoothParticle)) continue;
            ((SmoothParticle)baseParticle).setColor(color);
        }
    }

    public void renderStarfield(float f2, float f3) {
        if (this.particleColorShifter.isShifted() || this.wasShifted) {
            DynamicParticleGroup dynamicParticleGroup;
            Color color = this.particleColorShifter.getCurr();
            if (color.getAlpha() <= 0) {
                return;
            }
            DynamicParticleGroup[] dynamicParticleGroupArray = this.starfield.\u00d200000();
            int n = dynamicParticleGroupArray.length;
            int n2 = 0;
            while (n2 < n) {
                dynamicParticleGroup = dynamicParticleGroupArray[n2];
                this.applyColorShift(dynamicParticleGroup);
                ++n2;
            }
            dynamicParticleGroupArray = this.starfield2.\u00d200000();
            n = dynamicParticleGroupArray.length;
            n2 = 0;
            while (n2 < n) {
                dynamicParticleGroup = dynamicParticleGroupArray[n2];
                this.applyColorShift(dynamicParticleGroup);
                ++n2;
            }
            dynamicParticleGroupArray = this.starfield3.\u00d200000();
            n = dynamicParticleGroupArray.length;
            n2 = 0;
            while (n2 < n) {
                dynamicParticleGroup = dynamicParticleGroupArray[n2];
                this.applyColorShift(dynamicParticleGroup);
                ++n2;
            }
            this.wasShifted = this.particleColorShifter.isShifted();
        }
        this.starfield.o00000(0.0f, 0.0f);
        this.starfield2.o00000(f2 / 2.0f, f3 / 2.0f);
        this.starfield3.o00000(f2 * 0.75f, f3 * 0.75f);
    }

    public void setDefaultBackground() {
        if (this.hyperspaceMode) {
            this.replaceBackground(StarfarerSettings.new("backgrounds", "defaultHyperBackground"));
        } else {
            this.replaceBackground(StarfarerSettings.new("backgrounds", "defaultSpaceBackground"));
        }
    }

    public void replaceBackground(String string) {
        if (string == null) {
            string = this.hyperspaceMode ? StarfarerSettings.new("backgrounds", "defaultHyperBackground") : StarfarerSettings.new("backgrounds", "defaultSpaceBackground");
        }
        this.sprite.replaceTexture(string);
    }

    public void spriteUpdated() {
        float f2 = StarfarerSettings.O\u00d30000();
        float f3 = StarfarerSettings.null.new();
        float f4 = StarfarerSettings.interface.String;
        this.sprite.getSprite().setSize(this.sprite.getSprite().getWidth() / f4, this.sprite.getSprite().getHeight() / f4);
        float f5 = this.sprite.getSprite().getWidth();
        float f6 = this.sprite.getSprite().getHeight();
        if (f2 > f5) {
            this.sprite.getSprite().setWidth(f2);
            this.sprite.getSprite().setHeight(f6 * f2 / f5);
        }
        f5 = this.sprite.getSprite().getWidth();
        f6 = this.sprite.getSprite().getHeight();
        if (f3 > f6) {
            this.sprite.getSprite().setHeight(f3);
            this.sprite.getSprite().setWidth(f5 * f3 / f6);
        }
        this.bgOffset.x = (float)Math.random() * (this.sprite.getSprite().getWidth() - f2);
        this.bgOffset.y = (float)Math.random() * (this.sprite.getSprite().getHeight() - f3);
    }

    public ReplaceableSprite getSprite() {
        return this.sprite;
    }

    public void setBackgroundOffset(float f2, float f3) {
        this.bgOffset.x = f2;
        this.bgOffset.y = f3;
    }

    public ColorShifter getColorShifter() {
        return this.colorShifter;
    }

    public ColorShifter getParticleColorShifter() {
        return this.particleColorShifter;
    }
}

