/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign;

import com.fs.graphics.Sprite;
import com.fs.graphics.util.OoOO;
import com.fs.starfarer.api.campaign.AsteroidAPI;
import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.campaign.BaseCampaignEntity;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.CampaignEntity;
import com.fs.starfarer.combat.CombatViewport;
import com.fs.starfarer.prototype.Utils;
import com.fs.starfarer.renderers.O;
import com.fs.util.DoNotObfuscate;
import java.awt.Color;
import java.util.EnumSet;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CampaignAsteroid
extends BaseCampaignEntity
implements DoNotObfuscate,
AsteroidAPI {
    private transient Sprite shadowMask;
    private transient Sprite sprite;
    private float rotation;
    private float radius;
    private transient EnumSet<CampaignEngineLayers> layers = EnumSet.of(CampaignEngineLayers.ASTEROIDS);

    public CampaignAsteroid(float f2, float f3, float f4, CampaignEntity campaignEntity) {
        super(null);
        this.radius = f2;
        this.setLightSource(campaignEntity, Color.white);
        this.getLocation().set(f3, f4);
        this.rotation = (float)Math.random() * 10.0f - 5.0f;
        this.facing = (float)Math.random() * 360.0f;
        this.readResolve();
        this.setName("Asteroid");
    }

    @Override
    protected Object writeReplace() {
        super.writeReplace();
        this.rotation = (float)Math.round(this.rotation * 10.0f) / 10.0f;
        this.radius = (float)Math.round(this.radius * 10.0f) / 10.0f;
        this.facing = (float)Math.round(this.facing * 10.0f) / 10.0f;
        return this;
    }

    @Override
    protected Object readResolve() {
        super.readResolve();
        this.layers = EnumSet.of(CampaignEngineLayers.ASTEROIDS);
        String string = null;
        string = this.radius < 5.0f ? "graphics/asteroids/asteroid1.png" : (this.radius < 10.0f ? "graphics/asteroids/asteroid2.png" : (this.radius < 15.0f ? "graphics/asteroids/asteroid3.png" : "graphics/asteroids/asteroid4.png"));
        this.sprite = new Sprite(string);
        this.sprite.setSize(this.radius * 2.0f, this.radius * 2.0f);
        this.shadowMask = new Sprite("graphics/fx/ship_shadow_mask.png");
        float f2 = this.radius * 3.0f;
        this.shadowMask.setSize(f2, f2);
        return this;
    }

    @Override
    public void advance(float f2) {
        super.advance(f2);
        this.facing += this.rotation * f2;
    }

    public void forceRender() {
        this.render(CampaignEngineLayers.ASTEROIDS, CampaignEngine.getInstance().getViewport());
    }

    @Override
    public void render(CampaignEngineLayers campaignEngineLayers, CombatViewport combatViewport) {
        if (!combatViewport.isNearViewport(this.getLocation(), this.radius + 100.0f)) {
            return;
        }
        if (campaignEngineLayers == CampaignEngineLayers.ASTEROIDS) {
            float f2 = combatViewport.getAlphaMult();
            f2 *= this.getSensorFaderBrightness();
            if (this.getLightSource() != null && this.getLightColor() != null) {
                this.sprite.setColor(this.getLightColor());
            } else {
                this.sprite.setColor(Color.white);
            }
            Vector2f vector2f = this.getLocation();
            this.sprite.setNormalBlend();
            this.sprite.setAlphaMult(f2);
            this.sprite.setAngle(this.facing);
            this.sprite.renderAtCenter(vector2f.x, vector2f.y);
            if (this.getLightSource() != null && this.getLightColor() != null && !this.getLightSource().hasTag("ambient_ls")) {
                float f3;
                float f4 = f3 = this.shadowMask.getWidth() * 1.41f;
                GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)true);
                GL11.glPushMatrix();
                GL11.glTranslatef((float)vector2f.x, (float)vector2f.y, (float)0.0f);
                O.\u00d500000(0.0f - f3 / 2.0f - 1.0f, 0.0f - f4 / 2.0f - 1.0f, f3 + 2.0f, f4 + 2.0f, O.o00000, 0.0f);
                GL11.glPopMatrix();
                this.sprite.setColor(OoOO.String((Color)this.getLightColor()));
                this.sprite.setBlendFunc(1, 0);
                this.sprite.renderAtCenter(vector2f.x, vector2f.y);
                float f5 = Utils.\u00d500000(this.getLocation(), this.getLightSource().getLocation());
                this.shadowMask.setAlphaMult(f2);
                this.shadowMask.setAngle(f5);
                this.shadowMask.setBlendFunc(0, 770);
                this.shadowMask.renderAtCenter(vector2f.x, vector2f.y);
                GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                this.shadowMask.setBlendFunc(772, 773);
                this.shadowMask.renderAtCenter(vector2f.x, vector2f.y);
            }
        }
    }

    @Override
    public EnumSet<CampaignEngineLayers> getActiveLayers() {
        return this.layers;
    }

    @Override
    public float getRadius() {
        return this.radius;
    }

    public boolean isStar() {
        return false;
    }

    public float getRotation() {
        return this.rotation;
    }

    public void setRotation(float f2) {
        this.rotation = f2;
    }
}

