/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign;

import com.fs.starfarer.C;
import com.fs.starfarer.String.L;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.comm.CommMessageAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.ListenerUtil;
import com.fs.starfarer.api.characters.AfterShipCreationSkillEffect;
import com.fs.starfarer.api.characters.FleetTotalItem;
import com.fs.starfarer.api.characters.FleetTotalSource;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.SkillEffectType;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.StatBonus;
import com.fs.starfarer.api.impl.campaign.intel.MessageIntel;
import com.fs.starfarer.api.impl.campaign.plog.PlaythroughLog;
import com.fs.starfarer.api.plugins.LevelupPlugin;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.combat.entities.Ship;
import com.fs.starfarer.combat.entities.ship.class;
import com.fs.starfarer.coreui.refit.auto.I;
import com.fs.starfarer.loading.SkillSpec;
import com.fs.starfarer.loading.SpecStore;
import com.fs.starfarer.loading.o0OO;
import com.fs.starfarer.loading.scripts.ScriptStore;
import com.fs.starfarer.settings.StarfarerSettings;
import com.fs.starfarer.util.DynamicStats;
import com.fs.util.DoNotObfuscate;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharacterStats
implements DoNotObfuscate,
Cloneable,
MutableCharacterStatsAPI {
    private static Map<String, List<o>> effectCache;
    private transient List<AptitudeLevel> aptitudes = new ArrayList<AptitudeLevel>();
    private transient List<SkillLevel> skills = new ArrayList<SkillLevel>();
    private String a;
    private String s;
    private long xpAtLastStoryPointGain = 0L;
    private long xp = 0L;
    private long bonusXp = 0L;
    private long deferredBonusXp = 0L;
    private int level = 1;
    private int points = 0;
    private int storyPoints = 0;
    private CampaignFleetAPI fleet;
    private DynamicStats dynamic = new DynamicStats();
    private MutableStat adminNumber = new MutableStat(StarfarerSettings.\u00f500000("baseMaxAdmins"));
    private MutableStat outpostNumber = new MutableStat(StarfarerSettings.\u00f500000("baseMaxOutposts"));
    private MutableStat weaponOPCostMult = new MutableStat(1.0f);
    private StatBonus smallWeaponOPCost = new StatBonus();
    private StatBonus mediumWeaponOPCost = new StatBonus();
    private StatBonus largeWeaponOPCost = new StatBonus();
    private StatBonus shipOrdnancePointBonus = new StatBonus();
    private MutableStat repairRateMult = new MutableStat(1.0f);
    private MutableStat commandPoints = new MutableStat((float)StarfarerSettings.\u00f5\u00d20000());
    private MutableStat marineEffectivnessMult = new MutableStat(1.0f);
    private StatBonus combatDeploymentCost = new StatBonus();
    private StatBonus maxCapacitorsBonus = new StatBonus();
    private StatBonus maxVentsBonus = new StatBonus();
    private StatBonus travelSpeedBonus = new StatBonus();
    private MutableStat officerNumber = new MutableStat(StarfarerSettings.class.String());
    private transient String bonusXPGainReason = null;
    private transient boolean onlyAddBonusXPDoNotSpendStoryPoints = false;
    private transient boolean skipRefresh = true;

    public long getDeferredBonusXp() {
        return this.deferredBonusXp;
    }

    public void setDeferredBonusXp(long l2) {
        this.deferredBonusXp = l2;
    }

    public CharacterStats clone() {
        try {
            CharacterStats characterStats = (CharacterStats)super.clone();
            characterStats.aptitudes = new ArrayList<AptitudeLevel>();
            for (AptitudeLevel object : this.aptitudes) {
                characterStats.aptitudes.add(object.clone());
            }
            characterStats.skills = new ArrayList<SkillLevel>();
            for (SkillLevel skillLevel : this.skills) {
                characterStats.skills.add(skillLevel.clone());
            }
            characterStats.officerNumber = this.officerNumber.createCopy();
            characterStats.adminNumber = this.adminNumber.createCopy();
            characterStats.weaponOPCostMult = this.weaponOPCostMult.createCopy();
            characterStats.smallWeaponOPCost = this.smallWeaponOPCost.createCopy();
            characterStats.mediumWeaponOPCost = this.mediumWeaponOPCost.createCopy();
            characterStats.largeWeaponOPCost = this.largeWeaponOPCost.createCopy();
            characterStats.shipOrdnancePointBonus = this.shipOrdnancePointBonus.createCopy();
            characterStats.marineEffectivnessMult = this.marineEffectivnessMult.createCopy();
            characterStats.commandPoints = this.commandPoints.createCopy();
            characterStats.combatDeploymentCost = this.combatDeploymentCost.createCopy();
            characterStats.maxCapacitorsBonus = this.maxCapacitorsBonus.createCopy();
            characterStats.maxVentsBonus = this.maxVentsBonus.createCopy();
            characterStats.travelSpeedBonus = this.travelSpeedBonus.createCopy();
            characterStats.officerNumber = this.officerNumber.createCopy();
            if (this.dynamic != null) {
                characterStats.dynamic = new DynamicStats();
                for (String string : this.dynamic.getStats().keySet()) {
                    characterStats.dynamic.getStats().put(string, this.dynamic.getStats().get(string).createCopy());
                }
                for (String string : this.dynamic.getMods().keySet()) {
                    characterStats.dynamic.getMods().put(string, this.dynamic.getMods().get(string).createCopy());
                }
            }
            return characterStats;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean sameAs(CharacterStats characterStats) {
        if (characterStats == null) {
            return false;
        }
        if (characterStats.points != this.points) {
            return false;
        }
        if (characterStats.storyPoints != this.storyPoints) {
            return false;
        }
        for (SkillLevel skillLevel : this.skills) {
            if (skillLevel.getLevel() == characterStats.getSkillLevel(skillLevel.getSkill())) continue;
            return false;
        }
        for (SkillLevel skillLevel : characterStats.skills) {
            if (skillLevel.getLevel() == this.getSkillLevel(skillLevel.getSkill())) continue;
            return false;
        }
        return true;
    }

    public static Map<String, List<o>> getEffectCache() {
        if (effectCache == null) {
            effectCache = new HashMap<String, List<o>>();
        }
        return effectCache;
    }

    public long getBonusXp() {
        return this.bonusXp;
    }

    public void setBonusXp(long l2) {
        this.bonusXp = l2;
    }

    public void addBonusXP(long l2, boolean bl, TextPanelAPI textPanelAPI, boolean bl2) {
        if (l2 <= 0L) {
            return;
        }
        this.bonusXp += l2;
        if (CampaignEngine.getInstance().getPlayerStats() == this && bl) {
            String string = Misc.getWithDGS((float)l2);
            String string2 = "Gained " + string + " bonus experience";
            if (this.bonusXPGainReason != null) {
                string2 = String.valueOf(string2) + " " + this.bonusXPGainReason;
            }
            if (bl2 && textPanelAPI == null) {
                Global.getSector().getCampaignUI().getMessageDisplay().addMessage(string2, string, C.\u00d5O0000);
            } else if (textPanelAPI != null) {
                textPanelAPI.setFontSmallInsignia();
                textPanelAPI.addParagraph(string2, Misc.getStoryOptionColor());
                textPanelAPI.highlightLastInLastPara(string + " bonus experience", Misc.getStoryOptionColor());
                textPanelAPI.setFontInsignia();
            } else {
                MessageIntel messageIntel = new MessageIntel(string2, Misc.getBasePlayerColor(), new String[]{string}, new Color[]{Misc.getHighlightColor()});
                Global.getSector().getCampaignUI().addMessage((IntelInfoPlugin)messageIntel);
            }
        }
    }

    public void spendStoryPoints(int n, boolean bl, TextPanelAPI textPanelAPI, boolean bl2, String string) {
        this.spendStoryPoints(n, bl, textPanelAPI, bl2, 0.0f, string);
    }

    public void setOnlyAddBonusXPDoNotSpendStoryPoints(boolean bl) {
        this.onlyAddBonusXPDoNotSpendStoryPoints = bl;
    }

    public void setBonusXPGainReason(String string) {
        this.bonusXPGainReason = string;
    }

    public void spendStoryPoints(int n, boolean bl, TextPanelAPI textPanelAPI, boolean bl2, float f2, String string) {
        if (!this.onlyAddBonusXPDoNotSpendStoryPoints) {
            this.storyPoints -= n;
        }
        if (this.storyPoints < 0) {
            this.storyPoints = 0;
        }
        if (CampaignEngine.getInstance().getPlayerStats() == this) {
            if (string != null) {
                PlaythroughLog.getInstance().addEntry(string);
            }
            if (bl && !this.onlyAddBonusXPDoNotSpendStoryPoints) {
                String string2 = "" + n;
                String string3 = "point";
                if (n != 1) {
                    string3 = "points";
                }
                String string4 = "Used " + string2 + " " + Misc.STORY + " " + string3;
                if (bl2 && textPanelAPI == null) {
                    Global.getSector().getCampaignUI().getMessageDisplay().addMessage(string4, string2, C.\u00d5O0000);
                } else if (textPanelAPI != null) {
                    textPanelAPI.setFontSmallInsignia();
                    textPanelAPI.addParagraph(string4, Misc.getStoryOptionColor());
                    textPanelAPI.highlightLastInLastPara(string2 + " " + Misc.STORY + " " + string3, Misc.getStoryOptionColor());
                    textPanelAPI.setFontInsignia();
                } else {
                    MessageIntel messageIntel = new MessageIntel(string4, Misc.getBasePlayerColor(), new String[]{string2}, new Color[]{Misc.getHighlightColor()});
                    Global.getSector().getCampaignUI().addMessage((IntelInfoPlugin)messageIntel);
                }
            }
            float f3 = 0.0f;
            int n2 = 0;
            while (n2 < n) {
                boolean bl3;
                float f4 = Math.round((float)this.getTotalBonusAndDeferredXPForStoryPoint() * f2);
                float f5 = Math.round((float)this.getBonusXPForSpendingStoryPointBeforeSpendingIt() * f2);
                LevelupPlugin levelupPlugin = ScriptStore.o00000(LevelupPlugin.class);
                int n3 = levelupPlugin.getMaxLevel();
                boolean bl4 = bl3 = this.level >= n3;
                if (bl3) {
                    f5 = f4;
                }
                f3 += f5;
                this.deferredBonusXp = (long)((float)this.deferredBonusXp + Math.max(0.0f, f4 - f5));
                ++n2;
            }
            if (f3 > 0.0f) {
                this.addBonusXP(Math.round(f3), bl, textPanelAPI, bl2);
            }
        }
    }

    public long getXPThresholdForNextStoryPoint(long l2) {
        LevelupPlugin levelupPlugin = ScriptStore.o00000(LevelupPlugin.class);
        int n = levelupPlugin.getStoryPointsPerLevel();
        int n2 = levelupPlugin.getMaxLevel();
        long l3 = levelupPlugin.getXPForLevel(this.level);
        long l4 = levelupPlugin.getXPForLevel(this.level + 1);
        long l5 = (l4 - l3) / (long)n;
        if (l5 <= 0L) {
            l5 = 100000L;
        }
        long l6 = l3;
        int n3 = this.level + 1;
        int n4 = 1;
        while ((l6 += l5) <= l2) {
            if (n4 % n == 0 && n3 < n2 + 1) {
                long l7 = l4;
                l4 = levelupPlugin.getXPForLevel(++n3);
                l5 = (l4 - l7) / (long)n;
            }
            ++n4;
        }
        return l6;
    }

    public long getTotalBonusAndDeferredXPForStoryPoint() {
        LevelupPlugin levelupPlugin = ScriptStore.o00000(LevelupPlugin.class);
        int n = levelupPlugin.getStoryPointsPerLevel();
        int n2 = levelupPlugin.getMaxLevel() + 1;
        long l2 = levelupPlugin.getXPForLevel(n2 - 1);
        long l3 = levelupPlugin.getXPForLevel(n2);
        return (l3 - l2) / (long)n;
    }

    public long getBonusXPForSpendingStoryPointBeforeSpendingIt() {
        LevelupPlugin levelupPlugin = ScriptStore.o00000(LevelupPlugin.class);
        int n = levelupPlugin.getStoryPointsPerLevel();
        int n2 = 1;
        while (levelupPlugin.getXPForLevel(n2 + 1) <= this.xp + this.bonusXp * 2L) {
            if (++n2 >= levelupPlugin.getMaxLevel()) break;
        }
        if (n2 < levelupPlugin.getMaxLevel() - 1) {
            long l2 = levelupPlugin.getXPForLevel(n2);
            long l3 = levelupPlugin.getXPForLevel(n2 + 1);
            long l4 = levelupPlugin.getXPForLevel(n2 + 2);
            float f2 = (float)(this.xp + this.bonusXp * 2L - l2) / (float)(l3 -= l2);
            float f3 = 1.0f / (float)n;
            float f4 = f2 + f3 * 2.0f;
            float f5 = Math.max(0.0f, Math.min(1.0f, f4) - f2) * (float)l3;
            float f6 = Math.max(0.0f, f4 - 1.0f) * (float)((l4 -= l2) - l3);
            return Math.round((f5 + f6) * 0.5f);
        }
        int n3 = this.level + 1;
        n3 = Math.min(n3, levelupPlugin.getMaxLevel() + 1);
        long l5 = levelupPlugin.getXPForLevel(n3 - 1);
        long l6 = levelupPlugin.getXPForLevel(n3);
        return (l6 - l5) / (long)n;
    }

    public int getStoryPoints() {
        return this.storyPoints;
    }

    public void setStoryPoints(int n) {
        this.storyPoints = n;
    }

    public void addStoryPoints(int n) {
        this.storyPoints += n;
        if (this.storyPoints < 0) {
            this.storyPoints = 0;
        }
    }

    public void addStoryPoints(int n, TextPanelAPI textPanelAPI, boolean bl) {
        this.addStoryPoints(n);
        L.o00000("ui_char_gained_story_point", 1.0f, 1.0f);
        String string = "points";
        if (n == 1) {
            string = "point";
        }
        String string2 = "Gained " + n + " " + Misc.STORY + " " + string;
        if (textPanelAPI != null) {
            textPanelAPI.setFontSmallInsignia();
            textPanelAPI.addParagraph(string2, C.oo0000);
            textPanelAPI.highlightLastInLastPara(n + " " + Misc.STORY + " " + string, Misc.getStoryOptionColor());
            textPanelAPI.setFontInsignia();
        } else {
            MessageIntel messageIntel = new MessageIntel(string2, Misc.getBasePlayerColor(), new String[]{n + " " + Misc.STORY + " " + string}, new Color[]{Misc.getStoryOptionColor()});
            messageIntel.setIcon(CampaignEngine.getInstance().getPlayerPerson().getPortraitSprite());
            Global.getSector().getCampaignUI().addMessage((IntelInfoPlugin)messageIntel, CommMessageAPI.MessageClickAction.CHARACTER_TAB);
        }
        if (bl) {
            CampaignEngine.getInstance().getUIData().setOpenedCharacterTabSinceLevelUp(false);
        }
    }

    public MutableStat getAdminNumber() {
        return this.adminNumber;
    }

    public MutableStat getOutpostNumber() {
        return this.outpostNumber;
    }

    public DynamicStats getDynamic() {
        if (this.dynamic == null) {
            this.dynamic = new DynamicStats();
        }
        return this.dynamic;
    }

    public CharacterStats() {
        for (o0OO o0OO2 : SpecStore.OO0000()) {
            this.setAptitudeLevel(o0OO2.\u00f800000(), 0.0f);
        }
        this.skipRefresh = false;
    }

    public CampaignFleetAPI getFleet() {
        return this.fleet;
    }

    public void setFleet(CampaignFleetAPI campaignFleetAPI) {
        this.fleet = campaignFleetAPI;
    }

    Object readResolve() {
        Cloneable cloneable;
        String string;
        int n;
        int n2;
        String[] stringArray;
        String[] stringArray2;
        this.aptitudes = new ArrayList<AptitudeLevel>();
        this.skills = new ArrayList<SkillLevel>();
        this.weaponOPCostMult = new MutableStat(1.0f);
        this.smallWeaponOPCost = new StatBonus();
        this.mediumWeaponOPCost = new StatBonus();
        this.largeWeaponOPCost = new StatBonus();
        this.marineEffectivnessMult = new MutableStat(1.0f);
        this.combatDeploymentCost = new StatBonus();
        this.maxCapacitorsBonus = new StatBonus();
        this.maxVentsBonus = new StatBonus();
        this.travelSpeedBonus = new StatBonus();
        this.shipOrdnancePointBonus = new StatBonus();
        this.officerNumber = new MutableStat(StarfarerSettings.class.String());
        this.adminNumber = new MutableStat(StarfarerSettings.\u00f500000("baseMaxAdmins"));
        this.outpostNumber = new MutableStat(StarfarerSettings.\u00f500000("baseMaxOutposts"));
        if (this.repairRateMult == null) {
            this.repairRateMult = new MutableStat(1.0f);
        }
        if (this.commandPoints == null) {
            this.commandPoints = new MutableStat((float)StarfarerSettings.\u00f5\u00d20000());
        }
        if (this.a != null) {
            try {
                JSONObject object2 = new JSONObject(this.a);
                stringArray2 = JSONObject.getNames((JSONObject)object2);
                if (stringArray2 != null) {
                    stringArray = stringArray2;
                    n2 = stringArray2.length;
                    n = 0;
                    while (n < n2) {
                        string = stringArray[n];
                        cloneable = new AptitudeLevel(string);
                        ((AptitudeLevel)cloneable).level = (float)object2.getDouble(string);
                        this.aptitudes.add((AptitudeLevel)cloneable);
                        ++n;
                    }
                    Collections.sort(this.aptitudes, new Comparator<AptitudeLevel>(){

                        public int o00000(AptitudeLevel aptitudeLevel, AptitudeLevel aptitudeLevel2) {
                            return aptitudeLevel.aptitude.o00000() - aptitudeLevel2.aptitude.o00000();
                        }
                    });
                }
            }
            catch (JSONException jSONException) {
                throw new RuntimeException(jSONException);
            }
        }
        if (this.s != null) {
            try {
                JSONObject jSONException = new JSONObject(this.s);
                stringArray2 = JSONObject.getNames((JSONObject)jSONException);
                if (stringArray2 != null) {
                    stringArray = stringArray2;
                    n2 = stringArray2.length;
                    n = 0;
                    while (n < n2) {
                        string = stringArray[n];
                        cloneable = new SkillLevel(string);
                        ((SkillLevel)cloneable).level = (float)jSONException.getDouble(string);
                        this.skills.add((SkillLevel)cloneable);
                        ++n;
                    }
                }
            }
            catch (JSONException jSONException) {
                throw new RuntimeException(jSONException);
            }
        }
        for (o0OO o0OO2 : SpecStore.OO0000()) {
            if (this.getAptitudeLevelAsLevel(o0OO2.\u00f800000()) != null) continue;
            this.setAptitudeLevel(o0OO2.\u00f800000(), 0.0f);
        }
        this.refreshCharacterStatsEffects();
        return this;
    }

    Object writeReplace() {
        JSONObject jSONObject;
        boolean bl;
        if (this.dynamic != null) {
            this.dynamic.removeUmodified();
            if (this.dynamic.isEmpty()) {
                this.dynamic = null;
            }
        }
        CharacterStats characterStats = this.clone();
        boolean bl2 = bl = Global.getSector().getCharacterData().getPerson().getStats() == this;
        if (!bl) {
            jSONObject = characterStats.aptitudes.iterator();
            while (jSONObject.hasNext()) {
                AptitudeLevel object3 = (AptitudeLevel)jSONObject.next();
                if (!(object3.getLevel() <= 0.0f) || !(characterStats.getSkillLevel(object3.getAptitude().public()) <= 0.0f)) continue;
                jSONObject.remove();
            }
            Iterator<SkillLevel> iterator = characterStats.skills.iterator();
            while (iterator.hasNext()) {
                SkillLevel skillLevel = iterator.next();
                if (!(skillLevel.getLevel() <= 0.0f)) continue;
                iterator.remove();
            }
        }
        try {
            jSONObject = new JSONObject();
            for (AptitudeLevel aptitudeLevel : characterStats.aptitudes) {
                jSONObject.put(aptitudeLevel.aptitude.\u00f800000(), (double)aptitudeLevel.level);
            }
            characterStats.a = jSONObject.toString();
            JSONObject jSONObject2 = new JSONObject();
            for (SkillLevel skillLevel : characterStats.skills) {
                jSONObject2.put(skillLevel.skill.getId(), (double)skillLevel.level);
            }
            characterStats.s = jSONObject2.toString();
            if (JSONObject.getNames((JSONObject)jSONObject) == null) {
                characterStats.a = null;
            }
            if (JSONObject.getNames((JSONObject)jSONObject2) == null) {
                characterStats.s = null;
            }
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
        if (this.isUnmodified(this.weaponOPCostMult) || !bl) {
            characterStats.weaponOPCostMult = null;
        }
        if (this.isUnmodified(this.smallWeaponOPCost) || !bl) {
            characterStats.smallWeaponOPCost = null;
        }
        if (this.isUnmodified(this.mediumWeaponOPCost) || !bl) {
            characterStats.mediumWeaponOPCost = null;
        }
        if (this.isUnmodified(this.largeWeaponOPCost) || !bl) {
            characterStats.largeWeaponOPCost = null;
        }
        if (this.isUnmodified(this.shipOrdnancePointBonus) || !bl) {
            characterStats.shipOrdnancePointBonus = null;
        }
        if (this.isUnmodified(this.repairRateMult) || !bl) {
            characterStats.repairRateMult = null;
        }
        if (this.isUnmodified(this.commandPoints) || !bl) {
            characterStats.commandPoints = null;
        }
        if (this.isUnmodified(this.marineEffectivnessMult) || !bl) {
            characterStats.marineEffectivnessMult = null;
        }
        if (this.isUnmodified(this.combatDeploymentCost) || !bl) {
            characterStats.combatDeploymentCost = null;
        }
        if (this.isUnmodified(this.maxCapacitorsBonus) || !bl) {
            characterStats.maxCapacitorsBonus = null;
        }
        if (this.isUnmodified(this.maxVentsBonus) || !bl) {
            characterStats.maxVentsBonus = null;
        }
        if (this.isUnmodified(this.travelSpeedBonus) || !bl) {
            characterStats.travelSpeedBonus = null;
        }
        if (this.isUnmodified(this.officerNumber) || !bl) {
            characterStats.officerNumber = null;
        }
        if (this.isUnmodified(this.adminNumber) || !bl) {
            characterStats.adminNumber = null;
        }
        if (this.isUnmodified(this.outpostNumber) || !bl) {
            characterStats.outpostNumber = null;
        }
        return characterStats;
    }

    private boolean isUnmodified(StatBonus statBonus) {
        return statBonus.getFlatBonuses().isEmpty() && statBonus.getMultBonuses().isEmpty() && statBonus.getPercentBonuses().isEmpty();
    }

    private boolean isUnmodified(MutableStat mutableStat) {
        return mutableStat.getFlatMods().isEmpty() && mutableStat.getMultMods().isEmpty() && mutableStat.getPercentMods().isEmpty();
    }

    public void increaseSkill(String string) {
        SkillLevel skillLevel = this.getSkillLevelAsLevel(string);
        if (skillLevel == null) {
            SkillSpec skillSpec = SpecStore.o00000(SkillSpec.class, string);
            skillLevel = new SkillLevel(skillSpec);
            this.skills.add(skillLevel);
        }
        SkillLevel skillLevel2 = skillLevel;
        skillLevel2.level = skillLevel2.level + 1.0f;
        int n = 1;
        if (skillLevel.getSkill().isElite()) {
            n = 2;
        }
        if (skillLevel.level > (float)n) {
            skillLevel.level = n;
        }
        this.refreshCharacterStatsEffects();
    }

    public boolean isSkipRefresh() {
        return this.skipRefresh;
    }

    public void setSkipRefresh(boolean bl) {
        this.skipRefresh = bl;
    }

    public void refreshCharacterStatsEffects() {
        this.refreshCharacterStatsEffects(true);
    }

    public void refreshCharacterStatsEffects(boolean bl) {
        Object object;
        if (this.skipRefresh) {
            return;
        }
        ListenerUtil.reportAboutToRefreshCharacterStatEffects();
        String string = "refreshCharacterStatsEffects";
        List<o> list = CharacterStats.getEffectCache().get(string);
        if (list == null) {
            list = new ArrayList<o>();
            CharacterStats.getEffectCache().put(string, list);
            ArrayList<String> arrayList2 = new ArrayList<String>(SpecStore.\u00d400000(SkillSpec.class));
            for (String string2 : arrayList2) {
                object = SpecStore.o00000(SkillSpec.class, string2);
                int n = 0;
                for (SkillSpec.SkillEffectSpec skillEffectSpec : ((SkillSpec)object).getEffects()) {
                    if (skillEffectSpec.\u00f400000() == SkillEffectType.CHARACTER_STATS || skillEffectSpec.\u00f400000() == SkillEffectType.FLEET) {
                        String string3 = String.valueOf(((SkillSpec)object).getId()) + "_stats_" + n;
                        list.add(new o(skillEffectSpec, string3));
                    }
                    ++n;
                }
            }
        }
        for (o o2 : list) {
            if (o2.super.\u00f400000() == SkillEffectType.CHARACTER_STATS) {
                o2.super.\u00d5O0000().unapply((MutableCharacterStatsAPI)this, o2.\u00d200000);
                continue;
            }
            if (o2.super.\u00f400000() != SkillEffectType.FLEET || this.fleet == null || this.fleet.getStats() == null) continue;
            o2.super.private().unapply(this.fleet.getStats(), o2.\u00d200000);
        }
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        for (SkillLevel skillLevel : this.skills) {
            if (skillLevel.getSkill().isAptitudeEffect() || skillLevel.getLevel() <= 0.0f) continue;
            object = skillLevel.getSkill().getGoverningAptitudeId();
            Integer n = (Integer)hashMap.get(object);
            if (n == null) {
                n = 0;
            }
            n = Math.max(n, skillLevel.getSkill().getTier());
            hashMap.put(object, n);
        }
        for (AptitudeLevel aptitudeLevel : this.aptitudes) {
            object = (Integer)hashMap.get(aptitudeLevel.getAptitude().\u00f800000());
            if (object == null) {
                object = 0;
            }
            aptitudeLevel.setMaxTier((Integer)object);
        }
        for (o o3 : this.getStatsEffects()) {
            float f2 = this.getSkillLevel(o3.super.super());
            o3.super.\u00d5O0000().apply((MutableCharacterStatsAPI)this, o3.\u00d200000, f2);
        }
        if (this.fleet != null && this.fleet.getStats() != null) {
            for (o o4 : this.getFleetEffects()) {
                float f3 = this.getSkillLevel(o4.super.super());
                o4.super.private().apply(this.fleet.getStats(), o4.\u00d200000, f3);
            }
        }
        if (CampaignEngine.getInstance().getPlayerStats() == this && bl) {
            this.refreshAllOutpostsEffectsForPlayerOutposts();
        }
        if (CampaignEngine.getInstance().getPlayerStats() == this) {
            ListenerUtil.reportRefreshedCharacterStatEffects();
        }
    }

    public void decreaseSkill(String string) {
        SkillLevel skillLevel = this.getSkillLevelAsLevel(string);
        if (skillLevel == null) {
            SkillSpec skillSpec = SpecStore.o00000(SkillSpec.class, string);
            skillLevel = new SkillLevel(skillSpec);
            this.skills.add(skillLevel);
        }
        SkillLevel skillLevel2 = skillLevel;
        skillLevel2.level = skillLevel2.level - 1.0f;
        if (skillLevel.level < 0.0f) {
            skillLevel.level = 0.0f;
            this.skills.remove(skillLevel);
        }
        this.refreshCharacterStatsEffects();
    }

    public float getAptitudeLevel(String string) {
        for (AptitudeLevel aptitudeLevel : this.aptitudes) {
            if (!aptitudeLevel.getAptitude().\u00f800000().equals(string)) continue;
            return aptitudeLevel.getLevel();
        }
        return 0.0f;
    }

    public AptitudeLevel getAptitudeLevelAsLevel(String string) {
        for (AptitudeLevel aptitudeLevel : this.aptitudes) {
            if (!aptitudeLevel.getAptitude().\u00f800000().equals(string)) continue;
            return aptitudeLevel;
        }
        return null;
    }

    public float getSkillLevel(SkillSpec skillSpec) {
        return this.getSkillLevel(skillSpec.getId());
    }

    public float getSkillLevel(String string) {
        for (SkillLevel skillLevel : this.skills) {
            if (!skillLevel.getSkill().getId().equals(string)) continue;
            return skillLevel.getLevel();
        }
        return 0.0f;
    }

    public SkillLevel getSkillLevelAsLevel(String string) {
        for (SkillLevel skillLevel : this.skills) {
            if (!skillLevel.getSkill().getId().equals(string)) continue;
            return skillLevel;
        }
        return null;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public List<String> getAvailableHullmodIds() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (SkillLevel skillLevel : this.skills) {
            for (SkillSpec.SkillEffectSpec skillEffectSpec : skillLevel.getSkill().getEffects()) {
                float f2 = this.getSkillLevel(skillEffectSpec.super());
                if (!(f2 > 0.0f) || skillEffectSpec.\u00f400000() != SkillEffectType.HULLMOD_UNLOCK || skillEffectSpec.\u00d500000() == null) continue;
                arrayList.addAll(skillEffectSpec.\u00d200000(f2));
            }
        }
        return arrayList;
    }

    public List<String> getGrantedAbilityIds() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (SkillLevel skillLevel : this.skills) {
            for (SkillSpec.SkillEffectSpec skillEffectSpec : skillLevel.getSkill().getEffects()) {
                float f2 = this.getSkillLevel(skillEffectSpec.super());
                if (!(f2 >= skillEffectSpec.do()) || skillEffectSpec.\u00f400000() != SkillEffectType.ABILITY_UNLOCK || skillEffectSpec.String() == null) continue;
                arrayList.addAll(skillEffectSpec.String());
            }
        }
        return arrayList;
    }

    public boolean isHullModAvailable(String string) {
        return this.getAvailableHullmodIds().contains(string);
    }

    public List<o> getShipEffects() {
        ArrayList<o> arrayList = new ArrayList<o>();
        for (SkillLevel skillLevel : this.skills) {
            int n = 0;
            for (SkillSpec.SkillEffectSpec skillEffectSpec : skillLevel.getSkill().getEffects()) {
                float f2 = this.getSkillLevel(skillEffectSpec.super());
                if (skillEffectSpec.\u00f400000() == SkillEffectType.SHIP && f2 >= skillEffectSpec.do()) {
                    arrayList.add(new o(skillEffectSpec, String.valueOf(skillLevel.getSkill().getId()) + "_ship_" + n));
                }
                ++n;
            }
        }
        return arrayList;
    }

    public List<I> getFleetTotals() {
        ArrayList<FleetTotalItem> arrayList = new ArrayList<FleetTotalItem>();
        HashSet<String> hashSet = new HashSet<String>();
        LinkedHashMap<String, I> linkedHashMap = new LinkedHashMap<String, I>();
        for (SkillLevel cloneable2 : this.skills) {
            for (SkillSpec.SkillEffectSpec skillEffectSpec : cloneable2.getSkill().getEffects()) {
                String string;
                FleetTotalItem fleetTotalItem;
                float f2 = this.getSkillLevel(skillEffectSpec.super());
                if (!(f2 >= skillEffectSpec.do())) continue;
                FleetTotalSource fleetTotalSource = skillEffectSpec.\u00d300000();
                if (fleetTotalSource != null) {
                    fleetTotalItem = fleetTotalSource.getFleetTotalItem();
                    String string2 = string = fleetTotalItem != null ? String.valueOf(fleetTotalItem.label) + "_" + fleetTotalItem.value : "";
                    if (fleetTotalItem != null && !hashSet.contains(string)) {
                        arrayList.add(fleetTotalItem);
                        hashSet.add(string);
                    }
                }
                if (fleetTotalSource == null) continue;
                fleetTotalItem = fleetTotalSource.getFleetTotalItem();
                string = fleetTotalItem != null ? String.valueOf(fleetTotalItem.label) + "_" + fleetTotalItem.value : "";
                I i2 = (I)linkedHashMap.get(string);
                if (i2 == null) {
                    i2 = new I();
                    i2.\u00d200000 = fleetTotalItem;
                    linkedHashMap.put(string, i2);
                }
                i2.super.add(cloneable2);
            }
        }
        ArrayList<I> arrayList2 = new ArrayList<I>(linkedHashMap.values());
        Collections.sort(arrayList2, new Comparator<I>(){

            public int super(I i2, I i3) {
                return (int)Math.signum(i2.\u00d200000.sortOrder - i3.\u00d200000.sortOrder);
            }
        });
        for (Object i3 : arrayList2) {
            Collections.sort(((I)i3).super, new Comparator<MutableCharacterStatsAPI.SkillLevelAPI>(){

                public int o00000(MutableCharacterStatsAPI.SkillLevelAPI skillLevelAPI, MutableCharacterStatsAPI.SkillLevelAPI skillLevelAPI2) {
                    return (int)Math.signum(skillLevelAPI.getSkill().getOrder() - skillLevelAPI2.getSkill().getOrder());
                }
            });
        }
        return arrayList2;
    }

    public List<o> getOutpostEffects() {
        ArrayList<o> arrayList = new ArrayList<o>();
        for (SkillLevel skillLevel : this.skills) {
            int n = 0;
            for (SkillSpec.SkillEffectSpec skillEffectSpec : skillLevel.getSkill().getEffects()) {
                float f2 = this.getSkillLevel(skillEffectSpec.super());
                if (skillEffectSpec.\u00f400000() == SkillEffectType.GOVERNED_OUTPOST && f2 >= skillEffectSpec.do()) {
                    arrayList.add(new o(skillEffectSpec, String.valueOf(skillLevel.getSkill().getId()) + "_GO_" + n));
                }
                ++n;
            }
        }
        return arrayList;
    }

    public List<o> getAllOutpostEffects() {
        ArrayList<o> arrayList = new ArrayList<o>();
        for (SkillLevel skillLevel : this.skills) {
            int n = 0;
            for (SkillSpec.SkillEffectSpec skillEffectSpec : skillLevel.getSkill().getEffects()) {
                float f2 = this.getSkillLevel(skillEffectSpec.super());
                if (skillEffectSpec.\u00f400000() == SkillEffectType.ALL_OUTPOSTS && f2 >= skillEffectSpec.do()) {
                    arrayList.add(new o(skillEffectSpec, String.valueOf(skillLevel.getSkill().getId()) + "_AO_" + n));
                }
                ++n;
            }
        }
        return arrayList;
    }

    public List<o> getAllShipsInFleetEffects() {
        ArrayList<o> arrayList = new ArrayList<o>();
        for (SkillLevel skillLevel : this.skills) {
            int n = 0;
            for (SkillSpec.SkillEffectSpec skillEffectSpec : skillLevel.getSkill().getEffects()) {
                float f2 = this.getSkillLevel(skillEffectSpec.super());
                if (skillEffectSpec.\u00f400000() == SkillEffectType.ALL_SHIPS_IN_FLEET && f2 >= skillEffectSpec.do()) {
                    arrayList.add(new o(skillEffectSpec, String.valueOf(skillLevel.getSkill().getId()) + "_ships_" + n));
                }
                ++n;
            }
        }
        return arrayList;
    }

    public List<o> getAllFightersInFleetEffects() {
        ArrayList<o> arrayList = new ArrayList<o>();
        for (SkillLevel skillLevel : this.skills) {
            int n = 0;
            for (SkillSpec.SkillEffectSpec skillEffectSpec : skillLevel.getSkill().getEffects()) {
                float f2 = this.getSkillLevel(skillEffectSpec.super());
                if (skillEffectSpec.\u00f400000() == SkillEffectType.ALL_FIGHTERS_IN_FLEET && f2 >= skillEffectSpec.do()) {
                    arrayList.add(new o(skillEffectSpec, String.valueOf(skillLevel.getSkill().getId()) + "_all_fighters_" + n));
                }
                ++n;
            }
        }
        return arrayList;
    }

    public List<o> getShipFightersEffects() {
        ArrayList<o> arrayList = new ArrayList<o>();
        for (SkillLevel skillLevel : this.skills) {
            int n = 0;
            for (SkillSpec.SkillEffectSpec skillEffectSpec : skillLevel.getSkill().getEffects()) {
                float f2 = this.getSkillLevel(skillEffectSpec.super());
                if (skillEffectSpec.\u00f400000() == SkillEffectType.SHIP_FIGHTERS && f2 >= skillEffectSpec.do()) {
                    arrayList.add(new o(skillEffectSpec, String.valueOf(skillLevel.getSkill().getId()) + "_ship_fighters_" + n));
                }
                ++n;
            }
        }
        return arrayList;
    }

    public List<o> getStatsEffects() {
        ArrayList<o> arrayList = new ArrayList<o>();
        for (SkillLevel skillLevel : this.skills) {
            int n = 0;
            for (SkillSpec.SkillEffectSpec skillEffectSpec : skillLevel.getSkill().getEffects()) {
                float f2 = this.getSkillLevel(skillEffectSpec.super());
                if (skillEffectSpec.\u00f400000() == SkillEffectType.CHARACTER_STATS && f2 >= skillEffectSpec.do()) {
                    arrayList.add(new o(skillEffectSpec, String.valueOf(skillLevel.getSkill().getId()) + "_stats_" + n));
                }
                ++n;
            }
        }
        return arrayList;
    }

    public List<o> getFleetEffects() {
        ArrayList<o> arrayList = new ArrayList<o>();
        for (SkillLevel skillLevel : this.skills) {
            int n = 0;
            for (SkillSpec.SkillEffectSpec skillEffectSpec : skillLevel.getSkill().getEffects()) {
                float f2 = this.getSkillLevel(skillEffectSpec.super());
                if (skillEffectSpec.\u00f400000() == SkillEffectType.FLEET && f2 >= skillEffectSpec.do()) {
                    arrayList.add(new o(skillEffectSpec, String.valueOf(skillLevel.getSkill().getId()) + "_stats_" + n));
                }
                ++n;
            }
        }
        return arrayList;
    }

    public void applyFleetwideToShip(Ship ship) {
        if (ship.isFighter()) {
            return;
        }
        this.applyFleetwideToStats(ship.getStats(), ship.getHullSize());
    }

    public void applyFleetwideToStats(class clazz, ShipAPI.HullSize hullSize) {
        if (hullSize == ShipAPI.HullSize.FIGHTER) {
            return;
        }
        for (o o2 : this.getAllShipsInFleetEffects()) {
            float f2 = this.getSkillLevel(o2.super.super());
            o2.super.\u00d3O0000().apply((MutableShipStatsAPI)clazz, hullSize, o2.\u00d200000, f2);
        }
    }

    public void unapplyFleetwideToShip(Ship ship) {
        if (ship.isFighter()) {
            return;
        }
        for (o o2 : this.getAllShipsInFleetEffects()) {
            o2.super.\u00d3O0000().unapply(ship.getMutableStats(), ship.getHullSize(), o2.\u00d200000);
        }
    }

    public void applyFleetwideAfterShipCreationToShip(Ship ship) {
        if (ship.isFighter()) {
            return;
        }
        for (o o2 : this.getAllShipsInFleetEffects()) {
            AfterShipCreationSkillEffect afterShipCreationSkillEffect = o2.super.OO0000();
            if (afterShipCreationSkillEffect == null) continue;
            afterShipCreationSkillEffect.unapplyEffectsAfterShipCreation((ShipAPI)ship, o2.\u00d200000);
            afterShipCreationSkillEffect.applyEffectsAfterShipCreation((ShipAPI)ship, o2.\u00d200000);
        }
        if (ship.getSystem() != null) {
            ship.getSystem().updateValuesFromStats();
        }
        if (ship.getPhaseCloak() != null) {
            ship.getPhaseCloak().updateValuesFromStats();
        }
    }

    public void unapplyFleetwideAfterShipCreationToShip(Ship ship) {
        if (ship.isFighter()) {
            return;
        }
        for (o o2 : this.getAllShipsInFleetEffects()) {
            AfterShipCreationSkillEffect afterShipCreationSkillEffect = o2.super.OO0000();
            if (afterShipCreationSkillEffect == null) continue;
            afterShipCreationSkillEffect.unapplyEffectsAfterShipCreation((ShipAPI)ship, o2.\u00d200000);
        }
        if (ship.getSystem() != null) {
            ship.getSystem().updateValuesFromStats();
        }
        if (ship.getPhaseCloak() != null) {
            ship.getPhaseCloak().updateValuesFromStats();
        }
    }

    public void applyPersonalToShip(Ship ship) {
        this.applyPersonalToStats(ship.getStats(), ship.getHullSize());
        this.applyPersonalAfterShipCreationToShip(ship);
        if (ship.getFleetCommander() != null) {
            ship.getFleetCommander().getStats().applyFleetwideToShip(ship);
            ship.getFleetCommander().getStats().applyFleetwideAfterShipCreationToShip(ship);
        }
    }

    public void unapplyPersonalToShip(Ship ship) {
        for (o o2 : this.getShipEffects()) {
            o2.super.\u00d3O0000().unapply(ship.getMutableStats(), ship.getHullSize(), o2.\u00d200000);
        }
        this.unapplyPersonalAfterShipCreationToShip(ship);
        if (ship.getFleetCommander() != null) {
            ship.getFleetCommander().getStats().unapplyFleetwideToShip(ship);
            ship.getFleetCommander().getStats().unapplyFleetwideAfterShipCreationToShip(ship);
        }
    }

    public void applyPersonalToStats(class clazz, ShipAPI.HullSize hullSize) {
        for (o o2 : this.getShipEffects()) {
            float f2 = this.getSkillLevel(o2.super.super());
            o2.super.\u00d3O0000().apply((MutableShipStatsAPI)clazz, hullSize, o2.\u00d200000, f2);
        }
    }

    public void applyPersonalAfterShipCreationToShip(Ship ship) {
        for (o o2 : this.getShipEffects()) {
            AfterShipCreationSkillEffect afterShipCreationSkillEffect = o2.super.OO0000();
            if (afterShipCreationSkillEffect == null) continue;
            afterShipCreationSkillEffect.unapplyEffectsAfterShipCreation((ShipAPI)ship, o2.\u00d200000);
            afterShipCreationSkillEffect.applyEffectsAfterShipCreation((ShipAPI)ship, o2.\u00d200000);
        }
        if (ship.getSystem() != null) {
            ship.getSystem().updateValuesFromStats();
        }
        if (ship.getPhaseCloak() != null) {
            ship.getPhaseCloak().updateValuesFromStats();
        }
    }

    public void unapplyPersonalAfterShipCreationToShip(Ship ship) {
        for (o o2 : this.getShipEffects()) {
            AfterShipCreationSkillEffect afterShipCreationSkillEffect = o2.super.OO0000();
            if (afterShipCreationSkillEffect == null) continue;
            afterShipCreationSkillEffect.unapplyEffectsAfterShipCreation((ShipAPI)ship, o2.\u00d200000);
        }
        if (ship.getSystem() != null) {
            ship.getSystem().updateValuesFromStats();
        }
        if (ship.getPhaseCloak() != null) {
            ship.getPhaseCloak().updateValuesFromStats();
        }
    }

    public void applyGovernedOutpostEffectsToMarket(MarketAPI marketAPI) {
        for (o o2 : this.getOutpostEffects()) {
            float f2 = this.getSkillLevel(o2.super.super());
            o2.super.\u00f800000().apply(marketAPI, o2.\u00d200000, f2);
        }
    }

    public void applyAllOutpostEffectsToMarket(MarketAPI marketAPI) {
        for (o o2 : this.getAllOutpostEffects()) {
            float f2 = this.getSkillLevel(o2.super.super());
            o2.super.\u00f800000().apply(marketAPI, o2.\u00d200000, f2);
        }
    }

    public void refreshGovernedOutpostEffects(MarketAPI marketAPI) {
        String string = "refreshGovernedOutpostEffects";
        List<o> list = CharacterStats.getEffectCache().get(string);
        if (list == null) {
            list = new ArrayList<o>();
            CharacterStats.getEffectCache().put(string, list);
            ArrayList<String> object = new ArrayList<String>(SpecStore.\u00d400000(SkillSpec.class));
            for (Object object2 : object) {
                SkillSpec skillSpec = SpecStore.o00000(SkillSpec.class, (String)object2);
                int n = 0;
                for (SkillSpec.SkillEffectSpec skillEffectSpec : skillSpec.getEffects()) {
                    if (skillEffectSpec.\u00f400000() == SkillEffectType.GOVERNED_OUTPOST) {
                        String string2 = String.valueOf(skillSpec.getId()) + "_GO_" + n;
                        list.add(new o(skillEffectSpec, string2));
                    }
                    ++n;
                }
            }
        }
        for (o o2 : list) {
            if (o2.super.\u00f400000() != SkillEffectType.GOVERNED_OUTPOST) continue;
            o2.super.\u00f800000().unapply(marketAPI, o2.\u00d200000);
        }
        this.applyGovernedOutpostEffectsToMarket(marketAPI);
    }

    public void refreshAllOutpostsEffectsForPlayerOutposts() {
        for (MarketAPI marketAPI : Global.getSector().getEconomy().getMarketsCopy()) {
            if (!marketAPI.isPlayerOwned()) continue;
            this.refreshAllOutpostsEffects(marketAPI);
            if (marketAPI.getAdmin().getStats() == this) {
                this.refreshGovernedOutpostEffects(marketAPI);
            }
            marketAPI.reapplyConditions();
            marketAPI.reapplyIndustries();
        }
    }

    public void refreshAllOutpostsEffects(MarketAPI marketAPI) {
        String string = "refreshAllOutpostsEffects";
        List<o> list = CharacterStats.getEffectCache().get(string);
        if (list == null) {
            list = new ArrayList<o>();
            CharacterStats.getEffectCache().put(string, list);
            ArrayList<String> object = new ArrayList<String>(SpecStore.\u00d400000(SkillSpec.class));
            for (Object object2 : object) {
                SkillSpec skillSpec = SpecStore.o00000(SkillSpec.class, (String)object2);
                int n = 0;
                for (SkillSpec.SkillEffectSpec skillEffectSpec : skillSpec.getEffects()) {
                    if (skillEffectSpec.\u00f400000() == SkillEffectType.ALL_OUTPOSTS) {
                        String string2 = String.valueOf(skillSpec.getId()) + "_AO_" + n;
                        list.add(new o(skillEffectSpec, string2));
                    }
                    ++n;
                }
            }
        }
        for (o o2 : list) {
            if (o2.super.\u00f400000() != SkillEffectType.ALL_OUTPOSTS) continue;
            o2.super.\u00f800000().unapply(marketAPI, o2.\u00d200000);
        }
        if (marketAPI.isPlayerOwned()) {
            this.applyAllOutpostEffectsToMarket(marketAPI);
        }
    }

    public void applyShipFightersToStats(class clazz, ShipAPI.HullSize hullSize) {
        for (o o2 : this.getShipFightersEffects()) {
            float f2 = this.getSkillLevel(o2.super.super());
            o2.super.\u00d3O0000().apply((MutableShipStatsAPI)clazz, hullSize, o2.\u00d200000, f2);
        }
    }

    public void applyAllFightersToStats(class clazz, ShipAPI.HullSize hullSize) {
        for (o o2 : this.getAllFightersInFleetEffects()) {
            float f2 = this.getSkillLevel(o2.super.super());
            o2.super.\u00d3O0000().apply((MutableShipStatsAPI)clazz, hullSize, o2.\u00d200000, f2);
        }
    }

    public void setAptitudeLevel(String string, float f2) {
        for (AptitudeLevel object2 : this.aptitudes) {
            if (!object2.getAptitude().\u00f800000().equals(string)) continue;
            object2.setLevel(f2);
            SkillSpec skillSpec = object2.getAptitude().int();
            if (skillSpec != null) {
                this.setSkillLevel(skillSpec.getId(), f2);
            }
            return;
        }
        o0OO o0OO2 = SpecStore.o00000(o0OO.class, string);
        AptitudeLevel aptitudeLevel = new AptitudeLevel(o0OO2);
        aptitudeLevel.setLevel(f2);
        SkillSpec skillSpec = o0OO2.int();
        if (skillSpec != null) {
            this.setSkillLevel(skillSpec.getId(), f2);
        }
        this.aptitudes.add(aptitudeLevel);
    }

    public void setSkillLevel(String string, float f2) {
        for (SkillLevel object2 : this.skills) {
            if (!object2.getSkill().getId().equals(string)) continue;
            object2.setLevel(f2);
            this.refreshCharacterStatsEffects();
            return;
        }
        SkillSpec skillSpec = SpecStore.o00000(SkillSpec.class, string);
        SkillLevel skillLevel = new SkillLevel(skillSpec);
        this.skills.add(skillLevel);
        skillLevel.setLevel(f2);
        this.refreshCharacterStatsEffects();
    }

    public boolean hasSkill(SkillSpec skillSpec) {
        return this.hasSkill(skillSpec.getId());
    }

    public boolean hasSkill(String string) {
        for (SkillLevel skillLevel : this.skills) {
            if (!skillLevel.getSkill().getId().equals(string) || !(skillLevel.getLevel() > 0.0f)) continue;
            return true;
        }
        return false;
    }

    public List<AptitudeLevel> getAptitudes() {
        return this.aptitudes;
    }

    public List<SkillLevel> getSkills() {
        return this.skills;
    }

    public List<MutableCharacterStatsAPI.SkillLevelAPI> getSkillsCopy() {
        if (this.skills == null) {
            return new ArrayList<MutableCharacterStatsAPI.SkillLevelAPI>();
        }
        return new ArrayList<MutableCharacterStatsAPI.SkillLevelAPI>(this.skills);
    }

    public long getXP() {
        return this.xp;
    }

    public void setXP(long l2) {
        this.xp = l2;
    }

    public boolean isPlayerStats() {
        return CampaignEngine.getInstance().getPlayerStats() == this;
    }

    public void addXP(long l2) {
        this.addXP(l2, null);
    }

    public void addXP(long l2, TextPanelAPI textPanelAPI) {
        this.addXP(l2, textPanelAPI, true);
    }

    public void addXP(long l2, TextPanelAPI textPanelAPI, boolean bl) {
        this.addXP(l2, textPanelAPI, bl, true);
    }

    public void addXP(long l2, TextPanelAPI textPanelAPI, boolean bl, boolean bl2) {
        this.addXP(l2, textPanelAPI, bl, bl2, true);
    }

    public long getBonusXPUsed(long l2) {
        long l3;
        LevelupPlugin levelupPlugin;
        float f2 = 1.0f;
        if (CampaignEngine.getInstance().getPlayerStats() == this && this.level == (levelupPlugin = ScriptStore.o00000(LevelupPlugin.class)).getMaxLevel()) {
            f2 = levelupPlugin.getBonusXPUseMultAtMaxLevel();
        }
        if ((l3 = Math.min((long)((float)l2 * f2), this.bonusXp)) < 0L) {
            l3 = 0L;
        }
        return l3;
    }

    public void addXP(long l2, TextPanelAPI textPanelAPI, boolean bl, boolean bl2, boolean bl3) {
        long l3 = 0L;
        if (bl2 && this.bonusXp > 0L) {
            l3 = this.getBonusXPUsed(l2);
            l2 += l3;
            this.bonusXp -= l3;
        }
        this.xp += l2;
        if (CampaignEngine.getInstance().getPlayerStats() == this && bl) {
            if (l3 > 0L) {
                String string = Misc.getWithDGS((float)l3);
                String string2 = Misc.getWithDGS((float)l2);
                String string3 = "Gained " + string2 + " experience (" + string + " bonus XP used)";
                if (textPanelAPI != null) {
                    textPanelAPI.setFontSmallInsignia();
                    textPanelAPI.addParagraph(string3, C.oo0000);
                    textPanelAPI.highlightInLastPara(new String[]{string2, string});
                    textPanelAPI.setHighlightColorsInLastPara(new Color[]{C.\u00d5O0000, Misc.getStoryOptionColor()});
                    textPanelAPI.setFontInsignia();
                } else {
                    MessageIntel messageIntel = new MessageIntel(string3, Misc.getBasePlayerColor(), new String[]{string2, string}, new Color[]{Misc.getHighlightColor(), Misc.getStoryOptionColor()});
                    Global.getSector().getCampaignUI().addMessage((IntelInfoPlugin)messageIntel);
                }
            } else {
                String string = Misc.getWithDGS((float)l2);
                String string4 = "Gained " + string + " experience";
                if (textPanelAPI != null) {
                    textPanelAPI.setFontSmallInsignia();
                    textPanelAPI.addParagraph(string4, C.oo0000);
                    textPanelAPI.highlightLastInLastPara(string, C.\u00d5O0000);
                    textPanelAPI.setFontInsignia();
                } else {
                    MessageIntel messageIntel = new MessageIntel(string4, Misc.getBasePlayerColor(), new String[]{string}, new Color[]{Misc.getHighlightColor()});
                    Global.getSector().getCampaignUI().addMessage((IntelInfoPlugin)messageIntel);
                }
            }
        }
        if (bl3) {
            this.levelUpIfNeeded(textPanelAPI);
        }
    }

    public int getPoints() {
        return this.points;
    }

    public void setPoints(int n) {
        this.points = n;
    }

    public void addPoints(int n) {
        this.points += n;
        if (this.points < 0) {
            this.points = 0;
        }
    }

    public void levelUpIfNeeded() {
        this.levelUpIfNeeded(null);
    }

    public void levelUpIfNeeded(TextPanelAPI textPanelAPI) {
        String string;
        boolean bl;
        LevelupPlugin levelupPlugin = ScriptStore.o00000(LevelupPlugin.class);
        boolean bl2 = CampaignEngine.getInstance().getPlayerStats() == this;
        int n = levelupPlugin.getMaxLevel();
        boolean bl3 = bl = this.level >= n;
        if (!bl2 && bl) {
            return;
        }
        boolean bl4 = false;
        if (bl2) {
            long l2 = 0L;
            while ((l2 = this.getXPThresholdForNextStoryPoint(this.xpAtLastStoryPointGain)) <= this.xp) {
                bl4 = true;
                ++this.storyPoints;
                this.xpAtLastStoryPointGain = l2;
            }
        }
        boolean bl5 = false;
        while (!bl && this.getXP() >= levelupPlugin.getXPForLevel(this.level + 1)) {
            Object object;
            bl5 = true;
            ++this.level;
            bl = this.level >= n;
            int n2 = levelupPlugin.getPointsAtLevel(this.level);
            this.points += n2;
            if (CampaignEngine.getInstance().getPlayerStats() != this) continue;
            string = "You have advanced to level " + this.level;
            if (bl) {
                string = String.valueOf(string) + " (maximum)";
            }
            if (textPanelAPI != null) {
                textPanelAPI.setFontSmallInsignia();
                textPanelAPI.addParagraph(string, C.oo0000);
                textPanelAPI.highlightLastInLastPara("" + this.level, C.\u00d5O0000);
                textPanelAPI.setFontInsignia();
            } else {
                object = new MessageIntel(string, Misc.getBasePlayerColor(), new String[]{"" + this.level}, new Color[]{Misc.getHighlightColor()});
                Global.getSector().getCampaignUI().addMessage((IntelInfoPlugin)object);
            }
            if (this.deferredBonusXp <= 0L || !bl) continue;
            object = Misc.getWithDGS((float)this.deferredBonusXp);
            this.bonusXp += this.deferredBonusXp;
            string = "Gained " + (String)object + " bonus experience from " + Misc.STORY + " points spent earlier";
            if (textPanelAPI != null) {
                textPanelAPI.setFontSmallInsignia();
                textPanelAPI.addParagraph(string, C.oo0000);
                textPanelAPI.highlightLastInLastPara((String)object, C.\u00d5O0000);
                textPanelAPI.setFontInsignia();
                continue;
            }
            MessageIntel messageIntel = new MessageIntel(string, Misc.getBasePlayerColor(), new String[]{object}, new Color[]{Misc.getHighlightColor()});
            Global.getSector().getCampaignUI().addMessage((IntelInfoPlugin)messageIntel);
        }
        if (bl2) {
            if (bl) {
                long l3 = levelupPlugin.getXPForLevel(this.level + 0);
                long l4 = levelupPlugin.getXPForLevel(this.level + 1);
                long l5 = l4 - l3;
                if (l5 <= 0L) {
                    l5 = 100000L;
                }
                while (this.xp >= l4) {
                    this.xp -= l5;
                    this.xpAtLastStoryPointGain -= l5;
                }
            }
            if (bl4) {
                if (!bl5) {
                    L.o00000("ui_char_gained_story_point", 1.0f, 1.0f);
                }
                String string2 = "points";
                if (this.storyPoints == 1) {
                    string2 = "point";
                }
                string = "You have " + this.storyPoints + " " + Misc.STORY + " " + string2 + " to spend";
                if (textPanelAPI != null) {
                    textPanelAPI.setFontSmallInsignia();
                    textPanelAPI.addParagraph(string, C.oo0000);
                    textPanelAPI.highlightLastInLastPara(this.storyPoints + " " + Misc.STORY + " " + string2, Misc.getStoryOptionColor());
                    textPanelAPI.setFontInsignia();
                } else {
                    MessageIntel messageIntel = new MessageIntel(string, Misc.getBasePlayerColor(), new String[]{this.storyPoints + " " + Misc.STORY + " " + string2}, new Color[]{Misc.getStoryOptionColor()});
                    messageIntel.setIcon(CampaignEngine.getInstance().getPlayerPerson().getPortraitSprite());
                    Global.getSector().getCampaignUI().addMessage((IntelInfoPlugin)messageIntel, CommMessageAPI.MessageClickAction.CHARACTER_TAB);
                }
                CampaignEngine.getInstance().getUIData().setOpenedCharacterTabSinceLevelUp(false);
            }
            if (bl5) {
                L.o00000("ui_char_level_up", 1.0f, 1.0f);
                if (this.points > 0) {
                    String string3 = "points";
                    if (this.points == 1) {
                        string3 = "point";
                    }
                    string = "You have " + this.points + " skill " + string3 + " to spend";
                    if (textPanelAPI != null) {
                        textPanelAPI.setFontSmallInsignia();
                        textPanelAPI.addParagraph(string, C.oo0000);
                        textPanelAPI.highlightLastInLastPara(this.points + " skill " + string3, C.\u00d5O0000);
                        textPanelAPI.setFontInsignia();
                    } else {
                        MessageIntel messageIntel = new MessageIntel(string, Misc.getBasePlayerColor(), new String[]{this.points + " skill " + string3}, new Color[]{Misc.getHighlightColor()});
                        messageIntel.setIcon(CampaignEngine.getInstance().getPlayerPerson().getPortraitSprite());
                        Global.getSector().getCampaignUI().addMessage((IntelInfoPlugin)messageIntel, CommMessageAPI.MessageClickAction.CHARACTER_TAB);
                    }
                }
                CampaignEngine.getInstance().getUIData().setOpenedCharacterTabSinceLevelUp(false);
            }
        }
    }

    public MutableStat getWeaponOPCostMult() {
        return this.weaponOPCostMult;
    }

    public StatBonus getSmallWeaponOPCost() {
        return this.smallWeaponOPCost;
    }

    public StatBonus getMediumWeaponOPCost() {
        return this.mediumWeaponOPCost;
    }

    public StatBonus getLargeWeaponOPCost() {
        return this.largeWeaponOPCost;
    }

    public StatBonus getShipOrdnancePointBonus() {
        return this.shipOrdnancePointBonus;
    }

    public MutableStat getCommandPoints() {
        return this.commandPoints;
    }

    public MutableStat getMarineEffectivnessMult() {
        return this.marineEffectivnessMult;
    }

    public StatBonus getCombatDeploymentCost() {
        return this.combatDeploymentCost;
    }

    public StatBonus getMaxCapacitorsBonus() {
        return this.maxCapacitorsBonus;
    }

    public StatBonus getMaxVentsBonus() {
        return this.maxVentsBonus;
    }

    public StatBonus getTravelSpeedBonus() {
        return this.travelSpeedBonus;
    }

    public MutableStat getOfficerNumber() {
        return this.officerNumber;
    }

    public void increaseAptitude(String string) {
        this.setAptitudeLevel(string, this.getAptitudeLevel(string) + 1.0f);
    }

    public MutableStat getRepairRateMult() {
        return this.repairRateMult;
    }

    public static class AptitudeLevel
    implements DoNotObfuscate,
    Cloneable {
        private transient o0OO aptitude;
        private float level;
        private int maxTier = 0;
        private String savedId = null;

        protected AptitudeLevel clone() {
            try {
                return (AptitudeLevel)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public AptitudeLevel(o0OO o0OO2) {
            this.aptitude = o0OO2;
            this.level = 0.0f;
        }

        public AptitudeLevel(String string) {
            this.savedId = string;
            this.level = 0.0f;
            this.readResolve();
        }

        public float getLevel() {
            return this.level;
        }

        public void setLevel(float f2) {
            this.level = f2;
        }

        public o0OO getAptitude() {
            return this.aptitude;
        }

        public int getMaxTier() {
            return this.maxTier;
        }

        public void setMaxTier(int n) {
            this.maxTier = n;
        }

        Object readResolve() {
            this.aptitude = SpecStore.o00000(o0OO.class, this.savedId);
            return this;
        }

        Object writeReplace() {
            this.savedId = this.aptitude.\u00f800000();
            return this;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class o {
        public SkillSpec.SkillEffectSpec super;
        public String \u00d200000;

        public o(SkillSpec.SkillEffectSpec skillEffectSpec, String string) {
            this.super = skillEffectSpec;
            this.\u00d200000 = string;
        }
    }

    public static class SkillLevel
    implements DoNotObfuscate,
    Cloneable,
    MutableCharacterStatsAPI.SkillLevelAPI {
        private transient SkillSpec skill;
        private String savedId = null;
        private float level;

        protected SkillLevel clone() {
            try {
                return (SkillLevel)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public SkillLevel(SkillSpec skillSpec) {
            this.skill = skillSpec;
            this.level = 0.0f;
        }

        public SkillLevel(String string) {
            this.savedId = string;
            this.level = 0.0f;
            this.readResolve();
        }

        public float getLevel() {
            return this.level;
        }

        public void setLevel(float f2) {
            this.level = f2;
        }

        public SkillSpec getSkill() {
            return this.skill;
        }

        Object readResolve() {
            this.skill = SpecStore.o00000(SkillSpec.class, this.savedId);
            return this;
        }

        Object writeReplace() {
            this.savedId = this.skill.getId();
            return this;
        }

        public String toString() {
            return String.valueOf(this.skill.getName()) + ": " + Math.round(this.getLevel());
        }
    }
}

