/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign;

import com.fs.starfarer.api.campaign.listeners.ListenerManagerAPI;
import com.fs.util.DoNotObfuscate;
import com.fs.util.container.repo.ObjectRepository;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListenerManager
implements ListenerManagerAPI,
DoNotObfuscate {
    private ObjectRepository listeners = new ObjectRepository();
    private transient ObjectRepository transientListeners = new ObjectRepository();

    protected Object readResolve() {
        if (this.transientListeners == null) {
            this.transientListeners = new ObjectRepository();
        }
        if (this.listeners == null) {
            this.listeners = new ObjectRepository();
        }
        return this;
    }

    public void addListener(Object object) {
        this.addListener(object, false);
    }

    public void addListener(Object object, boolean bl) {
        if (bl) {
            this.transientListeners.add(object);
        } else {
            this.listeners.add(object);
        }
    }

    public boolean hasListener(Object object) {
        return this.listeners.contains(object) || this.transientListeners.contains(object);
    }

    public void removeListener(Object object) {
        this.listeners.remove(object);
        this.transientListeners.remove(object);
    }

    public void removeListenerOfClass(Class<?> clazz) {
        for (Object e2 : new ArrayList(this.listeners.getList(clazz))) {
            this.listeners.remove(e2);
        }
        for (Object e2 : new ArrayList(this.transientListeners.getList(clazz))) {
            this.transientListeners.remove(e2);
        }
    }

    public boolean hasListenerOfClass(Class<?> clazz) {
        return !this.listeners.getList(clazz).isEmpty() || !this.transientListeners.getList(clazz).isEmpty();
    }

    public <T> List<T> getListeners(Class<T> clazz) {
        ArrayList arrayList = new ArrayList(this.listeners.getList(clazz));
        arrayList.addAll(this.transientListeners.getList(clazz));
        return arrayList;
    }
}

