/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign;

import com.fs.starfarer.campaign.econ.Economy;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueHistory
implements DoNotObfuscate {
    private transient int num;
    private float[] month;
    private transient List<Float> monthList = new ArrayList<Float>();
    private int count = 0;
    private float[] year;
    private transient List<Float> yearList = new ArrayList<Float>();

    public ValueHistory() {
        this.num = Economy.NUM_ITER_PER_MONTH;
        if (this.num < 1) {
            this.num = 1;
        }
        this.readResolve();
    }

    Object readResolve() {
        int n;
        this.num = Economy.NUM_ITER_PER_MONTH;
        this.monthList = new ArrayList<Float>();
        if (this.month != null) {
            n = 0;
            while (n < this.month.length) {
                this.monthList.add(Float.valueOf(this.month[n]));
                ++n;
            }
        }
        this.yearList = new ArrayList<Float>();
        if (this.year != null) {
            n = 0;
            while (n < this.year.length) {
                this.yearList.add(Float.valueOf(this.year[n]));
                ++n;
            }
        }
        return this;
    }

    public void addSample(float f2) {
        this.monthList.add(Float.valueOf(f2));
        while (this.monthList.size() > this.num) {
            this.monthList.remove(0);
        }
        ++this.count;
        if (this.count >= this.num) {
            float f3 = 0.0f;
            float f4 = 0.0f;
            for (Float f5 : this.monthList) {
                f3 += f5.floatValue();
                f4 += 1.0f;
            }
            if (f4 > 0.0f) {
                f3 /= f4;
            }
            this.yearList.add(Float.valueOf(f3));
            while (this.yearList.size() > 12) {
                this.yearList.remove(0);
            }
            this.count = 0;
        }
    }

    public void keepMonths(int n) {
        while (this.yearList.size() > n) {
            this.yearList.remove(0);
        }
    }

    public void zeroPad() {
        while (this.yearList.size() < 12) {
            this.yearList.add(0, Float.valueOf(0.0f));
        }
        while (this.monthList.size() < this.num) {
            this.monthList.add(0, Float.valueOf(0.0f));
        }
    }

    public void generatePad() {
        int n = this.yearList.size();
        if (n == 3) {
            this.yearList.add(0, this.yearList.get(n - 1));
            this.yearList.add(0, this.yearList.get(n - 1));
            n = this.yearList.size();
            this.yearList.add(0, this.yearList.get(n - 1));
            this.yearList.add(0, this.yearList.get(n - 1));
            this.yearList.add(0, this.yearList.get(n - 1));
            this.yearList.add(0, this.yearList.get(0));
            this.yearList.add(0, this.yearList.get(2));
            this.yearList.add(0, this.yearList.get(3));
            this.yearList.add(0, this.yearList.get(4));
        }
        int n2 = 0;
        int n3 = 0;
        while (this.yearList.size() < 12) {
            float f2 = 0.0f;
            if (n > 0) {
                f2 = this.yearList.get(n - 1).floatValue();
                if (n2 >= n + 1) {
                    if (n2 - n + n3 >= this.yearList.size()) {
                        n3 = 0;
                    }
                    f2 = this.yearList.get(n2 - n + n3).floatValue();
                    ++n3;
                }
            }
            this.yearList.add(0, Float.valueOf(f2));
            ++n2;
        }
    }

    public List<Float> getMonth() {
        return this.monthList;
    }

    public List<Float> getYear() {
        return this.yearList;
    }

    Object writeReplace() {
        int n;
        if (this.monthList.size() > 0) {
            this.month = new float[this.monthList.size()];
            n = 0;
            while (n < this.monthList.size()) {
                this.month[n] = this.monthList.get(n).floatValue();
                ++n;
            }
        } else {
            this.month = null;
        }
        if (this.yearList.size() > 0) {
            this.year = new float[this.yearList.size()];
            n = 0;
            while (n < this.yearList.size()) {
                this.year[n] = this.yearList.get(n).floatValue();
                ++n;
            }
        } else {
            this.year = null;
        }
        return this;
    }
}

