/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.command;

import com.fs.starfarer.api.campaign.FactionProductionAPI;
import com.fs.starfarer.api.loading.WingRole;
import com.fs.starfarer.api.util.CountingMap;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.Faction;
import com.fs.starfarer.campaign.command.C;
import com.fs.starfarer.campaign.command.CustomProductionPanel;
import com.fs.starfarer.campaign.command.J;
import com.fs.starfarer.campaign.command.L;
import com.fs.starfarer.campaign.command.do;
import com.fs.starfarer.campaign.command.super;
import com.fs.starfarer.campaign.ui.B;
import com.fs.starfarer.campaign.ui.UITable;
import com.fs.starfarer.campaign.ui.voidsuper;
import com.fs.starfarer.loading.SpecStore;
import com.fs.starfarer.loading.specs.BaseWeaponSpec;
import com.fs.starfarer.loading.specs.FighterWingSpec;
import com.fs.starfarer.ui.impl.StandardTooltipV2Expandable;
import com.fs.starfarer.ui.int;
import com.fs.starfarer.util.super.ooOO;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FighterBlueprintBrowser
extends L
implements C,
UITable.Oo {
    public static String ALL_TECHS = "All designs";
    public static String ALL_TYPES = "All types";
    public static String FIGHTER = "Fighter";
    public static String BOMBER = "Bomber";
    public static String INTERCEPTOR = "Interceptor";
    public static String OTHER = "Other";
    private List<FighterWingSpec> \u00f4\u00f8o000 = new ArrayList<FighterWingSpec>();
    private CustomProductionPanel \u00f6\u00f8o000;
    private TableColumns public.void$super = null;

    public FighterBlueprintBrowser(CustomProductionPanel customProductionPanel, L.o o2) {
        super(o2, customProductionPanel);
        this.\u00f6\u00f8o000 = customProductionPanel;
        if (customProductionPanel != null && customProductionPanel.isPickerMode() && customProductionPanel.getDelegate() != null && customProductionPanel.getDelegate().getAvailableFighters() != null) {
            for (String string : customProductionPanel.getDelegate().getAvailableFighters()) {
                FighterWingSpec fighterWingSpec = SpecStore.o00000(FighterWingSpec.class, string);
                this.\u00f4\u00f8o000.add(fighterWingSpec);
            }
        } else {
            Faction faction = CampaignEngine.getInstance().getPlayerFaction();
            for (String string : faction.getKnownFighters()) {
                FighterWingSpec fighterWingSpec = SpecStore.o00000(FighterWingSpec.class, string);
                this.\u00f4\u00f8o000.add(fighterWingSpec);
            }
        }
    }

    public List<FighterWingSpec> getKnownFighters() {
        return this.\u00f4\u00f8o000;
    }

    @Override
    protected UITable createTable() {
        voidsuper voidsuper2 = new voidsuper(this.faction);
        voidsuper2.addColumn((Object)TableColumns.NAME, "Fighter blueprint", 300.0f, true);
        voidsuper2.addColumn((Object)TableColumns.TYPE, "Type", 163.0f, true);
        voidsuper2.addColumn((Object)TableColumns.TECH, "Design type", 200.0f, true);
        voidsuper2.setTooltip(0, "Fighter name. Mouse over the icon for a detailed tooltip with its stats.");
        voidsuper2.setTooltip(1, "Fighter type - bomber, interceptor, heavy fighter, etc.");
        voidsuper2.setTooltip(2, "The originator of the design (such as a corporation or a faction), or, for more common designs, its general classification.");
        if (this.mode == L.o.\u00d300000) {
            voidsuper2.addColumn((Object)TableColumns.ENABLED, ENABLED_COL, 120.0f, true);
            voidsuper2.setTooltip(3, "Prioriziting a fighter will make it more likely to be used by your faction's fleets.");
        } else {
            voidsuper2.addColumn((Object)TableColumns.COST, "Cost", 120.0f, true);
            voidsuper2.setTooltipAbove(3, new StandardTooltipV2Expandable(300.0f, false){

                public void createImpl(boolean bl) {
                    this.addPara("Production cost.", 0.0f);
                }
            });
        }
        UITable uITable = new UITable(8000.0f, J.ROW_HEIGHT, voidsuper2, this);
        uITable.setEmptyText("No matching fighter blueprints");
        uITable.setWithBackground(true);
        uITable.autoSizeToRows(J.TABLE_ROWS);
        return uITable;
    }

    @Override
    public void updateTable() {
        this.table.clear();
        this.table.suspendRecompute();
        Set<String> set = this.tags.getSelected();
        for (FighterWingSpec fighterWingSpec : this.\u00f4\u00f8o000) {
            if (!this.wingMatchesTags(fighterWingSpec, set)) continue;
            super super_ = new super(this.\u00f6\u00f8o000, this.table.getHeader(), super.o.\u00d300000, fighterWingSpec.getId(), this.mode);
            this.table.addRow(super_);
            if (this.mode != L.o.\u00d200000) continue;
            super_.getButton().getLogic().super(int.o.String);
        }
        this.table.resumeRecompute();
        this.table.sort((Object)TableColumns.TYPE, false);
        super.updateTable();
    }

    protected boolean wingMatchesTags(FighterWingSpec fighterWingSpec, Set<String> set) {
        if (fighterWingSpec.getRole() == WingRole.FIGHTER ? !set.contains(FIGHTER) : (fighterWingSpec.getRole() == WingRole.BOMBER ? !set.contains(BOMBER) : (fighterWingSpec.getRole() == WingRole.INTERCEPTOR ? !set.contains(INTERCEPTOR) : !set.contains(OTHER)))) {
            return false;
        }
        String string = fighterWingSpec.getVariant().getHullSpec().getManufacturer();
        return string == null || set.contains(string);
    }

    @Override
    protected do createTags() {
        do do_ = new do(this.table.getWidth(), this);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        CountingMap countingMap = new CountingMap();
        for (FighterWingSpec fighterWingSpec : this.\u00f4\u00f8o000) {
            countingMap.add((Object)fighterWingSpec.getVariant().getHullSpec().getManufacturer());
            if (fighterWingSpec.getRole() == WingRole.FIGHTER) {
                ++n;
                continue;
            }
            if (fighterWingSpec.getRole() == WingRole.BOMBER) {
                ++n2;
                continue;
            }
            if (fighterWingSpec.getRole() == WingRole.INTERCEPTOR) {
                ++n3;
                continue;
            }
            ++n4;
        }
        float f2 = 10.0f;
        float f3 = 3.0f;
        if (!countingMap.isEmpty()) {
            do_.beginGroup(false, ALL_TECHS);
            ArrayList arrayList = new ArrayList(countingMap.keySet());
            Collections.sort(arrayList);
            for (String string : arrayList) {
                do_.addTag(string, string, countingMap.getCount((Object)string));
            }
            do_.addGroup(0.0f);
        }
        do_.beginGroup(false, ALL_TYPES, 120.0f);
        do_.addTag(FIGHTER, n);
        do_.addTag(BOMBER, n2);
        do_.addTag(INTERCEPTOR, n3);
        do_.addTag(OTHER, n4);
        do_.addGroup(f2);
        return do_;
    }

    @Override
    public void tagsChanged(do do_) {
        TableColumns tableColumns = this.public.void$super;
        this.updateTable();
        if (tableColumns != null) {
            this.table.sort((Object)tableColumns, null);
            this.table.sort((Object)tableColumns, null);
        }
    }

    @Override
    public Comparator<B> tableGetComparator(UITable uITable, final Object object) {
        return new Comparator<B>(){

            public int o00000(B b2, B b3) {
                int n;
                super super_ = (super)b2;
                super super_2 = (super)b3;
                BaseWeaponSpec baseWeaponSpec = super_.getWeaponSpec();
                FighterWingSpec fighterWingSpec = super_.getWingSpec();
                BaseWeaponSpec baseWeaponSpec2 = super_2.getWeaponSpec();
                FighterWingSpec fighterWingSpec2 = super_2.getWingSpec();
                FighterBlueprintBrowser.this.public.void$super = (TableColumns)((Object)object);
                if (object == TableColumns.TECH && (n = super_.getTechString().compareTo(super_2.getTechString())) != 0) {
                    return n;
                }
                if (object == TableColumns.TYPE && (n = super_.getTypeString().compareTo(super_2.getTypeString())) != 0) {
                    return n;
                }
                if (object == TableColumns.ENABLED) {
                    if (super_.isBlueprintEnabled() && !super_2.isBlueprintEnabled()) {
                        return -1;
                    }
                    if (super_2.isBlueprintEnabled() && !super_.isBlueprintEnabled()) {
                        return 1;
                    }
                    n = super_.getSizeOrdinal() - super_2.getSizeOrdinal();
                    if (n != 0) {
                        return n;
                    }
                }
                if (object == TableColumns.COST && (n = super_.getCostValue() - super_2.getCostValue()) != 0) {
                    return n;
                }
                return super_.getNameString().compareTo(super_2.getNameString());
            }
        };
    }

    @Override
    public void tableRowSelected(UITable uITable, B b2, Object object) {
        super super_ = (super)b2;
        if (this.mode == L.o.\u00d300000) {
            super_.setBlueprintEnabled(!super_.isBlueprintEnabled());
        } else {
            Cloneable cloneable;
            int n = 1;
            boolean bl = true;
            if (object instanceof ooOO) {
                cloneable = (ooOO)object;
                if (((ooOO)cloneable).isCtrlDown()) {
                    n = 1000;
                } else if (((ooOO)cloneable).isShiftDown()) {
                    n = CustomProductionPanel.SHIFT_CLICK_QUANTITY;
                }
                if (((ooOO)cloneable).isRMBEvent()) {
                    bl = false;
                }
            }
            cloneable = this.\u00f6\u00f8o000.getProd();
            if (bl) {
                int n2 = this.\u00f6\u00f8o000.getDelegate() == null ? 0 : (this.\u00f6\u00f8o000.getDelegate().withQuantityLimits() ? 0 : 1000);
                cloneable.addItem(FactionProductionAPI.ProductionItemType.FIGHTER, super_.getWingSpec().getId(), n, n2);
            } else {
                cloneable.removeItem(FactionProductionAPI.ProductionItemType.FIGHTER, super_.getWingSpec().getId(), n);
            }
            this.\u00f6\u00f8o000.updatePlanTable(FactionProductionAPI.ProductionItemType.FIGHTER, super_.getWingSpec().getId());
            super_.getButton().flash(false, 0.1f, 0.9f);
        }
        super_.getButton().unhighlight();
    }

    @Override
    public void tableSortFinished(UITable uITable, voidsuper.o o2) {
    }

    @Override
    protected void selectAll() {
        for (B b2 : this.table.getRows()) {
            super super_ = (super)b2;
            super_.setBlueprintEnabled(true);
        }
    }

    @Override
    protected void unselectAll() {
        for (B b2 : this.table.getRows()) {
            super super_ = (super)b2;
            super_.setBlueprintEnabled(false);
        }
    }

    @Override
    protected void unselectAllReally() {
        Faction faction = CampaignEngine.getInstance().getPlayerFaction();
        for (String string : faction.getKnownFighters()) {
            faction.removePriorityFighter(string);
        }
    }

    @Override
    protected int getNumPriority() {
        Faction faction = CampaignEngine.getInstance().getPlayerFaction();
        return faction.getPriorityFighters().size();
    }

    @Override
    protected void autoEnableSet(boolean bl) {
        Faction faction = CampaignEngine.getInstance().getPlayerFaction();
        faction.setAutoEnableKnownFighters(bl);
    }

    @Override
    protected String getAutoEnableSubject() {
        return "fighter blueprints";
    }

    @Override
    protected boolean isAutoEnableSet() {
        Faction faction = CampaignEngine.getInstance().getPlayerFaction();
        return faction.isAutoEnableKnownFighters();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TableColumns implements DoNotObfuscate
    {
        NAME,
        TYPE,
        TECH,
        ENABLED,
        COST;

    }
}

