/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.command;

import com.fs.starfarer.api.campaign.FactionProductionAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipHullSpecAPI;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.util.CountingMap;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.Faction;
import com.fs.starfarer.campaign.command.C;
import com.fs.starfarer.campaign.command.CustomProductionPanel;
import com.fs.starfarer.campaign.command.J;
import com.fs.starfarer.campaign.command.L;
import com.fs.starfarer.campaign.command.N;
import com.fs.starfarer.campaign.command.do;
import com.fs.starfarer.campaign.ui.B;
import com.fs.starfarer.campaign.ui.UITable;
import com.fs.starfarer.campaign.ui.voidsuper;
import com.fs.starfarer.loading.SpecStore;
import com.fs.starfarer.loading.specs.privatesuper;
import com.fs.starfarer.ui.impl.StandardTooltipV2Expandable;
import com.fs.starfarer.ui.int;
import com.fs.starfarer.util.super.ooOO;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ShipBlueprintBrowser
extends L
implements C,
UITable.Oo {
    public static String ALL_TECHS = "All designs";
    public static String ALL_SIZES = "All sizes";
    public static String ALL_TYPES = "All types";
    public static String FRIGATES = "Frigates";
    public static String DESTROYERS = "Destroyers";
    public static String CRUISERS = "Cruisers";
    public static String CAPITALS = "Capitals";
    public static String COMBAT_SHIPS = "Warships";
    public static String PHASE_SHIPS = "Phase ships";
    public static String CARRIERS = "Carriers";
    public static String CIVILIAN = "Civilian";
    private List<privatesuper> \u00d5\u00f8o000 = new ArrayList<privatesuper>();
    private CustomProductionPanel \u00d8\u00f8o000;
    private TableColumns for.void$super = null;

    public ShipBlueprintBrowser(CustomProductionPanel customProductionPanel, L.o o2) {
        super(o2, customProductionPanel);
        this.\u00d8\u00f8o000 = customProductionPanel;
        if (customProductionPanel != null && customProductionPanel.isPickerMode() && customProductionPanel.getDelegate() != null && customProductionPanel.getDelegate().getAvailableShipHulls() != null) {
            for (String string : customProductionPanel.getDelegate().getAvailableShipHulls()) {
                privatesuper privatesuper2 = SpecStore.o00000(privatesuper.class, string);
                this.\u00d5\u00f8o000.add(privatesuper2);
            }
        } else {
            Faction faction = CampaignEngine.getInstance().getPlayerFaction();
            for (String string : faction.getKnownShips()) {
                privatesuper privatesuper3 = SpecStore.o00000(privatesuper.class, string);
                this.\u00d5\u00f8o000.add(privatesuper3);
            }
        }
    }

    public List<privatesuper> getKnownHulls() {
        return this.\u00d5\u00f8o000;
    }

    @Override
    protected UITable createTable() {
        voidsuper voidsuper2 = new voidsuper(this.faction);
        voidsuper2.addColumn((Object)TableColumns.NAME, "Ship hull blueprint", 300.0f, true);
        voidsuper2.addColumn((Object)TableColumns.SIZE, "Size", 80.0f, true);
        voidsuper2.addColumn((Object)TableColumns.TYPE, "Type", 80.0f, true);
        voidsuper2.addColumn((Object)TableColumns.TECH, "Design type", 200.0f, true);
        voidsuper2.setTooltip(0, "Hull name. Mouse over the icon for a detailed tooltip with its stats.");
        voidsuper2.setTooltip(1, "Hull size.");
        voidsuper2.setTooltip(2, "Ship type - warship, carrier, phase ship, or civilian.");
        voidsuper2.setTooltip(3, "The originator of the design (such as a corporation or a faction), or, for more common designs, its general classification.");
        if (this.mode == L.o.\u00d300000) {
            voidsuper2.addColumn((Object)TableColumns.ENABLED, ENABLED_COL, 120.0f, true);
            voidsuper2.setTooltip(4, "Prioriziting a ship will make it more likely to be used in your faction's fleets.");
        } else {
            voidsuper2.addColumn((Object)TableColumns.COST, "Cost", 120.0f, true);
            voidsuper2.setTooltipLeft(4, new StandardTooltipV2Expandable(300.0f, false){

                public void createImpl(boolean bl) {
                    if (DebugFlags.WEAPONS_HAVE_COST) {
                        float f2 = 0.0f;
                        if (ShipBlueprintBrowser.this.\u00d8\u00f8o000 == null || !ShipBlueprintBrowser.this.\u00d8\u00f8o000.isPickerMode()) {
                            this.addPara("Production cost. Does not include outfitting the ship with weapons and fighters.", f2);
                            f2 = 10.0f;
                            this.addPara("The cost of weapons and fighters installed on the ship will be deducted once it's produced and does not count against the monthly production capacity.", f2);
                        } else {
                            this.addPara("Cost to produce a hull of this ship type. The hull will not have any weapons or fighter LPCs mounted.", f2);
                        }
                    } else {
                        this.addPara("Production cost. Includes outfitting the ship with weapons and fighters.", 0.0f);
                    }
                }
            });
        }
        UITable uITable = new UITable(8000.0f, J.ROW_HEIGHT, voidsuper2, this);
        uITable.setEmptyText("No matching ship hull blueprints");
        uITable.setWithBackground(true);
        uITable.autoSizeToRows(J.TABLE_ROWS);
        return uITable;
    }

    @Override
    public void updateTable() {
        this.table.clear();
        this.table.suspendRecompute();
        Set<String> set = this.tags.getSelected();
        for (privatesuper privatesuper2 : this.\u00d5\u00f8o000) {
            if (!this.hullMatchesTags(privatesuper2, set)) continue;
            N n = new N(this.\u00d8\u00f8o000, this.table.getHeader(), privatesuper2.getHullId(), this.mode);
            this.table.addRow(n);
            if (this.mode != L.o.\u00d200000) continue;
            n.getButton().getLogic().super(int.o.String);
        }
        this.table.resumeRecompute();
        this.table.sort((Object)TableColumns.SIZE, false);
        super.updateTable();
    }

    protected boolean hullMatchesTags(privatesuper privatesuper2, Set<String> set) {
        boolean bl;
        boolean bl2;
        ShipAPI.HullSize hullSize = privatesuper2.getHullSize();
        String string = null;
        if (hullSize == ShipAPI.HullSize.FRIGATE) {
            string = FRIGATES;
        }
        if (hullSize == ShipAPI.HullSize.DESTROYER) {
            string = DESTROYERS;
        }
        if (hullSize == ShipAPI.HullSize.CRUISER) {
            string = CRUISERS;
        }
        if (hullSize == ShipAPI.HullSize.CAPITAL_SHIP) {
            string = CAPITALS;
        }
        if (string != null && !set.contains(string)) {
            return false;
        }
        boolean bl3 = privatesuper2.isPhase() || privatesuper2.getHints().contains(ShipHullSpecAPI.ShipTypeHints.PHASE);
        boolean bl4 = bl2 = bl3 && privatesuper2.isCivilianNonCarrier();
        if (!bl2 && bl3 && !set.contains(PHASE_SHIPS)) {
            return false;
        }
        if (!bl2 && privatesuper2.isCivilianNonCarrier() && !set.contains(CIVILIAN)) {
            return false;
        }
        if (bl2 && !set.contains(PHASE_SHIPS) && !set.contains(CIVILIAN)) {
            return false;
        }
        if (privatesuper2.isCarrier() && !set.contains(CARRIERS)) {
            return false;
        }
        boolean bl5 = bl = !bl3 && !privatesuper2.isCarrier() && !privatesuper2.isCivilianNonCarrier();
        if (bl && !set.contains(COMBAT_SHIPS)) {
            return false;
        }
        String string2 = privatesuper2.getManufacturer();
        return string2 == null || set.contains(string2);
    }

    @Override
    protected do createTags() {
        do do_ = new do(this.table.getWidth(), this);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        CountingMap countingMap = new CountingMap();
        for (privatesuper privatesuper2 : this.\u00d5\u00f8o000) {
            boolean bl = privatesuper2.isPhase() || privatesuper2.getHints().contains(ShipHullSpecAPI.ShipTypeHints.PHASE);
            countingMap.add((Object)privatesuper2.getManufacturer());
            if (privatesuper2.isCarrier()) {
                ++n;
            } else if (privatesuper2.isCivilianNonCarrier()) {
                ++n2;
            } else if (bl) {
                ++n3;
            } else {
                ++n4;
            }
            if (privatesuper2.isCivilianNonCarrier() && bl) {
                ++n3;
            }
            if (privatesuper2.getHullSize() == ShipAPI.HullSize.FRIGATE) {
                ++n5;
                continue;
            }
            if (privatesuper2.getHullSize() == ShipAPI.HullSize.DESTROYER) {
                ++n6;
                continue;
            }
            if (privatesuper2.getHullSize() == ShipAPI.HullSize.CRUISER) {
                ++n7;
                continue;
            }
            if (privatesuper2.getHullSize() != ShipAPI.HullSize.CAPITAL_SHIP) continue;
            ++n8;
        }
        float f2 = 10.0f;
        float f3 = 3.0f;
        if (!countingMap.isEmpty()) {
            do_.beginGroup(false, ALL_TECHS);
            ArrayList arrayList = new ArrayList(countingMap.keySet());
            Collections.sort(arrayList);
            for (String string : arrayList) {
                do_.addTag(string, string, countingMap.getCount((Object)string));
            }
            do_.addGroup(0.0f);
        }
        do_.beginGroup(false, ALL_SIZES, 120.0f);
        do_.addTag(FRIGATES, n5);
        do_.addTag(DESTROYERS, n6);
        do_.addTag(CRUISERS, n7);
        do_.addTag(CAPITALS, n8);
        do_.addGroup(f2 * 1.0f);
        do_.beginGroup(false, ALL_TYPES, 120.0f);
        do_.addTag(COMBAT_SHIPS, n4);
        do_.addTag(PHASE_SHIPS, n3);
        do_.addTag(CARRIERS, n);
        do_.addTag(CIVILIAN, n2);
        do_.addGroup(f3);
        return do_;
    }

    @Override
    public void tagsChanged(do do_) {
        TableColumns tableColumns = this.for.void$super;
        this.updateTable();
        if (tableColumns != null) {
            this.table.sort((Object)tableColumns, null);
            this.table.sort((Object)tableColumns, null);
        }
    }

    @Override
    public Comparator<B> tableGetComparator(UITable uITable, final Object object) {
        return new Comparator<B>(){

            public int super(B b2, B b3) {
                int n;
                N n2 = (N)b2;
                N n3 = (N)b3;
                privatesuper privatesuper2 = n2.getSpec();
                privatesuper privatesuper3 = n3.getSpec();
                ShipBlueprintBrowser.this.for.void$super = (TableColumns)((Object)object);
                if (object == TableColumns.SIZE && (n = privatesuper2.getHullSize().ordinal() - privatesuper3.getHullSize().ordinal()) != 0) {
                    return n;
                }
                if (object == TableColumns.TECH) {
                    return privatesuper2.getManufacturer().compareTo(privatesuper3.getManufacturer());
                }
                if (object == TableColumns.TYPE) {
                    return n2.getTypeString().compareTo(n3.getTypeString());
                }
                if (object == TableColumns.ENABLED) {
                    if (n2.isBlueprintEnabled() && !n3.isBlueprintEnabled()) {
                        return -1;
                    }
                    if (n3.isBlueprintEnabled() && !n2.isBlueprintEnabled()) {
                        return 1;
                    }
                    n = privatesuper2.getHullSize().ordinal() - privatesuper3.getHullSize().ordinal();
                    if (n != 0) {
                        return -n;
                    }
                }
                if (object == TableColumns.COST && (n = n2.getCostValue() - n3.getCostValue()) != 0) {
                    return n;
                }
                return privatesuper2.getHullName().compareTo(privatesuper3.getHullName());
            }
        };
    }

    @Override
    public void tableRowSelected(UITable uITable, B b2, Object object) {
        N n = (N)b2;
        if (this.mode == L.o.\u00d300000) {
            n.setBlueprintEnabled(!n.isBlueprintEnabled());
        } else {
            Cloneable cloneable;
            int n2 = 1;
            boolean bl = true;
            if (object instanceof ooOO) {
                cloneable = (ooOO)object;
                if (((ooOO)cloneable).isCtrlDown()) {
                    n2 = 1000;
                } else if (((ooOO)cloneable).isShiftDown()) {
                    n2 = CustomProductionPanel.SHIFT_CLICK_QUANTITY;
                }
                if (((ooOO)cloneable).isRMBEvent()) {
                    bl = false;
                }
            }
            cloneable = this.\u00d8\u00f8o000.getProd();
            if (bl) {
                int n3 = this.\u00d8\u00f8o000.getDelegate() == null ? 0 : (this.\u00d8\u00f8o000.getDelegate().withQuantityLimits() ? 0 : 1000);
                cloneable.addItem(FactionProductionAPI.ProductionItemType.SHIP, n.getHullId(), n2, n3);
            } else {
                cloneable.removeItem(FactionProductionAPI.ProductionItemType.SHIP, n.getHullId(), n2);
            }
            this.\u00d8\u00f8o000.updatePlanTable(FactionProductionAPI.ProductionItemType.SHIP, n.getHullId());
            n.getButton().flash(false, 0.1f, 0.9f);
        }
        n.getButton().unhighlight();
    }

    @Override
    public void tableSortFinished(UITable uITable, voidsuper.o o2) {
    }

    @Override
    protected void selectAll() {
        for (B b2 : this.table.getRows()) {
            N n = (N)b2;
            n.setBlueprintEnabled(true);
        }
    }

    @Override
    protected void unselectAll() {
        for (B b2 : this.table.getRows()) {
            N n = (N)b2;
            n.setBlueprintEnabled(false);
        }
    }

    @Override
    protected void unselectAllReally() {
        Faction faction = CampaignEngine.getInstance().getPlayerFaction();
        for (String string : faction.getKnownShips()) {
            faction.removePriorityShip(string);
        }
    }

    @Override
    protected int getNumPriority() {
        Faction faction = CampaignEngine.getInstance().getPlayerFaction();
        return faction.getPriorityShips().size();
    }

    @Override
    protected void autoEnableSet(boolean bl) {
        Faction faction = CampaignEngine.getInstance().getPlayerFaction();
        faction.setAutoEnableKnownShips(bl);
    }

    @Override
    protected String getAutoEnableSubject() {
        return "ship blueprints";
    }

    @Override
    protected boolean isAutoEnableSet() {
        Faction faction = CampaignEngine.getInstance().getPlayerFaction();
        return faction.isAutoEnableKnownShips();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TableColumns implements DoNotObfuscate
    {
        NAME,
        SIZE,
        TYPE,
        TECH,
        ENABLED,
        COST;

    }
}

