/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.econ;

import com.fs.graphics.util.OoOO;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CampaignPlugin;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.SubmarketPlugin;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.ImmigrationPlugin;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketConditionAPI;
import com.fs.starfarer.api.campaign.econ.MarketDemandAPI;
import com.fs.starfarer.api.campaign.econ.MarketImmigrationModifier;
import com.fs.starfarer.api.campaign.econ.PriceVariability;
import com.fs.starfarer.api.campaign.econ.SubmarketAPI;
import com.fs.starfarer.api.campaign.listeners.ListenerUtil;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.AdminData;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.combat.MutableStatWithTempMods;
import com.fs.starfarer.api.combat.StatBonus;
import com.fs.starfarer.api.fleet.ShipFilter;
import com.fs.starfarer.api.fleet.ShipRolePick;
import com.fs.starfarer.api.impl.campaign.econ.impl.BaseIndustry;
import com.fs.starfarer.api.impl.campaign.econ.impl.ConstructionQueue;
import com.fs.starfarer.api.impl.campaign.econ.impl.PopulationAndInfrastructure;
import com.fs.starfarer.api.impl.campaign.population.CoreImmigrationPluginImpl;
import com.fs.starfarer.api.impl.campaign.population.PopulationComposition;
import com.fs.starfarer.api.impl.campaign.procgen.ConditionGenDataSpec;
import com.fs.starfarer.api.impl.campaign.submarkets.LocalResourcesSubmarketPlugin;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.CommDirectory;
import com.fs.starfarer.campaign.Faction;
import com.fs.starfarer.campaign.econ.CommodityOnMarket;
import com.fs.starfarer.campaign.econ.Economy;
import com.fs.starfarer.campaign.econ.MarketCondition;
import com.fs.starfarer.campaign.econ.MarketDemand;
import com.fs.starfarer.campaign.econ.MarketDemandData;
import com.fs.starfarer.campaign.econ.PlanetConditionMarket;
import com.fs.starfarer.campaign.econ.Submarket;
import com.fs.starfarer.campaign.econ.oOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO;
import com.fs.starfarer.campaign.fleet.MutableMarketStats;
import com.fs.starfarer.campaign.rules.Memory;
import com.fs.starfarer.loading.F;
import com.fs.starfarer.loading.SpecStore;
import com.fs.starfarer.loading.specs.H;
import com.fs.starfarer.rpg.Person;
import com.fs.util.DoNotObfuscate;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Market
implements DoNotObfuscate,
MarketAPI,
Cloneable {
    private String id;
    private String name;
    private List<CommodityOnMarket> commodities = new ArrayList<CommodityOnMarket>();
    private transient Map<String, CommodityOnMarket> commodityMap = new HashMap<String, CommodityOnMarket>();
    private transient Map<String, List<CommodityOnMarket>> commoditiesByDemandClass = new HashMap<String, List<CommodityOnMarket>>();
    private MarketDemandData demandData;
    private int size = 1;
    private Vector2f location = new Vector2f();
    private transient Vector2f simDisplayLocation = new Vector2f();
    private final Economy economy;
    private StatBonus demandPriceMod = new StatBonus();
    private StatBonus supplyPriceMod = new StatBonus();
    private MutableStat tariff = new MutableStat(0.0f);
    private String factionId;
    private MutableStatWithTempMods power = new MutableStatWithTempMods(0.0f);
    private MutableStat hazard = new MutableStat(0.0f);
    private SectorEntityToken primaryEntity = null;
    private List<Submarket> submarkets = new ArrayList<Submarket>();
    private MemoryAPI memory;
    private MutableMarketStats stats = new MutableMarketStats();
    private boolean isPlanetConditionMarketOnly = false;
    private StatBonus accessibilityMod = new StatBonus();
    private MutableStat incomeMult = new MutableStat(1.0f);
    private MutableStat upkeepMult = new MutableStat(1.0f);
    private Boolean useStockpilesForShortages = false;
    private List<Industry> industries = new ArrayList<Industry>();
    private boolean playerOwned = false;
    private boolean hasSpaceport = false;
    private boolean hasWaystation = false;
    private PopulationComposition population;
    private PopulationComposition incoming;
    private LinkedHashSet<MarketImmigrationModifier> immigrationModifiers = new LinkedHashSet();
    private transient LinkedHashSet<MarketImmigrationModifier> transientImmigrationModifiers = new LinkedHashSet();
    private boolean allowImport = true;
    private boolean allowExport = true;
    private float incentiveCredits = 0.0f;
    private String econGroup = null;
    private Boolean hidden = null;
    private Boolean invalidMissionTarget = null;
    private Boolean incentives = null;
    private ConstructionQueue constructionQueue = new ConstructionQueue();
    private CommDirectory commDirectory = null;
    private Set<Person> people = null;
    private Person admin;
    private float prevStability = -1.0f;
    private float daysInExistence = 0.0f;
    private LinkedHashSet<SectorEntityToken> connectedEntities = new LinkedHashSet();
    private transient Faction cachedFaction = null;
    private List<MarketConditionAPI> conditions = new ArrayList<MarketConditionAPI>();
    private LinkedHashSet<String> suppressedConditions = new LinkedHashSet();
    private transient Map<String, MarketConditionAPI> conditionsCache = null;
    private MarketAPI.SurveyLevel surveyLevel = MarketAPI.SurveyLevel.NONE;
    protected Boolean retainSuppressedConditionsSetWhenEmpty = null;
    private boolean forceNoConvertOnSave = false;
    private transient Map<String, Boolean> hostileCache = new HashMap<String, Boolean>();
    private boolean isFreePort = false;
    private HashSet<String> tags = null;

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.id == null ? 0 : this.id.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Market market = (Market)object;
        return !(this.id == null ? market.id != null : !this.id.equals(market.id));
    }

    public Market(String string, String string2, int n, Economy economy) {
        this.id = string;
        this.name = string2;
        this.economy = economy;
        this.demandData = new MarketDemandData(this);
        this.size = n;
        this.getAllCommodities();
        this.hazard.modifyFlat("haz_base", 1.0f, "Base value");
    }

    public String getEconGroup() {
        return this.econGroup;
    }

    public void setEconGroup(String string) {
        this.econGroup = string;
    }

    public ConstructionQueue getConstructionQueue() {
        return this.constructionQueue;
    }

    public boolean isPlayerOwned() {
        return this.playerOwned;
    }

    public boolean hasSpaceport() {
        return this.hasSpaceport;
    }

    public void setHasSpaceport(boolean bl) {
        this.hasSpaceport = bl;
    }

    public void setPlayerOwned(boolean bl) {
        boolean bl2 = this.playerOwned;
        this.playerOwned = bl;
        if (bl2 || this.isPlayerOwned()) {
            Global.getSector().getPlayerStats().refreshAllOutpostsEffects((MarketAPI)this);
        }
    }

    public List<Industry> getIndustries() {
        return this.industries;
    }

    public Industry getIndustry(String string) {
        for (Industry industry : this.industries) {
            if (!string.equals(industry.getId())) continue;
            return industry;
        }
        return null;
    }

    public boolean hasIndustry(String string) {
        for (Industry industry : this.industries) {
            if (!string.equals(industry.getId())) continue;
            return true;
        }
        return false;
    }

    public boolean hasFunctionalIndustry(String string) {
        for (Industry industry : this.industries) {
            if (!string.equals(industry.getId()) || !industry.isFunctional()) continue;
            return true;
        }
        return false;
    }

    public void addIndustry(String string) {
        this.addIndustry(string, null);
    }

    public void addIndustry(String string, List<String> list) {
        if (this.hasIndustry(string)) {
            return;
        }
        H h2 = SpecStore.o00000(H.class, string);
        if (h2 == null) {
            throw new RuntimeException("Industry [" + string + "] not found");
        }
        Industry industry = h2.getNewPluginInstance(this);
        if (list != null) {
            industry.initWithParams(list);
        }
        this.industries.add(industry);
        industry.apply();
    }

    public Industry instantiateIndustry(String string) {
        H h2 = SpecStore.o00000(H.class, string);
        if (h2 == null) {
            throw new RuntimeException("Industry [" + string + "] not found");
        }
        Industry industry = h2.getNewPluginInstance(this);
        return industry;
    }

    public void removeIndustry(String string, MarketAPI.MarketInteractionMode marketInteractionMode, boolean bl) {
        Iterator<Industry> iterator = this.getIndustries().iterator();
        while (iterator.hasNext()) {
            Industry industry = iterator.next();
            if (string == null || !string.equals(industry.getId())) continue;
            industry.notifyBeingRemoved(marketInteractionMode, bl);
            industry.unapply();
            iterator.remove();
        }
    }

    public void reapplyIndustries() {
        this.getAdmin().getStats().refreshGovernedOutpostEffects(this);
        for (Industry industry : this.industries) {
            industry.unapply();
            industry.apply();
        }
        PopulationAndInfrastructure.modifyUpkeepByHazardRating((MarketAPI)this, (String)"upkeep_hazard_mod");
    }

    public boolean isInEconomy() {
        return Global.getSector().getEconomy() != null && Global.getSector().getEconomy().getMarket(this.getId()) != null;
    }

    public boolean isInHyperspace() {
        return this.getContainingLocation() != null && this.getContainingLocation().isHyperspace();
    }

    public CommDirectory getCommDirectory() {
        if (this.commDirectory == null) {
            this.commDirectory = new CommDirectory();
        }
        return this.commDirectory;
    }

    public Person getAdmin() {
        if (this.admin == null) {
            Person person = new Person("steady");
            person.setFaction(this.getFactionId());
            this.setAdmin(person);
        }
        if (this.isPlayerOwned() && this.admin.isDefault()) {
            this.setAdmin(null);
            this.admin = (Person)Global.getSector().getPlayerPerson();
            this.admin.getStats().refreshGovernedOutpostEffects(this);
        }
        return this.admin;
    }

    public void setAdmin(PersonAPI personAPI) {
        boolean bl;
        boolean bl2 = bl = this.admin != personAPI;
        if (this.admin != null) {
            this.removePerson(this.admin);
            this.getCommDirectory().removePerson(this.admin);
        }
        if (this.admin != null) {
            for (AdminData adminData : CampaignEngine.getInstance().getCharacterData().getAdmins()) {
                if (adminData.getPerson() != this.admin) continue;
                adminData.setMarket(null);
            }
        }
        this.admin = (Person)personAPI;
        if (this.admin != null) {
            this.addPerson(this.admin);
            if (bl) {
                this.admin.getStats().refreshGovernedOutpostEffects(this);
            }
        }
    }

    public Set<Person> getPeople() {
        return this.people;
    }

    public void addPerson(PersonAPI personAPI) {
        if (personAPI == null) {
            return;
        }
        if (this.people == null) {
            this.people = new HashSet<Person>();
        }
        if (!this.people.contains(personAPI)) {
            this.people.add((Person)personAPI);
        }
        if (personAPI != null) {
            personAPI.setMarket((MarketAPI)this);
        }
    }

    public void removePerson(PersonAPI personAPI) {
        if (this.people == null) {
            return;
        }
        this.people.remove(personAPI);
        if (personAPI != null) {
            personAPI.setMarket(null);
        }
        if (this.people.isEmpty()) {
            this.people = null;
        }
    }

    public List<PersonAPI> getPeopleCopy() {
        if (this.people == null) {
            return new ArrayList<PersonAPI>();
        }
        return new ArrayList<PersonAPI>(this.people);
    }

    public void setMemory(MemoryAPI memoryAPI) {
        this.memory = memoryAPI;
    }

    public MemoryAPI getMemory() {
        if (this.memory == null) {
            this.memory = new Memory();
        }
        for (CampaignPlugin campaignPlugin : CampaignEngine.getInstance().getModAndPluginData().getPlugins()) {
            campaignPlugin.updateMarketFacts((MarketAPI)this, this.memory);
        }
        return this.memory;
    }

    public MemoryAPI getMemoryWithoutUpdate() {
        if (this.memory == null) {
            this.memory = new Memory();
        }
        return this.memory;
    }

    public float getPrevStability() {
        return this.prevStability;
    }

    public void updatePrevStability() {
        this.prevStability = this.getStabilityValue();
    }

    public float getDaysInExistence() {
        return this.daysInExistence;
    }

    public void setDaysInExistence(float f2) {
        this.daysInExistence = f2;
    }

    public void advance(float f2) {
        float f3 = Global.getSector().getClock().convertToDays(f2);
        this.daysInExistence += f3;
        this.power.advance(f3);
        float f4 = this.getStabilityValue();
        if (f4 != this.prevStability) {
            this.prevStability = f4;
            this.reapplyConditions();
            this.reapplyIndustries();
            this.updatePrices();
        }
        for (MarketConditionAPI object : new ArrayList<MarketConditionAPI>(this.getConditions())) {
            object.getPlugin().advance(f2);
        }
        for (Submarket submarket : this.submarkets) {
            submarket.getPlugin().advance(f2);
        }
        if (this.memory != null) {
            ((Memory)this.memory).advance(f2);
        }
        if (this.people != null) {
            for (Person person : this.people) {
                person.advance(f2);
            }
        }
        if (!this.getConstructionQueue().getItems().isEmpty() && Misc.getCurrentlyBeingConstructed((MarketAPI)this) == null) {
            BaseIndustry.buildNextInQueue((MarketAPI)this);
        }
        for (CommodityOnMarket commodityOnMarket : this.getCommodities()) {
            commodityOnMarket.getAvailableStat().advance(f3);
            commodityOnMarket.getTradeMod().advance(f3);
            commodityOnMarket.getTradeModPlus().advance(f3);
            commodityOnMarket.getTradeModMinus().advance(f3);
            commodityOnMarket.reapplyEventMod();
        }
        for (Industry industry : new ArrayList<Industry>(this.industries)) {
            industry.advance(f2);
        }
    }

    public SectorEntityToken getPrimaryEntity() {
        return this.primaryEntity;
    }

    public PlanetAPI getPlanetEntity() {
        for (SectorEntityToken sectorEntityToken : this.getConnectedEntities()) {
            if (!(sectorEntityToken instanceof PlanetAPI)) continue;
            return (PlanetAPI)sectorEntityToken;
        }
        return null;
    }

    public void setPrimaryEntity(SectorEntityToken sectorEntityToken) {
        this.primaryEntity = sectorEntityToken;
        if (!this.connectedEntities.contains(sectorEntityToken)) {
            this.connectedEntities.add(sectorEntityToken);
        }
        if (this.primaryEntity != null && this.primaryEntity.getLocationInHyperspace() != null) {
            this.location.set((ReadableVector2f)this.primaryEntity.getLocationInHyperspace());
        }
    }

    public Set<SectorEntityToken> getConnectedEntities() {
        return this.connectedEntities;
    }

    private void sortSubmarkets() {
        Collections.sort(this.submarkets, new Comparator<Submarket>(){

            public int o00000(Submarket submarket, Submarket submarket2) {
                return new Float(submarket.getSpec().getOrder()).compareTo(new Float(submarket2.getSpec().getOrder()));
            }
        });
    }

    public void addSubmarket(SubmarketAPI submarketAPI) {
        this.submarkets.add((Submarket)submarketAPI);
    }

    public void addSubmarket(String string) {
        if (this.hasSubmarket(string)) {
            return;
        }
        this.submarkets.add(new Submarket(this, string));
        this.sortSubmarkets();
    }

    public Submarket getSubmarket(String string) {
        for (Submarket submarket : this.submarkets) {
            if (!submarket.getSpecId().equals(string)) continue;
            return submarket;
        }
        return null;
    }

    public boolean hasSubmarket(String string) {
        for (Submarket submarket : this.submarkets) {
            if (!submarket.getSpecId().equals(string)) continue;
            return true;
        }
        return false;
    }

    public List<Submarket> getSubmarkets() {
        return this.submarkets;
    }

    public List<SubmarketAPI> getSubmarketsCopy() {
        return new ArrayList<SubmarketAPI>(this.submarkets);
    }

    public void removeSubmarket(String string) {
        for (Submarket submarket : this.submarkets) {
            if (!submarket.getSpecId().equals(string)) continue;
            this.submarkets.remove(submarket);
            this.sortSubmarkets();
            return;
        }
    }

    public MutableStat getIncomeMult() {
        return this.incomeMult;
    }

    public MutableStat getUpkeepMult() {
        return this.upkeepMult;
    }

    public MutableStat getHazard() {
        return this.hazard;
    }

    public float getHazardValue() {
        return this.hazard.getModifiedValue();
    }

    public MutableStatWithTempMods getStability() {
        return this.power;
    }

    public float getStabilityValue() {
        float f2 = this.getStability().getModifiedValue();
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 10.0f) {
            f2 = 10.0f;
        }
        f2 = Math.round(f2);
        return f2;
    }

    public String getFactionId() {
        return this.factionId;
    }

    public Faction getFaction() {
        if (this.cachedFaction == null) {
            this.cachedFaction = CampaignEngine.getInstance().getFaction(this.factionId);
        }
        return this.cachedFaction;
    }

    public void setFactionId(String string) {
        this.factionId = string;
        this.cachedFaction = null;
    }

    public MutableMarketStats getStats() {
        return this.stats;
    }

    public StatBonus getAccessibilityMod() {
        return this.accessibilityMod;
    }

    Object readResolve() {
        if (this.constructionQueue == null) {
            this.constructionQueue = new ConstructionQueue();
        }
        if (this.suppressedConditions == null) {
            this.suppressedConditions = new LinkedHashSet();
        }
        if (this.incomeMult == null) {
            this.incomeMult = new MutableStat(1.0f);
        }
        if (this.upkeepMult == null) {
            this.upkeepMult = new MutableStat(1.0f);
        }
        if (this.immigrationModifiers == null) {
            this.immigrationModifiers = new LinkedHashSet();
        }
        if (this.transientImmigrationModifiers == null) {
            this.transientImmigrationModifiers = new LinkedHashSet();
        }
        if (this.industries == null) {
            this.industries = new ArrayList<Industry>();
        }
        if (this.accessibilityMod == null) {
            this.accessibilityMod = new StatBonus();
        }
        if (this.surveyLevel == null) {
            this.surveyLevel = MarketAPI.SurveyLevel.NONE;
        }
        if (this.commodities == null) {
            this.commodities = new ArrayList<CommodityOnMarket>();
        }
        if (this.demandData == null) {
            this.demandData = new MarketDemandData(this);
        }
        if (this.connectedEntities == null) {
            this.connectedEntities = new LinkedHashSet();
        }
        if (this.stats == null) {
            this.stats = new MutableMarketStats();
        }
        if (this.hazard == null) {
            this.hazard = new MutableStat(0.0f);
        }
        this.hazard.modifyFlat("haz_base", 1.0f, "Base value");
        this.commodityMap = new HashMap<String, CommodityOnMarket>();
        this.commoditiesByDemandClass = new HashMap<String, List<CommodityOnMarket>>();
        for (CommodityOnMarket commodityOnMarket : this.commodities) {
            this.commodityMap.put(commodityOnMarket.getCommodity().getId(), commodityOnMarket);
            this.addToDemandClassList(commodityOnMarket);
        }
        this.getAllCommodities();
        return this;
    }

    public boolean isUseStockpilesForShortages() {
        return this.useStockpilesForShortages != null && this.useStockpilesForShortages != false;
    }

    public void setUseStockpilesForShortages(boolean bl) {
        this.useStockpilesForShortages = bl;
        if (!this.useStockpilesForShortages.booleanValue()) {
            this.useStockpilesForShortages = null;
        }
    }

    public void clearCommodities() {
        this.commodities = new ArrayList<CommodityOnMarket>();
        this.commodityMap = new HashMap<String, CommodityOnMarket>();
        this.commoditiesByDemandClass = new HashMap<String, List<CommodityOnMarket>>();
    }

    Object writeReplace() {
        Market market = this.clone();
        market.commodities = new ArrayList<CommodityOnMarket>(this.commodities);
        Iterator<CommodityOnMarket> iterator = market.commodities.iterator();
        while (iterator.hasNext()) {
            CommodityOnMarket object = iterator.next();
            if (object.getAvailable() != 0 || object.getMaxDemand() != 0 || object.getMaxSupply() != 0) continue;
            iterator.remove();
        }
        market.demandData = new MarketDemandData(market);
        for (String string : this.demandData.getDemands().keySet()) {
            MarketDemand marketDemand = this.demandData.getDemands().get(string);
            if (marketDemand.getDemandValue() == 0.0f && marketDemand.getStockpileUtility() == 0.0f) continue;
            market.demandData.getDemands().put(string, marketDemand);
        }
        if (this.isPlanetConditionMarketOnly) {
            market.commodities = null;
            market.demandData = null;
            market.commDirectory = null;
        }
        if (market.suppressedConditions != null && market.suppressedConditions.isEmpty()) {
            market.suppressedConditions = null;
        }
        return market;
    }

    public Market clone() {
        try {
            Market market = (Market)super.clone();
            return market;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public MutableStat getTariff() {
        return this.tariff;
    }

    public StatBonus getDemandPriceMod() {
        return this.demandPriceMod;
    }

    public StatBonus getSupplyPriceMod() {
        return this.supplyPriceMod;
    }

    private void addToDemandClassList(CommodityOnMarket commodityOnMarket) {
        List<CommodityOnMarket> list = this.commoditiesByDemandClass.get(commodityOnMarket.getCommodity().getDemandClass());
        if (list == null) {
            list = new ArrayList<CommodityOnMarket>();
            this.commoditiesByDemandClass.put(commodityOnMarket.getCommodity().getDemandClass(), list);
        }
        list.add(commodityOnMarket);
    }

    public Economy getEconomy() {
        return this.economy;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public List<CommodityOnMarket> getCommodities() {
        return this.commodities;
    }

    public List<CommodityOnMarketAPI> getCommoditiesCopy() {
        return new ArrayList<CommodityOnMarketAPI>(this.commodities);
    }

    public void updatePrices() {
        for (CommodityOnMarket commodityOnMarket : this.commodities) {
            commodityOnMarket.updateCalc();
        }
    }

    public List<CommodityOnMarket> getCommoditiesWithClass(String string) {
        List<CommodityOnMarket> list = this.commoditiesByDemandClass.get(string);
        if (list == null) {
            list = new ArrayList<CommodityOnMarket>();
        }
        return list;
    }

    public CommodityOnMarket getCommodityData(F f2) {
        return this.getCommodityData(f2.getId());
    }

    public CommodityOnMarket getCommodityData(String string) {
        CommodityOnMarket commodityOnMarket = this.commodityMap.get(string);
        if (commodityOnMarket != null) {
            return commodityOnMarket;
        }
        commodityOnMarket = new CommodityOnMarket(this, string);
        this.commodities.add(commodityOnMarket);
        this.commodityMap.put(string, commodityOnMarket);
        this.addToDemandClassList(commodityOnMarket);
        return commodityOnMarket;
    }

    public float getDemandPrice(String string, double d2, boolean bl) {
        return this.getDemandPriceAssumingExistingTransaction(string, d2, 0.0, bl);
    }

    public float getDemandPriceAssumingExistingTransaction(String string, double d2, double d3, boolean bl) {
        CommodityOnMarket commodityOnMarket = this.getCommodityData(string);
        MarketDemand marketDemand = this.demandData.getDemand(commodityOnMarket.getCommodity().getDemandClass());
        double d4 = (double)marketDemand.getStockpileUtility() + d3;
        return this.getDemandPriceAssumingStockpileUtility(commodityOnMarket, d4, d2, bl);
    }

    public float getDemandPriceAssumingStockpileUtility(CommodityOnMarket commodityOnMarket, double d2, double d3, boolean bl) {
        if (d3 <= 0.0) {
            return 0.0f;
        }
        if (commodityOnMarket.getCommodity().getPriceVariability() == PriceVariability.V0) {
            float f2 = (float)(d3 * (double)commodityOnMarket.getCommodity().getBasePrice());
            if (bl) {
                f2 = commodityOnMarket.getPlayerDemandPriceMod().computeEffective(f2);
            }
            return f2;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        double d4 = commodityOnMarket.getDemandPrice().getAddPrice(d2, d3 * (double)commodityOnMarket.getUtilityOnMarket());
        double d5 = d4 / d3;
        d4 = (double)this.demandPriceMod.computeEffective((float)d5) * d3;
        if (bl) {
            d5 = d4 / d3;
            d4 = (double)commodityOnMarket.getPlayerDemandPriceMod().computeEffective((float)d5) * d3;
        }
        if (d4 < d3) {
            d4 = d3;
        }
        return (float)Math.floor(d4);
    }

    public float getSupplyPrice(String string, double d2, boolean bl) {
        return this.getSupplyPriceAssumingExistingTransaction(string, d2, 0.0, bl);
    }

    public float getSupplyPriceAssumingExistingTransaction(String string, double d2, double d3, boolean bl) {
        CommodityOnMarket commodityOnMarket = this.getCommodityData(string);
        MarketDemand marketDemand = this.demandData.getDemand(commodityOnMarket.getCommodity().getDemandClass());
        double d4 = (double)marketDemand.getStockpileUtility() + d3;
        return this.getSupplyPriceAssumingStockpileUtility(commodityOnMarket, d4, d2, bl);
    }

    public float getSupplyPriceAssumingStockpileUtility(CommodityOnMarket commodityOnMarket, double d2, double d3, boolean bl) {
        double d4;
        if (d3 <= 0.0) {
            return 0.0f;
        }
        if (commodityOnMarket.getCommodity().getPriceVariability() == PriceVariability.V0) {
            float f2 = (float)(d3 * (double)commodityOnMarket.getCommodity().getBasePrice());
            if (bl) {
                f2 = commodityOnMarket.getPlayerSupplyPriceMod().computeEffective(f2);
            }
            return f2;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        if (d2 < (d4 = d3 * (double)commodityOnMarket.getUtilityOnMarket())) {
            d2 = d4;
        }
        double d5 = commodityOnMarket.getSupplyPrice().getRemovePrice(d2, d3 * (double)commodityOnMarket.getUtilityOnMarket());
        double d6 = d5 / d3;
        d5 = (double)this.supplyPriceMod.computeEffective((float)d6) * d3;
        if (bl) {
            d5 = (double)commodityOnMarket.getPlayerSupplyPriceMod().computeEffective((float)d6) * d3;
        }
        if (d5 < d3) {
            d5 = d3;
        }
        return (float)Math.floor(d5);
    }

    public MarketDemandData getDemandData() {
        return this.demandData;
    }

    public String toString() {
        String string = "Market: <b>" + this.getName() + "</b>\n\n";
        for (CommodityOnMarket commodityOnMarket : this.commodities) {
            string = String.valueOf(string) + commodityOnMarket.toString() + "\n";
        }
        return string;
    }

    public Vector2f getLocation() {
        SectorEntityToken sectorEntityToken = this.getPrimaryEntity();
        if (sectorEntityToken == null) {
            return this.location;
        }
        return sectorEntityToken.getLocationInHyperspace();
    }

    public Vector2f getSimDisplayLocation() {
        return this.simDisplayLocation;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        int n2 = this.size;
        this.size = n;
        if (n2 != n) {
            ListenerUtil.reportColonySizeChanged((MarketAPI)this, (int)n2);
        }
    }

    public List<CommodityOnMarketAPI> getCommoditiesWithTags(String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>(oOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO.super().keySet());
        ArrayList<CommodityOnMarketAPI> arrayList2 = new ArrayList<CommodityOnMarketAPI>();
        block0: for (String string : arrayList) {
            CommodityOnMarket commodityOnMarket = this.getCommodityData(string);
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray2[n2];
                if (commodityOnMarket.getCommodity().hasTag(string2)) {
                    arrayList2.add(commodityOnMarket);
                    continue block0;
                }
                ++n2;
            }
        }
        return arrayList2;
    }

    public List<CommodityOnMarketAPI> getCommoditiesWithTag(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(oOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO.super().keySet());
        ArrayList<CommodityOnMarketAPI> arrayList2 = new ArrayList<CommodityOnMarketAPI>();
        for (String string2 : arrayList) {
            CommodityOnMarket commodityOnMarket = this.getCommodityData(string2);
            if (!commodityOnMarket.getCommodity().hasTag(string)) continue;
            arrayList2.add(commodityOnMarket);
        }
        return arrayList2;
    }

    public List<CommodityOnMarketAPI> getAllCommodities() {
        ArrayList<String> arrayList = new ArrayList<String>(oOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO.super().keySet());
        ArrayList<CommodityOnMarketAPI> arrayList2 = new ArrayList<CommodityOnMarketAPI>();
        for (String string : arrayList) {
            CommodityOnMarket commodityOnMarket = this.getCommodityData(string);
            arrayList2.add(commodityOnMarket);
        }
        return arrayList2;
    }

    public MarketDemand getDemand(String string) {
        return this.getDemandData().getDemand(string);
    }

    public List<MarketDemandAPI> getDemandWithTag(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(oOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO.super().keySet());
        ArrayList<MarketDemandAPI> arrayList2 = new ArrayList<MarketDemandAPI>();
        for (String string2 : arrayList) {
            MarketDemand marketDemand;
            F f2 = oOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO.super(string2);
            if (!f2.isPrimary() || !(marketDemand = this.getDemand(f2.getDemandClass())).getBaseCommodity().hasTag(string)) continue;
            arrayList2.add(marketDemand);
        }
        return arrayList2;
    }

    private Map<String, MarketConditionAPI> getConditionsCache() {
        if (this.conditionsCache == null) {
            this.conditionsCache = new HashMap<String, MarketConditionAPI>();
        }
        for (MarketConditionAPI marketConditionAPI : this.getConditions()) {
            if (this.conditionsCache.containsKey(marketConditionAPI.getId())) continue;
            this.conditionsCache.put(marketConditionAPI.getId(), marketConditionAPI);
        }
        return this.conditionsCache;
    }

    private void resetCache() {
        this.conditionsCache = null;
    }

    public MarketAPI.SurveyLevel getSurveyLevel() {
        return this.surveyLevel;
    }

    public void setSurveyLevel(MarketAPI.SurveyLevel surveyLevel) {
        this.surveyLevel = surveyLevel;
    }

    public List<MarketConditionAPI> getConditions() {
        return this.conditions;
    }

    public MarketConditionAPI getCondition(String string) {
        return this.getConditionsCache().get(string);
    }

    public void setRetainSuppressedConditionsSetWhenEmpty(Boolean bl) {
        this.retainSuppressedConditionsSetWhenEmpty = bl;
    }

    public LinkedHashSet<String> getSuppressedConditions() {
        if (this.suppressedConditions == null) {
            this.suppressedConditions = new LinkedHashSet();
        }
        return this.suppressedConditions;
    }

    public boolean isConditionSuppressed(String string) {
        return this.suppressedConditions != null && this.suppressedConditions.contains(string);
    }

    public void suppressCondition(String string) {
        this.getSuppressedConditions().add(string);
    }

    public void unsuppressCondition(String string) {
        if (this.suppressedConditions != null && !this.suppressedConditions.isEmpty()) {
            this.suppressedConditions.remove(string);
            if (this.suppressedConditions.isEmpty() && (this.retainSuppressedConditionsSetWhenEmpty == null || !this.retainSuppressedConditionsSetWhenEmpty.booleanValue())) {
                this.suppressedConditions = null;
            }
        }
    }

    public void setSuppressedConditions(LinkedHashSet<String> linkedHashSet) {
        this.suppressedConditions = linkedHashSet;
    }

    public String addCondition(String string) {
        return this.addCondition(string, null);
    }

    public String addCondition(String string, Object object) {
        ConditionGenDataSpec conditionGenDataSpec;
        MarketCondition marketCondition = new MarketCondition(string, this);
        this.conditions.add(marketCondition);
        this.resetCache();
        if (object != null) {
            marketCondition.getPlugin().setParam(object);
        }
        if (!this.isConditionSuppressed(string)) {
            marketCondition.getPlugin().apply(marketCondition.getIdForPluginModifications());
        }
        if ((conditionGenDataSpec = marketCondition.getGenSpec()) != null) {
            marketCondition.setSurveyed(!conditionGenDataSpec.isRequiresSurvey());
        }
        return marketCondition.getIdForPluginModifications();
    }

    public void addCondition(MarketConditionAPI marketConditionAPI) {
        this.conditions.add(marketConditionAPI);
        this.resetCache();
    }

    public boolean hasCondition(String string) {
        return this.getConditionsCache().containsKey(string);
    }

    public boolean hasSpecificCondition(String string) {
        for (MarketConditionAPI marketConditionAPI : this.conditions) {
            if (!marketConditionAPI.getIdForPluginModifications().equals(string)) continue;
            return true;
        }
        return false;
    }

    public MarketConditionAPI getFirstCondition(String string) {
        return this.getConditionsCache().get(string);
    }

    public MarketConditionAPI getSpecificCondition(String string) {
        for (MarketConditionAPI marketConditionAPI : this.conditions) {
            if (!marketConditionAPI.getIdForPluginModifications().equals(string)) continue;
            return marketConditionAPI;
        }
        return null;
    }

    public void reapplyConditions() {
        for (MarketConditionAPI marketConditionAPI : new ArrayList<MarketConditionAPI>(this.conditions)) {
            marketConditionAPI.getPlugin().unapply(marketConditionAPI.getIdForPluginModifications());
            if (!marketConditionAPI.isSurveyed() || this.isConditionSuppressed(marketConditionAPI.getId())) continue;
            marketConditionAPI.getPlugin().apply(marketConditionAPI.getIdForPluginModifications());
        }
    }

    public void reapplyCondition(String string) {
        MarketConditionAPI marketConditionAPI = this.getSpecificCondition(string);
        if (marketConditionAPI != null) {
            marketConditionAPI.getPlugin().unapply(marketConditionAPI.getIdForPluginModifications());
            if (!this.isConditionSuppressed(marketConditionAPI.getId())) {
                marketConditionAPI.getPlugin().apply(marketConditionAPI.getIdForPluginModifications());
            }
        }
    }

    public void removeCondition(String string) {
        Iterator<MarketConditionAPI> iterator = this.conditions.iterator();
        while (iterator.hasNext()) {
            MarketConditionAPI marketConditionAPI = iterator.next();
            if (!marketConditionAPI.getId().equals(string)) continue;
            marketConditionAPI.getPlugin().unapply(marketConditionAPI.getIdForPluginModifications());
            iterator.remove();
            this.resetCache();
        }
    }

    public void removeSpecificCondition(String string) {
        Iterator<MarketConditionAPI> iterator = this.conditions.iterator();
        while (iterator.hasNext()) {
            MarketConditionAPI marketConditionAPI = iterator.next();
            if (!marketConditionAPI.getIdForPluginModifications().equals(string)) continue;
            marketConditionAPI.getPlugin().unapply(marketConditionAPI.getIdForPluginModifications());
            iterator.remove();
            this.resetCache();
            return;
        }
    }

    public boolean isIllegal(String string) {
        if (this.isFreePort()) {
            return false;
        }
        return this.getFaction().isIllegal(string);
    }

    public boolean isIllegal(CommodityOnMarketAPI commodityOnMarketAPI) {
        if (this.isFreePort()) {
            return false;
        }
        return this.getFaction().isIllegal(commodityOnMarketAPI.getId());
    }

    public void updatePriceMult() {
        CampaignEngine.getInstance().getEconomy().updatePriceMult(this);
    }

    public float pickShipAndAddToFleet(String string, FactionAPI.ShipPickParams shipPickParams, CampaignFleetAPI campaignFleetAPI) {
        return this.getFaction().pickShipAndAddToFleet(string, shipPickParams, campaignFleetAPI);
    }

    public float pickShipAndAddToFleet(String string, String string2, FactionAPI.ShipPickParams shipPickParams, CampaignFleetAPI campaignFleetAPI) {
        FactionAPI factionAPI = Global.getSector().getFaction(string2);
        return factionAPI.pickShipAndAddToFleet(string, shipPickParams, campaignFleetAPI);
    }

    public List<ShipRolePick> pickShipsForRole(String string, FactionAPI.ShipPickParams shipPickParams, Random random, ShipFilter shipFilter) {
        Faction faction = (Faction)Global.getSector().getFaction(this.factionId);
        return faction.pickShip(string, shipPickParams, shipFilter, random);
    }

    public List<ShipRolePick> pickShipsForRole(String string, String string2, FactionAPI.ShipPickParams shipPickParams, Random random, ShipFilter shipFilter) {
        Faction faction = (Faction)Global.getSector().getFaction(string2);
        return faction.pickShip(string, shipPickParams, shipFilter, random);
    }

    public float getShipQualityFactor() {
        return Misc.getShipQuality((MarketAPI)this);
    }

    public StarSystemAPI getStarSystem() {
        SectorEntityToken sectorEntityToken = this.getPrimaryEntity();
        if (sectorEntityToken != null && sectorEntityToken.getContainingLocation() instanceof StarSystemAPI) {
            return (StarSystemAPI)sectorEntityToken.getContainingLocation();
        }
        return null;
    }

    public LocationAPI getContainingLocation() {
        SectorEntityToken sectorEntityToken = this.getPrimaryEntity();
        if (sectorEntityToken == null) {
            return null;
        }
        return sectorEntityToken.getContainingLocation();
    }

    public Vector2f getLocationInHyperspace() {
        SectorEntityToken sectorEntityToken = this.getPrimaryEntity();
        if (sectorEntityToken == null) {
            return this.getLocation();
        }
        return sectorEntityToken.getLocationInHyperspace();
    }

    public boolean isPlanetConditionMarketOnly() {
        return this.isPlanetConditionMarketOnly;
    }

    public void setPlanetConditionMarketOnly(boolean bl) {
        this.isPlanetConditionMarketOnly = bl;
    }

    public PlanetConditionMarket convertToCondition() {
        PlanetConditionMarket planetConditionMarket = new PlanetConditionMarket(this.id, this.name, this.getSize(), CampaignEngine.getInstance().getEconomy());
        for (MarketConditionAPI marketConditionAPI : this.getConditions()) {
            String string = planetConditionMarket.addCondition(marketConditionAPI.getId());
            MarketConditionAPI marketConditionAPI2 = planetConditionMarket.getSpecificCondition(string);
            marketConditionAPI2.setSurveyed(marketConditionAPI.isSurveyed());
        }
        planetConditionMarket.setMemory(this.getMemoryWithoutUpdate());
        planetConditionMarket.setSurveyLevel(this.getSurveyLevel());
        planetConditionMarket.setPrimaryEntity(this.getPrimaryEntity());
        return planetConditionMarket;
    }

    public boolean isForceNoConvertOnSave() {
        return this.forceNoConvertOnSave;
    }

    public void setForceNoConvertOnSave(boolean bl) {
        this.forceNoConvertOnSave = bl;
    }

    public boolean isHostile(MarketAPI marketAPI) {
        String string;
        Boolean bl;
        if (this.hostileCache == null) {
            this.hostileCache = new HashMap<String, Boolean>();
        }
        if ((bl = this.hostileCache.get(string = marketAPI.getFactionId())) != null) {
            return bl;
        }
        bl = this.getFaction().isHostileToFast(marketAPI.getFactionId());
        this.hostileCache.put(string, bl);
        return bl;
    }

    public void clearHostileCache() {
        if (this.hostileCache != null) {
            this.hostileCache.clear();
        }
    }

    public float getIndustryUpkeep() {
        float f2 = 0.0f;
        for (Industry industry : this.industries) {
            f2 += industry.getUpkeep().getModifiedValue();
        }
        return f2;
    }

    public float getIndustryIncome() {
        float f2 = 0.0f;
        for (Industry industry : this.industries) {
            f2 += industry.getIncome().getModifiedValue();
        }
        return f2;
    }

    public float getExportIncome(boolean bl) {
        bl = false;
        float f2 = 0.0f;
        for (CommodityOnMarketAPI commodityOnMarketAPI : this.getCommodities()) {
            f2 += (float)commodityOnMarketAPI.getExportIncome();
        }
        float f3 = 0.0f;
        return f2 - f3;
    }

    public float getNetIncome() {
        return this.getIndustryIncome() + this.getExportIncome(true) - this.getIndustryUpkeep() - (this.isUseStockpilesForShortages() ? this.getShortageCounteringCost() : 0.0f) - (this.isImmigrationIncentivesOn() ? this.getImmigrationIncentivesCost() : 0.0f);
    }

    public float getGrossIncome() {
        return this.getIndustryIncome() + this.getExportIncome(true);
    }

    public float getImmigrationIncentivesCost() {
        float f2 = -CoreImmigrationPluginImpl.getImmigrationHazardPenalty((MarketAPI)this) + CoreImmigrationPluginImpl.INCENTIVE_POINTS_EXTRA;
        float f3 = CoreImmigrationPluginImpl.INCENTIVE_CREDITS_PER_POINT * f2;
        return f3;
    }

    public float getShortageCounteringCost() {
        SubmarketPlugin submarketPlugin = Misc.getLocalResources((MarketAPI)this);
        if (submarketPlugin instanceof LocalResourcesSubmarketPlugin) {
            LocalResourcesSubmarketPlugin localResourcesSubmarketPlugin = (LocalResourcesSubmarketPlugin)submarketPlugin;
            return localResourcesSubmarketPlugin.getEstimatedShortageCounteringCostPerMonth();
        }
        return 0.0f;
    }

    public boolean hasWaystation() {
        return this.hasWaystation;
    }

    public void setHasWaystation(boolean bl) {
        this.hasWaystation = bl;
    }

    public PopulationComposition getPopulation() {
        if (this.population == null) {
            ImmigrationPlugin immigrationPlugin = Misc.getImmigrationPlugin((MarketAPI)this);
            this.population = new PopulationComposition();
            this.population.add(this.getFactionId(), immigrationPlugin.getWeightForMarketSize((float)this.getSize()));
            this.population.updateWeight();
        }
        return this.population;
    }

    public boolean wasIncomingSetBefore() {
        return this.incoming != null;
    }

    public PopulationComposition getIncoming() {
        if (this.incoming == null) {
            return new PopulationComposition();
        }
        return this.incoming;
    }

    public void setPopulation(PopulationComposition populationComposition) {
        this.population = populationComposition;
    }

    public void setIncoming(PopulationComposition populationComposition) {
        this.incoming = populationComposition;
    }

    public LinkedHashSet<MarketImmigrationModifier> getImmigrationModifiers() {
        return this.immigrationModifiers;
    }

    public LinkedHashSet<MarketImmigrationModifier> getTransientImmigrationModifiers() {
        return this.transientImmigrationModifiers;
    }

    public void addImmigrationModifier(MarketImmigrationModifier marketImmigrationModifier) {
        this.immigrationModifiers.add(marketImmigrationModifier);
    }

    public void removeImmigrationModifier(MarketImmigrationModifier marketImmigrationModifier) {
        this.immigrationModifiers.remove(marketImmigrationModifier);
    }

    public void addTransientImmigrationModifier(MarketImmigrationModifier marketImmigrationModifier) {
        this.transientImmigrationModifiers.add(marketImmigrationModifier);
    }

    public void removeTransientImmigrationModifier(MarketImmigrationModifier marketImmigrationModifier) {
        this.transientImmigrationModifiers.remove(marketImmigrationModifier);
    }

    public List<MarketImmigrationModifier> getAllImmigrationModifiers() {
        ArrayList<MarketImmigrationModifier> arrayList = new ArrayList<MarketImmigrationModifier>();
        arrayList.addAll(this.immigrationModifiers);
        arrayList.addAll(this.transientImmigrationModifiers);
        return arrayList;
    }

    public boolean isAllowImport() {
        return this.allowImport;
    }

    public void setAllowImport(boolean bl) {
        this.allowImport = bl;
    }

    public boolean isAllowExport() {
        return this.allowExport;
    }

    public void setAllowExport(boolean bl) {
        this.allowExport = bl;
    }

    public float getIncentiveCredits() {
        return this.incentiveCredits;
    }

    public void setIncentiveCredits(float f2) {
        this.incentiveCredits = f2;
    }

    public boolean isFreePort() {
        return this.isFreePort;
    }

    public void setFreePort(boolean bl) {
        if (this.isFreePort() == bl) {
            return;
        }
        this.isFreePort = bl;
        if (bl) {
            if (!this.hasCondition("free_market")) {
                this.addCondition("free_market", true);
            }
        } else {
            this.removeCondition("free_market");
        }
    }

    public boolean isImmigrationClosed() {
        return this.hasCondition("closed_immigration");
    }

    public void setImmigrationClosed(boolean bl) {
        if (this.isImmigrationClosed() == bl) {
            return;
        }
        if (bl) {
            this.addCondition("closed_immigration", true);
        } else {
            this.removeCondition("closed_immigration");
        }
    }

    public boolean hasTag(String string) {
        if (this.tags == null) {
            return false;
        }
        return this.tags.contains(string);
    }

    public void addTag(String string) {
        if (this.tags == null) {
            this.tags = new HashSet();
        }
        this.tags.add(string);
    }

    public void removeTag(String string) {
        if (this.tags == null) {
            return;
        }
        this.tags.remove(string);
        if (this.tags.isEmpty()) {
            this.tags = null;
        }
    }

    public Collection<String> getTags() {
        if (this.tags == null) {
            return new ArrayList<String>();
        }
        return this.tags;
    }

    public void clearTags() {
        if (this.tags != null) {
            this.tags.clear();
        }
    }

    public String getOnOrAt() {
        if (this.getPrimaryEntity() != null && this.getPrimaryEntity().hasTag("station")) {
            return "at";
        }
        return "on";
    }

    public Color getTextColorForFactionOrPlanet() {
        PlanetAPI planetAPI;
        if (this.isPlanetConditionMarketOnly() && (planetAPI = this.getPlanetEntity()) != null) {
            return OoOO.\u00d200000((Color)planetAPI.getSpec().getIconColor(), (int)255);
        }
        return this.getFaction().getBaseUIColor();
    }

    public Color getDarkColorForFactionOrPlanet() {
        PlanetAPI planetAPI;
        if (this.isPlanetConditionMarketOnly() && (planetAPI = this.getPlanetEntity()) != null) {
            return OoOO.\u00d200000((Color)OoOO.\u00d500000((Color)planetAPI.getSpec().getIconColor(), (float)0.4f), (int)175);
        }
        return this.getFaction().getDarkUIColor();
    }

    public boolean isHidden() {
        return this.hidden != null && this.hidden != false;
    }

    public void setHidden(Boolean bl) {
        if (bl != null && !bl.booleanValue()) {
            bl = null;
        }
        this.hidden = bl;
    }

    public boolean isInvalidMissionTarget() {
        return this.invalidMissionTarget != null && this.invalidMissionTarget != false;
    }

    public void setInvalidMissionTarget(Boolean bl) {
        if (bl != null && !bl.booleanValue()) {
            bl = null;
        }
        this.invalidMissionTarget = bl;
    }

    public boolean isImmigrationIncentivesOn() {
        return this.incentives != null && this.incentives != false;
    }

    public void setImmigrationIncentivesOn(Boolean bl) {
        if (bl != null && !bl.booleanValue()) {
            bl = null;
        }
        this.incentives = bl;
    }
}

