/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.econ;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CampaignPlugin;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketConditionAPI;
import com.fs.starfarer.api.campaign.econ.MarketDemandAPI;
import com.fs.starfarer.api.campaign.econ.MarketImmigrationModifier;
import com.fs.starfarer.api.campaign.econ.SubmarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.combat.MutableStatWithTempMods;
import com.fs.starfarer.api.combat.StatBonus;
import com.fs.starfarer.api.fleet.ShipFilter;
import com.fs.starfarer.api.fleet.ShipRolePick;
import com.fs.starfarer.api.impl.campaign.econ.impl.ConstructionQueue;
import com.fs.starfarer.api.impl.campaign.population.PopulationComposition;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.CommDirectory;
import com.fs.starfarer.campaign.Faction;
import com.fs.starfarer.campaign.ValueHistory;
import com.fs.starfarer.campaign.econ.CommodityOnMarket;
import com.fs.starfarer.campaign.econ.Economy;
import com.fs.starfarer.campaign.econ.Market;
import com.fs.starfarer.campaign.econ.MarketCondition;
import com.fs.starfarer.campaign.econ.MarketDemand;
import com.fs.starfarer.campaign.econ.MarketDemandData;
import com.fs.starfarer.campaign.econ.Submarket;
import com.fs.starfarer.campaign.fleet.MutableMarketStats;
import com.fs.starfarer.campaign.rules.Memory;
import com.fs.starfarer.loading.F;
import com.fs.starfarer.rpg.Person;
import com.fs.util.DoNotObfuscate;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanetConditionMarket
implements DoNotObfuscate,
MarketAPI,
Cloneable {
    private String id;
    private String name;
    private SectorEntityToken primaryEntity = null;
    private MemoryAPI memory;
    private MarketAPI.SurveyLevel surveyLevel = MarketAPI.SurveyLevel.NONE;
    private transient MutableStat hazard = new MutableStat(0.0f);
    private transient MutableMarketStats stats = new MutableMarketStats();
    private transient List<MarketConditionAPI> conditions = new ArrayList<MarketConditionAPI>();
    private Set<String> cond = new HashSet<String>();
    private Set<String> surveyed = new HashSet<String>();

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.id == null ? 0 : this.id.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PlanetConditionMarket planetConditionMarket = (PlanetConditionMarket)object;
        return !(this.id == null ? planetConditionMarket.id != null : !this.id.equals(planetConditionMarket.id));
    }

    public PlanetConditionMarket(String string, String string2, int n, Economy economy) {
        this.id = string;
        this.name = string2;
    }

    public CommDirectory getCommDirectory() {
        return new CommDirectory();
    }

    public Set<Person> getPeople() {
        return new HashSet<Person>();
    }

    public MemoryAPI getMemory() {
        if (this.memory == null) {
            this.memory = new Memory();
        }
        for (CampaignPlugin campaignPlugin : CampaignEngine.getInstance().getModAndPluginData().getPlugins()) {
            campaignPlugin.updateMarketFacts((MarketAPI)this, this.memory);
        }
        return this.memory;
    }

    public MemoryAPI getMemoryWithoutUpdate() {
        if (this.memory == null) {
            this.memory = new Memory();
        }
        return this.memory;
    }

    public void advance(float f2) {
        if (this.memory != null) {
            ((Memory)this.memory).advance(f2);
        }
    }

    public ValueHistory getStabilityHistory() {
        return new ValueHistory();
    }

    public SectorEntityToken getPrimaryEntity() {
        return this.primaryEntity;
    }

    public PlanetAPI getPlanetEntity() {
        for (SectorEntityToken sectorEntityToken : this.getConnectedEntities()) {
            if (!(sectorEntityToken instanceof PlanetAPI)) continue;
            return (PlanetAPI)sectorEntityToken;
        }
        return null;
    }

    public void setPrimaryEntity(SectorEntityToken sectorEntityToken) {
        this.primaryEntity = sectorEntityToken;
    }

    public Set<SectorEntityToken> getConnectedEntities() {
        LinkedHashSet<SectorEntityToken> linkedHashSet = new LinkedHashSet<SectorEntityToken>();
        linkedHashSet.add(this.primaryEntity);
        return linkedHashSet;
    }

    public void addSubmarket(String string) {
    }

    public Submarket getSubmarket(String string) {
        return null;
    }

    public boolean hasSubmarket(String string) {
        return false;
    }

    public List<Submarket> getSubmarkets() {
        return new ArrayList<Submarket>();
    }

    public List<SubmarketAPI> getSubmarketsCopy() {
        return new ArrayList<SubmarketAPI>();
    }

    public void removeSubmarket(String string) {
    }

    public MutableStat getHazard() {
        if (this.hazard == null) {
            this.hazard = new MutableStat(0.0f);
        }
        return this.hazard;
    }

    public float getHazardValue() {
        return this.getHazard().getModifiedValue();
    }

    public MutableStatWithTempMods getStability() {
        return new MutableStatWithTempMods(1.0f);
    }

    public float getStabilityValue() {
        float f2 = this.getStability().getModifiedValue();
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 10.0f) {
            f2 = 10.0f;
        }
        f2 = Math.round(f2);
        return f2;
    }

    public float getTradeVolume() {
        return 0.0f;
    }

    public float getDemandMetFraction() {
        return 1.0f;
    }

    public String getFactionId() {
        return "neutral";
    }

    public Faction getFaction() {
        return CampaignEngine.getInstance().getFaction(this.getFactionId());
    }

    public void setFactionId(String string) {
    }

    public void setParent(String string) {
    }

    public Set<String> getChildren() {
        return new HashSet<String>();
    }

    public String getParent() {
        return null;
    }

    public boolean isChildOf(MarketAPI marketAPI) {
        return false;
    }

    public boolean isParentOf(MarketAPI marketAPI) {
        return false;
    }

    public MutableMarketStats getStats() {
        return this.stats;
    }

    Object readResolve() {
        if (this.surveyLevel == null) {
            this.surveyLevel = MarketAPI.SurveyLevel.NONE;
        }
        if (this.stats == null) {
            this.stats = new MutableMarketStats();
        }
        if (this.hazard == null) {
            this.hazard = new MutableStat(0.0f);
        }
        if (this.conditions == null) {
            this.conditions = new ArrayList<MarketConditionAPI>();
        }
        if (this.cond == null) {
            this.cond = new HashSet<String>();
        }
        if (this.surveyed == null) {
            this.surveyed = new HashSet<String>();
        }
        for (String string : this.cond) {
            this.addCondition(string);
        }
        for (MarketConditionAPI marketConditionAPI : this.conditions) {
            if (!this.surveyed.contains(marketConditionAPI.getId())) continue;
            marketConditionAPI.setSurveyed(true);
        }
        return this;
    }

    Object writeReplace() {
        PlanetConditionMarket planetConditionMarket = this.clone();
        if (planetConditionMarket.memory != null && planetConditionMarket.memory.isEmpty()) {
            planetConditionMarket.memory = null;
        }
        if (planetConditionMarket.surveyLevel == MarketAPI.SurveyLevel.NONE) {
            planetConditionMarket.surveyLevel = null;
        }
        if (this.conditions != null) {
            for (MarketConditionAPI marketConditionAPI : this.conditions) {
                if (!marketConditionAPI.isSurveyed()) continue;
                this.surveyed.add(marketConditionAPI.getId());
            }
        }
        return planetConditionMarket;
    }

    public PlanetConditionMarket clone() {
        try {
            return (PlanetConditionMarket)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public MutableStat getTariff() {
        return new MutableStat(0.3f);
    }

    public StatBonus getDemandPriceMod() {
        return new StatBonus();
    }

    public StatBonus getSupplyPriceMod() {
        return new StatBonus();
    }

    public Economy getEconomy() {
        return (Economy)Global.getSector().getEconomy();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public List<CommodityOnMarket> getCommodities() {
        return new ArrayList<CommodityOnMarket>();
    }

    public void updatePrices() {
    }

    public float getAverageSoldLastT() {
        float f2 = 0.0f;
        return f2;
    }

    public float getAverageSmuggledLastT() {
        float f2 = 0.0f;
        return f2;
    }

    public void resetSmugglingValue() {
    }

    public float getAverageBoughtLastT() {
        float f2 = 0.0f;
        return f2;
    }

    public List<CommodityOnMarket> getCommoditiesWithClass(String string) {
        return new ArrayList<CommodityOnMarket>();
    }

    public CommodityOnMarket getCommodityData(F f2) {
        return null;
    }

    public CommodityOnMarket getCommodityData(String string) {
        return null;
    }

    public float getDemandPrice(String string, double d2, boolean bl) {
        return 1.0f;
    }

    public float getDemandPriceAssumingExistingTransaction(String string, double d2, double d3, boolean bl) {
        return 1.0f;
    }

    public float getDemandPriceAssumingStockpileUtility(CommodityOnMarket commodityOnMarket, double d2, double d3, boolean bl) {
        return 1.0f;
    }

    public float getSupplyPrice(String string, double d2, boolean bl) {
        return 1.0f;
    }

    public float getSupplyPriceAssumingExistingTransaction(String string, double d2, double d3, boolean bl) {
        return 1.0f;
    }

    public float getSupplyPriceAssumingStockpileUtility(CommodityOnMarket commodityOnMarket, double d2, double d3, boolean bl) {
        return 1.0f;
    }

    public MarketDemandData getDemandData() {
        return null;
    }

    public String toString() {
        return String.valueOf(this.name) + "(condition market only)";
    }

    public Vector2f getLocation() {
        return new Vector2f();
    }

    public Vector2f getSimDisplayLocation() {
        return new Vector2f();
    }

    public int getSize() {
        return 1;
    }

    public void setSize(int n) {
    }

    public List<CommodityOnMarketAPI> getCommoditiesWithTags(String ... stringArray) {
        return new ArrayList<CommodityOnMarketAPI>();
    }

    public List<CommodityOnMarketAPI> getCommoditiesWithTag(String string) {
        return new ArrayList<CommodityOnMarketAPI>();
    }

    public List<CommodityOnMarketAPI> getAllCommodities() {
        return new ArrayList<CommodityOnMarketAPI>();
    }

    public MarketDemand getDemand(String string) {
        return null;
    }

    public List<MarketDemandAPI> getDemandWithTag(String string) {
        return new ArrayList<MarketDemandAPI>();
    }

    public MarketAPI.SurveyLevel getSurveyLevel() {
        return this.surveyLevel;
    }

    public void setSurveyLevel(MarketAPI.SurveyLevel surveyLevel) {
        this.surveyLevel = surveyLevel;
    }

    public List<MarketConditionAPI> getConditions() {
        return this.conditions;
    }

    public String addCondition(String string) {
        return this.addCondition(string, null);
    }

    public String addCondition(String string, Object object) {
        this.cond.add(string);
        MarketCondition marketCondition = new MarketCondition(string, this);
        this.conditions.add(marketCondition);
        if (object != null) {
            marketCondition.getPlugin().setParam(object);
        }
        marketCondition.getPlugin().apply(marketCondition.getIdForPluginModifications());
        return marketCondition.getIdForPluginModifications();
    }

    public boolean hasCondition(String string) {
        for (MarketConditionAPI marketConditionAPI : this.conditions) {
            if (!marketConditionAPI.getId().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSpecificCondition(String string) {
        for (MarketConditionAPI marketConditionAPI : this.conditions) {
            if (!marketConditionAPI.getIdForPluginModifications().equals(string)) continue;
            return true;
        }
        return false;
    }

    public MarketConditionAPI getSpecificCondition(String string) {
        for (MarketConditionAPI marketConditionAPI : this.conditions) {
            if (!marketConditionAPI.getIdForPluginModifications().equals(string)) continue;
            return marketConditionAPI;
        }
        return null;
    }

    public void reapplyConditions() {
        for (MarketConditionAPI marketConditionAPI : this.conditions) {
            marketConditionAPI.getPlugin().unapply(marketConditionAPI.getIdForPluginModifications());
            if (!marketConditionAPI.isSurveyed()) continue;
            marketConditionAPI.getPlugin().apply(marketConditionAPI.getIdForPluginModifications());
        }
    }

    public void reapplyCondition(String string) {
        MarketConditionAPI marketConditionAPI = this.getSpecificCondition(string);
        if (marketConditionAPI != null) {
            marketConditionAPI.getPlugin().unapply(marketConditionAPI.getIdForPluginModifications());
            marketConditionAPI.getPlugin().apply(marketConditionAPI.getIdForPluginModifications());
        }
    }

    public void removeCondition(String string) {
        Iterator<MarketConditionAPI> iterator = this.conditions.iterator();
        while (iterator.hasNext()) {
            MarketConditionAPI marketConditionAPI = iterator.next();
            if (!marketConditionAPI.getId().equals(string)) continue;
            marketConditionAPI.getPlugin().unapply(marketConditionAPI.getIdForPluginModifications());
            iterator.remove();
        }
    }

    public void removeSpecificCondition(String string) {
        Iterator<MarketConditionAPI> iterator = this.conditions.iterator();
        while (iterator.hasNext()) {
            MarketConditionAPI marketConditionAPI = iterator.next();
            if (!marketConditionAPI.getIdForPluginModifications().equals(string)) continue;
            marketConditionAPI.getPlugin().unapply(marketConditionAPI.getIdForPluginModifications());
            iterator.remove();
            return;
        }
    }

    public boolean isIllegal(String string) {
        return this.getFaction().getSpec().getIllegalCommodities().contains(string);
    }

    public boolean isIllegal(CommodityOnMarketAPI commodityOnMarketAPI) {
        return this.getFaction().getSpec().getIllegalCommodities().contains(commodityOnMarketAPI.getId());
    }

    public void updatePriceMult() {
    }

    public float getShipQualityFactor() {
        return this.getStabilityValue() / 10.0f;
    }

    public StarSystemAPI getStarSystem() {
        SectorEntityToken sectorEntityToken = this.getPrimaryEntity();
        if (sectorEntityToken.getContainingLocation() instanceof StarSystemAPI) {
            return (StarSystemAPI)sectorEntityToken.getContainingLocation();
        }
        return null;
    }

    public LocationAPI getContainingLocation() {
        SectorEntityToken sectorEntityToken = this.getPrimaryEntity();
        if (sectorEntityToken == null) {
            return null;
        }
        return sectorEntityToken.getContainingLocation();
    }

    public Vector2f getLocationInHyperspace() {
        SectorEntityToken sectorEntityToken = this.getPrimaryEntity();
        if (sectorEntityToken == null) {
            return this.getLocation();
        }
        return sectorEntityToken.getLocationInHyperspace();
    }

    public boolean isPlanetConditionMarketOnly() {
        return true;
    }

    public void setPlanetConditionMarketOnly(boolean bl) {
    }

    public void addPerson(PersonAPI personAPI) {
    }

    public int getBaseSmugglingStabilityValue() {
        return 0;
    }

    public List<PersonAPI> getPeopleCopy() {
        return new ArrayList<PersonAPI>();
    }

    public void removePerson(PersonAPI personAPI) {
    }

    public void setBaseSmugglingStabilityValue(int n) {
    }

    public void setMemory(MemoryAPI memoryAPI) {
        this.memory = memoryAPI;
    }

    public Market convertToRegular() {
        Market market = new Market(this.id, this.name, this.getSize(), CampaignEngine.getInstance().getEconomy());
        for (String string : this.cond) {
            String string2 = market.addCondition(string);
            MarketConditionAPI marketConditionAPI = market.getSpecificCondition(string2);
            marketConditionAPI.setSurveyed(this.surveyed.contains(string));
        }
        market.setMemory(this.getMemoryWithoutUpdate());
        market.setSurveyLevel(this.getSurveyLevel());
        market.setPrimaryEntity(this.getPrimaryEntity());
        market.setFactionId(this.getFactionId());
        market.setPlanetConditionMarketOnly(true);
        return market;
    }

    public boolean isForceNoConvertOnSave() {
        return false;
    }

    public void setForceNoConvertOnSave(boolean bl) {
    }

    public MarketConditionAPI getFirstCondition(String string) {
        for (MarketConditionAPI marketConditionAPI : this.conditions) {
            if (!marketConditionAPI.getId().equals(string)) continue;
            return marketConditionAPI;
        }
        return null;
    }

    public boolean isInEconomy() {
        return false;
    }

    public MutableStat getReach() {
        return new MutableStat(0.0f);
    }

    public void addIndustry(String string) {
    }

    public List<Industry> getIndustries() {
        return new ArrayList<Industry>();
    }

    public void removeIndustry(String string, MarketAPI.MarketInteractionMode marketInteractionMode, boolean bl) {
    }

    public MutableStat getShipping() {
        return new MutableStat(0.0f);
    }

    public void reapplyIndustries() {
    }

    public MutableStat getLocalShipping() {
        return new MutableStat(0.0f);
    }

    public int getMaxDeficit(String ... stringArray) {
        return 0;
    }

    public Industry getIndustry(String string) {
        return null;
    }

    public MutableStat getReachExtension() {
        return new MutableStat(0.0f);
    }

    public boolean hasIndustry(String string) {
        return false;
    }

    public List<CommodityOnMarketAPI> getCommoditiesCopy() {
        return new ArrayList<CommodityOnMarketAPI>();
    }

    public MarketConditionAPI getCondition(String string) {
        return null;
    }

    public float getIndustryIncome() {
        return 0.0f;
    }

    public float getIndustryUpkeep() {
        return 0.0f;
    }

    public boolean hasWaystation() {
        return false;
    }

    public boolean isWaystation() {
        return false;
    }

    public Industry instantiateIndustry(String string) {
        return null;
    }

    public void clearCommodities() {
    }

    public boolean isPlayerOwned() {
        return false;
    }

    public void setPlayerOwned(boolean bl) {
    }

    public float getPrevStability() {
        return 0.0f;
    }

    public float getExportIncome(boolean bl) {
        return 0.0f;
    }

    public float getNetIncome() {
        return 0.0f;
    }

    public MutableStat getIncomeMult() {
        return new MutableStat(1.0f);
    }

    public MutableStat getUpkeepMult() {
        return new MutableStat(1.0f);
    }

    public PopulationComposition getIncoming() {
        return new PopulationComposition();
    }

    public PopulationComposition getPopulation() {
        return new PopulationComposition();
    }

    public void setIncoming(PopulationComposition populationComposition) {
    }

    public void setPopulation(PopulationComposition populationComposition) {
    }

    public void addImmigrationModifier(MarketImmigrationModifier marketImmigrationModifier) {
    }

    public void addTransientImmigrationModifier(MarketImmigrationModifier marketImmigrationModifier) {
    }

    public LinkedHashSet<MarketImmigrationModifier> getImmigrationModifiers() {
        return null;
    }

    public StatBonus getIncomingImmigrationMod() {
        return null;
    }

    public StatBonus getOutgoingImmigrationMod() {
        return null;
    }

    public LinkedHashSet<MarketImmigrationModifier> getTransientImmigrationModifiers() {
        return null;
    }

    public void removeImmigrationModifier(MarketImmigrationModifier marketImmigrationModifier) {
    }

    public void removeTransientImmigrationModifier(MarketImmigrationModifier marketImmigrationModifier) {
    }

    public List<MarketImmigrationModifier> getAllImmigrationModifiers() {
        return null;
    }

    public float getIncentiveCredits() {
        return 0.0f;
    }

    public boolean isAllowExport() {
        return false;
    }

    public boolean isAllowImport() {
        return false;
    }

    public boolean isFreePort() {
        return false;
    }

    public boolean isImmigrationClosed() {
        return false;
    }

    public void setAllowExport(boolean bl) {
    }

    public void setAllowImport(boolean bl) {
    }

    public void setFreePort(boolean bl) {
    }

    public void setImmigrationClosed(boolean bl) {
    }

    public void setIncentiveCredits(float f2) {
    }

    public boolean wasIncomingSetBefore() {
        return false;
    }

    public void addCondition(MarketConditionAPI marketConditionAPI) {
    }

    public PersonAPI getAdmin() {
        return null;
    }

    public void setAdmin(PersonAPI personAPI) {
    }

    public float getDaysInExistence() {
        return 0.0f;
    }

    public void setDaysInExistence(float f2) {
    }

    public StatBonus getAccessibilityMod() {
        return new StatBonus();
    }

    public float getAccessibility() {
        return 0.0f;
    }

    public float getAccessibility(MarketAPI marketAPI, boolean bl, boolean bl2) {
        return 0.0f;
    }

    public void setAccessibility(float f2) {
    }

    public float getAccessibility(MarketAPI marketAPI, boolean bl, boolean bl2, boolean bl3) {
        return 0.0f;
    }

    public MutableStat getWSImpactMult() {
        return new MutableStat(1.0f);
    }

    public boolean hasSpaceport() {
        return false;
    }

    public void setHasSpaceport(boolean bl) {
    }

    public void setHasWaystation(boolean bl) {
    }

    public String getEconGroup() {
        return null;
    }

    public void setEconGroup(String string) {
    }

    public float pickShipAndAddToFleet(String string, FactionAPI.ShipPickParams shipPickParams, CampaignFleetAPI campaignFleetAPI) {
        return 1.0f;
    }

    public float pickShipAndAddToFleet(String string, String string2, FactionAPI.ShipPickParams shipPickParams, CampaignFleetAPI campaignFleetAPI) {
        return 1.0f;
    }

    public List<ShipRolePick> pickShipsForRole(String string, FactionAPI.ShipPickParams shipPickParams, Random random, ShipFilter shipFilter) {
        return new ArrayList<ShipRolePick>();
    }

    public List<ShipRolePick> pickShipsForRole(String string, String string2, FactionAPI.ShipPickParams shipPickParams, Random random, ShipFilter shipFilter) {
        return new ArrayList<ShipRolePick>();
    }

    public void addIndustry(String string, List<String> list) {
    }

    public MutableStat getStockpileMult() {
        return new MutableStat(0.0f);
    }

    public void addTag(String string) {
    }

    public void clearTags() {
    }

    public Collection<String> getTags() {
        return null;
    }

    public boolean hasTag(String string) {
        return false;
    }

    public void removeTag(String string) {
    }

    public String getOnOrAt() {
        return null;
    }

    public Color getDarkColorForFactionOrPlanet() {
        return null;
    }

    public Color getTextColorForFactionOrPlanet() {
        return null;
    }

    public boolean isHidden() {
        return false;
    }

    public void setHidden(Boolean bl) {
    }

    public boolean isUseStockpilesForShortages() {
        return false;
    }

    public void setUseStockpilesForShortages(boolean bl) {
    }

    public float getShortageCounteringCost() {
        return 0.0f;
    }

    public void addSubmarket(SubmarketAPI submarketAPI) {
    }

    public ConstructionQueue getConstructionQueue() {
        return new ConstructionQueue();
    }

    public boolean isInHyperspace() {
        return false;
    }

    public LinkedHashSet<String> getSuppressedConditions() {
        return null;
    }

    public boolean isConditionSuppressed(String string) {
        return false;
    }

    public void suppressCondition(String string) {
    }

    public void unsuppressCondition(String string) {
    }

    public boolean isImmigrationIncentivesOn() {
        return false;
    }

    public void setImmigrationIncentivesOn(Boolean bl) {
    }

    public float getImmigrationIncentivesCost() {
        return 0.0f;
    }

    public boolean isInvalidMissionTarget() {
        return false;
    }

    public void setInvalidMissionTarget(Boolean bl) {
    }

    public void setSuppressedConditions(LinkedHashSet<String> linkedHashSet) {
    }

    public void setRetainSuppressedConditionsSetWhenEmpty(Boolean bl) {
    }

    public float getGrossIncome() {
        return 0.0f;
    }

    public boolean hasFunctionalIndustry(String string) {
        return false;
    }
}

