/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.econ;

import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SubmarketPlugin;
import com.fs.starfarer.api.campaign.econ.SubmarketAPI;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.Faction;
import com.fs.starfarer.campaign.econ.Market;
import com.fs.starfarer.campaign.fleet.CargoData;
import com.fs.starfarer.loading.L;
import com.fs.starfarer.loading.SpecStore;
import com.fs.util.DoNotObfuscate;

public class Submarket
implements SubmarketAPI,
DoNotObfuscate {
    private transient L spec = null;
    private Market market;
    private String specId;
    private SubmarketPlugin plugin;
    private Faction faction;

    public Submarket(Market market, String string) {
        this.market = market;
        this.specId = string;
        this.readResolve();
        this.plugin = this.spec.getNewPluginInstance();
        this.plugin.init((SubmarketAPI)this);
    }

    private void initFaction() {
        if (this.faction != null) {
            return;
        }
        this.faction = this.spec.getFactionId() != null && !this.spec.getFactionId().isEmpty() ? CampaignEngine.getInstance().getFaction(this.spec.getFactionId()) : this.market.getFaction();
        if (this.faction == null) {
            throw new RuntimeException("Faction with id [" + this.spec.getFactionId() + "] not found while instantiating submarket with id [" + this.spec.getId() + "]");
        }
    }

    public String getName() {
        String string = this.plugin.getName();
        if (string != null) {
            return string;
        }
        return this.spec.getName();
    }

    public String getNameOneLine() {
        String string = this.plugin.getName();
        if (string != null) {
            return string.replaceAll("\\n", " ");
        }
        return this.spec.getName().replaceAll("\\n", " ");
    }

    public String getIcon() {
        if (this.spec.getIcon() != null && !this.spec.getIcon().isEmpty()) {
            return this.spec.getIcon();
        }
        return this.faction.getLogo();
    }

    public Faction getFaction() {
        return this.faction;
    }

    public void setFaction(FactionAPI factionAPI) {
        this.faction = (Faction)factionAPI;
    }

    protected Object readResolve() {
        this.spec = SpecStore.o00000(L.class, this.specId);
        this.initFaction();
        return this;
    }

    public SubmarketPlugin getPlugin() {
        return this.plugin;
    }

    public L getSpec() {
        return this.spec;
    }

    public Market getMarket() {
        return this.market;
    }

    public String getSpecId() {
        return this.specId;
    }

    public CargoData getCargo() {
        return (CargoData)this.plugin.getCargo();
    }

    public CargoData getCargoNullOk() {
        return (CargoData)this.plugin.getCargoNullOk();
    }

    public boolean isIllegalOnSubmarket(String string, SubmarketPlugin.TransferAction transferAction) {
        return this.plugin.isIllegalOnSubmarket(string, transferAction);
    }

    public boolean isIllegalOnSubmarket(CargoStackAPI cargoStackAPI, SubmarketPlugin.TransferAction transferAction) {
        return this.plugin.isIllegalOnSubmarket(cargoStackAPI, transferAction);
    }

    public float getTariff() {
        return this.plugin.getTariff();
    }
}

