/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.econ.reach;

import com.fs.profiler.Profiler;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.econ.CommodityMarketDataAPI;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySourceType;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketShareDataAPI;
import com.fs.starfarer.api.combat.MutableStatWithTempMods;
import com.fs.starfarer.api.impl.campaign.econ.impl.BaseIndustry;
import com.fs.starfarer.api.impl.campaign.ids.Stats;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.campaign.econ.CommodityOnMarket;
import com.fs.starfarer.campaign.econ.Market;
import com.fs.starfarer.campaign.econ.reach.MarketShareData;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommodityMarketData
implements CommodityMarketDataAPI,
DoNotObfuscate {
    public static float COM_FACTOR = Global.getSettings().getFloat("accessibilityDistFromCOM");
    public static float BASE_ACCESSIBILITY = Global.getSettings().getFloat("accessibilityBaseValue");
    public static float SAME_FACTION_BONUS = Global.getSettings().getFloat("accessibilitySameFactionBonus");
    public static float PER_UNIT_SHIPPING = Global.getSettings().getFloat("accessibilityPerUnitShipping");
    public static String KEY_LOCAL = "core_local";
    public static String KEY_IMPORTS = "core_base";
    public static String KEY_SHORTAGE = "core_shortage";
    public static String KEY_LOWACCESS = "core_lowaccess";
    private String commodityId;
    private String econGroup;
    private int maxExportGlobal = 0;
    private LinkedHashMap<String, Integer> maxExportPerFaction = new LinkedHashMap();
    private LinkedHashMap<String, Float> marketValuePerFaction = new LinkedHashMap();
    private LinkedHashMap<MarketAPI, MarketShareData> marketShareData = new LinkedHashMap();
    private List<MarketShareDataAPI> sortedProducers = new ArrayList<MarketShareDataAPI>();
    private List<MarketShareDataAPI> sortedConsumers = new ArrayList<MarketShareDataAPI>();
    private float marketValue = 0.0f;

    public static Vector2f computeCenterOfMass(MarketAPI marketAPI, String string) {
        Vector2f vector2f = new Vector2f();
        float f2 = 0.0f;
        List list = Global.getSector().getEconomy().getMarketsInGroup(string);
        if (marketAPI != null && !list.contains(marketAPI)) {
            list.add(marketAPI);
        }
        for (MarketAPI marketAPI2 : list) {
            float f3 = Math.max(1.0f, (float)marketAPI2.getSize() - 1.0f);
            vector2f.x += marketAPI2.getLocationInHyperspace().x * f3;
            vector2f.y += marketAPI2.getLocationInHyperspace().y * f3;
            f2 += f3;
        }
        if (f2 > 0.0f) {
            vector2f.scale(1.0f / f2);
        }
        return vector2f;
    }

    public static float computeBaseAccessibility(MarketAPI marketAPI) {
        Vector2f vector2f = CommodityMarketData.computeCenterOfMass(marketAPI, marketAPI.getEconGroup());
        return CommodityMarketData.computeBaseAccessibility(marketAPI, vector2f);
    }

    public static float computeBaseAccessibility(MarketAPI marketAPI, Vector2f vector2f) {
        float f2 = Misc.getDistanceLY((Vector2f)vector2f, (Vector2f)marketAPI.getLocationInHyperspace());
        return (float)Math.round((BASE_ACCESSIBILITY - f2 / COM_FACTOR) * 100.0f) / 100.0f;
    }

    public static int getShippingCapacity(MarketAPI marketAPI, boolean bl) {
        float f2 = (float)Math.round(marketAPI.getAccessibilityMod().computeEffective(0.0f) * 100.0f) / 100.0f;
        if (bl) {
            f2 += SAME_FACTION_BONUS;
        }
        return (int)Math.max(0.0f, f2 / PER_UNIT_SHIPPING);
    }

    public int getMaxShipping(MarketAPI marketAPI, boolean bl) {
        return CommodityMarketData.getShippingCapacity(marketAPI, bl);
    }

    public static String getDescForAccessibility(float f2) {
        String string = "Proximity to other colonies";
        if (f2 < 0.0f) {
            string = "Isolation from other colonies";
        }
        return string;
    }

    public static String getFactionHostilityDesc() {
        return "Hostilities with other factions";
    }

    public static float getHostilityPenalty(MarketAPI marketAPI) {
        float f2 = Global.getSettings().getFloat("accessibilityLossWhenAllHostile");
        List list = Global.getSector().getEconomy().getMarketsInGroup(marketAPI.getEconGroup());
        if (!list.contains(marketAPI)) {
            list.add(marketAPI);
        }
        o o2 = new o(list);
        float f3 = o2.\u00d200000;
        Map<FactionAPI, Integer> map = o2.Object;
        Integer n = map.get(marketAPI.getFaction());
        if (n == null) {
            n = 0;
        }
        float f4 = (float)Math.round(f2 * (float)n.intValue() / f3 * 100.0f) / 100.0f;
        return f4;
    }

    public CommodityMarketData(String string, String string2) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Object object;
        CommodityOnMarketAPI commodityOnMarketAPI;
        String string3;
        this.commodityId = string;
        this.econGroup = string2;
        Vector2f vector2f = CommodityMarketData.computeCenterOfMass(null, string2);
        HashMap<String, Float> hashMap = new HashMap<String, Float>();
        HashMap<String, Float> hashMap2 = new HashMap<String, Float>();
        float f2 = 0.0f;
        List list = Global.getSector().getEconomy().getMarketsInGroup(string2);
        o o2 = new o(list);
        float f3 = o2.\u00d200000;
        Map<FactionAPI, Integer> map = o2.Object;
        float f4 = Global.getSettings().getFloat("accessibilityLossWhenAllHostile");
        for (MarketAPI marketAPI : list) {
            float f5;
            string3 = marketAPI.getFactionId();
            commodityOnMarketAPI = marketAPI.getCommodityData(string);
            object = ((Market)marketAPI).getCommoditiesWithClass(commodityOnMarketAPI.getDemandClass());
            commodityOnMarketAPI.updateMaxSupplyAndDemand();
            if (commodityOnMarketAPI.getCommodity().isPrimary()) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    CommodityOnMarketAPI commodityOnMarketAPI2 = (CommodityOnMarketAPI)iterator.next();
                    if (commodityOnMarketAPI2 == commodityOnMarketAPI) continue;
                    commodityOnMarketAPI2.setMaxDemand(commodityOnMarketAPI.getMaxDemand());
                    commodityOnMarketAPI2.setDemandLegal(commodityOnMarketAPI.isDemandLegal());
                }
            }
            ((CommodityOnMarket)commodityOnMarketAPI).setCommodityMarketData(this);
            n6 = commodityOnMarketAPI.getMaxSupply();
            n6 = Math.min(n6, commodityOnMarketAPI.getAvailable());
            n5 = CommodityMarketData.getShippingCapacity(marketAPI, false);
            n4 = CommodityMarketData.getShippingCapacity(marketAPI, true);
            n3 = Math.min(n6, n5);
            if (n3 > this.maxExportGlobal) {
                this.maxExportGlobal = n3;
            }
            n2 = this.getMaxExport(string3);
            n = Math.min(n6, n4);
            if (n > n2) {
                this.maxExportPerFaction.put(string3, n);
            }
            float f6 = CommodityMarketData.computeBaseAccessibility(marketAPI, vector2f);
            String string4 = CommodityMarketData.getDescForAccessibility(f6);
            marketAPI.getAccessibilityMod().modifyFlatAlways("core_base", f6, string4);
            if (f3 > 0.0f) {
                Profiler.\u00d200000((String)"Computing hostile accessibility mods");
                Integer n7 = map.get(marketAPI.getFaction());
                if (n7 == null) {
                    n7 = 0;
                }
                if ((f5 = (float)Math.round(f4 * (float)n7.intValue() / f3 * 100.0f) / 100.0f) > 0.0f) {
                    marketAPI.getAccessibilityMod().modifyFlatAlways("core_hostile", -f5, CommodityMarketData.getFactionHostilityDesc());
                } else {
                    marketAPI.getAccessibilityMod().unmodifyFlat("core_hostile");
                }
                Profiler.o00000();
            }
            float f7 = marketAPI.getAccessibilityMod().computeEffective(0.0f);
            f5 = BaseIndustry.getSizeMult((float)n3) * Math.max(0.0f, f7);
            f2 += f5;
            hashMap.put(marketAPI.getId(), Float.valueOf(f5));
            float f8 = this.getDemandValue(commodityOnMarketAPI);
            hashMap2.put(marketAPI.getId(), Float.valueOf(f8));
            this.marketValue += f8;
            this.marketValuePerFaction.put(string3, Float.valueOf(this.getMarketValue(string3) + f8));
        }
        for (MarketAPI marketAPI : list) {
            boolean bl;
            string3 = marketAPI.getFactionId();
            commodityOnMarketAPI = marketAPI.getCommodityData(string);
            object = this.getMarketShareData(marketAPI);
            ((MarketShareData)object).setSourceIsIllegal(!(commodityOnMarketAPI.isDemandLegal() && commodityOnMarketAPI.getMaxDemand() > 0 || commodityOnMarketAPI.isSupplyLegal() && commodityOnMarketAPI.getMaxSupply() > 0));
            if (f2 > 0.0f) {
                float f9 = ((Float)hashMap.get(marketAPI.getId())).floatValue();
                ((MarketShareData)object).setExportMarketShare(f9 / f2);
            }
            if (this.marketValue > 0.0f) {
                float f10 = ((Float)hashMap2.get(marketAPI.getId())).floatValue();
                ((MarketShareData)object).setMarketValueFraction(f10 / this.marketValue);
            }
            n6 = CommodityMarketData.getShippingCapacity(marketAPI, false);
            n5 = CommodityMarketData.getShippingCapacity(marketAPI, true);
            n4 = commodityOnMarketAPI.getMaxSupply();
            n3 = commodityOnMarketAPI.getMaxDemand();
            n2 = n3 - n4;
            if (n2 < 0) {
                n2 = 0;
            }
            n = this.getMaxExport(string3);
            int n8 = Math.min(n5, n);
            if (((MarketShareData)object).isSourceIsIllegal()) {
                n8 = 0;
            }
            int n9 = Math.min(n6, this.maxExportGlobal);
            ((MarketShareData)object).setSource(CommoditySourceType.NONE);
            MutableStatWithTempMods mutableStatWithTempMods = commodityOnMarketAPI.getAvailableStat();
            mutableStatWithTempMods.unmodifyFlat(KEY_LOCAL);
            mutableStatWithTempMods.unmodifyFlat(KEY_IMPORTS);
            mutableStatWithTempMods.unmodifyFlat(KEY_SHORTAGE);
            mutableStatWithTempMods.unmodifyFlat(KEY_LOWACCESS);
            if (n4 + n8 + n9 <= 0 && n3 <= 0) continue;
            String string5 = "import";
            if (((MarketShareData)object).isSourceIsIllegal()) {
                string5 = "smuggling";
            }
            if (n4 > 0) {
                ((MarketShareData)object).setSource(CommoditySourceType.LOCAL);
                mutableStatWithTempMods.modifyFlat(KEY_LOCAL, (float)n4, "Local production");
            }
            boolean bl2 = bl = n8 > n4 || n9 > n4;
            if (n2 > 0 && !marketAPI.isHidden()) {
                int n10;
                int n11;
                int n12;
                int n13;
                int n14 = n2 - Math.max(0, n3 - n) - Math.max(0, n2 - n5);
                if (n14 >= (n13 = n2 - Math.max(0, n3 - this.maxExportGlobal) - Math.max(0, n2 - n6))) {
                    if (bl) {
                        ((MarketShareData)object).setSource(CommoditySourceType.IN_FACTION);
                    }
                    n12 = n2;
                    mutableStatWithTempMods.modifyFlat(KEY_IMPORTS, (float)n12, "Desired " + string5 + " volume (in-faction)");
                    n11 = n3 - n;
                    n11 = Math.min(n11, n2);
                    if (n11 > 0) {
                        mutableStatWithTempMods.modifyFlat(KEY_SHORTAGE, (float)(-n11), "In-faction shortage (max in-faction production source has " + n + ")");
                    }
                    n10 = n12 - n5;
                    n10 = Math.min(n10, n2);
                    if ((n10 -= Math.max(0, n11)) > 0) {
                        mutableStatWithTempMods.modifyFlat(KEY_LOWACCESS, (float)(-n10), "Insufficient accessibility");
                    }
                } else if (n9 > 0) {
                    if (bl) {
                        ((MarketShareData)object).setSource(CommoditySourceType.GLOBAL);
                    }
                    n12 = n2;
                    mutableStatWithTempMods.modifyFlat(KEY_IMPORTS, (float)n12, "Desired " + string5 + " volume");
                    n11 = n3 - this.maxExportGlobal;
                    n11 = Math.min(n11, n2);
                    if (n11 > 0) {
                        mutableStatWithTempMods.modifyFlat(KEY_SHORTAGE, (float)(-n11), "Global shortage (max production source has " + this.maxExportGlobal + ")");
                    }
                    n10 = n12 - n6;
                    n10 = Math.min(n10, n2);
                    if ((n10 -= Math.max(0, n11)) > 0) {
                        mutableStatWithTempMods.modifyFlat(KEY_LOWACCESS, (float)(-n10), "Insufficient accessibility");
                    }
                }
            }
            commodityOnMarketAPI.reapplyEventMod();
        }
        this.adjustMarketShare(list);
    }

    public void adjustMarketShare(List<MarketAPI> list) {
        float f2;
        Profiler.\u00d200000((String)"Adjusting market share");
        int n = 0;
        for (MarketAPI marketAPI : list) {
            Iterator<MarketAPI> iterator = this.getMarketShareData(marketAPI);
            f2 = ((MarketShareData)((Object)iterator)).getExportMarketShare();
            n += (int)(f2 * 100.0f);
        }
        this.sortedProducers = new ArrayList<MarketShareData>(this.marketShareData.values());
        Collections.sort(this.sortedProducers, new Comparator<MarketShareDataAPI>(){

            public int o00000(MarketShareDataAPI marketShareDataAPI, MarketShareDataAPI marketShareDataAPI2) {
                float f2 = marketShareDataAPI.getExportMarketShare() * 100.0f - (float)((int)(marketShareDataAPI.getExportMarketShare() * 100.0f));
                float f3 = marketShareDataAPI2.getExportMarketShare() * 100.0f - (float)((int)(marketShareDataAPI2.getExportMarketShare() * 100.0f));
                return (int)Math.signum(f3 - f2);
            }
        });
        int n2 = 100 - n;
        for (MarketShareDataAPI marketShareDataAPI : this.sortedProducers) {
            f2 = marketShareDataAPI.getExportMarketShare();
            if (!(f2 > 0.0f)) continue;
            if (n2 > 0) {
                marketShareDataAPI.setExportMarketShare((float)((int)(f2 * 100.0f) + 1) / 100.0f);
                --n2;
                continue;
            }
            marketShareDataAPI.setExportMarketShare((float)((int)(f2 * 100.0f)) / 100.0f);
        }
        n = 0;
        for (MarketAPI marketAPI : list) {
            MarketShareData marketShareData = this.getMarketShareData(marketAPI);
            float f3 = marketShareData.getMarketValueFraction();
            n += (int)(f3 * 100.0f);
        }
        this.sortedConsumers = new ArrayList<MarketShareData>(this.marketShareData.values());
        Collections.sort(this.sortedConsumers, new Comparator<MarketShareDataAPI>(){

            public int super(MarketShareDataAPI marketShareDataAPI, MarketShareDataAPI marketShareDataAPI2) {
                float f2 = marketShareDataAPI.getMarketValueFraction() * 100.0f - (float)((int)(marketShareDataAPI.getMarketValueFraction() * 100.0f));
                float f3 = marketShareDataAPI2.getMarketValueFraction() * 100.0f - (float)((int)(marketShareDataAPI2.getMarketValueFraction() * 100.0f));
                return (int)Math.signum(f3 - f2);
            }
        });
        n2 = 100 - n;
        for (MarketShareDataAPI marketShareDataAPI : this.sortedConsumers) {
            float f4 = marketShareDataAPI.getMarketValueFraction();
            if (!(f4 > 0.0f)) continue;
            if (n2 > 0) {
                marketShareDataAPI.setMarketValueFraction((float)((int)(f4 * 100.0f) + 1) / 100.0f);
                --n2;
                continue;
            }
            marketShareDataAPI.setMarketValueFraction((float)((int)(f4 * 100.0f)) / 100.0f);
        }
        Profiler.o00000();
    }

    public List<MarketAPI> getMarkets() {
        List list = Global.getSector().getEconomy().getMarketsInGroup(this.econGroup);
        return list;
    }

    public List<MarketShareDataAPI> getSortedProducers() {
        return this.sortedProducers;
    }

    public List<MarketShareDataAPI> getSortedConsumers() {
        return this.sortedConsumers;
    }

    public int getExportMarketSharePercent(MarketAPI marketAPI) {
        return Math.round(this.getMarketShareData(marketAPI).getExportMarketShare() * 100.0f);
    }

    public int getMarketValuePercent(MarketAPI marketAPI) {
        return Math.round(this.getMarketShareData(marketAPI).getMarketValueFraction() * 100.0f);
    }

    public MarketShareData getMarketShareData(MarketAPI marketAPI) {
        MarketShareData marketShareData = this.marketShareData.get(marketAPI);
        if (marketShareData == null) {
            marketShareData = new MarketShareData();
        }
        this.marketShareData.put(marketAPI, marketShareData);
        return marketShareData;
    }

    public int getMaxExport(String string) {
        Integer n = this.maxExportPerFaction.get(string);
        if (n == null) {
            return 0;
        }
        return n;
    }

    public float getMarketValue(String string) {
        Float f2 = this.marketValuePerFaction.get(string);
        if (f2 == null) {
            return 0.0f;
        }
        return f2.floatValue();
    }

    public String getCommodityId() {
        return this.commodityId;
    }

    public String getEconGroup() {
        return this.econGroup;
    }

    public int getMaxExportGlobal() {
        return this.maxExportGlobal;
    }

    public float getMarketValue() {
        float f2 = this.getMarketValue("player");
        return this.marketValue - f2;
    }

    public float getMarketValueOutsideFaction(String string) {
        float f2 = this.getMarketValue(string);
        return this.getMarketValue() - f2;
    }

    public int getExportIncome(CommodityOnMarketAPI commodityOnMarketAPI) {
        MarketShareData marketShareData = this.getMarketShareData(commodityOnMarketAPI.getMarket());
        if (marketShareData.isSourceIsIllegal()) {
            return 0;
        }
        float f2 = commodityOnMarketAPI.getMarket().getIncomeMult().getModifiedValue();
        float f3 = 1.0f;
        if (commodityOnMarketAPI.getMarket().isPlayerOwned()) {
            f3 = Global.getSector().getPlayerStats().getDynamic().getValue(Stats.getCommodityExportCreditsMultId((String)commodityOnMarketAPI.getId()));
        }
        return (int)(marketShareData.getExportMarketShare() * this.getMarketValue() * (f2 *= f3));
    }

    public int getDemandValue(CommodityOnMarketAPI commodityOnMarketAPI) {
        float f2 = CommodityMarketData.getShippingCapacity(commodityOnMarketAPI.getMarket(), false);
        float f3 = commodityOnMarketAPI.getMaxDemand();
        float f4 = commodityOnMarketAPI.getCommodity().getExportValue();
        float f5 = Global.getSettings().getFloat("exportIncomeMult");
        float f6 = BaseIndustry.getSizeMult((float)Math.min(f2, f3)) * f4 * f5;
        return (int)f6;
    }

    public int getMarketSharePercent(FactionAPI factionAPI) {
        int n = 0;
        for (MarketAPI marketAPI : this.getMarkets()) {
            int n2 = this.getExportMarketSharePercent(marketAPI);
            if (marketAPI.getFaction() != factionAPI && (!factionAPI.isPlayerFaction() || !marketAPI.isPlayerOwned())) continue;
            n += n2;
        }
        return n;
    }

    public Map<FactionAPI, Integer> getMarketSharePercentPerFaction() {
        LinkedHashMap<FactionAPI, Integer> linkedHashMap = new LinkedHashMap<FactionAPI, Integer>();
        for (MarketAPI marketAPI : this.getMarkets()) {
            FactionAPI factionAPI = marketAPI.getFaction();
            if (linkedHashMap.containsKey(factionAPI)) continue;
            Integer n = this.getMarketSharePercent(factionAPI);
            linkedHashMap.put(factionAPI, n);
        }
        return linkedHashMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class o {
        public float \u00d200000 = 0.0f;
        public Map<FactionAPI, Integer> o00000 = new LinkedHashMap<FactionAPI, Integer>();
        public Map<FactionAPI, Integer> Object;

        public o(List<MarketAPI> list) {
            for (MarketAPI marketAPI : list) {
                FactionAPI factionAPI2 = marketAPI.getFaction();
                Object object = this.o00000.get(factionAPI2);
                if (object == null) {
                    object = 0;
                }
                int n = Math.max(1, marketAPI.getSize() - 2);
                this.o00000.put(factionAPI2, (Integer)object + n);
                this.\u00d200000 += (float)n;
            }
            this.Object = new HashMap<FactionAPI, Integer>();
            for (FactionAPI factionAPI : this.o00000.keySet()) {
                this.Object.put(factionAPI, 0);
            }
            for (FactionAPI factionAPI : this.o00000.keySet()) {
                for (FactionAPI factionAPI2 : this.o00000.keySet()) {
                    if (factionAPI == factionAPI2 || !factionAPI.isHostileTo(factionAPI2)) continue;
                    Integer n = this.Object.get(factionAPI);
                    if (n == null) {
                        n = 0;
                    }
                    this.Object.put(factionAPI, n + this.o00000.get(factionAPI2));
                }
            }
        }
    }
}

