/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.econ.reach;

import com.fs.profiler.Profiler;
import com.fs.starfarer.api.campaign.econ.ImmigrationPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.campaign.econ.Economy;
import com.fs.starfarer.campaign.econ.contract.iter.MultiFrameTask;
import com.fs.starfarer.campaign.econ.reach.ReachEconomy;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmigrationTask
extends MultiFrameTask
implements DoNotObfuscate {
    private ReachEconomy economy;
    private List<MarketAPI> markets;
    private boolean uiUpdateOnly;

    public ImmigrationTask(List<MarketAPI> list, ReachEconomy reachEconomy, boolean bl) {
        this.economy = reachEconomy;
        this.uiUpdateOnly = bl;
        this.markets = new ArrayList<MarketAPI>(list);
    }

    @Override
    public void doNextBatch() {
        if (this.isDone()) {
            return;
        }
        MarketAPI marketAPI = this.markets.remove(0);
        Profiler.\u00d200000((String)"Immigration");
        ImmigrationPlugin immigrationPlugin = Misc.getImmigrationPlugin((MarketAPI)marketAPI);
        immigrationPlugin.advance(30.0f / (float)Economy.NUM_ITER_PER_MONTH, this.uiUpdateOnly);
        Profiler.o00000();
    }

    @Override
    public boolean isDone() {
        return this.markets == null || this.markets.isEmpty();
    }

    @Override
    public String getLoggingIdentifier() {
        return "ImmigrationTask";
    }
}

