/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.econ.reach;

import com.fs.profiler.Profiler;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.util.ListMap;
import com.fs.starfarer.campaign.econ.Economy;
import com.fs.starfarer.campaign.econ.contract.iter.MultiFrameTask;
import com.fs.starfarer.campaign.econ.reach.FinishEconomyUpdateTask;
import com.fs.starfarer.campaign.econ.reach.ImmigrationTask;
import com.fs.starfarer.campaign.econ.reach.MainWorkTask;
import com.fs.starfarer.campaign.econ.reach.MainWorkTask2;
import com.fs.starfarer.campaign.econ.reach.UpdateMarketsAgainTask;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReachEconomy
implements DoNotObfuscate {
    public static boolean WITH_REACH = false;
    private List<MarketAPI> markets = new ArrayList<MarketAPI>();
    private transient ListMap<MarketAPI> locationToMarket = null;
    private transient LinkedHashSet<LocationAPI> locationsWithMarkets = null;
    private transient LinkedHashMap<String, MarketAPI> idToMarket = new LinkedHashMap();
    private transient boolean locationCacheNeedsUpdate = true;

    public void updateLocationMap() {
        if (this.locationCacheNeedsUpdate || this.locationToMarket == null || this.idToMarket == null || this.locationsWithMarkets == null) {
            if (this.locationToMarket == null) {
                this.locationToMarket = new ListMap();
            }
            this.locationToMarket.clear();
            if (this.locationsWithMarkets == null) {
                this.locationsWithMarkets = new LinkedHashSet();
            }
            this.locationsWithMarkets.clear();
            if (this.idToMarket == null) {
                this.idToMarket = new LinkedHashMap();
            }
            this.idToMarket.clear();
            for (MarketAPI marketAPI : this.markets) {
                if (marketAPI.getContainingLocation() == null) continue;
                String string = marketAPI.getContainingLocation().getId();
                this.locationToMarket.add(string, (Object)marketAPI);
                this.locationsWithMarkets.add(marketAPI.getContainingLocation());
                this.idToMarket.put(marketAPI.getId(), marketAPI);
            }
            this.locationCacheNeedsUpdate = false;
        }
    }

    public void setLocationCacheNeedsUpdate(boolean bl) {
        this.locationCacheNeedsUpdate = bl;
    }

    public LinkedHashMap<String, MarketAPI> getIdToMarket() {
        this.updateLocationMap();
        return this.idToMarket;
    }

    public List<LocationAPI> getLocationsWithMarkets() {
        this.updateLocationMap();
        return new ArrayList<LocationAPI>(this.locationsWithMarkets);
    }

    public List<StarSystemAPI> getStarSystemsWithMarkets() {
        this.updateLocationMap();
        ArrayList<StarSystemAPI> arrayList = new ArrayList<StarSystemAPI>();
        for (LocationAPI locationAPI : this.locationsWithMarkets) {
            if (!(locationAPI instanceof StarSystemAPI)) continue;
            arrayList.add((StarSystemAPI)locationAPI);
        }
        return arrayList;
    }

    public List<MarketAPI> getMarkets(LocationAPI locationAPI) {
        if (locationAPI == null) {
            return new ArrayList<MarketAPI>();
        }
        this.updateLocationMap();
        return this.locationToMarket.getList(locationAPI.getId());
    }

    public void addMarket(MarketAPI marketAPI) {
        if (this.markets.contains(marketAPI)) {
            return;
        }
        this.markets.add(marketAPI);
        this.locationCacheNeedsUpdate = true;
    }

    public void removeMarket(MarketAPI marketAPI) {
        this.markets.remove(marketAPI);
        this.locationCacheNeedsUpdate = true;
    }

    public List<MarketAPI> getMarkets() {
        return this.markets;
    }

    public List<MarketAPI> getMarketsWithSameGroup(MarketAPI marketAPI) {
        return this.getMarketsWithSameGroup(marketAPI, this.markets);
    }

    public List<MarketAPI> getMarketsWithSameGroup(MarketAPI marketAPI, List<MarketAPI> list) {
        ArrayList<MarketAPI> arrayList = new ArrayList<MarketAPI>();
        for (MarketAPI marketAPI2 : list) {
            if (!this.areInSameGroup(marketAPI, marketAPI2)) continue;
            arrayList.add(marketAPI2);
        }
        return arrayList;
    }

    public List<MarketAPI> getMarketsInGroup(String string) {
        ArrayList<MarketAPI> arrayList = new ArrayList<MarketAPI>();
        for (MarketAPI marketAPI : this.markets) {
            if (!this.isInGroup(string, marketAPI)) continue;
            arrayList.add(marketAPI);
        }
        return arrayList;
    }

    public boolean isInGroup(String string, MarketAPI marketAPI) {
        if (string == null && marketAPI.getEconGroup() == null) {
            return true;
        }
        return string != null && string.equals(marketAPI.getEconGroup());
    }

    public boolean areInSameGroup(MarketAPI marketAPI, MarketAPI marketAPI2) {
        return this.isInGroup(marketAPI.getEconGroup(), marketAPI2);
    }

    public void nextStep(MainWorkTask.EconWorkParams econWorkParams) {
        Profiler.\u00d200000((String)"nextStep()");
        for (MarketAPI object2 : new ArrayList<MarketAPI>(this.markets)) {
            PersonAPI personAPI = object2.getAdmin();
            personAPI.getStats().refreshCharacterStatsEffects();
            personAPI.getStats().refreshGovernedOutpostEffects(object2);
        }
        MainWorkTask2 mainWorkTask2 = new MainWorkTask2(this.markets, this, econWorkParams);
        while (!((MultiFrameTask)mainWorkTask2).isDone()) {
            ((MultiFrameTask)mainWorkTask2).doNextBatch();
        }
        UpdateMarketsAgainTask updateMarketsAgainTask = new UpdateMarketsAgainTask((Economy)Global.getSector().getEconomy());
        while (!((MultiFrameTask)updateMarketsAgainTask).isDone()) {
            ((MultiFrameTask)updateMarketsAgainTask).doNextBatch();
        }
        if (econWorkParams.withImmigration) {
            ImmigrationTask immigrationTask = new ImmigrationTask(this.markets, this, !econWorkParams.forceNonUIStep);
            while (!((MultiFrameTask)immigrationTask).isDone()) {
                ((MultiFrameTask)immigrationTask).doNextBatch();
            }
        }
        FinishEconomyUpdateTask finishEconomyUpdateTask = new FinishEconomyUpdateTask((Economy)Global.getSector().getEconomy());
        while (!((MultiFrameTask)finishEconomyUpdateTask).isDone()) {
            ((MultiFrameTask)finishEconomyUpdateTask).doNextBatch();
        }
        Profiler.o00000();
    }

    public static void main(String[] stringArray) {
    }
}

