/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.fleet;

import com.fs.graphics.G;
import com.fs.graphics.Sprite;
import com.fs.graphics.anim.Animation;
import com.fs.graphics.anim.BaseAnimation;
import com.fs.graphics.util.Fader;
import com.fs.graphics.util.OoOO;
import com.fs.profiler.Profiler;
import com.fs.starfarer.String.L;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.FleetMemberViewAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.fleet.CampaignFleet;
import com.fs.starfarer.campaign.fleet.CampaignFleetView;
import com.fs.starfarer.campaign.fleet.CampaignShipEngineGlow;
import com.fs.starfarer.campaign.fleet.ContrailEngineV2;
import com.fs.starfarer.campaign.fleet.FleetMember;
import com.fs.starfarer.campaign.fleet.SmoothFacingModule;
import com.fs.starfarer.campaign.fleet.SmoothMovementModule;
import com.fs.starfarer.campaign.util.CollectionItemView;
import com.fs.starfarer.combat.ai.FighterWingFormation;
import com.fs.starfarer.combat.entities.ContrailEngine;
import com.fs.starfarer.combat.entities.ship.oOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO.B;
import com.fs.starfarer.loading.specs.BaseWeaponSpec;
import com.fs.starfarer.loading.specs.EngineSlot;
import com.fs.starfarer.loading.specs.HullVariantSpec;
import com.fs.starfarer.loading.specs.Y;
import com.fs.starfarer.loading.specs.interface;
import com.fs.starfarer.loading.specs.o00o;
import com.fs.starfarer.loading.specs.while;
import com.fs.starfarer.prototype.Utils;
import com.fs.starfarer.renderers.JitterRenderer;
import com.fs.starfarer.renderers.O;
import com.fs.starfarer.settings.StarfarerSettings;
import com.fs.starfarer.ui.super.B;
import com.fs.starfarer.util.ColorShifter;
import com.fs.starfarer.util.ValueShifter;
import com.fs.util.DoNotObfuscate;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class CampaignFleetMemberView
implements CollectionItemView,
DoNotObfuscate,
FleetMemberViewAPI {
    private final CampaignFleet fleet;
    private FleetMember member;
    private Fader fader = new Fader(0.0f, 1.0f, 1.5f);
    private Vector2f originLoc = new Vector2f();
    private float originFacing;
    private Vector2f desiredOffset = new Vector2f();
    private float turnRate;
    private float maxTurnRate;
    private float moveSpeed;
    private SmoothMovementModule movementModule;
    private transient Sprite sprite;
    private transient List<B.o> moduleIcons = new ArrayList<B.o>();
    private transient Sprite shadowMask;
    private transient Sprite windEffect;
    private float scaleMult;
    private CampaignShipEngineGlow engineGlow;
    private float shipSizeOrdinal;
    private FighterWingFormation formation;
    private Vector2f[] desiredFighterOffsets = new Vector2f[10];
    private SmoothMovementModule[] fighterMovement = new SmoothMovementModule[10];
    private SmoothFacingModule facingModule;
    private float facing;
    private Fader jitterFader = null;
    private int jitterCopies = 10;
    private float maxJitterRange = 10.0f;
    private Color jitterColor = Color.white;
    private JitterRenderer jr = null;
    private ColorShifter engineColor;
    private ValueShifter engineWidthMult;
    private ValueShifter engineHeightMult;
    private ColorShifter engineGlowColor;
    private ValueShifter engineGlowSizeMult;
    private ColorShifter contrailColor;
    private ValueShifter contrailWidthMult;
    private ValueShifter contrailDurMult;
    private ColorShifter glowColor;
    private ColorShifter windEffectColor;
    private ValueShifter windEffectDirX;
    private ValueShifter windEffectDirY;
    private float prevAngle = -1.0f;
    private Vector2f zero = new Vector2f();
    private boolean offsetOverridden = false;
    private boolean useLight = false;
    private float extraAlphaMult = 1.0f;
    private float windOffset = 0.0f;

    protected Object readResolve() {
        if (this.engineColor == null) {
            this.engineColor = new ColorShifter(this.engineGlow.getColor());
        }
        if (this.engineGlowColor == null) {
            this.engineGlowColor = new ColorShifter(this.engineGlow.getColor());
        }
        if (this.contrailColor == null) {
            this.contrailColor = new ColorShifter(this.engineGlow.getContrailColor());
        }
        if (this.glowColor == null) {
            this.glowColor = new ColorShifter(new Color(0, 0, 0, 0));
        }
        if (this.engineWidthMult == null) {
            this.engineWidthMult = new ValueShifter(1.0f);
        }
        if (this.engineHeightMult == null) {
            this.engineHeightMult = new ValueShifter(1.0f);
        }
        if (this.engineGlowSizeMult == null) {
            this.engineGlowSizeMult = new ValueShifter(1.0f);
        }
        if (this.contrailWidthMult == null) {
            this.contrailWidthMult = new ValueShifter(1.0f);
        }
        if (this.contrailDurMult == null) {
            this.contrailDurMult = new ValueShifter(1.0f);
        }
        if (this.windEffectDirX == null) {
            this.windEffectDirX = new ValueShifter(0.0f);
        }
        if (this.windEffectDirY == null) {
            this.windEffectDirY = new ValueShifter(0.0f);
        }
        if (this.windEffectColor == null) {
            this.windEffectColor = new ColorShifter(new Color(0, 0, 0, 0));
        }
        this.engineColor.setBase(this.engineGlow.getColor());
        this.engineGlowColor.setBase(this.engineGlow.getColor());
        this.contrailColor.setBase(this.engineGlow.getContrailColor());
        this.shadowMask = new Sprite("graphics/fx/ship_shadow_mask.png");
        this.sprite = new Sprite(this.member.getHullSpec().getSpriteSpec().\u00d300000());
        float f2 = this.member.getHullSpec().getSpriteSpec().null();
        float f3 = this.member.getHullSpec().getSpriteSpec().o00000();
        float f4 = this.member.getHullSpec().getSpriteSpec().class();
        float f5 = this.member.getHullSpec().getSpriteSpec().new();
        if (this.member.getSpriteOverride() != null) {
            this.sprite = new Sprite(this.member.getSpriteOverride());
            if (this.member.getOverrideSpriteSize() != null) {
                f2 = this.member.getOverrideSpriteSize().x;
                f3 = this.member.getOverrideSpriteSize().y;
                this.scaleMult = 1.0f;
                this.sprite.setSize(f2 * this.scaleMult, f3 * this.scaleMult);
            }
        } else {
            this.sprite.setSize(f2 * this.scaleMult, f3 * this.scaleMult);
            this.sprite.setCenter(f4 * this.scaleMult, f5 * this.scaleMult);
        }
        interface interface_ = this.member.getVariant().getSizeWithModules();
        float f6 = Math.max(interface_.null() * this.scaleMult, interface_.o00000() * this.scaleMult) * 1.7f;
        if (this.member.isStation()) {
            f6 = Math.max(interface_.null() * this.scaleMult, interface_.o00000() * this.scaleMult) * 2.0f;
        }
        this.shadowMask.setSize(f6, f6);
        this.windEffect = StarfarerSettings.class("terrain", "wind_effect");
        this.moduleIcons = new ArrayList<B.o>();
        int n = 0;
        for (String string : this.member.getVariant().getModuleSlots()) {
            ++n;
            String string2 = this.member.getVariant().getStationModuleId(string);
            if (string2 == null) continue;
            Y y = this.member.getVariant().getHullSpec().getWeaponSlot(string);
            HullVariantSpec hullVariantSpec = null;
            hullVariantSpec = this.member.getVariant().getModuleVariant(string);
            B.o o2 = new B.o();
            o2.\u00d300000 = y;
            o2.\u00d200000 = new Sprite(hullVariantSpec.getHullSpec().getSpriteSpec().\u00d300000());
            o2.super = hullVariantSpec;
            this.moduleIcons.add(o2);
        }
        return this;
    }

    public float getScaleMult() {
        return this.scaleMult;
    }

    public void setScaleMult(float f2) {
        this.scaleMult = f2;
    }

    public CampaignFleet getFleet() {
        return this.fleet;
    }

    public CampaignFleetMemberView(CampaignFleet campaignFleet, FleetMember fleetMember) {
        this.fleet = campaignFleet;
        this.member = fleetMember;
        this.fader.fadeIn();
        switch (fleetMember.getHullSpec().getHullSize()) {
            case CAPITAL_SHIP: {
                if (fleetMember.isStation()) {
                    this.scaleMult = 0.1f;
                    this.moveSpeed = 6.0f;
                    this.maxTurnRate = 40.0f;
                    break;
                }
                this.scaleMult = 0.07f;
                this.moveSpeed = 6.0f;
                this.maxTurnRate = 40.0f;
                break;
            }
            case CRUISER: {
                this.scaleMult = 0.08f;
                this.moveSpeed = 8.0f;
                this.maxTurnRate = 60.0f;
                break;
            }
            case DESTROYER: {
                this.scaleMult = 0.09f;
                this.moveSpeed = 10.0f;
                this.maxTurnRate = 80.0f;
                break;
            }
            case FRIGATE: {
                this.scaleMult = 0.11f;
                this.moveSpeed = 14.0f;
                this.maxTurnRate = 120.0f;
                break;
            }
            case FIGHTER: {
                this.scaleMult = 0.15f;
                this.moveSpeed = 15.0f;
                this.maxTurnRate = 200.0f;
                break;
            }
            case DEFAULT: {
                this.scaleMult = 0.1f;
                this.moveSpeed = 6.0f;
                this.maxTurnRate = 60.0f;
            }
        }
        this.shadowMask = new Sprite("graphics/fx/ship_shadow_mask.png");
        this.sprite = new Sprite(fleetMember.getHullSpec().getSpriteSpec().\u00d300000());
        float f2 = fleetMember.getHullSpec().getSpriteSpec().null();
        float f3 = fleetMember.getHullSpec().getSpriteSpec().o00000();
        float f4 = fleetMember.getHullSpec().getSpriteSpec().class();
        float f5 = fleetMember.getHullSpec().getSpriteSpec().new();
        if (fleetMember.getSpriteOverride() != null) {
            this.sprite = new Sprite(fleetMember.getSpriteOverride());
            if (fleetMember.getOverrideSpriteSize() != null) {
                f2 = fleetMember.getOverrideSpriteSize().x;
                f3 = fleetMember.getOverrideSpriteSize().y;
                this.scaleMult = 1.0f;
                this.sprite.setSize(f2 * this.scaleMult, f3 * this.scaleMult);
            }
        } else {
            this.sprite.setSize(f2 * this.scaleMult, f3 * this.scaleMult);
            this.sprite.setCenter(f4 * this.scaleMult, f5 * this.scaleMult);
        }
        interface interface_ = fleetMember.getVariant().getSizeWithModules();
        float f6 = Math.max(interface_.null() * this.scaleMult, interface_.o00000() * this.scaleMult) * 1.7f;
        if (fleetMember.isStation()) {
            f6 = Math.max(interface_.null() * this.scaleMult, interface_.o00000() * this.scaleMult) * 2.0f;
        }
        this.shadowMask.setSize(f6, f6);
        this.shipSizeOrdinal = fleetMember.getHullSpec().getHullSize().ordinal();
        this.regenerateOffset();
        this.engineGlow = new CampaignShipEngineGlow(fleetMember, this.scaleMult);
        if (fleetMember.isFighterWing()) {
            this.formation = new FighterWingFormation(fleetMember.getWingSpec().getFormation());
            float f7 = this.originLoc.x + this.desiredOffset.x;
            float f8 = this.originLoc.y + this.desiredOffset.y;
            float f9 = fleetMember.getHullSpec().getSpriteSpec().\u00d400000() * 4.0f * this.scaleMult;
            Vector2f vector2f = new Vector2f(f7, f8);
            int n = 0;
            while (n < fleetMember.getWingSpec().getNumFighters()) {
                this.fighterMovement[n] = new SmoothMovementModule(this.moveSpeed * 1.0f, this.moveSpeed * 1.25f);
                this.desiredFighterOffsets[n] = this.formation.getFormationOffset(vector2f, this.facing, f9, f9, n);
                this.fighterMovement[n].getLocation().set((ReadableVector2f)this.desiredFighterOffsets[n]);
                ++n;
            }
        } else {
            this.fighterMovement = null;
            this.desiredFighterOffsets = null;
        }
        this.movementModule = new SmoothMovementModule(this.moveSpeed * 0.5f, this.moveSpeed);
        this.movementModule.getLocation().set((ReadableVector2f)this.desiredOffset);
        this.facingModule = new SmoothFacingModule(this.maxTurnRate * 0.5f, this.maxTurnRate);
        this.facingModule.setFacing(campaignFleet.getFacing());
        this.readResolve();
    }

    public ColorShifter getEngineColor() {
        return this.engineColor;
    }

    public ValueShifter getEngineWidthMult() {
        return this.engineWidthMult;
    }

    public ColorShifter getGlowColor() {
        return this.glowColor;
    }

    public ValueShifter getEngineHeightMult() {
        return this.engineHeightMult;
    }

    public ColorShifter getEngineGlowColor() {
        return this.engineGlowColor;
    }

    public ValueShifter getEngineGlowSizeMult() {
        return this.engineGlowSizeMult;
    }

    public ColorShifter getContrailColor() {
        return this.contrailColor;
    }

    public ValueShifter getContrailWidthMult() {
        return this.contrailWidthMult;
    }

    public ValueShifter getContrailDurMult() {
        return this.contrailDurMult;
    }

    private void regenerateOffset() {
        if (this.offsetOverridden) {
            return;
        }
        ShipAPI.HullSize hullSize = this.member.getHullSpec().getHullSize();
        float f2 = this.fleet.getRadius();
        float f3 = Misc.getSizeNum((ShipAPI.HullSize)this.fleet.getLargestShipSize());
        float f4 = Misc.getSizeNum((ShipAPI.HullSize)hullSize);
        float f5 = 0.0f;
        float f6 = ((f3 - f4) / f3 * 0.5f + 0.5f) * f2;
        if (this.fleet.isOnlyOneLargestShip() && this.fleet.getLargestShipSize() == hullSize) {
            f6 = 0.0f;
            f5 = 0.0f;
        }
        float f7 = this.prevAngle == -1.0f ? (float)Math.random() * 360.0f : this.prevAngle + 120.0f + (float)Math.random() * 120.0f;
        float f8 = f5 + (float)Math.sqrt(Math.random()) * (f6 - f5);
        this.desiredOffset.set((ReadableVector2f)Utils.\u00d300000(f7).scale(f8));
        this.prevAngle = f7;
        this.prevAngle = Misc.normalizeAngle((float)this.prevAngle);
    }

    public void overrideOffset(float f2, float f3) {
        this.desiredOffset.set(f2, f3);
        this.movementModule.getLocation().set(f2, f3);
        if (this.member.isFighterWing()) {
            Vector2f vector2f = this.movementModule.getLocation();
            float f4 = this.member.getHullSpec().getSpriteSpec().\u00d400000() * 4.0f * this.scaleMult;
            Vector2f vector2f2 = new Vector2f(this.originLoc.x + vector2f.x, this.originLoc.y + vector2f.y);
            int n = 1;
            while (n < this.member.getWingSpec().getNumFighters()) {
                this.desiredFighterOffsets[n] = this.formation.getFormationOffset(vector2f2, this.facing, f4, f4, n);
                this.fighterMovement[n].getLocation().set(this.desiredFighterOffsets[n].x, this.desiredFighterOffsets[n].y);
                ++n;
            }
        }
        this.offsetOverridden = true;
    }

    public void setJitterDirection(Vector2f vector2f) {
        if (this.jr != null) {
            this.jr.setJitterDirection(vector2f);
        }
    }

    public void setJitterLength(float f2) {
        if (this.jr != null) {
            this.jr.setJitterLength(f2);
        }
    }

    public void setUseCircularJitter(boolean bl) {
        if (this.jr != null) {
            this.jr.setUseCircularJitter(bl);
        }
    }

    public void setJitterBrightness(float f2) {
        if (this.jitterFader != null) {
            this.jitterFader.setBrightness(f2);
        }
    }

    public void endJitter() {
        this.jr = null;
        this.jitterFader = null;
    }

    public void setJitter(float f2, float f3, Color color, int n, float f4) {
        this.jitterColor = color;
        this.jitterCopies = n;
        this.maxJitterRange = f4;
        if (this.jitterFader != null) {
            this.jitterFader.fadeIn();
        } else {
            this.jitterFader = new Fader(0.0f, f2, f3, false, true);
            this.jitterFader.fadeIn();
            this.jr = new JitterRenderer();
        }
    }

    public boolean isJittering() {
        return this.jitterFader != null;
    }

    public void advance(float f2, CampaignFleetView campaignFleetView) {
        float f3;
        float f4;
        float f5;
        float f6;
        Object object;
        Profiler.\u00d200000((String)"CFMV Advance");
        this.fader.advance(f2);
        this.engineGlow.advance(this, f2);
        if (f2 > 0.0f && this.jr != null) {
            this.jr.updateSeed();
        }
        if (this.jitterFader != null) {
            this.jitterFader.advance(f2);
            if (this.jitterFader.isFadedOut()) {
                this.jitterFader = null;
                this.jr = null;
            }
        }
        this.movementModule.advance(null, this.desiredOffset, this.zero, f2);
        Vector2f vector2f = this.movementModule.getLocation();
        this.engineColor.advance(f2);
        this.engineWidthMult.advance(f2);
        this.engineHeightMult.advance(f2);
        this.engineGlowColor.advance(f2);
        this.engineGlowSizeMult.advance(f2);
        this.contrailColor.advance(f2);
        this.contrailWidthMult.advance(f2);
        this.contrailDurMult.advance(f2);
        this.glowColor.advance(f2);
        this.windEffectDirX.advance(f2);
        this.windEffectDirY.advance(f2);
        this.windEffectColor.advance(f2);
        Object object2 = null;
        if (this.windEffectColor.isShifted()) {
            object = new Vector2f(this.windEffectDirX.getCurr(), this.windEffectDirY.getCurr());
            float f7 = object.length();
            if (f7 < 0.1f) {
                f7 = 0.1f;
            }
            f6 = CampaignEngine.getInstance().getClock().convertToDays(f2);
            float f8 = Math.min(this.sprite.getWidth(), this.sprite.getHeight()) / 2.0f;
            f5 = f8 * f7;
            f4 = f5 / (float)this.windEffect.getTexture().\u00d300000();
            this.windOffset += 0.1f * f4 * f6 * 100.0f;
            if (this.windOffset > 1.0f) {
                this.windOffset -= 1.0f;
            }
            object2 = object;
        }
        this.facingModule.setMaxTurnRate(this.maxTurnRate * 3.0f);
        this.facingModule.setTurnAcceleration(this.maxTurnRate * 10.0f);
        if (campaignFleetView != null) {
            if (!this.engineGlow.isAccelerating()) {
                // empty if block
            }
            if (!this.isJittering() && !this.member.isFighterWing()) {
                object = new ArrayList();
                object.add(new Vector2f(vector2f.x, vector2f.y));
                if (this.member.getFleetData() != null && this.member.getFleetData().getFleet() != null) {
                    if (!this.member.getFleetData().getFleet().isInCurrentLocation()) {
                        object.clear();
                    } else {
                        SectorEntityToken.VisibilityLevel visibilityLevel = this.member.getFleetData().getFleet().getVisibilityLevelToPlayerFleet();
                        if (visibilityLevel == SectorEntityToken.VisibilityLevel.NONE) {
                            object.clear();
                        }
                    }
                }
                int n = 0;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Vector2f vector2f2 = (Vector2f)iterator.next();
                    List<CampaignShipEngineGlow.SlotData> list = this.engineGlow.getClusters();
                    int n2 = list.size();
                    ++n;
                    int n3 = 0;
                    while (n3 < n2) {
                        float f9;
                        Object object3;
                        Vector2f vector2f3 = new Vector2f((ReadableVector2f)vector2f2);
                        String string = String.valueOf(this.member.getId()) + "_" + n + "_" + n3;
                        CampaignShipEngineGlow.SlotData slotData = list.get(n3);
                        float f10 = 2.0f;
                        if (this.member.isFighterWing()) {
                            f10 = 1.0f;
                        }
                        f10 *= 1.5f;
                        float f11 = 1.0f;
                        switch (this.member.getHullSpec().getHullSize()) {
                            case CAPITAL_SHIP: {
                                f11 = 2.0f;
                                break;
                            }
                            case CRUISER: {
                                f11 = 1.5f;
                                break;
                            }
                            case DESTROYER: {
                                f11 = 1.25f;
                                break;
                            }
                            case FRIGATE: {
                                f11 = 0.75f;
                                break;
                            }
                            case FIGHTER: {
                                f11 = 0.5f;
                            }
                        }
                        if (!campaignFleetView.getContrails().hasContrail(string)) {
                            campaignFleetView.getContrails().initContrail(string, OoOO.String((Color)this.contrailColor.getCurr(), (float)slotData.weight), slotData.width * f10 * this.contrailWidthMult.getCurr(), f11 * this.contrailDurMult.getCurr(), 5.0f, 50.0f, 7.5f, ContrailEngine.ContrailWidthMode.WIDEN, EngineSlot.BlendMode.GLOW, true);
                        }
                        campaignFleetView.getContrails().updateContrail(string, OoOO.String((Color)this.contrailColor.getCurr(), (float)slotData.weight), slotData.width * f10 * this.contrailWidthMult.getCurr(), f11 * this.contrailDurMult.getCurr(), 5.0f, 50.0f, 7.5f, ContrailEngine.ContrailWidthMode.WIDEN, EngineSlot.BlendMode.GLOW);
                        float f12 = campaignFleetView.getFleet().getLocation().x;
                        float f13 = campaignFleetView.getFleet().getLocation().y;
                        boolean bl = true;
                        ContrailEngineV2.Contrail contrail = campaignFleetView.getContrails().getContrails().get(string);
                        if (contrail != null && !contrail.points.isEmpty()) {
                            object3 = contrail.points.get(contrail.points.size() - 1);
                            float f14 = object3.point.x - f12;
                            f9 = object3.point.y - f13;
                            float f15 = f14 * f14 + f9 * f9;
                            if (f15 < contrail.minSegLength * contrail.minSegLength) {
                                bl = false;
                            }
                        }
                        if (bl) {
                            object3 = Utils.\u00d300000(this.facingModule.getFacing() + slotData.angle);
                            object3.scale(campaignFleetView.getFleet().getTravelSpeed() * 0.25f);
                            vector2f3.x += f12;
                            vector2f3.y += f13;
                            if (object2 != null) {
                                object3.x += ((Vector2f)object2).x * 10.0f;
                                object3.y += ((Vector2f)object2).y * 10.0f;
                            }
                            Vector2f vector2f4 = new Vector2f((ReadableVector2f)slotData.offset);
                            vector2f4 = Utils.super(vector2f4, Utils.super(this.facingModule.getFacing()));
                            vector2f3.x += vector2f4.x;
                            vector2f3.y += vector2f4.y;
                            f9 = Math.max(0.0f, this.engineGlow.getAccelFader().getBrightness());
                            if (this.fleet.getVelocity().length() <= 15.0f) {
                                f9 = 0.0f;
                            }
                            campaignFleetView.getContrails().addPoint(string, vector2f3, (Vector2f)object3, f9);
                        }
                        ++n3;
                    }
                }
            }
        }
        if (this.member.isFighterWing()) {
            float f16 = this.originLoc.x + vector2f.x;
            float f17 = this.originLoc.y + vector2f.y;
            f6 = this.member.getHullSpec().getSpriteSpec().\u00d400000() * 4.0f * this.scaleMult;
            Vector2f vector2f5 = new Vector2f(f16, f17);
            int n = 1;
            while (n < this.member.getWingSpec().getNumFighters()) {
                this.desiredFighterOffsets[n] = this.formation.getFormationOffset(vector2f5, this.facing, f6, f6, n);
                this.fighterMovement[n].advance(null, this.desiredFighterOffsets[n], this.movementModule.getVelocity(), f2);
                ++n;
            }
        }
        if ((f3 = Utils.void(this.movementModule.getLocation(), this.desiredOffset)) < 3.0f) {
            this.regenerateOffset();
        }
        boolean bl = true;
        if (this.fleet.getLargestShipSize() != null && (float)this.fleet.getLargestShipSize().ordinal() > this.shipSizeOrdinal && this.shipSizeOrdinal <= 2.0f) {
            bl = false;
        }
        bl = true;
        f6 = this.originFacing;
        if (!bl) {
            if (f3 > 10.0f) {
                f6 = Utils.\u00d300000(this.movementModule.getLocation(), this.desiredOffset);
            }
        } else {
            Vector2f vector2f6 = this.fleet.getMoveDestination();
            f3 = vector2f6 != null ? Utils.void(this.fleet.getMovementModule().getLocation(), vector2f6) : 0.0f;
        }
        this.facingModule.advance(f6, f2);
        if (this.member.isStation()) {
            f6 = this.fleet.getFacing();
            this.facingModule.setFacing(f6);
        }
        this.facing = this.facingModule.getFacing();
        boolean bl2 = false;
        f5 = this.fleet.getFacing();
        if (this.fleet.getVelocity().length() > 5.0f) {
            bl2 = true;
            f5 = Utils.\u00d300000(this.fleet.getVelocity());
        }
        if (this.fleet.getMovementModule().getAccelVector().length() > 12.0f * this.fleet.getStats().getAccelerationMult().getModifiedValue()) {
            bl2 = true;
            f5 = Utils.\u00d300000((Vector2f)this.fleet.getMovementModule().getAccelVector());
        }
        if (f3 < 10.0f) {
            bl2 = false;
        }
        if ((f4 = Utils.super(this.facing, f5)) > 120.0f || !bl2 || this.fleet.getBattle() != null) {
            this.engineGlow.decelerate();
        } else {
            this.engineGlow.accelerate();
        }
        Profiler.o00000();
    }

    public SmoothMovementModule getMovementModule() {
        return this.movementModule;
    }

    public void setUseLight(boolean bl) {
        this.useLight = bl;
    }

    private float getCrossSection(Vector2f vector2f) {
        float f2 = Utils.\u00d300000(vector2f);
        float f3 = Utils.super(f2, this.facing);
        if (f3 > 90.0f) {
            f3 = 180.0f - f3;
        }
        float f4 = (float)Math.cos(f3 * Utils.\u00d3O0000);
        float f5 = (float)Math.sin(f3 * Utils.\u00d3O0000);
        return f4 * this.sprite.getWidth() + f5 * this.sprite.getHeight();
    }

    private float getPerpCrossSection(Vector2f vector2f) {
        float f2 = Utils.\u00d300000(vector2f);
        float f3 = Utils.super(f2, this.facing);
        if (f3 > 90.0f) {
            f3 = 180.0f - f3;
        }
        float f4 = (float)Math.cos(f3 * Utils.\u00d3O0000);
        float f5 = (float)Math.sin(f3 * Utils.\u00d3O0000);
        return f5 * this.sprite.getWidth() + f4 * this.sprite.getHeight();
    }

    public void render(float f2, Color color, float f3, float f4) {
        f3 *= this.fader.getBrightness();
        f3 *= this.extraAlphaMult;
        Vector2f vector2f = this.movementModule.getLocation();
        if (this.member.isFighterWing()) {
            float f5 = this.originLoc.x + vector2f.x;
            float f6 = this.originLoc.y + vector2f.y;
            float f7 = this.member.getHullSpec().getSpriteSpec().\u00d400000() * 4.0f * this.scaleMult;
            Vector2f vector2f2 = new Vector2f(f5, f6);
            int n = 1;
            while (n < this.member.getWingSpec().getNumFighters()) {
                if (!(this.member.getStatus().getStatus(n).getHullFraction() <= 0.0f)) {
                    Vector2f vector2f3 = this.fighterMovement[n].getLocation();
                    this.renderSingle(this.originLoc.x + vector2f3.x, this.originLoc.y + vector2f3.y, f2, color, f3, f4);
                }
                ++n;
            }
            this.renderSingle(this.originLoc.x + vector2f.x, this.originLoc.y + vector2f.y, f2, color, f3, f4);
        } else {
            this.renderSingle(this.originLoc.x + vector2f.x, this.originLoc.y + vector2f.y, f2, color, f3, f4);
        }
    }

    public float getExtraAlphaMult() {
        return this.extraAlphaMult;
    }

    public void setExtraAlphaMult(float f2) {
        this.extraAlphaMult = f2;
    }

    private void renderSingle(float f2, float f3, float f4, Color color, float f5, float f6) {
        float f7;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)f2, (float)f3, (float)0.0f);
        if (this.useLight) {
            this.sprite.setColor(color);
        } else {
            this.sprite.setColor(Color.white);
        }
        float f8 = 1.0f;
        if (this.jitterFader != null) {
            f8 = 1.0f - this.jitterFader.getBrightness();
            f8 *= f8;
        }
        Profiler.\u00d200000((String)"Ship sprite");
        this.sprite.setNormalBlend();
        this.sprite.setAlphaMult(f5 * f8);
        if (this.member.isStation()) {
            this.facing = this.fleet.getFacing();
        }
        this.sprite.setAngle(this.facing - 90.0f);
        this.sprite.renderAtCenter(0.0f, 0.0f);
        if (this.glowColor.isShifted()) {
            this.sprite.setColor(this.glowColor.getCurr());
            this.sprite.setAdditiveBlend();
            this.sprite.setAlphaMult(f5 * f8 * 1.0f);
            this.sprite.renderAtCenter(0.0f, 0.0f);
            this.renderModules();
            if (this.useLight) {
                this.sprite.setColor(color);
            } else {
                this.sprite.setColor(Color.white);
            }
        }
        Profiler.o00000();
        this.renderWindEffect(f5 * f8);
        if (this.useLight && !this.member.isFighterWing() && this.fleet.getFleetView().getLightSource() != null && !this.fleet.getFleetView().getLightSource().hasTag("ambient_ls")) {
            float f9;
            Profiler.\u00d200000((String)"Shadow");
            f7 = f9 = this.shadowMask.getWidth() * 1.41f;
            GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)true);
            GL11.glPushMatrix();
            GL11.glRotatef((float)this.sprite.getAngle(), (float)0.0f, (float)0.0f, (float)1.0f);
            O.\u00d500000(0.0f - f9 / 2.0f - 1.0f, 0.0f - f7 / 2.0f - 1.0f, f9 + 2.0f, f7 + 2.0f, O.o00000, 0.0f);
            GL11.glPopMatrix();
            this.sprite.setBlendFunc(1, 0);
            float f10 = this.sprite.getAlphaMult();
            this.sprite.setAlphaMult(Math.min(this.sprite.getAlphaMult() * 100.0f, 1.0f));
            this.sprite.renderAtCenter(0.0f, 0.0f);
            this.sprite.setAlphaMult(f10);
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            CampaignFleetMemberView.renderWeapons(this.member, 0.0f, 0.0f, this.facing, this.scaleMult, f5 * f8, false);
            this.sprite.setNormalBlend();
            this.renderModules();
            GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)true);
            this.shadowMask.setAlphaMult(Math.min(f5 * f6 * f8 * 100.0f, 1.0f));
            this.shadowMask.setAngle(f4);
            this.shadowMask.setBlendFunc(0, 770);
            this.shadowMask.renderAtCenter(0.0f, 0.0f);
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            this.shadowMask.setBlendFunc(772, 773);
            this.shadowMask.renderAtCenter(0.0f, 0.0f);
            Profiler.o00000();
        } else {
            CampaignFleetMemberView.renderWeapons(this.member, 0.0f, 0.0f, this.facing, this.scaleMult, f5 * f8, false);
            this.sprite.setNormalBlend();
            this.renderModules();
        }
        this.engineGlow.render(this, this.facing, f5 * f8);
        if (this.jitterFader != null) {
            Profiler.\u00d200000((String)"Ship jitter");
            Color color2 = this.sprite.getColor();
            this.sprite.setColor(this.jitterColor);
            this.sprite.setAlphaMult(f5 * (1.0f - f8));
            this.sprite.setAdditiveBlend();
            f7 = this.jitterFader.getBrightness();
            this.jr.render(this.sprite, 0.0f, 0.0f, f7 * this.maxJitterRange, this.jitterCopies);
            this.sprite.setColor(color2);
            Profiler.o00000();
        }
        GL11.glPopMatrix();
    }

    private void renderModules() {
        if (this.member.getSpriteOverride() != null) {
            return;
        }
        float f2 = this.sprite.getWidth() / this.member.getHullSpec().getSpriteSpec().null();
        int n = 0;
        for (B.o o2 : this.moduleIcons) {
            if (++n >= this.member.getStatus().getStatusLength() || this.member.getStatus().getStatus(n).isDetached()) continue;
            interface interface_ = o2.super.getHullSpec().getSpriteSpec();
            o2.\u00d200000.setSize(interface_.null() * f2, interface_.o00000() * f2);
            o2.\u00d200000.setCenter(interface_.class() * f2, interface_.new() * f2);
            o2.\u00d200000.setBlendFunc(this.sprite.getBlendSrc(), this.sprite.getBlendDest());
            o2.\u00d200000.setColor(this.sprite.getColor());
            o2.\u00d200000.setAngle(this.facing - 90.0f + o2.\u00d300000.getAngle());
            o2.\u00d200000.setAlphaMult(this.sprite.getAlphaMult());
            Vector2f vector2f = o2.\u00d300000.computeRelativePosition(this.facing, o2.super.getHullSpec().getModuleAnchor());
            vector2f.scale(f2);
            o2.\u00d200000.renderAtCenter(vector2f.x, vector2f.y);
        }
    }

    public static void renderWeapons(FleetMember fleetMember, float f2, float f3, float f4, float f5, float f6, boolean bl) {
        float f7 = CampaignEngine.getInstance().getCampaignUI().getZoomFactor();
        Sprite sprite = new Sprite();
        for (String string : fleetMember.getVariant().getAllFittedSlots()) {
            BaseWeaponSpec baseWeaponSpec;
            Y y = (Y)fleetMember.getVariant().getSlot(string);
            if (y == null) {
                throw new RuntimeException("Slot id [" + string + "] not found on hull [" + fleetMember.getHullId() + "]");
            }
            if (f7 > 1.2f && !y.isDecorative() && !bl || !y.isDecorative() && !bl || (baseWeaponSpec = fleetMember.getVariant().getWeaponSpec(string)).hasHint(BaseWeaponSpec.o.o00000)) continue;
            boolean bl2 = baseWeaponSpec.hasHint(BaseWeaponSpec.o.Object);
            if (bl2) {
                sprite.setAdditiveBlend();
            } else {
                sprite.setNormalBlend();
            }
            sprite.setAlphaMult(f6);
            Vector2f vector2f = y.computeRelativePosition(f4);
            vector2f.scale(f5);
            if (!y.isHidden()) {
                if (y.isTurret()) {
                    sprite.setTexture(G.\u00d200000((String)baseWeaponSpec.getTurretSpriteName()));
                } else if (y.isHardpoint()) {
                    sprite.setTexture(G.\u00d200000((String)baseWeaponSpec.getHardpointSpriteName()));
                }
                sprite.setSize(sprite.getWidth() * f5, sprite.getHeight() * f5);
                B.o00000(sprite, y);
                sprite.setAngle(f4 + y.getAngle() - 90.0f);
                sprite.renderAtCenter(f2 + vector2f.x, f3 + vector2f.y);
            }
            if (!(baseWeaponSpec instanceof while)) continue;
            while while_ = (while)baseWeaponSpec;
            if (!y.isHidden()) {
                if (y.isTurret()) {
                    sprite.setTexture(G.\u00d200000((String)while_.getTurretGunSpriteName()));
                } else if (y.isHardpoint()) {
                    sprite.setTexture(G.\u00d200000((String)while_.getHardpointGunSpriteName()));
                }
                sprite.setSize(sprite.getWidth() * f5, sprite.getHeight() * f5);
                B.o00000(sprite, y);
                sprite.setAngle(f4 + y.getAngle() - 90.0f);
                sprite.renderAtCenter(f2 + vector2f.x, f3 + vector2f.y);
            }
            boolean bl3 = baseWeaponSpec.hasHint(BaseWeaponSpec.o.\u00d800000);
            if (!y.isHidden()) {
                bl3 |= baseWeaponSpec.hasHint(BaseWeaponSpec.o.\u00d400000);
            }
            if (!bl3) continue;
            int n = B.o00000(y, baseWeaponSpec);
            o00o o00o2 = (o00o)while_.getProjectileSpec();
            int n2 = 0;
            while (n2 < n) {
                sprite.setTexture(G.\u00d200000((String)o00o2.getHullSpec().getSpriteName()));
                sprite.setSize(sprite.getWidth() * f5, sprite.getHeight() * f5);
                sprite.setCenter(o00o2.getHullSpec().getSpriteSpec().class() * f5, o00o2.getHullSpec().getSpriteSpec().new() * f5);
                float f8 = f4 + y.getAngle() + B.Object(y, baseWeaponSpec, n2);
                Vector2f vector2f2 = B.\u00d200000(y, baseWeaponSpec, n2);
                float f9 = (float)Math.cos(Math.toRadians(f8));
                float f10 = (float)Math.sin(Math.toRadians(f8));
                float f11 = vector2f2.x * f9 - vector2f2.y * f10;
                float f12 = vector2f2.x * f10 + vector2f2.y * f9;
                sprite.setAngle(f8 - 90.0f);
                sprite.renderAtCenter(f2 + vector2f.x + (f11 *= f5), f3 + vector2f.y + (f12 *= f5));
                ++n2;
            }
        }
    }

    private void renderWindEffect(float f2) {
        if (!this.windEffectColor.isShifted()) {
            return;
        }
        Vector2f vector2f = new Vector2f(this.windEffectDirX.getCurr(), this.windEffectDirY.getCurr());
        float f3 = vector2f.length();
        if (f3 < 1.0f) {
            return;
        }
        float f4 = Utils.\u00d300000(vector2f);
        this.windEffect.getTexture().\u00d800000();
        Color color = this.windEffectColor.getCurr();
        GL11.glPushMatrix();
        GL11.glRotatef((float)(this.facing - 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)(this.sprite.getWidth() / 2.0f - this.sprite.getCenterX()), (float)(this.sprite.getHeight() / 2.0f - this.sprite.getCenterY()), (float)0.0f);
        GL11.glRotatef((float)(f4 + 180.0f - this.facing + 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        f2 *= 0.67f;
        float f5 = Math.min(this.sprite.getWidth(), this.sprite.getHeight()) / 2.0f;
        float f6 = f5 * f3;
        float f7 = this.getCrossSection(vector2f);
        f5 = f7 * 0.6f;
        float f8 = f6 / (float)this.windEffect.getTexture().\u00d300000();
        GL11.glBegin((int)7);
        OoOO.\u00d200000((Color)color, (float)f2);
        GL11.glTexCoord2f((float)(this.windOffset + f8), (float)0.5f);
        GL11.glVertex2f((float)0.0f, (float)0.0f);
        OoOO.\u00d200000((Color)color, (float)0.0f);
        GL11.glTexCoord2f((float)(this.windOffset + f8), (float)1.0f);
        GL11.glVertex2f((float)0.0f, (float)f5);
        GL11.glTexCoord2f((float)this.windOffset, (float)1.0f);
        GL11.glVertex2f((float)(-f6), (float)(f6 / 2.0f));
        GL11.glTexCoord2f((float)this.windOffset, (float)0.0f);
        GL11.glVertex2f((float)(-f6), (float)0.0f);
        OoOO.\u00d200000((Color)color, (float)f2);
        GL11.glTexCoord2f((float)(this.windOffset + f8), (float)0.5f);
        GL11.glVertex2f((float)0.0f, (float)0.0f);
        OoOO.\u00d200000((Color)color, (float)0.0f);
        GL11.glTexCoord2f((float)(this.windOffset + f8), (float)0.0f);
        GL11.glVertex2f((float)0.0f, (float)(-f5));
        GL11.glTexCoord2f((float)this.windOffset, (float)1.0f);
        GL11.glVertex2f((float)(-f6), (float)(-f6 / 2.0f));
        GL11.glTexCoord2f((float)this.windOffset, (float)0.0f);
        GL11.glVertex2f((float)(-f6), (float)0.0f);
        float f9 = f5 / (float)this.windEffect.getTexture().\u00d300000();
        f9 *= 0.5f;
        OoOO.\u00d200000((Color)color, (float)f2);
        GL11.glTexCoord2f((float)(this.windOffset + f8), (float)0.5f);
        GL11.glVertex2f((float)0.0f, (float)0.0f);
        OoOO.\u00d200000((Color)color, (float)0.0f);
        GL11.glTexCoord2f((float)(this.windOffset + f8), (float)1.0f);
        GL11.glVertex2f((float)0.0f, (float)f5);
        GL11.glTexCoord2f((float)(this.windOffset + f8 + f9), (float)1.0f);
        GL11.glVertex2f((float)(f5 / 2.0f), (float)(f5 / 2.0f));
        GL11.glTexCoord2f((float)(this.windOffset + f8 + f9), (float)0.0f);
        GL11.glVertex2f((float)(f5 / 2.0f), (float)0.0f);
        OoOO.\u00d200000((Color)color, (float)f2);
        GL11.glTexCoord2f((float)(this.windOffset + f8), (float)0.5f);
        GL11.glVertex2f((float)0.0f, (float)0.0f);
        OoOO.\u00d200000((Color)color, (float)0.0f);
        GL11.glTexCoord2f((float)(this.windOffset + f8), (float)1.0f);
        GL11.glVertex2f((float)0.0f, (float)(-f5));
        GL11.glTexCoord2f((float)(this.windOffset + f8 + f9), (float)1.0f);
        GL11.glVertex2f((float)(f5 / 2.0f), (float)(-f5 / 2.0f));
        GL11.glTexCoord2f((float)(this.windOffset + f8 + f9), (float)0.0f);
        GL11.glVertex2f((float)(f5 / 2.0f), (float)0.0f);
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    public ColorShifter getWindEffectColor() {
        return this.windEffectColor;
    }

    public ValueShifter getWindEffectDirX() {
        return this.windEffectDirX;
    }

    public ValueShifter getWindEffectDirY() {
        return this.windEffectDirY;
    }

    public boolean isExpired() {
        return this.fader.isIdle() && this.fader.getBrightness() == 0.0f;
    }

    public void notifyOrphaned() {
        this.fader.fadeOut();
    }

    public void setOrigin(float f2, float f3, float f4) {
        this.originLoc.set(f2, f3);
        this.originFacing = f4;
    }

    public void setFacing(float f2) {
        this.facing = f2;
        this.facingModule.setFacing(f2);
    }

    public int getRenderOrder() {
        return 10 - (int)this.shipSizeOrdinal;
    }

    public FleetMember getMember() {
        return this.member;
    }

    public Object getItem() {
        return this.member;
    }

    public void showExplosionFlash() {
        DelayedFlash delayedFlash = new DelayedFlash(this.shadowMask.getWidth() * 5.0f, this.fleet, this.movementModule, this.member);
        delayedFlash.setDuration((float)Math.random() * 1.0f);
        CampaignEngine.getInstance().getAnimationManager().addAnimation((Animation)delayedFlash);
    }

    public Vector2f getAbsoluteLocation() {
        Vector2f vector2f = this.movementModule.getLocation();
        float f2 = this.fleet.getLocation().x + vector2f.x;
        float f3 = this.fleet.getLocation().y + vector2f.y;
        Vector2f vector2f2 = new Vector2f(f2, f3);
        return vector2f2;
    }

    public Vector2f getAbsoluteVelocity() {
        Vector2f vector2f = Vector2f.add((Vector2f)this.movementModule.getVelocity(), (Vector2f)this.fleet.getMovementModule().getVelocity(), (Vector2f)new Vector2f());
        return vector2f;
    }

    private static class DelayedFlash
    extends BaseAnimation
    implements DoNotObfuscate {
        private float size;
        private SmoothMovementModule movementModule;
        private FleetMember member;
        private CampaignFleet fleet;

        public DelayedFlash(float f2, CampaignFleet campaignFleet, SmoothMovementModule smoothMovementModule, FleetMember fleetMember) {
            this.movementModule = smoothMovementModule;
            this.member = fleetMember;
            this.size = f2;
            this.fleet = campaignFleet;
        }

        public void finished() {
            if (CampaignEngine.getInstance().getCurrentLocation() != this.fleet.getContainingLocation()) {
                return;
            }
            Vector2f vector2f = this.movementModule.getLocation();
            float f2 = this.fleet.getLocation().x + vector2f.x;
            float f3 = this.fleet.getLocation().y + vector2f.y;
            Color color = this.member.getHullSpec().getHullStyle().new();
            Vector2f vector2f2 = Vector2f.add((Vector2f)this.movementModule.getVelocity(), (Vector2f)this.fleet.getMovementModule().getVelocity(), (Vector2f)new Vector2f());
            vector2f2.set(0.0f, 0.0f);
            Vector2f vector2f3 = new Vector2f(f2, f3);
            this.fleet.getContainingLocation().addHitParticle(vector2f3, vector2f2, this.size, 0.4f, 1.0f + (float)Math.random(), color);
            this.fleet.getContainingLocation().addHitParticle(vector2f3, vector2f2, this.size * 0.25f, 0.4f, 1.0f + (float)Math.random(), color);
            this.fleet.getContainingLocation().addHitParticle(vector2f3, vector2f2, this.size * 0.15f, 1.0f, 1.0f + (float)Math.random(), Color.white);
            L.o00000("explosion_fleet_member", 1.0f, 0.5f + (float)Math.random() * 0.5f, vector2f3, vector2f2);
        }
    }
}

