/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.fleet;

import com.fs.profiler.Profiler;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.campaign.fleet.CampaignFleet;
import com.fs.starfarer.campaign.fleet.CampaignFleetMemberView;
import com.fs.starfarer.campaign.fleet.ContrailEngineV2;
import com.fs.starfarer.campaign.fleet.FleetMember;
import com.fs.starfarer.campaign.util.CollectionView;
import com.fs.starfarer.prototype.Utils;
import com.fs.util.DoNotObfuscate;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CampaignFleetView
implements CollectionView.CollectionViewDelegate<CampaignFleetMemberView>,
DoNotObfuscate,
Cloneable {
    private CampaignFleet fleet;
    private CollectionView<CampaignFleetMemberView> shipViews;
    private SectorEntityToken lightSource;
    private Color lightColor;
    private ContrailEngineV2 contrails = new ContrailEngineV2();

    protected CampaignFleetView clone() {
        try {
            return (CampaignFleetView)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public CampaignFleetView(CampaignFleet campaignFleet) {
        this.fleet = campaignFleet;
        this.shipViews = new CollectionView<CampaignFleetMemberView>(this);
    }

    Object readResolve() {
        return this;
    }

    Object writeReplace() {
        if (this.contrails != null && this.contrails.getContrails().isEmpty()) {
            this.contrails = null;
        }
        if (!this.fleet.isInCurrentLocation()) {
            this.contrails = null;
        }
        if (this.contrails != null) {
            float f2 = 0.0f;
            float f3 = 0.0f;
            int n = 0;
            for (ContrailEngineV2.Contrail contrail : this.contrails.getContrails().values()) {
                float f4 = 0.0f;
                for (ContrailEngineV2.ContrailPoint contrailPoint : contrail.points) {
                    float f5;
                    if (contrailPoint.distToPrev < 100.0f) {
                        f4 += contrailPoint.distToPrev;
                    }
                    if (!((f5 = contrailPoint.maxBrightness) > f3)) continue;
                    f3 = f5;
                }
                if (f4 > f2) {
                    f2 = f4;
                }
                n += contrail.points.size();
            }
        }
        return this;
    }

    public void setLightSource(SectorEntityToken sectorEntityToken, Color color) {
        this.lightSource = sectorEntityToken;
        this.lightColor = color;
    }

    public SectorEntityToken getLightSource() {
        return this.lightSource;
    }

    public ContrailEngineV2 getContrails() {
        if (this.contrails == null) {
            this.contrails = new ContrailEngineV2();
        }
        return this.contrails;
    }

    public CampaignFleet getFleet() {
        return this.fleet;
    }

    public CampaignFleetMemberView getViewForMember(FleetMember fleetMember) {
        return this.shipViews.getViewForItem(fleetMember);
    }

    public Collection<CampaignFleetMemberView> getViews() {
        return this.shipViews.getViews();
    }

    public int getNumVisibleShips() {
        return this.shipViews.getViews().size();
    }

    public void advance(float f2) {
        Profiler.\u00d200000((String)"Deciding what to show");
        ArrayList<FleetMember> arrayList = new ArrayList<FleetMember>();
        List<FleetMember> list = this.fleet.getSortedMembers();
        int n = 20;
        int n2 = Math.max(0, this.fleet.getSortedMembers().size() - n);
        int n3 = 7;
        int n4 = 0;
        while (n4 < list.size()) {
            FleetMember object = list.get(n4);
            arrayList.add(object);
            if (n4 == n3) {
                n4 += n2;
            }
            ++n4;
        }
        Profiler.o00000();
        Profiler.\u00d200000((String)"Syncing");
        this.shipViews.sync(arrayList);
        this.shipViews.finishSync();
        Profiler.o00000();
        float f3 = f2;
        for (CampaignFleetMemberView campaignFleetMemberView : this.shipViews.getViews()) {
            campaignFleetMemberView.advance(f3, this);
        }
        if (this.contrails != null) {
            Profiler.\u00d200000((String)"Contrails");
            this.contrails.advance(f2);
            Profiler.o00000();
        }
    }

    public void render(float f2) {
        float f3 = this.fleet.getFacing();
        boolean bl = this.lightSource != null;
        float f4 = 0.0f;
        float f5 = 1.0f;
        if (bl) {
            f4 = Utils.\u00d500000(this.fleet.getLocation(), this.lightSource.getLocation());
            float f6 = Utils.void(this.fleet.getLocation(), this.lightSource.getLocation());
            if (f6 < 500.0f) {
                f5 = f6 / 500.0f;
            }
        }
        for (CampaignFleetMemberView campaignFleetMemberView : this.shipViews.getViews()) {
            campaignFleetMemberView.setOrigin(0.0f, 0.0f, f3);
            if (bl) {
                campaignFleetMemberView.setUseLight(true);
            } else {
                campaignFleetMemberView.setUseLight(false);
            }
            campaignFleetMemberView.render(f4, this.lightColor, f2, f5);
        }
    }

    public void renderContrails(float f2) {
        if (this.contrails != null) {
            this.contrails.render(f2);
        }
    }

    @Override
    public CampaignFleetMemberView createItemView(Object object) {
        if (object instanceof FleetMember) {
            CampaignFleetMemberView campaignFleetMemberView = new CampaignFleetMemberView(this.fleet, (FleetMember)object);
            return campaignFleetMemberView;
        }
        return null;
    }

    @Override
    public boolean shouldCreateViewFor(Object object) {
        return true;
    }

    public void clear() {
        this.shipViews.clear();
        if (this.contrails != null) {
            this.contrails.clear();
            this.contrails = null;
        }
    }
}

