/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.fleet;

import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.campaign.SubmarketPlugin;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.util.MutableValue;
import com.fs.starfarer.campaign.Faction;
import com.fs.starfarer.campaign.FactionManager;
import com.fs.starfarer.campaign.econ.Submarket;
import com.fs.starfarer.campaign.fleet.FleetData;
import com.fs.starfarer.campaign.fleet.FleetMember;
import com.fs.starfarer.campaign.ui.trade.CargoItemStack;
import com.fs.starfarer.loading.F;
import com.fs.starfarer.loading.SpecStore;
import com.fs.starfarer.loading.X;
import com.fs.starfarer.loading.specs.BaseWeaponSpec;
import com.fs.starfarer.loading.specs.FighterWingSpec;
import com.fs.starfarer.loading.specs.HullVariantSpec;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CargoData
implements CargoAPI,
DoNotObfuscate {
    public static final String FUEL_ID = "fuel";
    public static final String SUPPLIES_ID = "supplies";
    public static final String MARINES_ID = "marines";
    private static final CargoItemStack NULL_STACK = new CargoItemStack(CargoAPI.CargoItemType.NULL, null);
    private ArrayList<CargoItemStack> stacks = new ArrayList();
    private MutableValue credits = new MutableValue();
    private boolean unlimitedStacks;
    private float maxCapacity = 1000.0f;
    private float spaceUsed = 50.0f;
    private float maxFuel = 500.0f;
    private float maxPersonnel = 750.0f;
    private FleetData carryingFleet = null;
    private FleetData mothballedShips = null;
    private boolean freeTransfer = false;
    private CargoAPI origSource = null;
    private Map<String, Float> partials = null;
    private transient float extraCargoUsed = 0.0f;
    private transient float extraFuelUsed = 0.0f;
    private transient float extraCrewUsed = 0.0f;
    private transient float extraMarinesUsed = 0.0f;
    private transient float extraSuppliesUsed = 0.0f;

    public static CargoData createCopyWithSameStacks(CargoAPI cargoAPI) {
        CargoData cargoData = new CargoData(false);
        if (cargoAPI instanceof CargoData) {
            cargoData.setUnlimitedStacks(((CargoData)cargoAPI).isUnlimitedStacks());
            for (CargoItemStack cargoItemStack : ((CargoData)cargoAPI).getStacks()) {
                cargoData.addItems(cargoItemStack.getType(), cargoItemStack.getData(), cargoItemStack.getSize());
            }
        } else {
            for (CargoAPI.CargoItemQuantity cargoItemQuantity : cargoAPI.getWeapons()) {
                cargoData.addItems(CargoAPI.CargoItemType.WEAPONS, cargoItemQuantity.getItem(), cargoItemQuantity.getCount());
            }
            for (CargoAPI.CargoItemQuantity cargoItemQuantity : cargoAPI.getFighters()) {
                cargoData.addItems(CargoAPI.CargoItemType.FIGHTER_CHIP, cargoItemQuantity.getItem(), cargoItemQuantity.getCount());
            }
        }
        return cargoData;
    }

    public CargoAPI createCopy() {
        CargoData cargoData = new CargoData(false);
        cargoData.setUnlimitedStacks(this.isUnlimitedStacks());
        for (CargoItemStack cargoItemStack : this.getStacks()) {
            cargoData.addItems(cargoItemStack.getType(), cargoItemStack.getData(), cargoItemStack.getSize());
        }
        return cargoData;
    }

    public CargoData(boolean bl) {
        this.unlimitedStacks = bl = true;
    }

    public boolean isUnlimitedStacks() {
        return this.unlimitedStacks;
    }

    public void setUnlimitedStacks(boolean bl) {
        this.unlimitedStacks = bl;
    }

    public FleetData getMothballedShips() {
        return this.mothballedShips;
    }

    public void setMothballedShips(FleetData fleetData) {
        this.mothballedShips = fleetData;
    }

    public void initMothballedShips(String string) {
        if (this.mothballedShips == null) {
            Faction faction = FactionManager.getInstance().getFaction(string);
            this.mothballedShips = new FleetData(faction.getShipNamePrefix(), faction.getId());
        }
    }

    public void addMothballedShip(FleetMemberType fleetMemberType, String string, String string2) {
        this.initMothballedShips("independent");
        if (string2 == null) {
            FleetMember fleetMember = new FleetMember(0, string, fleetMemberType);
            fleetMember.getRepairTracker().setMothballed(true);
            this.mothballedShips.addFleetMember(fleetMember);
        } else {
            FleetMember fleetMember = new FleetMember(0, string, fleetMemberType, string2);
            fleetMember.getRepairTracker().setMothballed(true);
            this.mothballedShips.addFleetMember(fleetMember);
        }
    }

    public void addAll(CargoAPI cargoAPI) {
        this.addAll(cargoAPI, false);
    }

    public void addAll(CargoAPI cargoAPI, boolean bl) {
        for (CargoStackAPI cargoStackAPI : cargoAPI.getStacksCopy()) {
            this.addFromStack(cargoStackAPI);
        }
        if (bl && cargoAPI.getMothballedShips() != null && !cargoAPI.getMothballedShips().getMembersListCopy().isEmpty()) {
            if (this.getMothballedShips() == null) {
                this.initMothballedShips("independent");
            }
            for (CargoStackAPI cargoStackAPI : cargoAPI.getMothballedShips().getMembersListCopy()) {
                this.getMothballedShips().addFleetMember((FleetMemberAPI)cargoStackAPI);
            }
        }
    }

    public void removeAll(CargoAPI cargoAPI) {
        for (CargoStackAPI cargoStackAPI : cargoAPI.getStacksCopy()) {
            this.removeItems(cargoStackAPI.getType(), cargoStackAPI.getData(), cargoStackAPI.getSize());
        }
    }

    public void setFleetData(FleetData fleetData) {
        this.carryingFleet = fleetData;
    }

    public FleetData getFleetData() {
        return this.carryingFleet;
    }

    public boolean isEmpty() {
        if (this.stacks.isEmpty()) {
            return true;
        }
        for (CargoItemStack cargoItemStack : this.stacks) {
            if (cargoItemStack.isNull()) continue;
            return false;
        }
        return true;
    }

    public float getSupplies() {
        return this.getItemQuantity(CargoAPI.CargoItemType.RESOURCES, SUPPLIES_ID) + (float)((int)this.extraSuppliesUsed);
    }

    public float getFuel() {
        return this.getItemQuantity(CargoAPI.CargoItemType.RESOURCES, FUEL_ID) + this.extraFuelUsed;
    }

    public int getTotalCrew() {
        return this.getCrew() + (int)this.extraCrewUsed;
    }

    public int getTotalPersonnel() {
        return this.getTotalCrew() + this.getMarines();
    }

    public int getFreeCrewSpace() {
        return (int)(this.getMaxPersonnel() - (float)this.getTotalPersonnel());
    }

    public int getFreeFuelSpace() {
        return (int)(this.getMaxFuel() - this.getFuel());
    }

    public void addCrew(int n) {
        this.addItems(CargoAPI.CargoItemType.RESOURCES, "crew", n);
    }

    public void removeCrew(int n) {
        this.removeItems(CargoAPI.CargoItemType.RESOURCES, "crew", n);
    }

    public int getCrew() {
        return (int)this.getItemQuantity(CargoAPI.CargoItemType.RESOURCES, "crew");
    }

    public int getMarines() {
        return (int)this.getItemQuantity(CargoAPI.CargoItemType.RESOURCES, MARINES_ID) + (int)this.extraMarinesUsed;
    }

    public void addMarines(int n) {
        this.addItems(CargoAPI.CargoItemType.RESOURCES, MARINES_ID, n);
    }

    public void removeMarines(int n) {
        this.removeItems(CargoAPI.CargoItemType.RESOURCES, MARINES_ID, n);
    }

    public void addFuel(float f2) {
        this.addItems(CargoAPI.CargoItemType.RESOURCES, FUEL_ID, f2);
    }

    public void removeFuel(float f2) {
        this.removeItems(CargoAPI.CargoItemType.RESOURCES, FUEL_ID, f2);
    }

    public void addSupplies(float f2) {
        this.addItems(CargoAPI.CargoItemType.RESOURCES, SUPPLIES_ID, f2);
    }

    public void removeSupplies(float f2) {
        this.removeItems(CargoAPI.CargoItemType.RESOURCES, SUPPLIES_ID, f2);
    }

    public void addWeapons(String string, int n) {
        this.addItems(CargoAPI.CargoItemType.WEAPONS, string, n);
    }

    public void addFighters(String string, int n) {
        this.addItems(CargoAPI.CargoItemType.FIGHTER_CHIP, string, n);
    }

    public void removeFighters(String string, int n) {
        this.removeItems(CargoAPI.CargoItemType.FIGHTER_CHIP, string, n);
    }

    public void addHullmods(String string, int n) {
        this.addItems(CargoAPI.CargoItemType.SPECIAL, new SpecialItemData("modspec", string), n);
    }

    public void removeWeapons(String string, int n) {
        this.removeItems(CargoAPI.CargoItemType.WEAPONS, string, n);
    }

    public int getNumWeapons(String string) {
        return (int)this.getItemQuantity(CargoAPI.CargoItemType.WEAPONS, string);
    }

    public int getNumFighters(String string) {
        return (int)this.getItemQuantity(CargoAPI.CargoItemType.FIGHTER_CHIP, string);
    }

    public void removeEmptyStacks() {
        Iterator<CargoItemStack> iterator = this.stacks.iterator();
        while (iterator.hasNext()) {
            CargoItemStack cargoItemStack = iterator.next();
            if (cargoItemStack.isNull()) {
                iterator.remove();
                continue;
            }
            if (!cargoItemStack.isEmpty()) continue;
            iterator.remove();
        }
    }

    public CargoAPI getOrigSource() {
        return this.origSource;
    }

    public void setOrigSource(CargoAPI cargoAPI) {
        this.origSource = cargoAPI;
    }

    public void sort() {
        this.sort(null, SubmarketPlugin.TransferAction.PLAYER_BUY);
    }

    public void sort(final Submarket submarket, final SubmarketPlugin.TransferAction transferAction) {
        Cloneable cloneable;
        Iterator<CargoItemStack> iterator = this.stacks.iterator();
        while (iterator.hasNext()) {
            cloneable = iterator.next();
            if (!((CargoItemStack)cloneable).isNull()) continue;
            iterator.remove();
        }
        cloneable = new ArrayList<CargoItemStack>(this.stacks);
        this.stacks.clear();
        Iterator<Object> iterator2 = cloneable.iterator();
        while (iterator2.hasNext()) {
            CargoItemStack cargoItemStack = (CargoItemStack)iterator2.next();
            this.addItems(cargoItemStack.getType(), cargoItemStack.getData(), cargoItemStack.getSize());
        }
        for (CargoItemStack cargoItemStack : this.stacks) {
            cargoItemStack.setCargo((CargoAPI)(this.origSource != null ? this.origSource : this));
        }
        Collections.sort(this.stacks, new Comparator<CargoItemStack>(){
            private static /* synthetic */ int[] $SWITCH_TABLE$com$fs$starfarer$api$campaign$CargoAPI$CargoItemType;

            public int super(CargoItemStack cargoItemStack, CargoItemStack cargoItemStack2) {
                SubmarketPlugin submarketPlugin = null;
                if (submarket != null) {
                    submarketPlugin = submarket.getPlugin();
                }
                if (submarketPlugin != null) {
                    boolean bl = submarketPlugin.isIllegalOnSubmarket((CargoStackAPI)cargoItemStack, transferAction);
                    boolean bl2 = submarketPlugin.isIllegalOnSubmarket((CargoStackAPI)cargoItemStack2, transferAction);
                    if (bl && !bl2) {
                        return 1;
                    }
                    if (!bl && bl2) {
                        return -1;
                    }
                }
                CargoAPI.CargoItemType cargoItemType = cargoItemStack.getType();
                CargoAPI.CargoItemType cargoItemType2 = cargoItemStack2.getType();
                int n = cargoItemType.ordinal() - cargoItemType2.ordinal();
                if (n != 0) {
                    return n;
                }
                switch (1.super()[cargoItemType.ordinal()]) {
                    case 2: {
                        BaseWeaponSpec baseWeaponSpec = cargoItemStack.getWeaponIfWeapon();
                        BaseWeaponSpec baseWeaponSpec2 = cargoItemStack2.getWeaponIfWeapon();
                        n = baseWeaponSpec2.getSize().ordinal() - baseWeaponSpec.getSize().ordinal();
                        if (n != 0) {
                            return n;
                        }
                        n = (int)Math.signum(cargoItemStack2.getSize() - cargoItemStack.getSize());
                        if (n != 0) {
                            return n;
                        }
                        if (baseWeaponSpec2.getWeaponId().equals(baseWeaponSpec.getWeaponId())) {
                            return (int)Math.signum(cargoItemStack2.getSize() - cargoItemStack.getSize());
                        }
                        return baseWeaponSpec.getWeaponName().compareTo(baseWeaponSpec2.getWeaponName());
                    }
                    case 1: {
                        F f2 = cargoItemStack.getResourceIfResource();
                        F f3 = cargoItemStack2.getResourceIfResource();
                        if (f3.getId().equals(f2.getId())) {
                            return (int)Math.signum(cargoItemStack2.getSize() - cargoItemStack.getSize());
                        }
                        return new Float(f2.getOrder()).compareTo(new Float(f3.getOrder()));
                    }
                    case 3: {
                        FighterWingSpec fighterWingSpec = cargoItemStack.getFighterWingSpecIfWing();
                        FighterWingSpec fighterWingSpec2 = cargoItemStack2.getFighterWingSpecIfWing();
                        HullVariantSpec hullVariantSpec = SpecStore.o00000(HullVariantSpec.class, fighterWingSpec.getVariantId());
                        HullVariantSpec hullVariantSpec2 = SpecStore.o00000(HullVariantSpec.class, fighterWingSpec2.getVariantId());
                        return hullVariantSpec.getHullSpec().getHullName().compareTo(hullVariantSpec2.getHullSpec().getHullName());
                    }
                    case 4: {
                        X x2 = cargoItemStack.getSpecialItemSpecIfSpecial();
                        X x3 = cargoItemStack2.getSpecialItemSpecIfSpecial();
                        if (x3.getId().equals(x2.getId())) {
                            return (int)Math.signum(cargoItemStack2.getSize() - cargoItemStack.getSize());
                        }
                        return new Float(x2.getOrder()).compareTo(new Float(x3.getOrder()));
                    }
                }
                return 0;
            }

            static /* synthetic */ int[] super() {
                if ($SWITCH_TABLE$com$fs$starfarer$api$campaign$CargoAPI$CargoItemType != null) {
                    return $SWITCH_TABLE$com$fs$starfarer$api$campaign$CargoAPI$CargoItemType;
                }
                int[] nArray = new int[CargoAPI.CargoItemType.values().length];
                try {
                    nArray[CargoAPI.CargoItemType.FIGHTER_CHIP.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[CargoAPI.CargoItemType.NULL.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[CargoAPI.CargoItemType.RESOURCES.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[CargoAPI.CargoItemType.SPECIAL.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[CargoAPI.CargoItemType.WEAPONS.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                $SWITCH_TABLE$com$fs$starfarer$api$campaign$CargoAPI$CargoItemType = nArray;
                return nArray;
            }
        });
        if (this.mothballedShips != null) {
            this.mothballedShips.sort();
        }
    }

    public float getMaxCapacity() {
        return (int)this.maxCapacity;
    }

    public float getMaxFuel() {
        return (int)this.maxFuel;
    }

    public void setMaxFuel(float f2) {
        this.maxFuel = f2;
    }

    public float getMaxPersonnel() {
        return (int)this.maxPersonnel;
    }

    public void setMaxPersonnel(float f2) {
        this.maxPersonnel = f2;
    }

    public void setMaxCapacity(float f2) {
        this.maxCapacity = f2;
    }

    public float getSpaceUsed() {
        return this.spaceUsed;
    }

    public float getSpaceLeft() {
        return Math.max(0.0f, this.maxCapacity - this.spaceUsed);
    }

    public void updateSpaceUsed() {
        float f2 = 0.0f;
        for (CargoItemStack cargoItemStack : this.stacks) {
            f2 += cargoItemStack.getCargoSpace();
        }
        this.spaceUsed = f2 + this.extraCargoUsed;
    }

    public void clear() {
        this.stacks.clear();
        this.updateSpaceUsed();
    }

    public CargoItemStack findStack(CargoAPI.CargoItemType cargoItemType, Object object) {
        CargoItemStack cargoItemStack = null;
        for (CargoItemStack cargoItemStack2 : this.stacks) {
            if (cargoItemStack2.getType() != cargoItemType || object != null && !object.equals(cargoItemStack2.getData()) || cargoItemStack != null && !(cargoItemStack.getSize() > cargoItemStack2.getSize())) continue;
            cargoItemStack = cargoItemStack2;
        }
        return cargoItemStack;
    }

    public List<CargoItemStack> findAllStacks(CargoAPI.CargoItemType cargoItemType, Object object) {
        ArrayList<CargoItemStack> arrayList = new ArrayList<CargoItemStack>();
        for (CargoItemStack cargoItemStack : this.stacks) {
            if (cargoItemStack.getType() != cargoItemType || object != null && !object.equals(cargoItemStack.getData())) continue;
            arrayList.add(cargoItemStack);
        }
        return arrayList;
    }

    public float getItemQuantity(CargoAPI.CargoItemType cargoItemType, Object object) {
        float f2 = 0.0f;
        for (CargoItemStack cargoItemStack : this.stacks) {
            if (cargoItemStack.getType() != cargoItemType || object != null && !object.equals(cargoItemStack.getData())) continue;
            f2 += cargoItemStack.getSize();
        }
        return f2;
    }

    public CargoItemStack getStackAtIndex(int n) {
        if (n < 0 || n >= this.stacks.size()) {
            return null;
        }
        CargoItemStack cargoItemStack = this.stacks.get(n);
        if (cargoItemStack == NULL_STACK) {
            return null;
        }
        return cargoItemStack;
    }

    public void setStackAtIndex(CargoItemStack cargoItemStack, int n) {
        int n2 = 0;
        while (n2 < n + 1) {
            if (n2 >= this.stacks.size()) {
                this.stacks.add(NULL_STACK);
            }
            ++n2;
        }
        this.stacks.set(n, cargoItemStack);
        cargoItemStack.setCargo((CargoAPI)(this.origSource != null ? this.origSource : this));
        this.updateSpaceUsed();
    }

    public void removeStackAtIndex(int n) {
        if (n >= this.stacks.size()) {
            return;
        }
        if (n < 0) {
            return;
        }
        this.stacks.set(n, NULL_STACK);
        this.updateSpaceUsed();
    }

    public void removeStack(CargoStackAPI cargoStackAPI) {
        this.stacks.remove(cargoStackAPI);
        this.updateSpaceUsed();
    }

    public int getIndexOfStack(CargoItemStack cargoItemStack) {
        return this.stacks.indexOf(cargoItemStack);
    }

    public void addFromStack(CargoStackAPI cargoStackAPI) {
        this.addItems(cargoStackAPI.getType(), cargoStackAPI.getData(), cargoStackAPI.getSize());
    }

    public void addStack(CargoItemStack cargoItemStack) {
        int n = this.findFirstUnusedIndex();
        this.stacks.set(n, cargoItemStack);
        cargoItemStack.setCargo((CargoAPI)(this.origSource != null ? this.origSource : this));
        if (this.partials != null && cargoItemStack.getType() == CargoAPI.CargoItemType.RESOURCES) {
            String string = String.valueOf(cargoItemStack.getType().name()) + cargoItemStack.getData().toString();
            float f2 = cargoItemStack.getSize() - (float)((int)cargoItemStack.getSize());
            float f3 = this.getPartial(string) + f2;
            if (f3 >= 1.0f) {
                cargoItemStack.setSize(cargoItemStack.getSize() + (float)((int)f3));
                this.setPartial(string, f3 - (float)((int)f3));
            } else {
                this.setPartial(string, f3);
            }
        }
        this.updateSpaceUsed();
    }

    public int findFirstUnusedIndex() {
        int n = 0;
        while (n < this.stacks.size()) {
            if (this.stacks.get(n) == NULL_STACK || this.stacks.get(n) == null || this.stacks.get(n).getSize() <= 0.0f) {
                return n;
            }
            ++n;
        }
        this.stacks.add(NULL_STACK);
        return this.stacks.size() - 1;
    }

    public void initPartialsIfNeeded() {
        if (this.partials == null) {
            this.partials = new HashMap<String, Float>();
        }
    }

    public float getPartial(String string) {
        if (this.partials == null) {
            return 0.0f;
        }
        Float f2 = this.partials.get(string);
        if (f2 == null) {
            return 0.0f;
        }
        return f2.floatValue();
    }

    private void setPartial(String string, float f2) {
        if (this.partials == null) {
            return;
        }
        if (f2 == 0.0f) {
            this.partials.remove(string);
        } else {
            this.partials.put(string, Float.valueOf(f2));
        }
    }

    public void addCommodity(String string, float f2) {
        this.addItems(CargoAPI.CargoItemType.RESOURCES, string, f2);
    }

    public void addSpecial(SpecialItemData specialItemData, float f2) {
        this.addItems(CargoAPI.CargoItemType.SPECIAL, specialItemData, f2);
    }

    public void addItems(CargoAPI.CargoItemType cargoItemType, Object object, float f2) {
        float f3;
        float f4;
        Object object2;
        if (f2 <= 0.0f) {
            return;
        }
        if (cargoItemType == CargoAPI.CargoItemType.NULL) {
            return;
        }
        if (this.partials != null && cargoItemType == CargoAPI.CargoItemType.RESOURCES) {
            object2 = String.valueOf(cargoItemType.name()) + object.toString();
            f4 = f2 - (float)((int)f2);
            f3 = this.getPartial((String)object2) + f4;
            f2 = (int)f2;
            if (f3 >= 1.0f) {
                f2 += (float)((int)f3);
                this.setPartial((String)object2, f3 - (float)((int)f3));
            } else {
                this.setPartial((String)object2, f3);
            }
            if (f2 <= 0.0f) {
                return;
            }
        }
        if (this.carryingFleet != null && object instanceof String && f2 > 0.0f && ((String)(object2 = (String)object)).equals("crew")) {
            this.carryingFleet.setSyncNeeded();
        }
        do {
            if ((object2 = this.findStack(cargoItemType, object)) == null || ((CargoItemStack)object2).isFull()) {
                if (f2 < 1.0f) break;
                object2 = new CargoItemStack(cargoItemType, object, this);
                if (this.unlimitedStacks) {
                    ((CargoItemStack)object2).setMaxSize(1000000);
                }
                if (cargoItemType == CargoAPI.CargoItemType.WEAPONS || cargoItemType == CargoAPI.CargoItemType.SPECIAL || cargoItemType == CargoAPI.CargoItemType.FIGHTER_CHIP) {
                    ((CargoItemStack)object2).setRoundSize(true);
                }
                this.addStack((CargoItemStack)object2);
            }
            f4 = ((CargoItemStack)object2).getFree();
            f3 = Math.min(f4, f2);
            ((CargoItemStack)object2).setSize(Math.min(((CargoItemStack)object2).getMaxSize(), ((CargoItemStack)object2).getSize() + f3));
        } while ((f2 -= f3) >= 1.0f);
        this.updateSpaceUsed();
    }

    public float getQuantity(CargoAPI.CargoItemType cargoItemType, Object object) {
        float f2 = 0.0f;
        for (CargoItemStack cargoItemStack : this.stacks) {
            if (cargoItemStack.getType() != cargoItemType || object != null && !object.equals(cargoItemStack.getData())) continue;
            f2 += cargoItemStack.getSize();
        }
        return f2;
    }

    public float getCommodityQuantity(String string) {
        return this.getQuantity(CargoAPI.CargoItemType.RESOURCES, string);
    }

    public void removeCommodity(String string, float f2) {
        this.removeItems(CargoAPI.CargoItemType.RESOURCES, string, f2);
    }

    public boolean removeItems(CargoAPI.CargoItemType cargoItemType, Object object, float f2) {
        float f3;
        float f4;
        Object object2;
        if (f2 <= 0.0f) {
            return true;
        }
        if (cargoItemType == CargoAPI.CargoItemType.NULL) {
            return false;
        }
        if (this.partials != null && cargoItemType == CargoAPI.CargoItemType.RESOURCES) {
            object2 = String.valueOf(cargoItemType.name()) + object.toString();
            f4 = f2 - (float)((int)f2);
            f3 = f4 - this.getPartial((String)object2);
            f2 = (int)f2;
            if (f3 >= 1.0f) {
                f2 += (float)((int)f3);
                this.setPartial((String)object2, -(f3 - (float)((int)f3)));
            } else {
                this.setPartial((String)object2, -f3);
            }
            if (f2 <= 0.0f) {
                return true;
            }
        }
        if (this.carryingFleet != null && object instanceof String && f2 > 0.0f && ((String)(object2 = (String)object)).equals("crew")) {
            this.carryingFleet.setSyncNeeded();
        }
        while (f2 > 0.0f) {
            object2 = this.findStack(cargoItemType, object);
            if (object2 == null || ((CargoItemStack)object2).isNull()) {
                return false;
            }
            f4 = ((CargoItemStack)object2).getSize();
            f3 = Math.min(f4, f2);
            ((CargoItemStack)object2).setSize(Math.max(0.0f, ((CargoItemStack)object2).getSize() - f3));
            if (((CargoItemStack)object2).getSize() < 1.0f) {
                this.stacks.set(this.stacks.indexOf(object2), NULL_STACK);
            }
            f2 -= f3;
        }
        this.updateSpaceUsed();
        return true;
    }

    public List<CargoAPI.CargoItemQuantity<String>> getWeapons() {
        List<CargoItemStack> list = this.findAllStacks(CargoAPI.CargoItemType.WEAPONS, null);
        HashSet<String> hashSet = new HashSet<String>();
        for (CargoItemStack cargoItemStack : list) {
            hashSet.add((String)cargoItemStack.getData());
        }
        ArrayList<CargoAPI.CargoItemQuantity<String>> arrayList = new ArrayList<CargoAPI.CargoItemQuantity<String>>();
        for (String string : hashSet) {
            int n = (int)this.getItemQuantity(CargoAPI.CargoItemType.WEAPONS, string);
            CargoAPI.CargoItemQuantity cargoItemQuantity = new CargoAPI.CargoItemQuantity((Object)string, n);
            arrayList.add((CargoAPI.CargoItemQuantity<String>)cargoItemQuantity);
        }
        return arrayList;
    }

    public List<CargoAPI.CargoItemQuantity<String>> getFighters() {
        List<CargoItemStack> list = this.findAllStacks(CargoAPI.CargoItemType.FIGHTER_CHIP, null);
        HashSet<String> hashSet = new HashSet<String>();
        for (CargoItemStack cargoItemStack : list) {
            hashSet.add((String)cargoItemStack.getData());
        }
        ArrayList<CargoAPI.CargoItemQuantity<String>> arrayList = new ArrayList<CargoAPI.CargoItemQuantity<String>>();
        for (String string : hashSet) {
            int n = (int)this.getItemQuantity(CargoAPI.CargoItemType.FIGHTER_CHIP, string);
            CargoAPI.CargoItemQuantity cargoItemQuantity = new CargoAPI.CargoItemQuantity((Object)string, n);
            arrayList.add((CargoAPI.CargoItemQuantity<String>)cargoItemQuantity);
        }
        return arrayList;
    }

    public List<CargoItemStack> getStacks() {
        return this.stacks;
    }

    public List<CargoStackAPI> getStacksCopy() {
        return new ArrayList<CargoStackAPI>(this.getStacks());
    }

    public MutableValue getCredits() {
        return this.credits;
    }

    public void transfer(CargoAPI.CargoItemType cargoItemType, Object object, float f2, float f3, CargoAPI cargoAPI) {
        float f4 = this.getItemQuantity(cargoItemType, object);
        if (f4 - f3 < f2) {
            f2 = f4 - f3;
        }
        this.removeItems(cargoItemType, object, f2);
        cargoAPI.addItems(cargoItemType, object, f2);
    }

    public void transferCrew(float f2, float f3, CargoAPI cargoAPI) {
        float f4 = this.getTotalCrew();
        this.transfer(CargoAPI.CargoItemType.RESOURCES, "crew", f2, f3, cargoAPI);
    }

    public static void main(String[] stringArray) {
        System.out.println(-1);
    }

    public void gainCrewXP(float f2) {
        if (f2 <= 0.0f) {
            return;
        }
    }

    public void setFreeTransfer(boolean bl) {
        this.freeTransfer = bl;
    }

    public boolean isFreeTransfer() {
        return this.freeTransfer;
    }

    public void resetExtra() {
        this.extraCargoUsed = 0.0f;
        this.extraFuelUsed = 0.0f;
        this.extraCrewUsed = 0.0f;
        this.extraMarinesUsed = 0.0f;
        this.extraSuppliesUsed = 0.0f;
        this.updateSpaceUsed();
    }

    public float getExtraSuppliesUsed() {
        return this.extraSuppliesUsed;
    }

    public void setExtraSuppliesUsed(float f2) {
        this.extraSuppliesUsed = f2;
    }

    public float getExtraCargoUsed() {
        return this.extraCargoUsed;
    }

    public void setExtraCargoUsed(float f2) {
        this.extraCargoUsed = f2;
    }

    public float getExtraFuelUsed() {
        return this.extraFuelUsed;
    }

    public void setExtraFuelUsed(float f2) {
        this.extraFuelUsed = f2;
    }

    public float getExtraCrewUsed() {
        return this.extraCrewUsed;
    }

    public void setExtraCrewUsed(float f2) {
        this.extraCrewUsed = f2;
    }

    public float getExtraMarinesUsed() {
        return this.extraMarinesUsed;
    }

    public void setExtraMarinesUsed(float f2) {
        this.extraMarinesUsed = f2;
    }

    protected Object writeReplace() {
        for (CargoItemStack cargoItemStack : this.getStacks()) {
            cargoItemStack.setCargo((CargoAPI)(this.origSource != null ? this.origSource : this));
        }
        return this;
    }
}

