/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.ui.trade;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.campaign.SpecialItemPlugin;
import com.fs.starfarer.api.impl.campaign.graid.ShipWeaponsGroundRaidObjectivePluginImpl;
import com.fs.starfarer.api.loading.WeaponSpecAPI;
import com.fs.starfarer.campaign.fleet.CargoData;
import com.fs.starfarer.loading.F;
import com.fs.starfarer.loading.SpecStore;
import com.fs.starfarer.loading.X;
import com.fs.starfarer.loading.specs.BaseWeaponSpec;
import com.fs.starfarer.loading.specs.FighterWingSpec;
import com.fs.starfarer.loading.specs.P;
import com.fs.util.DoNotObfuscate;

public class CargoItemStack
implements Cloneable,
DoNotObfuscate,
CargoStackAPI {
    private boolean roundSize = false;
    private float size;
    private float maxSize = 100.0f;
    private float cargoSpacePerUnit = 0.0f;
    private CargoAPI.CargoItemType type;
    private Object data;
    private CargoData cargo;
    private transient SpecialItemPlugin plugin = null;
    private transient boolean isPickedUp = false;

    public CargoItemStack clone() {
        try {
            return (CargoItemStack)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean isPickedUp() {
        return this.isPickedUp;
    }

    public void setPickedUp(boolean bl) {
        this.isPickedUp = bl;
    }

    public String getSoundId() {
        F f2 = this.getResourceIfResource();
        if (f2 != null) {
            return f2.getSoundId();
        }
        X x2 = this.getSpecialItemSpecIfSpecial();
        if (x2 != null) {
            return x2.getSoundId();
        }
        if (this.isFighterWingStack()) {
            return "ui_chip_pickup";
        }
        if (this.isModSpecStack()) {
            return "ui_chip_pickup";
        }
        return "ui_cargo_default";
    }

    public String getSoundIdDrop() {
        F f2 = this.getResourceIfResource();
        if (f2 != null) {
            return f2.getSoundIdDrop();
        }
        X x2 = this.getSpecialItemSpecIfSpecial();
        if (x2 != null) {
            return x2.getSoundIdDrop();
        }
        if (this.isFighterWingStack()) {
            return "ui_fighter_drop";
        }
        if (this.isModSpecStack()) {
            return "ui_modspec_drop";
        }
        return "ui_cargo_default_drop";
    }

    public CargoItemStack(CargoAPI.CargoItemType cargoItemType, Object object, CargoData cargoData) {
        this.type = cargoItemType;
        this.data = object;
        this.cargo = cargoData;
        this.readResolve();
    }

    public Object writeReplace() {
        this.plugin = null;
        return this;
    }

    public Object readResolve() {
        switch (this.type) {
            case WEAPONS: {
                BaseWeaponSpec baseWeaponSpec = SpecStore.o00000(BaseWeaponSpec.class, (String)this.data);
                switch (baseWeaponSpec.getSize()) {
                    case LARGE: {
                        if (this.maxSize < 100000.0f) {
                            this.maxSize = 10.0f;
                        }
                        this.cargoSpacePerUnit = ShipWeaponsGroundRaidObjectivePluginImpl.CARGO_SPACE_PER_LARGE;
                        break;
                    }
                    case MEDIUM: {
                        if (this.maxSize < 100000.0f) {
                            this.maxSize = 20.0f;
                        }
                        this.cargoSpacePerUnit = ShipWeaponsGroundRaidObjectivePluginImpl.CARGO_SPACE_PER_MEDIUM;
                        break;
                    }
                    case SMALL: {
                        if (this.maxSize < 100000.0f) {
                            this.maxSize = 40.0f;
                        }
                        this.cargoSpacePerUnit = ShipWeaponsGroundRaidObjectivePluginImpl.CARGO_SPACE_PER_SMALL;
                    }
                }
                break;
            }
            case RESOURCES: {
                F f2 = SpecStore.o00000(F.class, (String)this.data);
                this.cargoSpacePerUnit = f2.getCargoSpace();
                if (!(this.maxSize < 100000.0f)) break;
                this.maxSize = f2.getStackSize();
                break;
            }
            case FIGHTER_CHIP: {
                FighterWingSpec fighterWingSpec = SpecStore.o00000(FighterWingSpec.class, (String)this.data);
                if (this.maxSize < 100000.0f) {
                    this.maxSize = 10000.0f;
                }
                this.cargoSpacePerUnit = 1.0f;
                break;
            }
            case SPECIAL: {
                X x2 = this.getSpecialItemSpecIfSpecial();
                this.cargoSpacePerUnit = x2.getCargoSpace();
                if (this.maxSize < 100000.0f) {
                    this.maxSize = x2.getStackSize();
                }
                this.plugin = x2.getNewPluginInstance(this);
                break;
            }
            default: {
                if (this.maxSize < 100000.0f) {
                    this.maxSize = 100.0f;
                }
                this.cargoSpacePerUnit = 1.0f;
            }
        }
        return this;
    }

    public SpecialItemPlugin getPlugin() {
        if (!this.isSpecialStack()) {
            return null;
        }
        if (this.plugin == null) {
            this.plugin = this.getSpecialItemSpecIfSpecial().getNewPluginInstance(this);
        }
        return this.plugin;
    }

    public boolean isWeaponStack() {
        return this.type == CargoAPI.CargoItemType.WEAPONS;
    }

    public boolean isModSpecStack() {
        SpecialItemData specialItemData = this.getSpecialDataIfSpecial();
        if (specialItemData == null) {
            return false;
        }
        return "modspec".equals(specialItemData.getId());
    }

    public boolean isFighterWingStack() {
        return this.type == CargoAPI.CargoItemType.FIGHTER_CHIP;
    }

    public boolean isResourceStack() {
        return this.type == CargoAPI.CargoItemType.RESOURCES;
    }

    public boolean isPersonnelStack() {
        return this.isCrewStack() || this.isMarineStack();
    }

    public boolean isCommodityStack() {
        return this.type == CargoAPI.CargoItemType.RESOURCES;
    }

    public String getCommodityId() {
        if (!this.isCommodityStack()) {
            return null;
        }
        return (String)this.getData();
    }

    public boolean isMarineStack() {
        return this.isResourceStack() && this.data instanceof String && ((String)this.data).equals("marines");
    }

    public boolean isFuelStack() {
        return this.isResourceStack() && this.data instanceof String && ((String)this.data).equals("fuel");
    }

    public boolean isSupplyStack() {
        return this.isResourceStack() && this.data instanceof String && ((String)this.data).equals("supplies");
    }

    public boolean isCrewStack() {
        return this.isResourceStack() && this.data instanceof String && ((String)this.data).equals("crew");
    }

    public WeaponSpecAPI getWeaponSpecIfWeapon() {
        if (this.type != CargoAPI.CargoItemType.WEAPONS) {
            return null;
        }
        return SpecStore.o00000(BaseWeaponSpec.class, (String)this.data);
    }

    public P getHullModSpecIfHullMod() {
        if (!this.isModSpecStack()) {
            return null;
        }
        return SpecStore.o00000(P.class, ((SpecialItemData)this.data).getData());
    }

    public FighterWingSpec getFighterWingSpecIfWing() {
        if (this.type != CargoAPI.CargoItemType.FIGHTER_CHIP) {
            return null;
        }
        return SpecStore.o00000(FighterWingSpec.class, (String)this.data);
    }

    public BaseWeaponSpec getWeaponIfWeapon() {
        if (this.type != CargoAPI.CargoItemType.WEAPONS) {
            return null;
        }
        return SpecStore.o00000(BaseWeaponSpec.class, (String)this.data);
    }

    public F getResourceIfResource() {
        if (this.type != CargoAPI.CargoItemType.RESOURCES) {
            return null;
        }
        return SpecStore.o00000(F.class, (String)this.data);
    }

    public X getSpecialItemSpecIfSpecial() {
        if (this.type != CargoAPI.CargoItemType.SPECIAL) {
            return null;
        }
        return SpecStore.o00000(X.class, ((SpecialItemData)this.data).getId());
    }

    public SpecialItemData getSpecialDataIfSpecial() {
        if (this.type != CargoAPI.CargoItemType.SPECIAL) {
            return null;
        }
        return (SpecialItemData)this.data;
    }

    public CargoItemStack(CargoAPI.CargoItemType cargoItemType, CargoData cargoData) {
        this.type = cargoItemType;
        this.cargo = cargoData;
    }

    public float getCargoSpace() {
        return this.cargoSpacePerUnit * this.size;
    }

    public float getCargoSpacePerUnit() {
        return this.cargoSpacePerUnit;
    }

    public void add(float f2) {
        this.setSize(this.size + f2);
        if (this.cargo != null) {
            this.cargo.updateSpaceUsed();
        }
    }

    public void subtract(float f2) {
        this.setSize(this.size - f2);
        if (this.cargo != null) {
            this.cargo.updateSpaceUsed();
        }
    }

    public void setRoundSize(boolean bl) {
        this.roundSize = bl;
    }

    public float getFree() {
        return this.maxSize - this.getSize();
    }

    public boolean isNull() {
        return this.type == CargoAPI.CargoItemType.NULL;
    }

    public boolean isEmpty() {
        return this.getSize() <= 0.0f;
    }

    public boolean isFull() {
        return this.getSize() >= this.maxSize;
    }

    public float getSize() {
        if (this.size != this.size) {
            this.size = 0.0f;
        }
        return this.size;
    }

    public void setSize(float f2) {
        if (f2 != f2) {
            f2 = 0.0f;
        }
        if (this.roundSize) {
            f2 = (int)f2;
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > this.maxSize) {
            f2 = this.maxSize;
        }
        this.size = f2;
        if (this.cargo != null) {
            this.cargo.updateSpaceUsed();
        }
    }

    public float getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int n) {
        this.maxSize = n;
    }

    public CargoAPI.CargoItemType getType() {
        return this.type;
    }

    public void setType(CargoAPI.CargoItemType cargoItemType) {
        this.type = cargoItemType;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object object) {
        this.data = object;
    }

    public int getBaseValue() {
        float f2 = this.getSize() * (float)this.getBaseValuePerUnit();
        return (int)f2;
    }

    public int getBaseValuePerUnit() {
        if (this.isSpecialStack()) {
            return this.getPlugin().getPrice(null, null);
        }
        switch (this.type) {
            case WEAPONS: {
                BaseWeaponSpec baseWeaponSpec = SpecStore.o00000(BaseWeaponSpec.class, (String)this.data);
                return (int)baseWeaponSpec.getBaseValue();
            }
            case RESOURCES: {
                F f2 = SpecStore.o00000(F.class, (String)this.data);
                return (int)f2.getBasePrice();
            }
            case FIGHTER_CHIP: {
                FighterWingSpec fighterWingSpec = SpecStore.o00000(FighterWingSpec.class, (String)this.data);
                return (int)fighterWingSpec.getBaseValue();
            }
        }
        return 10;
    }

    public boolean isSpecialStack() {
        return this.type == CargoAPI.CargoItemType.SPECIAL;
    }

    public String getDisplayName() {
        if (this.isResourceStack()) {
            return this.getResourceIfResource().getName();
        }
        if (this.isWeaponStack()) {
            return this.getWeaponIfWeapon().getWeaponName();
        }
        if (this.isFighterWingStack()) {
            return String.valueOf(this.getFighterWingSpecIfWing().getVariant().getHullSpec().getHullName()) + " LPC";
        }
        if (this.isModSpecStack()) {
            return String.valueOf(this.getHullModSpecIfHullMod().getDisplayName()) + " Modspec";
        }
        if (this.isSpecialStack()) {
            return this.getPlugin().getName();
        }
        return "Cargo Stack";
    }

    public CargoAPI getCargo() {
        return this.cargo;
    }

    public void setCargo(CargoAPI cargoAPI) {
        if (this.isNull()) {
            cargoAPI = null;
        }
        this.cargo = (CargoData)cargoAPI;
    }

    public boolean isInPlayerCargo() {
        CampaignFleetAPI campaignFleetAPI = Global.getSector().getPlayerFleet();
        CargoAPI cargoAPI = campaignFleetAPI.getCargo();
        return this.getCargo() == cargoAPI;
    }
}

