/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.util;

import com.fs.starfarer.campaign.util.CollectionItemView;
import com.fs.util.DoNotObfuscate;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionView<ItemView extends CollectionItemView>
implements DoNotObfuscate {
    private CollectionViewDelegate<ItemView> delegate;
    private Map<Object, ItemView> views = new LinkedHashMap<Object, ItemView>();
    private TreeSet<ItemView> sortedViews;
    private Set<Object> orphaned = new HashSet<Object>();
    private Set<ItemView> notified = new HashSet<ItemView>();

    public CollectionView(CollectionViewDelegate<ItemView> collectionViewDelegate) {
        this.delegate = collectionViewDelegate;
        this.sortedViews = new TreeSet(new Comparator<ItemView>(){

            public int o00000(ItemView ItemView, ItemView ItemView2) {
                return ItemView.getRenderOrder() - ItemView2.getRenderOrder();
            }
        });
    }

    public void clear() {
        this.orphaned.clear();
        this.notified.clear();
        this.views.clear();
        this.sortedViews.clear();
    }

    public void sync(List list) {
        for (Object e2 : list) {
            if (!this.views.containsKey(e2) && this.delegate.shouldCreateViewFor(e2)) {
                ItemView ItemView = this.delegate.createItemView(e2);
                if (ItemView == null) {
                    this.views.remove(e2);
                    this.sortedViews.remove(e2);
                    continue;
                }
                this.views.put(e2, ItemView);
                this.sortedViews.add(ItemView);
            }
            this.orphaned.remove(e2);
        }
    }

    public ItemView getViewForItem(Object object) {
        return (ItemView)((CollectionItemView)this.views.get(object));
    }

    public void finishSync() {
        for (Object iterator2 : this.orphaned) {
            CollectionItemView collectionItemView = (CollectionItemView)this.views.get(iterator2);
            if (collectionItemView == null || this.notified.contains(collectionItemView)) continue;
            collectionItemView.notifyOrphaned();
            this.notified.add(collectionItemView);
        }
        Iterator<Map.Entry<Object, ItemView>> iterator = this.views.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, ItemView> entry = iterator.next();
            if (!((CollectionItemView)entry.getValue()).isExpired()) continue;
            this.notified.remove(entry.getValue());
            iterator.remove();
            this.sortedViews.remove(entry.getValue());
        }
        this.orphaned.clear();
        this.orphaned.addAll(this.views.keySet());
    }

    public Collection<ItemView> getViews() {
        return this.views.values();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface CollectionViewDelegate<ItemView extends CollectionItemView>
    extends DoNotObfuscate {
        public ItemView createItemView(Object var1);

        public boolean shouldCreateViewFor(Object var1);
    }
}

