/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.rpg;

import com.fs.profiler.Profiler;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.ImportantPeopleAPI;
import com.fs.starfarer.api.characters.MarketPostPersonFilter;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.fleet.CampaignFleet;
import com.fs.starfarer.rpg.Person;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportantPeople
implements DoNotObfuscate,
ImportantPeopleAPI {
    private List<PersonData> people = new ArrayList<PersonData>();
    private transient Set<PersonAPI> excludeFromGetPerson = null;
    private transient Map<String, PersonData> idToPersonDataMap = null;
    protected transient boolean lastGetPersonResultWasExistingPerson = false;

    public void excludeFromGetPerson(PersonAPI personAPI) {
        if (this.excludeFromGetPerson == null) {
            this.excludeFromGetPerson = new LinkedHashSet<PersonAPI>();
        }
        this.excludeFromGetPerson.add(personAPI);
    }

    public void resetExcludeFromGetPerson() {
        this.excludeFromGetPerson = null;
    }

    public void advance(float f2) {
        if (Global.getSector().isPaused()) {
            return;
        }
        float f3 = CampaignEngine.getInstance().getClock().convertToDays(f2);
        for (PersonData personData : this.people) {
            if (!personData.person.isAdvanced()) {
                personData.person.advance(f3);
            }
            personData.person.setAdvanced(false);
        }
    }

    public boolean containsPerson(PersonAPI personAPI) {
        this.rebuildIDToPersonDataMapIfNeeded();
        return this.idToPersonDataMap.containsKey(personAPI.getId());
    }

    private void rebuildIDToPersonDataMapIfNeeded() {
        if (this.idToPersonDataMap == null) {
            this.idToPersonDataMap = new HashMap<String, PersonData>();
            for (PersonData personData : this.people) {
                this.idToPersonDataMap.put(personData.person.getId(), personData);
            }
        }
    }

    public PersonData getDataFor(String string) {
        this.rebuildIDToPersonDataMapIfNeeded();
        return this.idToPersonDataMap.get(string);
    }

    public void addPerson(PersonAPI personAPI) {
        if (this.containsPerson(personAPI)) {
            return;
        }
        PersonData personData = new PersonData((Person)personAPI);
        this.people.add(personData);
        if (personAPI.getMarket() != null) {
            personData.getLocation().setMarket(personAPI.getMarket());
        }
        this.rebuildIDToPersonDataMapIfNeeded();
        this.idToPersonDataMap.put(personData.person.getId(), personData);
    }

    public void removePerson(PersonAPI personAPI) {
        this.removePerson(personAPI.getId());
    }

    public void removePerson(String string) {
        PersonData personData = this.getDataFor(string);
        if (personData != null) {
            this.people.remove(personData);
            this.rebuildIDToPersonDataMapIfNeeded();
            this.idToPersonDataMap.remove(string);
        }
    }

    public List<PersonData> getPeople() {
        return this.people;
    }

    public List<ImportantPeopleAPI.PersonDataAPI> getPeopleCopy() {
        return new ArrayList<ImportantPeopleAPI.PersonDataAPI>(this.people);
    }

    public List<PersonAPI> getPeopleWithRank(String string) {
        ArrayList<PersonAPI> arrayList = new ArrayList<PersonAPI>();
        for (PersonData personData : this.people) {
            if (!string.equals(personData.person.getRank())) continue;
            arrayList.add(personData.person);
        }
        return arrayList;
    }

    public List<PersonAPI> getPeopleWithPost(String string) {
        ArrayList<PersonAPI> arrayList = new ArrayList<PersonAPI>();
        for (PersonData personData : this.people) {
            if (!string.equals(personData.person.getRank())) continue;
            arrayList.add(personData.person);
        }
        return arrayList;
    }

    public List<ImportantPeopleAPI.PersonDataAPI> getMatching(ImportantPeopleAPI.PersonFilter personFilter) {
        Profiler.\u00d200000((String)"getMatching()");
        ArrayList<ImportantPeopleAPI.PersonDataAPI> arrayList = new ArrayList<ImportantPeopleAPI.PersonDataAPI>();
        for (PersonData personData : this.people) {
            if (personData.location.getMarket() == null && personData.getPerson().getMarket() != null) {
                personData.location.setMarket(personData.getPerson().getMarket());
            }
            if (!personFilter.accept((ImportantPeopleAPI.PersonDataAPI)personData)) continue;
            arrayList.add(personData);
        }
        Profiler.o00000();
        return arrayList;
    }

    public ImportantPeopleAPI.PersonDataAPI getPerson(String string, MarketAPI marketAPI, String string2, String string3, String ... stringArray) {
        FactionAPI factionAPI = Global.getSector().getFaction(string);
        return this.getPerson(factionAPI, marketAPI, string2, string3, stringArray);
    }

    public ImportantPeopleAPI.PersonDataAPI getPerson(FactionAPI factionAPI, MarketAPI marketAPI, String string, String string2, String ... stringArray) {
        return this.getPerson(null, factionAPI, marketAPI, string, string2, stringArray);
    }

    public boolean isLastGetPersonResultWasExistingPerson() {
        return this.lastGetPersonResultWasExistingPerson;
    }

    public ImportantPeopleAPI.PersonDataAPI getPerson(Random random, FactionAPI factionAPI, MarketAPI marketAPI, String string, String string2, String ... stringArray) {
        WeightedRandomPicker weightedRandomPicker;
        Object object;
        Profiler.\u00d200000((String)"ImportantPeople.getPerson()");
        MarketPostPersonFilter marketPostPersonFilter = new MarketPostPersonFilter(marketAPI.getId(), string, stringArray);
        List<ImportantPeopleAPI.PersonDataAPI> list = this.getMatching((ImportantPeopleAPI.PersonFilter)marketPostPersonFilter);
        Iterator<ImportantPeopleAPI.PersonDataAPI> iterator = list.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (object.getPerson().getFaction() != factionAPI) {
                iterator.remove();
                continue;
            }
            if (this.excludeFromGetPerson != null && this.excludeFromGetPerson.contains(object.getPerson())) {
                iterator.remove();
                continue;
            }
            if (marketAPI == null || marketAPI.getCommDirectory() == null || (weightedRandomPicker = marketAPI.getCommDirectory().getEntryForPerson(object.getPerson())) == null || !weightedRandomPicker.isHidden()) continue;
            iterator.remove();
        }
        this.lastGetPersonResultWasExistingPerson = true;
        if (list.isEmpty()) {
            this.lastGetPersonResultWasExistingPerson = false;
            object = (Person)factionAPI.createRandomPerson(random);
            ((Person)object).setRankId(string2);
            weightedRandomPicker = new WeightedRandomPicker(random);
            if (stringArray != null) {
                weightedRandomPicker.addAll(Arrays.asList(stringArray));
            }
            ((Person)object).setPostId((String)weightedRandomPicker.pick());
            PersonData personData = new PersonData((Person)object);
            personData.setLocation(new PersonLocation(marketAPI));
            list.add(personData);
            marketAPI.addPerson((PersonAPI)object);
            this.people.add(personData);
            this.rebuildIDToPersonDataMapIfNeeded();
            this.idToPersonDataMap.put(personData.person.getId(), personData);
        }
        object = new WeightedRandomPicker(random);
        object.addAll(list);
        Profiler.o00000();
        return (ImportantPeopleAPI.PersonDataAPI)object.pick();
    }

    public PersonData getDataFor(PersonAPI personAPI) {
        return this.getDataFor(personAPI.getId());
    }

    public ImportantPeopleAPI.PersonDataAPI getData(PersonAPI personAPI) {
        return this.getDataFor(personAPI.getId());
    }

    public ImportantPeopleAPI.PersonDataAPI getData(String string) {
        return this.getDataFor(string);
    }

    public PersonAPI getPerson(String string) {
        PersonData personData = this.getDataFor(string);
        if (personData != null) {
            return personData.getPerson();
        }
        return null;
    }

    public boolean canCheckOutPerson(PersonAPI personAPI, String string) {
        PersonData personData = this.getDataFor(personAPI);
        if (personData == null) {
            return true;
        }
        return !personData.checkedOutFor.contains(string);
    }

    public boolean isCheckedOutForAnything(PersonAPI personAPI) {
        PersonData personData = this.getDataFor(personAPI);
        if (personData == null) {
            return false;
        }
        return !personData.checkedOutFor.isEmpty();
    }

    public void checkOutPerson(PersonAPI personAPI, String string) {
        PersonData personData = this.getDataFor(personAPI);
        if (personData == null) {
            return;
        }
        personData.checkedOutFor.add(string);
    }

    public void returnPerson(PersonAPI personAPI, String string) {
        PersonData personData = this.getDataFor(personAPI);
        if (personData == null) {
            return;
        }
        personData.checkedOutFor.remove(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PersonData
    implements DoNotObfuscate,
    ImportantPeopleAPI.PersonDataAPI {
        private Person person;
        private ImportantPeopleAPI.PersonLocationAPI location = new PersonLocation();
        private Set<String> checkedOutFor = new HashSet<String>();

        public PersonData(Person person) {
            this.person = person;
        }

        public ImportantPeopleAPI.PersonLocationAPI getLocation() {
            return this.location;
        }

        public void setLocation(ImportantPeopleAPI.PersonLocationAPI personLocationAPI) {
            this.location = personLocationAPI;
        }

        public PersonAPI getPerson() {
            return this.person;
        }

        public Set<String> getCheckedOutFor() {
            return this.checkedOutFor;
        }
    }

    public static class PersonLocation
    implements DoNotObfuscate,
    ImportantPeopleAPI.PersonLocationAPI {
        private MarketAPI market;
        private SectorEntityToken entity;

        public PersonLocation() {
        }

        public PersonLocation(SectorEntityToken sectorEntityToken) {
            this.entity = sectorEntityToken;
        }

        public PersonLocation(MarketAPI marketAPI) {
            this.market = marketAPI;
        }

        public MarketAPI getMarket() {
            return this.market;
        }

        public void setMarket(MarketAPI marketAPI) {
            this.market = marketAPI;
            this.entity = null;
        }

        public SectorEntityToken getEntity() {
            return this.entity;
        }

        public void setEntity(SectorEntityToken sectorEntityToken) {
            this.entity = sectorEntityToken;
            this.market = null;
        }

        public boolean isInMarket() {
            return this.market != null;
        }

        public boolean isOnFleet() {
            return this.entity instanceof CampaignFleet;
        }
    }
}

