/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.rpg;

import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CampaignPlugin;
import com.fs.starfarer.api.campaign.PersonImportance;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.FullName;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.characters.PersonalityAPI;
import com.fs.starfarer.api.characters.RelationshipAPI;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.loading.ContactTagSpec;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.CharacterStats;
import com.fs.starfarer.campaign.Faction;
import com.fs.starfarer.campaign.Relationship;
import com.fs.starfarer.campaign.rules.Memory;
import com.fs.starfarer.loading.SpecStore;
import com.fs.starfarer.rpg.super;
import com.fs.starfarer.settings.StarfarerSettings;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Person
implements PersonAPI,
DoNotObfuscate {
    private String id = "p_" + Misc.genUID();
    private transient super personality;
    private String personalityId;
    private FullName name;
    private String portraitSprite;
    private String rankId = Ranks.SPACE_COMMANDER;
    private String postId = Ranks.POST_FLEET_COMMANDER;
    private Memory memory;
    private CharacterStats stats = new CharacterStats();
    private int wantsToContactReasonsCount = 0;
    private float contactWeight = 1.0f;
    private String factionId = "neutral";
    private String aiCoreId = null;
    private Relationship relToPlayer = null;
    private boolean advanced = false;
    private CampaignFleetAPI fleet = null;
    private MarketAPI market = null;
    private PersonImportance importance = PersonImportance.MEDIUM;
    private HashSet<String> tags = null;
    protected Boolean voiceOverride = null;

    public Person() {
        this("steady");
    }

    public Person(String string) {
        this.personalityId = string;
        this.personality = SpecStore.o00000(super.class, string);
        this.name = new FullName("", "", FullName.Gender.ANY);
        this.portraitSprite = StarfarerSettings.new("misc", "default_portrait");
    }

    public String getHimOrHer() {
        if (this.getGender() == FullName.Gender.MALE) {
            return "him";
        }
        return "her";
    }

    public String getHisOrHer() {
        if (this.getGender() == FullName.Gender.MALE) {
            return "his";
        }
        return "her";
    }

    public String getHeOrShe() {
        if (this.getGender() == FullName.Gender.MALE) {
            return "he";
        }
        return "she";
    }

    public String getManOrWoman() {
        if (this.getGender() == FullName.Gender.MALE) {
            return "man";
        }
        return "woman";
    }

    public CampaignFleetAPI getFleet() {
        return this.fleet;
    }

    public void setFleet(CampaignFleetAPI campaignFleetAPI) {
        this.fleet = campaignFleetAPI;
    }

    public MarketAPI getMarket() {
        return this.market;
    }

    public void setMarket(MarketAPI marketAPI) {
        this.market = marketAPI;
    }

    public MutableCharacterStatsAPI getFleetCommanderStats() {
        if (this.fleet == null) {
            return null;
        }
        return this.fleet.getCommanderStats();
    }

    public String getAICoreId() {
        return this.aiCoreId;
    }

    public void setAICoreId(String string) {
        this.aiCoreId = string;
    }

    public boolean isAICore() {
        return this.aiCoreId != null;
    }

    public boolean isDefault() {
        return this.portraitSprite != null && this.portraitSprite.equals(StarfarerSettings.new("misc", "default_portrait"));
    }

    public boolean isPlayer() {
        return CampaignEngine.hasInstance() && CampaignEngine.getInstance().getPlayerPerson() == this;
    }

    Object readResolve() {
        if (this.stats == null) {
            this.stats = new CharacterStats();
        }
        if (this.portraitSprite == null) {
            this.portraitSprite = StarfarerSettings.new("misc", "default_portrait");
        }
        if (this.name == null) {
            this.name = new FullName("", "", FullName.Gender.ANY);
        }
        if (this.personality == null) {
            this.personality = SpecStore.o00000(super.class, this.personalityId);
        }
        if (this.importance == null) {
            this.importance = PersonImportance.VERY_LOW;
        }
        return this;
    }

    Object writeReplace() {
        if (this.relToPlayer != null && Math.abs(this.relToPlayer.getRel()) < 5.0E-4f) {
            this.relToPlayer = null;
        }
        return this;
    }

    public Faction getFaction() {
        return CampaignEngine.getInstance().getFaction(this.factionId);
    }

    public void setFaction(String string) {
        this.factionId = string;
    }

    public Relationship getRelToPlayer() {
        if (this.relToPlayer == null) {
            this.relToPlayer = new Relationship(new RelationshipAPI.RelationshipTarget(RelationshipAPI.RelationshipTargetType.PLAYER));
        }
        return this.relToPlayer;
    }

    public void advance(float f2) {
        if (this.memory != null) {
            this.memory.advance(f2);
        }
        this.advanced = true;
    }

    public boolean isAdvanced() {
        return this.advanced;
    }

    public void setAdvanced(boolean bl) {
        this.advanced = bl;
    }

    public Memory getMemory() {
        if (this.memory == null) {
            this.memory = new Memory();
        }
        for (CampaignPlugin campaignPlugin : CampaignEngine.getInstance().getModAndPluginData().getPlugins()) {
            campaignPlugin.updatePersonFacts((PersonAPI)this, (MemoryAPI)this.memory);
        }
        return this.memory;
    }

    public MemoryAPI getMemoryWithoutUpdate() {
        if (this.memory == null) {
            this.memory = new Memory();
        }
        return this.memory;
    }

    public CharacterStats getStats() {
        if (this.stats == null) {
            this.stats = new CharacterStats();
        }
        return this.stats;
    }

    public void setStats(MutableCharacterStatsAPI mutableCharacterStatsAPI) {
        this.stats = (CharacterStats)mutableCharacterStatsAPI;
    }

    public super getPersonality() {
        return this.personality;
    }

    public PersonalityAPI getPersonalityAPI() {
        return this.personality;
    }

    public void setPersonality(super super_) {
        this.personality = super_;
        this.personalityId = super_.getId();
    }

    public void setPersonality(String string) {
        this.personalityId = string;
        this.personality = SpecStore.o00000(super.class, string);
    }

    public FullName getName() {
        return this.name;
    }

    public String getNameString() {
        return this.name.getFullName();
    }

    public void setName(FullName fullName) {
        this.name = fullName;
    }

    public String getPortraitSprite() {
        return this.portraitSprite;
    }

    public void setPortraitSprite(String string) {
        this.portraitSprite = string;
    }

    public String getRank() {
        if (this.rankId == null) {
            return null;
        }
        return this.getFaction().getRank(this.rankId);
    }

    public String getRankArticle() {
        if (this.getRank() == null) {
            return "a";
        }
        char c2 = this.getRank().charAt(0);
        if (c2 == 'a' || c2 == 'e' || c2 == 'i' || c2 == 'o' || c2 == 'u') {
            return "an";
        }
        return "a";
    }

    public void setRankId(String string) {
        this.rankId = string;
    }

    public String getPost() {
        if (this.postId == null) {
            return null;
        }
        return this.getFaction().getPost(this.postId);
    }

    public String getPostArticle() {
        if (this.getPost() == null) {
            return "a";
        }
        char c2 = this.getPost().toLowerCase().charAt(0);
        if (c2 == 'a' || c2 == 'e' || c2 == 'i' || c2 == 'o' || c2 == 'u') {
            return "an";
        }
        return "a";
    }

    public void setPostId(String string) {
        this.postId = string;
    }

    public String getRankId() {
        return this.rankId;
    }

    public String getPostId() {
        return this.postId;
    }

    public FullName.Gender getGender() {
        return this.name.getGender();
    }

    public void setGender(FullName.Gender gender) {
        this.name.setGender(gender);
    }

    public boolean isMale() {
        return this.name.getGender() == FullName.Gender.MALE;
    }

    public boolean isFemale() {
        return this.name.getGender() == FullName.Gender.FEMALE;
    }

    public boolean wantsToContactPlayer() {
        return this.wantsToContactReasonsCount > 0;
    }

    public void incrWantsToContactReasons() {
        ++this.wantsToContactReasonsCount;
    }

    public void decrWantsToContactReasons() {
        --this.wantsToContactReasonsCount;
        if (this.wantsToContactReasonsCount < 0) {
            this.wantsToContactReasonsCount = 0;
        }
    }

    public float getContactWeight() {
        return this.contactWeight;
    }

    public void setContactWeight(float f2) {
        this.contactWeight = f2;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public boolean hasTag(String string) {
        if (this.tags == null) {
            return false;
        }
        return this.tags.contains(string);
    }

    public void addTag(String string) {
        if (this.tags == null) {
            this.tags = new HashSet();
        }
        this.tags.add(string);
    }

    public void removeTag(String string) {
        if (this.tags == null) {
            return;
        }
        this.tags.remove(string);
        if (this.tags.isEmpty()) {
            this.tags = null;
        }
    }

    public Set<String> getTags() {
        if (this.tags == null) {
            return new HashSet<String>();
        }
        return this.tags;
    }

    public void clearTags() {
        if (this.tags != null) {
            this.tags.clear();
            this.tags = null;
        }
    }

    public List<ContactTagSpec> getSortedContactTags() {
        ArrayList<ContactTagSpec> arrayList = new ArrayList<ContactTagSpec>();
        for (String string : this.getTags()) {
            ContactTagSpec contactTagSpec = SpecStore.o00000(ContactTagSpec.class, string, true);
            if (contactTagSpec == null) continue;
            arrayList.add(contactTagSpec);
        }
        Collections.sort(arrayList, new Comparator<ContactTagSpec>(){

            public int o00000(ContactTagSpec contactTagSpec, ContactTagSpec contactTagSpec2) {
                return (int)Math.signum(contactTagSpec.getSort() - contactTagSpec2.getSort());
            }
        });
        return arrayList;
    }

    public List<String> getSortedContactTagStrings() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ContactTagSpec contactTagSpec : this.getSortedContactTags()) {
            arrayList.add(contactTagSpec.getName());
        }
        return arrayList;
    }

    public PersonImportance getImportance() {
        return this.importance;
    }

    public void setImportance(PersonImportance personImportance) {
        this.importance = personImportance;
    }

    public void setImportanceAndVoice(PersonImportance personImportance, Random random) {
        if (this.voiceOverride == null) {
            this.setVoice(this.getFaction().pickVoice(personImportance, random));
        }
        this.importance = personImportance;
    }

    public void setVoice(String string) {
        if (string != null) {
            this.getMemoryWithoutUpdate().set("$voice", (Object)string);
            this.voiceOverride = true;
        } else {
            this.getMemoryWithoutUpdate().unset("$voice");
            this.voiceOverride = null;
        }
    }

    public String getVoice() {
        return this.getMemoryWithoutUpdate().getString("$voice");
    }

    public String toString() {
        return String.valueOf(this.getNameString()) + ", " + this.getPostId() + " [" + Misc.getAndJoined(new ArrayList<String>(this.getTags())) + "]";
    }
}

