/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.ui.impl;

import com.fs.starfarer.C;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.campaign.CampaignPlanet;
import com.fs.starfarer.campaign.JumpPoint;
import com.fs.starfarer.loading.StarfarerStrings;
import com.fs.starfarer.settings.StarfarerSettings;
import com.fs.starfarer.ui.b;
import com.fs.starfarer.ui.impl.StandardTooltipV2;
import com.fs.starfarer.ui.impl.StandardTooltipV2Expandable;
import com.fs.starfarer.ui.intsuper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.lwjgl.util.vector.Vector2f;

public class JumpPointTooltipFactory {
    public static StandardTooltipV2 o00000(final JumpPoint jumpPoint) {
        float f2 = 450.0f;
        StandardTooltipV2Expandable standardTooltipV2Expandable = new StandardTooltipV2Expandable(f2, false, true){

            public void createImpl(boolean bl) {
                String string2 = "jumpPointNormal";
                if (jumpPoint.isStarAnchor()) {
                    string2 = "jumpPointStar";
                } else if (jumpPoint.isGasGiantAnchor()) {
                    string2 = "jumpPointGasGiant";
                }
                StarfarerStrings.o o2 = StarfarerStrings.\u00d200000("misc", string2);
                Color color = Misc.getGrayColor();
                Color color2 = Misc.getHighlightColor();
                float f2 = 10.0f;
                float f3 = 5.0f;
                String string3 = null;
                boolean bl2 = false;
                for (JumpPointAPI.JumpDestination string4 : jumpPoint.getDestinations()) {
                    if (!(string4.getDestination().getContainingLocation() instanceof StarSystemAPI)) continue;
                    StarSystemAPI n = (StarSystemAPI)string4.getDestination().getContainingLocation();
                    string3 = n.getName();
                    break;
                }
                String string = jumpPoint.getName();
                this.setTitleFont("graphics/fonts/orbitron20aabold.fnt");
                this.addTitle(string).setAlignment(Alignment.MID);
                if (string3 != null) {
                    this.setParaFont("graphics/fonts/orbitron12condensed.fnt");
                    this.setParaFontColor(C.\u00d8o0000);
                    this.addPara(string3, 0.0f).setAlignment(Alignment.MID);
                    this.setParaFontColor(C.\u00d400000);
                }
                this.setParaSmallInsignia();
                boolean bl3 = jumpPoint.isWormhole();
                if (bl3) {
                    this.addPara("Wormholes can be used for rapid transit between termini located many light-years apart.", f2);
                } else {
                    this.addPara(o2.super, f2);
                    this.addSectionHeading("Nearby objects", Alignment.MID, f2);
                    int n = jumpPoint.getDestinations().size();
                    if (n <= 0) {
                        this.addPara("This jump-point is anomalous and has no reachable destinations.", f2);
                    } else if (n > 1) {
                        this.addPara("This jump-point has multiple possible destinations, and the gravimetric readings are too chaotic to provide any useful data.", f2);
                    } else {
                        float f4;
                        Object f6;
                        JumpPointAPI.JumpDestination jumpDestination = jumpPoint.getDestinations().get(0);
                        LocationAPI locationAPI = jumpDestination.getDestination().getContainingLocation();
                        final Vector2f vector2f = jumpDestination.getDestination().getLocation();
                        float f5 = StarfarerSettings.\u00f500000("campaignMaxObjectRangeAroundJumpPoint");
                        ArrayList<Object> arrayList = new ArrayList<Object>();
                        if (jumpPoint.getDestinationVisualEntity() != null) {
                            arrayList.add(jumpPoint.getDestinationVisualEntity());
                        }
                        if (!locationAPI.isHyperspace()) {
                            Object n22;
                            List f7 = Misc.getMarketsInLocation((LocationAPI)locationAPI);
                            for (Object n22 : f7) {
                                if (n22.isHidden() || arrayList.contains(f6 = n22.getPrimaryEntity()) || (f4 = Misc.getDistance((Vector2f)vector2f, (Vector2f)f6.getLocation())) > f5 && this.\u00d200000((SectorEntityToken)f6) != jumpPoint) continue;
                                arrayList.add(f6);
                            }
                            for (Object n22 : locationAPI.getPlanets()) {
                                float f8;
                                if (arrayList.contains(n22) || (f8 = Misc.getDistance((Vector2f)vector2f, (Vector2f)n22.getLocation())) > f5 && this.\u00d200000((SectorEntityToken)n22) != jumpPoint) continue;
                                arrayList.add(n22);
                            }
                            n22 = locationAPI.getEntities(JumpPointAPI.class);
                            f6 = n22.iterator();
                            while (f6.hasNext()) {
                                JumpPointAPI bl4 = (JumpPointAPI)f6.next();
                            }
                        }
                        if (arrayList.isEmpty()) {
                            this.addPara("Gravimetric readings and nav data projections indicate there are no significant objects near this jump-point's destination.", f2);
                        } else {
                            this.addPara("Gravimetric readings and nav data projections indicate significant objects near this jump-point's destination.", f2);
                            Collections.sort(arrayList, new Comparator<SectorEntityToken>(){

                                public int super(SectorEntityToken sectorEntityToken, SectorEntityToken sectorEntityToken2) {
                                    float f2;
                                    float f3 = Misc.getDistance((Vector2f)vector2f, (Vector2f)sectorEntityToken.getLocation());
                                    if (Math.abs(f3 - (f2 = Misc.getDistance((Vector2f)vector2f, (Vector2f)sectorEntityToken2.getLocation()))) < 100.0f) {
                                        return sectorEntityToken.getName().compareTo(sectorEntityToken2.getName());
                                    }
                                    return (int)Math.signum(f3 - f2);
                                }
                            });
                            float f9 = this.width;
                            this.beginGrid(f9, 1);
                            int n2 = 0;
                            this.setGridLabelColor(C.oo0000);
                            this.setGridValueColor(C.oo0000);
                            this.addToGrid(0, n2++, "Object", "Distance", C.oo0000);
                            boolean bl4 = false;
                            if (locationAPI instanceof StarSystemAPI && (f6 = Misc.getMinSystemSurveyLevel((StarSystemAPI)((StarSystemAPI)locationAPI))) != MarketAPI.SurveyLevel.NONE) {
                                bl4 = true;
                            }
                            f6 = new HashSet();
                            f4 = 0.0f;
                            for (SectorEntityToken sectorEntityToken : arrayList) {
                                float f10;
                                String string4;
                                String string5;
                                float f11 = Misc.getDistance((Vector2f)vector2f, (Vector2f)sectorEntityToken.getLocation());
                                String string6 = "" + (int)Misc.getRounded((float)f11);
                                if (f11 < 100.0f) {
                                    string6 = "0";
                                }
                                intsuper.o o3 = null;
                                if (sectorEntityToken.getMarket() != null && !sectorEntityToken.getMarket().isPlanetConditionMarketOnly() && !f6.contains(sectorEntityToken.getMarket().getId())) {
                                    Object object;
                                    f6.add(sectorEntityToken.getMarket().getId());
                                    MarketAPI marketAPI = sectorEntityToken.getMarket();
                                    string5 = marketAPI.getFaction();
                                    string4 = "orbital station";
                                    if (marketAPI.getPrimaryEntity() != null && marketAPI.getPrimaryEntity() instanceof CampaignPlanet) {
                                        object = (CampaignPlanet)marketAPI.getPrimaryEntity();
                                        string4 = String.valueOf(((CampaignPlanet)object).getSpec().getName().toLowerCase()) + " world";
                                    }
                                    object = "";
                                    if (marketAPI.getMemoryWithoutUpdate().getBoolean("$military")) {
                                        object = " (military)";
                                    }
                                    this.setGridLabelColor(string5.getBaseUIColor());
                                    o3 = this.addToGrid(0, n2++, String.valueOf(marketAPI.getName()) + " - " + string5.getDisplayName() + (String)object + ", " + string4, string6);
                                    o3.nameLabel.getRenderer().super(new Color[]{C.\u00d400000});
                                    o3.nameLabel.getRenderer().super(new String[]{string4});
                                    float f12 = o3.nameLabel.getWidth() + o3.valueLabel.getWidth() + 10.0f;
                                    if (f12 > f4) {
                                        f4 = f12;
                                    }
                                } else if (sectorEntityToken instanceof PlanetAPI) {
                                    PlanetAPI planetAPI = (PlanetAPI)sectorEntityToken;
                                    string5 = String.valueOf(planetAPI.getName()) + ",";
                                    string4 = String.valueOf(planetAPI.getSpec().getName().toLowerCase()) + " world";
                                    if (planetAPI.isStar() || planetAPI.isGasGiant()) {
                                        string4 = planetAPI.getSpec().getName().toLowerCase();
                                    }
                                    if (!(bl4 || planetAPI.isStar() || planetAPI.isGasGiant())) {
                                        string5 = "Unidentified";
                                        string4 = "planet";
                                    }
                                    this.setGridLabelColor(C.\u00d400000);
                                    o3 = this.addToGrid(0, n2++, String.valueOf(string5) + " " + string4, string6);
                                    o3.nameLabel.getRenderer().super(new Color[]{C.\u00d400000});
                                    o3.nameLabel.getRenderer().super(new String[]{string4});
                                    float f13 = o3.nameLabel.getWidth() + o3.valueLabel.getWidth() + 10.0f;
                                    if (f13 > f4) {
                                        f4 = f13;
                                    }
                                } else if (sectorEntityToken instanceof JumpPointAPI) {
                                    JumpPointAPI jumpPointAPI = (JumpPointAPI)sectorEntityToken;
                                    this.setGridLabelColor(C.\u00d400000);
                                    string5 = jumpPointAPI.getName();
                                    string5 = string5.replaceAll("(?is)Jump Point", "");
                                    string5 = string5.replaceAll("(?is)Jumppoint", "");
                                    o3 = this.addToGrid(0, n2++, String.valueOf(string5) + " - jump point", string6);
                                }
                                if (o3 == null || !((f10 = o3.nameLabel.getWidth() + o3.valueLabel.getWidth() + 10.0f) > f4)) continue;
                                f4 = f10;
                            }
                            if (f4 > this.width) {
                                for (b b2 : this.currGrid.getChildrenCopy()) {
                                    if (!(b2 instanceof intsuper.o)) continue;
                                    intsuper.o o4 = (intsuper.o)b2;
                                    o4.setSize(f4, o4.getHeight());
                                }
                                this.setSize(f4 + 25.0f, this.getHeight());
                            }
                            intsuper intsuper2 = this.currGrid;
                            this.addGrid(f2);
                            intsuper2.getPosition().setXAlignOffset((this.width - f9) / 2.0f);
                        }
                    }
                }
            }

            private SectorEntityToken \u00d200000(SectorEntityToken sectorEntityToken) {
                float f2 = Float.MAX_VALUE;
                JumpPointAPI jumpPointAPI = null;
                List list = jumpPoint.getContainingLocation().getEntities(JumpPointAPI.class);
                for (JumpPointAPI jumpPointAPI2 : list) {
                    float f3 = Misc.getDistance((Vector2f)jumpPoint.getLocation(), (Vector2f)jumpPointAPI2.getLocation());
                    if (f3 > 3000.0f || jumpPointAPI2.isStarAnchor()) continue;
                    for (JumpPointAPI.JumpDestination jumpDestination : jumpPointAPI2.getDestinations()) {
                        float f4;
                        if (jumpDestination.getDestination() == null || jumpDestination.getDestination().getContainingLocation() != sectorEntityToken.getContainingLocation() || !((f4 = Misc.getDistance((Vector2f)sectorEntityToken.getLocation(), (Vector2f)jumpDestination.getDestination().getLocation())) < f2 - 10.0f)) continue;
                        f2 = f4;
                        jumpPointAPI = jumpPointAPI2;
                    }
                }
                return jumpPointAPI;
            }
        };
        return standardTooltipV2Expandable;
    }
}

