/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.util;

import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.combat.StatBonus;
import com.fs.starfarer.api.util.DynamicStatsAPI;
import com.fs.util.DoNotObfuscate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicStats
implements DoNotObfuscate,
DynamicStatsAPI {
    private Map<String, MutableStat> stats = new HashMap<String, MutableStat>();
    private Map<String, StatBonus> mods = new HashMap<String, StatBonus>();

    public MutableStat getStat(String string) {
        MutableStat mutableStat = this.stats.get(string);
        if (mutableStat == null) {
            mutableStat = new MutableStat(1.0f);
            this.stats.put(string, mutableStat);
        }
        return mutableStat;
    }

    public StatBonus getMod(String string) {
        StatBonus statBonus = this.mods.get(string);
        if (statBonus == null) {
            statBonus = new StatBonus();
            this.mods.put(string, statBonus);
        }
        return statBonus;
    }

    public float getValue(String string) {
        if (!this.stats.containsKey(string)) {
            return 1.0f;
        }
        return this.stats.get(string).getModifiedValue();
    }

    public float getValue(String string, float f2) {
        if (!this.mods.containsKey(string)) {
            return f2;
        }
        return this.mods.get(string).computeEffective(f2);
    }

    public void removeUmodified() {
        Object object;
        Iterator<MutableStat> iterator = this.stats.values().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!object.isUnmodified()) continue;
            iterator.remove();
        }
        object = this.mods.values().iterator();
        while (object.hasNext()) {
            StatBonus statBonus = (StatBonus)object.next();
            if (!statBonus.isUnmodified()) continue;
            object.remove();
        }
    }

    public boolean isEmpty() {
        return this.stats.isEmpty() && this.mods.isEmpty();
    }

    public Map<String, MutableStat> getStats() {
        return this.stats;
    }

    public Map<String, StatBonus> getMods() {
        return this.mods;
    }
}

