/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.skin.TextAreaSkin;
import com.sun.javafx.scene.control.skin.TextFieldSkin;
import com.sun.javafx.scene.control.skin.Utils;
import java.util.Collection;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.ListChangeListener;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;

public class EmbeddedTextContextMenuContent
extends StackPane {
    private ContextMenu contextMenu;
    private StackPane pointer;
    private HBox menuBox;

    public EmbeddedTextContextMenuContent(ContextMenu contextMenu) {
        this.contextMenu = contextMenu;
        this.menuBox = new HBox();
        this.pointer = new StackPane();
        this.pointer.getStyleClass().add("pointer");
        this.updateMenuItemContainer();
        this.getChildren().addAll((Node[])new Node[]{this.pointer, this.menuBox});
        this.contextMenu.ownerNodeProperty().addListener(new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                if (EmbeddedTextContextMenuContent.this.contextMenu.getOwnerNode() instanceof TextArea) {
                    TextAreaSkin textAreaSkin = (TextAreaSkin)((TextArea)EmbeddedTextContextMenuContent.this.contextMenu.getOwnerNode()).getSkin();
                    textAreaSkin.getProperties().addListener(new InvalidationListener(){

                        @Override
                        public void invalidated(Observable observable) {
                            EmbeddedTextContextMenuContent.this.requestLayout();
                        }
                    });
                } else if (EmbeddedTextContextMenuContent.this.contextMenu.getOwnerNode() instanceof TextField) {
                    TextFieldSkin textFieldSkin = (TextFieldSkin)((TextField)EmbeddedTextContextMenuContent.this.contextMenu.getOwnerNode()).getSkin();
                    textFieldSkin.getProperties().addListener(new InvalidationListener(){

                        @Override
                        public void invalidated(Observable observable) {
                            EmbeddedTextContextMenuContent.this.requestLayout();
                        }
                    });
                }
            }
        });
        this.contextMenu.getItems().addListener(new ListChangeListener<MenuItem>(){

            @Override
            public void onChanged(ListChangeListener.Change<? extends MenuItem> change) {
                EmbeddedTextContextMenuContent.this.updateMenuItemContainer();
            }
        });
    }

    private void updateMenuItemContainer() {
        this.menuBox.getChildren().clear();
        for (MenuItem menuItem : this.contextMenu.getItems()) {
            MenuItemContainer menuItemContainer = new MenuItemContainer(menuItem);
            menuItemContainer.visibleProperty().bind(menuItem.visibleProperty());
            this.menuBox.getChildren().add(menuItemContainer);
        }
    }

    private void hideAllMenus(MenuItem menuItem) {
        Menu menu;
        this.contextMenu.hide();
        while ((menu = menuItem.getParentMenu()) != null) {
            menu.hide();
            menuItem = menu;
        }
        if (menu == null && menuItem.getParentPopup() != null) {
            menuItem.getParentPopup().hide();
        }
    }

    @Override
    protected double computePrefHeight(double d) {
        double d2 = this.snapSpace(this.getInsets().getTop());
        double d3 = this.snapSpace(this.getInsets().getBottom());
        double d4 = this.snapSize(this.pointer.prefHeight(d));
        double d5 = this.snapSize(this.menuBox.prefHeight(d));
        return d2 + d4 + d5 + d3;
    }

    @Override
    protected double computePrefWidth(double d) {
        double d2 = this.snapSpace(this.getInsets().getLeft());
        double d3 = this.snapSpace(this.getInsets().getRight());
        double d4 = this.snapSize(this.menuBox.prefWidth(d));
        return d2 + d4 + d3;
    }

    @Override
    protected void layoutChildren() {
        double d = this.snapSpace(this.getInsets().getLeft());
        double d2 = this.snapSpace(this.getInsets().getRight());
        double d3 = this.snapSpace(this.getInsets().getTop());
        double d4 = this.snapSize(this.getWidth() - (d + d2));
        double d5 = this.snapSize(Utils.boundedSize(this.pointer.prefWidth(-1.0), this.pointer.minWidth(-1.0), this.pointer.maxWidth(-1.0)));
        double d6 = this.snapSize(Utils.boundedSize(this.pointer.prefWidth(-1.0), this.pointer.minWidth(-1.0), this.pointer.maxWidth(-1.0)));
        double d7 = this.snapSize(Utils.boundedSize(this.menuBox.prefWidth(-1.0), this.menuBox.minWidth(-1.0), this.menuBox.maxWidth(-1.0)));
        double d8 = this.snapSize(Utils.boundedSize(this.menuBox.prefWidth(-1.0), this.menuBox.minWidth(-1.0), this.menuBox.maxWidth(-1.0)));
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        if (this.contextMenu.getOwnerNode() instanceof TextArea) {
            TextArea textArea = (TextArea)this.contextMenu.getOwnerNode();
            TextAreaSkin textAreaSkin = (TextAreaSkin)textArea.getSkin();
            d9 = Double.valueOf(textAreaSkin.getProperties().get("CONTEXT_MENU_SCENE_X").toString());
            d10 = Double.valueOf(textAreaSkin.getProperties().get("CONTEXT_MENU_SCREEN_X").toString());
            textAreaSkin.getProperties().clear();
        } else if (this.contextMenu.getOwnerNode() instanceof TextField) {
            TextField textField = (TextField)this.contextMenu.getOwnerNode();
            TextFieldSkin textFieldSkin = (TextFieldSkin)textField.getSkin();
            d9 = Double.valueOf(textFieldSkin.getProperties().get("CONTEXT_MENU_SCENE_X").toString());
            d10 = Double.valueOf(textFieldSkin.getProperties().get("CONTEXT_MENU_SCREEN_X").toString());
            textFieldSkin.getProperties().clear();
        }
        d11 = d9 == 0.0 ? d4 / 2.0 : d10 - d9 - this.contextMenu.getX() + d9;
        this.pointer.resize(d5, d6);
        this.positionInArea(this.pointer, d11, d3, d5, d6, 0.0, HPos.CENTER, VPos.CENTER);
        this.menuBox.resize(d7, d8);
        this.positionInArea(this.menuBox, d, d3 + d6, d7, d8, 0.0, HPos.CENTER, VPos.CENTER);
    }

    class MenuItemContainer
    extends Button {
        private MenuItem item;

        public MenuItemContainer(MenuItem menuItem) {
            this.getStyleClass().addAll((Collection<String>)menuItem.getStyleClass());
            this.setId(menuItem.getId());
            this.item = menuItem;
            this.setText(menuItem.getText());
            this.setStyle(menuItem.getStyle());
            this.textProperty().bind(menuItem.textProperty());
        }

        public MenuItem getItem() {
            return this.item;
        }

        @Override
        public void fire() {
            Event.fireEvent(this.item, new ActionEvent());
            if (!Boolean.TRUE.equals((Boolean)this.item.getProperties().get("refreshMenu"))) {
                EmbeddedTextContextMenuContent.this.hideAllMenus(this.item);
            }
        }
    }
}

