/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign;

import com.fs.starfarer.api.campaign.ControlGroupsAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PersistentUIDataAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.ui.MapFilterData;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.MusicSuppressor;
import com.fs.starfarer.campaign.command.CommandTabData;
import com.fs.starfarer.campaign.comms.IntelTabData;
import com.fs.starfarer.campaign.fleet.FleetMember;
import com.fs.starfarer.ui.newui.HintPanel;
import com.fs.starfarer.util.IntervalTracker;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CampaignUIPersistentData
implements DoNotObfuscate,
PersistentUIDataAPI {
    private float campaignZoom = 1.0f;
    private float campaignMapZoom = 2.0f;
    private float hyperMapZoom = 3.0f;
    private Vector2f campaignMapCoordinates = new Vector2f();
    private boolean campaignMapCoordinatesValid = false;
    private Vector2f hyperMapCoordinates = new Vector2f();
    private boolean hyperMapCoordinatesValid = false;
    private LocationAPI campaignMapLocation = null;
    private FleetMember lastSelectedForRefit = null;
    private ControlGroups controlGroups = new ControlGroups();
    private boolean showOnlyInstallableHullmods = false;
    private boolean hideInstalledHullmods = false;
    private int refitAddModTabIndex = -1;
    private boolean openedCharacterTabSinceLevelUp = false;
    private IntelTabData intelData = new IntelTabData();
    private CommandTabData commandData = new CommandTabData();
    private IntervalTracker cleanupTracker = new IntervalTracker(0.5f, 1.5f);
    private AbilitySlots abilitySlots = new AbilitySlots();
    private MusicSuppressor musicSuppressor = new MusicSuppressor();
    private int commodityGraphMode = 0;
    private MapFilterData mapFilterData = new MapFilterData(true);
    private SectorEntityToken courseTarget = null;
    private List<HintPanel.SavedHintData> savedHints = new ArrayList<HintPanel.SavedHintData>();
    private String lastMarketId = null;
    private int cargoSubmarketIndex = 0;
    private int fleetSubmarketIndex = 0;
    private LinkedHashSet<String> checkedRefitTags = new LinkedHashSet();
    private LinkedHashSet<String> allRefitTags = new LinkedHashSet();

    Object writeReplace() {
        HintPanel hintPanel = (HintPanel)CampaignEngine.getInstance().getCampaignUI().getHintPanel();
        this.savedHints = new ArrayList<HintPanel.SavedHintData>();
        if (hintPanel != null) {
            for (HintPanel.o o2 : hintPanel.getHints()) {
                o2.o00000();
                this.savedHints.add(o2.\u00d300000);
            }
        }
        return this;
    }

    Object readResolve() {
        if (this.savedHints == null) {
            this.savedHints = new ArrayList<HintPanel.SavedHintData>();
        }
        if (this.mapFilterData == null) {
            this.mapFilterData = new MapFilterData(true);
        }
        if (this.controlGroups == null) {
            this.controlGroups = new ControlGroups();
        }
        if (this.intelData == null) {
            this.intelData = new IntelTabData();
        }
        if (this.commandData == null) {
            this.commandData = new CommandTabData();
        }
        if (this.cleanupTracker == null) {
            this.cleanupTracker = new IntervalTracker(0.5f, 1.5f);
        }
        if (this.abilitySlots == null) {
            this.abilitySlots = new AbilitySlots();
        }
        if (this.musicSuppressor == null) {
            this.musicSuppressor = new MusicSuppressor();
        }
        if (this.hyperMapCoordinates == null) {
            this.hyperMapCoordinates = new Vector2f();
        }
        if (this.checkedRefitTags == null) {
            this.checkedRefitTags = new LinkedHashSet();
        }
        if (this.allRefitTags == null) {
            this.allRefitTags = new LinkedHashSet();
        }
        return this;
    }

    public LinkedHashSet<String> getCheckedRefitTags() {
        return this.checkedRefitTags;
    }

    public LinkedHashSet<String> getAllRefitTags() {
        return this.allRefitTags;
    }

    public List<HintPanel.SavedHintData> getSavedHints() {
        return this.savedHints;
    }

    public SectorEntityToken getCourseTarget() {
        return this.courseTarget;
    }

    public void setCourseTarget(SectorEntityToken sectorEntityToken) {
        this.courseTarget = sectorEntityToken;
    }

    public MapFilterData getMapFilterData() {
        return this.mapFilterData;
    }

    public AbilitySlots getAbilitySlots() {
        return this.abilitySlots;
    }

    public PersistentUIDataAPI.AbilitySlotsAPI getAbilitySlotsAPI() {
        return this.abilitySlots;
    }

    public void setAbilitySlots(AbilitySlots abilitySlots) {
        this.abilitySlots = abilitySlots;
    }

    public IntelTabData getIntelData() {
        return this.intelData;
    }

    public CommandTabData getCommandData() {
        return this.commandData;
    }

    public void advance(float f2) {
        CampaignEngine campaignEngine = CampaignEngine.getInstance();
        this.musicSuppressor.advance(f2);
        if (campaignEngine.isPaused()) {
            return;
        }
        float f3 = campaignEngine.getClock().convertToDays(f2);
        this.cleanupTracker.advance(f3);
        if (this.cleanupTracker.intervalElapsed()) {
            this.intelData.performCleanup();
        }
    }

    public MusicSuppressor getMusicSuppressor() {
        return this.musicSuppressor;
    }

    public boolean isOpenedCharacterTabSinceLevelUp() {
        return this.openedCharacterTabSinceLevelUp;
    }

    public void setOpenedCharacterTabSinceLevelUp(boolean bl) {
        this.openedCharacterTabSinceLevelUp = bl;
    }

    public float getCampaignZoom() {
        return this.campaignZoom;
    }

    public void setCampaignZoom(float f2) {
        this.campaignZoom = f2;
    }

    public float getCampaignMapZoom() {
        return this.campaignMapZoom;
    }

    public void setCampaignMapZoom(float f2) {
        this.campaignMapZoom = f2;
    }

    public Vector2f getCampaignMapCoordinates() {
        return this.campaignMapCoordinates;
    }

    public Vector2f getHyperMapCoordinates() {
        return this.hyperMapCoordinates;
    }

    public boolean isCampaignMapCoordinatesValid() {
        return this.campaignMapCoordinatesValid;
    }

    public void setCampaignMapCoordinatesValid(boolean bl) {
        this.campaignMapCoordinatesValid = bl;
    }

    public boolean isHyperMapCoordinatesValid() {
        return this.hyperMapCoordinatesValid;
    }

    public void setHyperMapCoordinatesValid(boolean bl) {
        this.hyperMapCoordinatesValid = bl = true;
    }

    public LocationAPI getCampaignMapLocation() {
        return this.campaignMapLocation;
    }

    public void setCampaignMapLocation(LocationAPI locationAPI) {
        this.campaignMapLocation = locationAPI;
    }

    public float getHyperMapZoom() {
        return this.hyperMapZoom;
    }

    public void setHyperMapZoom(float f2) {
        this.hyperMapZoom = f2;
    }

    public FleetMember getLastSelectedForRefit() {
        return this.lastSelectedForRefit;
    }

    public void setLastSelectedForRefit(FleetMember fleetMember) {
        this.lastSelectedForRefit = fleetMember;
    }

    public ControlGroups getControlGroups() {
        return this.controlGroups;
    }

    public boolean isShowOnlyInstallableHullmods() {
        return this.showOnlyInstallableHullmods;
    }

    public void setShowOnlyInstallableHullmods(boolean bl) {
        this.showOnlyInstallableHullmods = bl;
    }

    public boolean isHideInstalledHullmods() {
        return this.hideInstalledHullmods;
    }

    public void setHideInstalledHullmods(boolean bl) {
        this.hideInstalledHullmods = bl;
    }

    public int getRefitAddModTabIndex() {
        return this.refitAddModTabIndex;
    }

    public void setRefitAddModTabIndex(int n) {
        this.refitAddModTabIndex = n;
    }

    public int getCommodityGraphMode() {
        return this.commodityGraphMode;
    }

    public void setCommodityGraphMode(int n) {
        this.commodityGraphMode = n;
    }

    public String getLastMarketId() {
        return this.lastMarketId;
    }

    public void setLastMarketId(String string) {
        this.lastMarketId = string;
    }

    public int getCargoSubmarketIndex() {
        return this.cargoSubmarketIndex;
    }

    public void setCargoSubmarketIndex(int n) {
        this.cargoSubmarketIndex = n;
    }

    public int getFleetSubmarketIndex() {
        return this.fleetSubmarketIndex;
    }

    public void setFleetSubmarketIndex(int n) {
        this.fleetSubmarketIndex = n;
    }

    public static class AbilitySlot
    implements DoNotObfuscate,
    PersistentUIDataAPI.AbilitySlotAPI {
        private int slotId;
        private String abilityId;
        private String inHyperAbilityId;

        public AbilitySlot(int n, String string) {
            this.slotId = n;
            this.abilityId = string;
        }

        public int getSlotId() {
            return this.slotId;
        }

        public void setSlotId(int n) {
            this.slotId = n;
        }

        public String getAbilityId() {
            return this.abilityId;
        }

        public void setAbilityId(String string) {
            this.abilityId = string;
        }

        public String getInHyperAbilityId() {
            return this.inHyperAbilityId;
        }

        public void setInHyperAbilityId(String string) {
            this.inHyperAbilityId = string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AbilitySlots
    implements DoNotObfuscate,
    PersistentUIDataAPI.AbilitySlotsAPI {
        private AbilitySlot[][] slots;
        private int currBarIndex = 0;
        private boolean locked = false;

        public AbilitySlots() {
            this.readResolve();
        }

        public AbilitySlot[] getCurrSlots() {
            return this.slots[this.currBarIndex];
        }

        public AbilitySlot[][] getSlots() {
            return this.slots;
        }

        public int getCurrBarIndex() {
            return this.currBarIndex;
        }

        public void setCurrBarIndex(int n) {
            this.currBarIndex = n;
        }

        public boolean isLocked() {
            return this.locked;
        }

        public void setLocked(boolean bl) {
            this.locked = bl;
        }

        Object readResolve() {
            if (this.slots == null) {
                this.slots = new AbilitySlot[5][10];
                int n = 0;
                while (n < this.slots.length) {
                    int n2 = 0;
                    while (n2 < this.slots[0].length) {
                        this.slots[n][n2] = new AbilitySlot(n2, null);
                        ++n2;
                    }
                    ++n;
                }
            }
            return this;
        }

        public List<PersistentUIDataAPI.AbilitySlotAPI> getCurrSlotsCopy() {
            ArrayList<PersistentUIDataAPI.AbilitySlotAPI> arrayList = new ArrayList<PersistentUIDataAPI.AbilitySlotAPI>();
            AbilitySlot[] abilitySlotArray = this.getCurrSlots();
            int n = abilitySlotArray.length;
            int n2 = 0;
            while (n2 < n) {
                AbilitySlot abilitySlot = abilitySlotArray[n2];
                arrayList.add(abilitySlot);
                ++n2;
            }
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ControlGroups
    implements DoNotObfuscate,
    ControlGroupsAPI {
        List<String>[] groups = new ArrayList[10];

        public ControlGroups() {
            int n = 0;
            while (n < this.groups.length) {
                this.groups[n] = new ArrayList<String>();
                ++n;
            }
        }

        public List<String> getGroup(int n) {
            return this.groups[n];
        }

        public void addToGroup(int n, FleetMemberAPI fleetMemberAPI) {
            if (fleetMemberAPI == null) {
                return;
            }
            int n2 = 0;
            while (n2 < this.groups.length) {
                Iterator<String> iterator = this.groups[n2].iterator();
                while (iterator.hasNext()) {
                    String string = iterator.next();
                    if (string == null || !string.equals(fleetMemberAPI.getId())) continue;
                    iterator.remove();
                }
                ++n2;
            }
            this.getGroup(n).add(fleetMemberAPI.getId());
        }

        public int getGroupIndexForFleetMember(FleetMemberAPI fleetMemberAPI) {
            int n = 0;
            while (n < this.groups.length) {
                for (String string : this.groups[n]) {
                    if (string == null || !string.equals(fleetMemberAPI.getId())) continue;
                    return n;
                }
                ++n;
            }
            return -1;
        }
    }
}

